/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import com.kingdee.bos.ctrl.common.util.CommonSLF4JLogger;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.jcr.NamespaceException;
import org.apache.jackrabbit.core.query.lucene.NamePathResolverImpl;
import org.apache.jackrabbit.core.query.lucene.NamespaceMappings;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.IllegalNameException;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;
import org.apache.jackrabbit.spi.commons.namespace.AbstractNamespaceResolver;
import org.slf4j.Logger;

public class FileBasedNamespaceMappings
extends AbstractNamespaceResolver
implements NamespaceMappings {
    private static Logger log = CommonSLF4JLogger.getLogger(NamespaceMappings.class);
    private final File storage;
    private final NameResolver nameResolver;
    private Map prefixToURI = new HashMap();
    private Map uriToPrefix = new HashMap();
    private int prefixCount;

    public FileBasedNamespaceMappings(File file) throws IOException {
        this.storage = file;
        this.load();
        this.nameResolver = NamePathResolverImpl.create(this);
    }

    @Override
    public synchronized String getURI(String prefix) throws NamespaceException {
        if (!this.prefixToURI.containsKey(prefix)) {
            throw new NamespaceException(prefix + ": is not a registered namespace prefix.");
        }
        return (String)this.prefixToURI.get(prefix);
    }

    @Override
    public synchronized String getPrefix(String uri) throws NamespaceException {
        String prefix = (String)this.uriToPrefix.get(uri);
        if (prefix == null) {
            while (this.prefixToURI.get(String.valueOf(this.prefixCount)) != null) {
                ++this.prefixCount;
            }
            prefix = String.valueOf(this.prefixCount);
            this.prefixToURI.put(prefix, uri);
            this.uriToPrefix.put(uri, prefix);
            log.debug("adding new namespace mapping: " + prefix + " -> " + uri);
            try {
                this.store();
            }
            catch (IOException e) {
                throw new NamespaceException("Could not obtain a prefix for uri: " + uri, (Throwable)e);
            }
        }
        return prefix;
    }

    @Override
    public String translatePropertyName(Name qName) throws IllegalNameException {
        try {
            return this.nameResolver.getJCRName(qName);
        }
        catch (NamespaceException e) {
            throw new IllegalNameException("Internal error.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() throws IOException {
        if (this.storage.exists()) {
            try (FileInputStream in = new FileInputStream(this.storage);){
                Properties props = new Properties();
                log.debug("loading namespace mappings...");
                props.load(in);
                for (String string : props.keySet()) {
                    String uri = props.getProperty(string);
                    log.debug(string + " -> " + uri);
                    this.prefixToURI.put(string, uri);
                    this.uriToPrefix.put(uri, string);
                }
                this.prefixCount = props.size();
                log.debug("namespace mappings loaded.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store() throws IOException {
        Properties props = new Properties();
        for (String prefix : this.prefixToURI.keySet()) {
            String uri = (String)this.prefixToURI.get(prefix);
            props.setProperty(prefix, uri);
        }
        try (OutputStream out = new FileOutputStream(this.storage);){
            out = new BufferedOutputStream(out);
            props.store(out, null);
        }
    }
}

