/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.state;

import com.kingdee.bos.ctrl.common.util.CommonSLF4JLogger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.WeakHashMap;
import org.apache.jackrabbit.core.state.Cache;
import org.apache.jackrabbit.core.state.CacheAccessListener;
import org.slf4j.Logger;

public class CacheManager
implements CacheAccessListener {
    private static Logger log = CommonSLF4JLogger.getLogger(CacheManager.class);
    private static final long DEFAULT_MAX_MEMORY = 0x1000000L;
    private static final long DEFAULT_MIN_MEMORY_PER_CACHE = 131072L;
    private static final long DEFAULT_MAX_MEMORY_PER_CACHE = 0x400000L;
    private WeakHashMap caches = new WeakHashMap();
    private static final int DEFAULT_MIN_RESIZE_INTERVAL = 1000;
    private static final int BIG_OBJECT_SIZE = 16384;
    private long maxMemory = 0x1000000L;
    private long minMemoryPerCache = 131072L;
    private long maxMemoryPerCache = 0x400000L;
    private long minResizeInterval = 1000L;
    private volatile long nextResize = System.currentTimeMillis() + 1000L;

    public long getMaxMemory() {
        return this.maxMemory;
    }

    public void setMaxMemory(long maxMemory) {
        this.maxMemory = maxMemory;
    }

    public long getMaxMemoryPerCache() {
        return this.maxMemoryPerCache;
    }

    public void setMaxMemoryPerCache(long maxMemoryPerCache) {
        this.maxMemoryPerCache = maxMemoryPerCache;
    }

    public long getMinMemoryPerCache() {
        return this.minMemoryPerCache;
    }

    public void setMinMemoryPerCache(long minMemoryPerCache) {
        this.minMemoryPerCache = minMemoryPerCache;
    }

    public long getMinResizeInterval() {
        return this.minResizeInterval;
    }

    public void setMinResizeInterval(long minResizeInterval) {
        this.minResizeInterval = minResizeInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cacheAccessed() {
        long now = System.currentTimeMillis();
        if (now < this.nextResize) {
            return;
        }
        CacheManager cacheManager = this;
        synchronized (cacheManager) {
            if (now < this.nextResize) {
                return;
            }
            this.nextResize = now + this.minResizeInterval;
            this.resizeAll();
            this.nextResize = System.currentTimeMillis() + this.minResizeInterval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resizeAll() {
        CacheInfo info;
        int i;
        log.debug("resizeAll size=" + this.caches.size());
        ArrayList list = new ArrayList();
        WeakHashMap weakHashMap = this.caches;
        synchronized (weakHashMap) {
            Iterator it = this.caches.keySet().iterator();
            while (it.hasNext()) {
                list.add(it.next());
            }
        }
        if (list.size() == 0) {
            return;
        }
        CacheInfo[] infos = new CacheInfo[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            infos[i2] = new CacheInfo((Cache)list.get(i2));
        }
        long totalAccessCount = 0L;
        long totalMemoryUsed = 0L;
        for (int i3 = 0; i3 < infos.length; ++i3) {
            totalAccessCount += infos[i3].getAccessCount();
            totalMemoryUsed += infos[i3].getMemoryUsed();
        }
        double memoryPerAccess = (double)this.maxMemory / 2.0 / Math.max(1.0, (double)totalAccessCount);
        double memoryPerUsed = (double)this.maxMemory / 2.0 / Math.max(1.0, (double)totalMemoryUsed);
        int fullCacheCount = 0;
        for (int i4 = 0; i4 < infos.length; ++i4) {
            CacheInfo info2 = infos[i4];
            long mem = (long)(memoryPerAccess * (double)info2.getAccessCount());
            mem += (long)(memoryPerUsed * (double)info2.getMemoryUsed());
            mem = Math.min(mem, this.maxMemoryPerCache);
            if (info2.wasFull()) {
                ++fullCacheCount;
            } else {
                mem = Math.min(mem, info2.getMemoryUsed());
            }
            mem = Math.min(mem, this.maxMemoryPerCache);
            mem = Math.max(mem, this.minMemoryPerCache);
            info2.setMemory(mem);
        }
        long unusedMemory = this.maxMemory;
        for (i = 0; i < infos.length; ++i) {
            unusedMemory -= infos[i].getMemory();
        }
        if (unusedMemory > 0L && fullCacheCount > 0) {
            for (i = 0; i < infos.length; ++i) {
                info = infos[i];
                if (!info.wasFull()) continue;
                info.setMemory(info.getMemory() + unusedMemory / (long)fullCacheCount);
            }
        }
        for (i = 0; i < infos.length; ++i) {
            info = infos[i];
            Cache cache = info.getCache();
            log.debug(cache + " now:" + cache.getMaxMemorySize() + " used:" + info.getMemoryUsed() + " access:" + info.getAccessCount() + " new:" + info.getMemory());
            cache.setMaxMemorySize(info.getMemory());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Cache cache) {
        WeakHashMap weakHashMap = this.caches;
        synchronized (weakHashMap) {
            this.caches.put(cache, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Cache cache) {
        WeakHashMap weakHashMap = this.caches;
        synchronized (weakHashMap) {
            this.caches.remove(cache);
        }
    }

    @Override
    public void disposeCache(Cache cache) {
        this.remove(cache);
    }

    public static class CacheInfo {
        private Cache cache;
        private long accessCount;
        private long memory;
        private long memoryUsed;
        private boolean wasFull;

        CacheInfo(Cache cache) {
            this.cache = cache;
            this.memory = cache.getMaxMemorySize();
            this.memoryUsed = cache.getMemoryUsed();
            this.accessCount = cache.getAccessCount();
            cache.resetAccessCount();
            this.wasFull = this.memoryUsed + 16384L >= this.memory;
        }

        boolean wasFull() {
            return this.wasFull;
        }

        long getAccessCount() {
            return this.accessCount;
        }

        long getMemoryUsed() {
            return this.memoryUsed;
        }

        void setMemory(long mem) {
            this.memory = mem;
        }

        long getMemory() {
            return this.memory;
        }

        Cache getCache() {
            return this.cache;
        }
    }
}

