/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.xml;

import com.kingdee.bos.ctrl.common.util.CommonSLF4JLogger;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.xml.AbstractSAXEventGenerator;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.jackrabbit.value.ValueHelper;
import org.slf4j.Logger;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class DocViewSAXEventGenerator
extends AbstractSAXEventGenerator {
    private static Logger log = CommonSLF4JLogger.getLogger(DocViewSAXEventGenerator.class);
    public static final String CDATA_TYPE = "CDATA";
    private final List props = new ArrayList();

    public DocViewSAXEventGenerator(Node node, boolean noRecurse, boolean skipBinary, ContentHandler contentHandler) throws RepositoryException {
        super(node, noRecurse, skipBinary, contentHandler);
    }

    private Name getQName(String rawName) throws RepositoryException {
        try {
            return this.resolver.getQName(rawName);
        }
        catch (NameException e) {
            String msg = "internal error: failed to resolve namespace mappings";
            log.error(msg, (Throwable)((Object)e));
            throw new RepositoryException(msg, (Throwable)((Object)e));
        }
    }

    @Override
    protected void entering(Node node, int level) throws RepositoryException, SAXException {
    }

    @Override
    protected void enteringProperties(Node node, int level) throws RepositoryException, SAXException {
        this.props.clear();
    }

    @Override
    protected void leavingProperties(Node node, int level) throws RepositoryException, SAXException {
        String name = node.getName();
        if (name.equals(this.jcrXMLText)) {
            for (Property prop : this.props) {
                String propName = prop.getName();
                if (!propName.equals(this.jcrXMLCharacters)) continue;
                char[] chars = prop.getValue().getString().toCharArray();
                this.contentHandler.characters(chars, 0, chars.length);
            }
        } else {
            String elemName = node.getDepth() == 0 ? this.jcrRoot : ISO9075.encode(name);
            AttributesImpl attrs = new AttributesImpl();
            this.addNamespacePrefixes(level, attrs);
            for (Property prop : this.props) {
                String propName = prop.getName();
                if (prop.getDefinition().isMultiple()) continue;
                String attrName = ISO9075.encode(propName);
                Name qName = this.getQName(attrName);
                if (prop.getType() == 2 && this.skipBinary) {
                    attrs.addAttribute(qName.getNamespaceURI(), qName.getLocalName(), attrName, CDATA_TYPE, "");
                    continue;
                }
                StringBuffer attrValue = new StringBuffer();
                attrValue.append(ValueHelper.serialize(prop.getValue(), false));
                attrs.addAttribute(qName.getNamespaceURI(), qName.getLocalName(), attrName, CDATA_TYPE, attrValue.toString());
            }
            Name qName = this.getQName(elemName);
            this.contentHandler.startElement(qName.getNamespaceURI(), qName.getLocalName(), elemName, attrs);
        }
    }

    @Override
    protected void leaving(Node node, int level) throws RepositoryException, SAXException {
        String name = node.getName();
        if (name.equals(this.jcrXMLText)) {
            return;
        }
        String elemName = node.getDepth() == 0 ? this.jcrRoot : ISO9075.encode(name);
        Name qName = this.getQName(elemName);
        this.contentHandler.endElement(qName.getNamespaceURI(), qName.getLocalName(), elemName);
    }

    @Override
    protected void entering(Property prop, int level) throws RepositoryException, SAXException {
        this.props.add(prop);
    }

    @Override
    protected void leaving(Property prop, int level) throws RepositoryException, SAXException {
    }
}

