/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi.commons.conversion;

import com.kingdee.bos.ctrl.common.util.CommonSLF4JLogger;
import javax.jcr.NamespaceException;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.CachingNameResolver;
import org.apache.jackrabbit.spi.commons.conversion.CachingPathResolver;
import org.apache.jackrabbit.spi.commons.conversion.IllegalNameException;
import org.apache.jackrabbit.spi.commons.conversion.MalformedPathException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;
import org.apache.jackrabbit.spi.commons.conversion.ParsingNameResolver;
import org.apache.jackrabbit.spi.commons.conversion.ParsingPathResolver;
import org.apache.jackrabbit.spi.commons.conversion.PathResolver;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.jackrabbit.spi.commons.name.PathFactoryImpl;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.slf4j.Logger;

public class DefaultNamePathResolver
implements NamePathResolver {
    private static Logger log = CommonSLF4JLogger.getLogger(DefaultNamePathResolver.class);
    private final NameResolver nResolver;
    private final PathResolver pResolver;

    public DefaultNamePathResolver(NamespaceResolver nsResolver) {
        this(nsResolver, false);
    }

    public DefaultNamePathResolver(NamespaceResolver nsResolver, boolean enableCaching) {
        ParsingNameResolver nr = new ParsingNameResolver(NameFactoryImpl.getInstance(), nsResolver);
        ParsingPathResolver pr = new ParsingPathResolver(PathFactoryImpl.getInstance(), nr);
        if (enableCaching) {
            this.nResolver = new CachingNameResolver(nr);
            this.pResolver = new CachingPathResolver(pr);
        } else {
            this.nResolver = nr;
            this.pResolver = pr;
        }
    }

    public DefaultNamePathResolver(NameResolver nResolver, PathResolver pResolver) {
        this.nResolver = nResolver;
        this.pResolver = pResolver;
    }

    @Override
    public Name getQName(String name) throws IllegalNameException, NamespaceException {
        return this.nResolver.getQName(name);
    }

    @Override
    public String getJCRName(Name name) throws NamespaceException {
        return this.nResolver.getJCRName(name);
    }

    @Override
    public Path getQPath(String path) throws MalformedPathException, IllegalNameException, NamespaceException {
        return this.pResolver.getQPath(path);
    }

    @Override
    public String getJCRPath(Path path) throws NamespaceException {
        return this.pResolver.getJCRPath(path);
    }
}

