/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.core;

import com.kingdee.bos.ctrl.excel.core.RenderUtil;
import com.kingdee.bos.ctrl.excel.core.SpreadView;
import com.kingdee.bos.ctrl.excel.core.SpreadViewUI;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.embed.EmbedhLayer;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

final class CornerUI
extends SpreadViewUI {
    private static CornerUI ui = new CornerUI();

    CornerUI() {
    }

    public static ComponentUI createUI(JComponent c) {
        return ui;
    }

    @Override
    protected void installDefaults(SpreadView view) {
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        SpreadView view = (SpreadView)c;
        int w = view.getSpread().getBook().getActiveSheet().getRowHeaderWidth();
        int h = view.getSpread().getBook().getActiveSheet().getColHeaderHeight();
        return new Dimension(w, h);
    }

    @Override
    protected boolean prePaint(Graphics2D g, SpreadView view) {
        return true;
    }

    @Override
    protected void paintBase(Graphics2D g, SpreadView view) {
        Graphics2D g2d = g;
        Sheet sheet = view.getSpread().getBook().getActiveSheet();
        int x = 0;
        int y = 0;
        int w = sheet.getRowHeaderWidth();
        int h = sheet.getColHeaderHeight();
        g2d.setColor(RenderUtil.HEAD_GRID_COLOR);
        g2d.fillRect(x, y, w, 1);
        g2d.fillRect(x, y + h - 1, w, 1);
        g2d.fillRect(x, y, 1, h);
        g2d.fillRect(x + w - 1, y, 1, h);
        EmbedhLayer gl = sheet.getEmbedments(false);
        if (sheet.getSheetOption().getSelection().isSheetBlocks() && (gl == null || !gl.hasSelection())) {
            g2d.setColor(RenderUtil.SELECT_ALL_COLOR);
            g2d.setXORMode(view.getBackground());
            g2d.fillRect(x, y, w, h);
        }
    }

    @Override
    protected void afterPaint(Graphics2D g, SpreadView view) {
    }
}

