/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.expans.model;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.expans.model.ExtConst;
import com.kingdee.bos.ctrl.excel.expans.model.collection.SortedExtPropFormulasArray;
import com.kingdee.bos.ctrl.excel.expans.model.collection.SortedExtPropsArray;
import com.kingdee.bos.ctrl.excel.expans.model.data.ExtDataSet;
import com.kingdee.bos.ctrl.excel.expans.model.data.ExtGroup;
import com.kingdee.bos.ctrl.excel.expans.model.data.ExtRow;
import com.kingdee.bos.ctrl.excel.model.expr.Expr;
import com.kingdee.bos.ctrl.excel.model.expr.IExprNode;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.CellPropAction;
import com.kingdee.bos.ctrl.excel.model.struct.Dependents;
import com.kingdee.bos.ctrl.excel.model.struct.ICalculable;
import com.kingdee.bos.ctrl.excel.model.struct.MergeBlocks;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetAction_InsDel;
import com.kingdee.bos.ctrl.excel.model.struct.node.CellBlockNode;
import com.kingdee.bos.ctrl.excel.model.struct.node.NamedObjectNode;
import com.kingdee.bos.ctrl.excel.model.util.ObjectArray;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;

public class ExtProps
extends ExtConst
implements Cloneable {
    private Cell _cell;
    private ExtProps _yHead;
    private ExtProps _xHead;
    private ExtProps _source = this;
    private SortedExtPropFormulasArray _formulas;
    private ExtGroup _group;
    private ExtRow _row;
    private int _extensible;
    private int _height;
    private int _width;
    private ExtProps[] _exts;
    private SortedExtPropsArray _subs;
    private CellBlock _subsBound;

    public ExtProps(Cell cell) {
        this._cell = cell;
        this._extensible = -1;
    }

    public Object clone() {
        ExtProps ep = null;
        try {
            ep = (ExtProps)super.clone();
            ep._subs = null;
            if (this._formulas != null) {
                ep._formulas = (SortedExtPropFormulasArray)((Object)this._formulas.clone());
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return ep;
    }

    public void calcExtendProps() {
        CellBlock merge = this._cell.getMerge(false);
        if (merge != null) {
            this._height = merge.getHeight() - 1;
            this._width = merge.getWidth() - 1;
        }
        this.getHead(true, true);
        this.getHead(false, true);
        this.getExtensible(true);
    }

    public void clearSubs() {
        if (this._subs != null) {
            this._subs.clear();
        }
    }

    public ExtGroup getGroup() {
        return this._group;
    }

    public void setGroup(ExtGroup group) {
        this._group = group;
    }

    public ExtRow getExtRow() {
        return this._row;
    }

    public void setExtRow(ExtRow row) {
        this._row = row;
    }

    public SortedExtPropFormulasArray getFormulas(boolean create) {
        if (this._formulas == null && create) {
            this._formulas = new SortedExtPropFormulasArray(this.getSheet(), this._cell);
        }
        return this._formulas;
    }

    public void setFormulas(SortedExtPropFormulasArray formulas) {
        this._formulas = formulas;
    }

    public String getFormula(CellPropAction action) {
        return this._formulas != null ? this._formulas.get(action) : null;
    }

    public void removeFormula(CellPropAction action) {
        if (this._formulas != null && this._formulas.remove(action) != null && this._formulas.isEmpty()) {
            this._formulas = null;
        }
    }

    public String toString() {
        String str;
        if (this._cell == null) {
            str = this._extensible == 2 ? "LEFT00" : "TOP00";
        } else {
            StringBuffer sb = new StringBuffer(this._cell.toString());
            switch (this._extensible) {
                case 2: {
                    sb.append(" V ");
                    break;
                }
                case 1: {
                    sb.append(" H ");
                    break;
                }
                case 0: {
                    sb.append(" N ");
                    break;
                }
                default: {
                    sb.append(" U ");
                }
            }
            sb.append(this._height);
            sb.append(' ');
            sb.append(this._width);
            str = sb.toString();
        }
        return str;
    }

    public Cell getCell() {
        return this._cell;
    }

    public void setCell(Cell cll) {
        this._cell = cll;
    }

    public Sheet getSheet() {
        return this._cell.getSheet();
    }

    public int getRC(boolean isRow) {
        return isRow ? this.getRow() : this.getCol();
    }

    public int getRow() {
        return this._cell == null ? 0 : this._cell.getRow();
    }

    public int getRow2() {
        return this._cell == null ? -1 : this._cell.getRow() + this._height;
    }

    public int getCol() {
        return this._cell == null ? 0 : this._cell.getCol();
    }

    public int getCol2() {
        return this._cell == null ? -1 : this._cell.getCol() + this._width;
    }

    public ExtProps getSource() {
        return this._source;
    }

    public void setSource(ExtProps src) {
        this._source = src;
    }

    public CellBlock getSubsBound() {
        if (this._subsBound == null) {
            this._subsBound = this.calcSubsBound(null);
        }
        return this._subsBound;
    }

    private CellBlock calcSubsBound(CellBlock bd) {
        int row = this.getRow();
        int col = this.getCol();
        if (bd == null) {
            bd = CellBlock.getNewCellBlock(row, col, row + this._height, col + this._width);
        } else {
            if (row < bd.getRow()) {
                bd.setRow(row);
            }
            if (row + this._height > bd.getRow2()) {
                bd.setRow2(row + this._height);
            }
            if (col < bd.getCol()) {
                bd.setCol(col);
            }
            if (col + this._width > bd.getCol2()) {
                bd.setCol2(col + this._width);
            }
        }
        if (this._subs != null) {
            for (int i = this._subs.size() - 1; i >= 0; --i) {
                ExtProps sub = (ExtProps)this._subs.get(i);
                sub.calcSubsBound(bd);
            }
        }
        return bd;
    }

    public int getExtIndex() {
        int index = 0;
        if (this._exts != null) {
            for (int i = 0; i < this._exts.length; ++i) {
                if (this != this._exts[i]) continue;
                index = i;
                break;
            }
        }
        return index;
    }

    public ExtProps[] getExts() {
        return this._exts;
    }

    public void linkHead(boolean isLeft) {
        ExtProps head;
        ExtProps extProps = head = isLeft ? this._yHead : this._xHead;
        if (head != null) {
            head.addSub(this);
        }
    }

    public ExtProps getHead(boolean yDir, boolean calc) {
        SortedCellBlockArray blocks;
        MergeBlocks merge;
        ExtProps head;
        ExtProps extProps = head = yDir ? this._yHead : this._xHead;
        if (head != null || !calc) {
            return head;
        }
        if (this._cell == null) {
            return null;
        }
        int row = this._cell.getRow();
        int col = this._cell.getCol();
        Sheet sheet = this._cell.getSheet();
        boolean follow = false;
        Sheet.ICellsIterator ci = yDir ? this._cell.getRowObject().getCellsIterator(0, col - 1, true, false) : sheet.getCellsIterator(0, col, row - 1, col, true, false);
        while (ci.hasNext()) {
            ExtProps prev;
            CellBlock cb;
            Cell prevCell = ci.next();
            if (!prevCell.isFirstMergedCell() && (cb = sheet.getMergeBlock(prevCell)) != null) {
                prevCell = sheet.getFirstCell(cb, false);
            }
            if ((prev = prevCell.getExtProps(false)) == null) continue;
            boolean prevCanExtend = false;
            if (prevCell.hasFormula()) {
                prevCanExtend = prevCell.getExpr().isExtensible();
            }
            if (prevCanExtend && (yDir ? prev.containRow(this) : prev.containCol(this)) && prev.getExtensible(true) == (yDir ? 2 : 1)) {
                if (this.isHeadOf(prev, yDir)) continue;
                head = prev;
                break;
            }
            ExtProps headOfPrev = yDir ? prev._yHead : prev._xHead;
            if (headOfPrev == null || headOfPrev.isCell00() || this.isHeadOf(headOfPrev, yDir)) continue;
            follow = true;
            head = headOfPrev;
            break;
        }
        if ((head == null || follow) && (merge = sheet.getMerger(false)) != null && (blocks = yDir ? merge.getTouchedBlocks(row, 0, row, col - 1) : merge.getTouchedBlocks(0, col, row - 1, col)) != null) {
            int headRow = 0;
            int headCol = 0;
            if (follow) {
                headRow = head.getRow();
                headCol = head.getCol();
            }
            for (int i = blocks.size() - 1; i >= 0; --i) {
                ExtProps headOfPrev;
                ExtProps prev;
                CellBlock cb = blocks.getBlock(i);
                if (head != null && !cb.contains(headRow, headCol) || !(yDir ? cb.containsRow(row) : cb.containsCol(col)) || (!yDir ? cb.containsRow(row) : cb.containsCol(col)) || (prev = sheet.getCell(cb.getRow(), cb.getCol(), false).getExtProps(false)) == null) continue;
                boolean prevCanExtend = false;
                Cell prevCell = prev.getCell();
                if (prevCell.hasFormula()) {
                    prevCanExtend = prevCell.getExpr().isExtensible();
                }
                if (prevCanExtend && prev.getExtensible(true) == (yDir ? 2 : 1)) {
                    head = prev;
                    break;
                }
                ExtProps extProps2 = headOfPrev = yDir ? prev._yHead : prev._xHead;
                if (headOfPrev == null || this.isHeadOf(headOfPrev, yDir)) continue;
                head = headOfPrev;
                break;
            }
        }
        if (sheet.isCalcExtend()) {
            this.setHead(head, yDir);
            return yDir ? this._yHead : this._xHead;
        }
        return head;
    }

    public void setHead(String headStr, boolean yDir) {
        ExtProps head = null;
        if (!StringUtil.isEmptyString((String)headStr)) {
            IExprNode node;
            Sheet sheet = this.getSheet();
            Expr expr = sheet.getExpr(null, headStr);
            if (expr.isSingleCell()) {
                CellBlockNode node2 = (CellBlockNode)expr.getParameters()[0];
                head = node2.getFirstCell(true).getExtProps(true);
            } else if (expr.isNamedObject() && (node = expr.getParameters()[0]) == NamedObjectNode.Null) {
                head = yDir ? sheet.LEFT00 : sheet.TOP00;
            }
        }
        this.setHead(head, yDir);
    }

    public boolean setHead(ExtProps head, boolean yDir) {
        if (head == null) {
            Sheet sheet = this.getSheet();
            ExtProps extProps = head = yDir ? sheet.LEFT00 : sheet.TOP00;
        }
        if (this.isHeadOf(head, yDir)) {
            return false;
        }
        if (yDir) {
            this._yHead = head;
        } else {
            this._xHead = head;
        }
        head.addSub(this);
        return true;
    }

    private void addSub(ExtProps sub) {
        if (this._subs == null) {
            this._subs = new SortedExtPropsArray();
        }
        this._subs.insert(sub);
        this._subsBound = null;
    }

    public int getHeight() {
        return this._height;
    }

    public void setHeight(int height) {
        this._height = height;
    }

    public int getWidth() {
        return this._width;
    }

    public void setWidth(int width) {
        this._width = width;
    }

    public boolean isExtensible() {
        int ext = this.getExtensible(true);
        return ext == 1 || ext == 2;
    }

    public int getExtensible(boolean calc) {
        if (this._extensible == -1 && calc) {
            ExtProps leftHead = this.getHead(true, true);
            ExtProps topHead = this.getHead(false, true);
            Sheet sheet = this.getSheet();
            int extensible = 2;
            if (leftHead == sheet.LEFT00) {
                if (topHead != sheet.TOP00) {
                    extensible = 1;
                }
            } else if (topHead != sheet.TOP00) {
                extensible = 0;
            }
            if (sheet.isCalcExtend()) {
                this._extensible = extensible;
            } else {
                return extensible;
            }
        }
        return this._extensible;
    }

    public void setExtensible(int extensible) {
        this._extensible = extensible == 2 || extensible == 1 || extensible == 0 ? extensible : -1;
    }

    public SortedExtPropsArray getSubs() {
        return this._subs;
    }

    public ExtProps getSubBySource(ExtProps source, boolean yDir) {
        if (this._subs != null) {
            ExtProps src = source._source;
            if (yDir) {
                int srcCol = source.getCol();
                ExtProps sub = this._subs.getSubBySourceCol(src, this.getRow(), srcCol);
                if (sub != null) {
                    return sub;
                }
                int size = this._subs.size();
                for (int i = 0; i < size; ++i) {
                    sub = (ExtProps)this._subs.get(i);
                    if (sub._source != src || sub.getCol() != srcCol) continue;
                    return sub;
                }
            } else {
                return this._subs.getSubBySourceRow(src, source.getRow());
            }
        }
        return null;
    }

    public boolean isCell00() {
        return this._cell == null;
    }

    public boolean containRow(ExtProps sub) {
        int subRow;
        int row = this.getRow();
        if (row <= (subRow = sub.getRow())) {
            return row + this._height >= subRow + sub._height;
        }
        return false;
    }

    public boolean containCol(ExtProps sub) {
        int subCol;
        int col = this.getCol();
        if (col <= (subCol = sub.getCol())) {
            return col + this._width >= subCol + sub._width;
        }
        return false;
    }

    public boolean isHeadOf(ExtProps sub, boolean yDir) {
        while (sub != null) {
            if (this == sub) {
                return true;
            }
            sub = yDir ? sub._yHead : sub._xHead;
        }
        return false;
    }

    private boolean isHeadOf(CellBlockNode cb, boolean yDir) {
        ExtProps sub;
        Cell cll = cb.getFirstCell(false);
        if (cll != null && (sub = cll.getExtProps(false)) != null) {
            return this.isHeadOf(sub, yDir);
        }
        return false;
    }

    public boolean sameRowTypeAs(ExtProps other) {
        return this._cell.getRowObject().getType() == other.getCell().getRowObject().getType();
    }

    private void expandSelf(int rowMergeInc, int colMergeInc) {
        if (this._cell == null) {
            return;
        }
        this._height += rowMergeInc;
        this._width += colMergeInc;
    }

    public void expandHead(boolean yDir, int mergeInc) {
        if (mergeInc <= 0) {
            return;
        }
        ExtProps head = yDir ? this._yHead : this._xHead;
        ExtProps sub = this;
        while (head != null) {
            SortedExtPropsArray headSubs = head._subs;
            int size = headSubs.size();
            for (int i = 0; i < size; ++i) {
                ExtProps sibling = (ExtProps)headSubs.get(i);
                if (sibling == sub) continue;
                if (yDir) {
                    if (!sibling.containRow(this)) continue;
                    sibling.expandSelf(mergeInc, 0);
                    continue;
                }
                if (!sibling.containCol(this)) continue;
                sibling.expandSelf(0, mergeInc);
            }
            if (!head.isCell00()) {
                if (yDir) {
                    if (head.containRow(this)) {
                        head.expandSelf(mergeInc, 0);
                    }
                } else if (head.containCol(this)) {
                    head.expandSelf(0, mergeInc);
                }
            }
            sub = head;
            head = yDir ? head._yHead : head._xHead;
        }
    }

    public void extend(boolean yDir, int extCount) {
        CellBlock subs = this.getSubsBound();
        int range = yDir ? subs.getHeight() : subs.getWidth();
        Cell thisCell = this.getCell();
        Sheet sheet = this.getSheet();
        if (extCount > 1) {
            CellBlock cbDst = yDir ? CellBlock.getNewCellBlock(subs.getRow2() + 1, 0, subs.getRow() + range * extCount - 1, 16383) : CellBlock.getNewCellBlock(0, subs.getCol2() + 1, 1048575, subs.getCol() + range * extCount - 1);
            SheetAction_InsDel sai = new SheetAction_InsDel(sheet.getRange(cbDst), true, yDir);
            sai.actionBlock(null, sheet, cbDst);
        }
        this.expandHead(yDir, range * (extCount - 1));
        Sheet.ICellsIterator ci = yDir ? sheet.getEntireRowCellsIterator(subs.getRow(), subs.getRow2(), false, false) : sheet.getEntireColCellsIterator(subs.getCol(), subs.getCol2(), false, false);
        while (ci.hasNext()) {
            boolean changeHead;
            ExtProps sub = ci.next().getExtProps(false);
            if (sub == null || !this.isHeadOf(sub, yDir)) continue;
            Cell subCell = sub.getCell();
            int subRow = subCell.getRow();
            int subCol = subCell.getCol();
            boolean hasFormula = subCell.hasFormula();
            ShareStyleAttributes subSSA = subCell.getSSA();
            Row rowObj = yDir ? null : sheet.getRow(subRow, true);
            boolean extSelf = this == sub;
            boolean bGroup = false;
            Variant[] aValue = null;
            ExtRow[] aRow = null;
            if (extSelf) {
                Variant var = subCell.getValue();
                if (var.isArray()) {
                    aValue = (Variant[])var.getValue();
                    bGroup = aValue[0].getValue() instanceof ExtGroup;
                } else {
                    ExtGroup group = (ExtGroup)var.getValue();
                    aValue = group.getValues();
                    aRow = group.getRows();
                }
            }
            ExtProps head = sub.getHead(yDir, true);
            int headRow = 0;
            int headCol = 0;
            boolean bl = changeHead = !head.isCell00() && this.isHeadOf(head, yDir);
            if (changeHead) {
                headRow = head.getRow();
                headCol = head.getCol();
            }
            int i = 0;
            int offset = 0;
            while (i < extCount) {
                Cell newCell = yDir ? sheet.getCell(subRow + offset, subCol, true) : rowObj.getCell(subCol + offset, true);
                ExtProps newProps = null;
                if (newCell == thisCell) {
                    newProps = sub;
                    newCell.setFormula(null);
                    this._exts = new ExtProps[extCount];
                }
                if (newCell != subCell) {
                    newProps = newCell.getExtProps(sub);
                    newCell.setSSA(subSSA);
                    if (changeHead) {
                        Cell newHeadCell = yDir ? sheet.getCell(headRow + offset, headCol, true) : sheet.getCell(headRow, headCol + offset, true);
                        ExtProps newHead = newHeadCell.getExtProps(head);
                        newProps.setHead(newHead, yDir);
                        newProps.linkHead(!yDir);
                    } else {
                        newProps.linkHead(yDir);
                        newProps.linkHead(!yDir);
                    }
                }
                if (extSelf) {
                    this._exts[i] = newProps;
                    if (bGroup) {
                        ExtGroup grp = (ExtGroup)aValue[i].getValue();
                        newCell.setValue(grp.getValues()[0]);
                        if (newProps != null) {
                            newProps.setGroup(grp);
                            if (!grp.isNullGroup()) {
                                newProps.setExtRow(grp.getRows()[0]);
                            }
                        }
                    } else {
                        newCell.setValue(aValue[i]);
                        if (aRow != null && newProps != null) {
                            newProps.setExtRow(aRow[i]);
                        }
                    }
                } else if (newCell != subCell) {
                    newCell.cloneVarFrom(subCell);
                    if (hasFormula) {
                        this.offsetExprCellBlockNode(this, newCell, newCell.getExpr(), offset, yDir);
                        if (newProps != null) {
                            SortedExtPropFormulasArray formulas = newProps.getFormulas(false);
                            if (formulas != null) {
                                int jEnd = formulas.size();
                                for (int j = 0; j < jEnd; ++j) {
                                    SortedExtPropFormulasArray.Node node = (SortedExtPropFormulasArray.Node)formulas.get(j);
                                    this.offsetExprCellBlockNode(this, newCell, node.getExpr(), offset, yDir);
                                }
                            }
                            newCell.setQueued(false);
                            newCell.setCalculating(false);
                            newCell.queue();
                        }
                    }
                }
                ++i;
                offset += range;
            }
        }
    }

    private boolean offsetExprCellBlockNode(ExtProps extender, Cell refer, Expr expr, int offset, boolean yDir) {
        if (expr == null || !expr.hasCellBlock()) {
            return false;
        }
        int offsetY = 0;
        int offsetX = 0;
        if (yDir) {
            offsetY = offset;
        } else {
            offsetX = offset;
        }
        boolean offseted = false;
        Sheet sheet = this.getSheet();
        Dependents deps = sheet.getDeps();
        ObjectArray al = deps.getObjectArray(-1);
        if (expr.getParameters(al, false) > 0) {
            int size = al.size();
            for (int ai = 0; ai < size; ++ai) {
                IExprNode[] nodes = ((Expr)al.get(ai)).getParameters();
                for (int i = nodes.length - 1; i >= 0; --i) {
                    CellBlockNode cb;
                    IExprNode node = nodes[i];
                    if (!(node instanceof CellBlockNode) || (cb = (CellBlockNode)node).getSheet() != sheet || cb.isAbsolute() || !extender.isHeadOf(cb, yDir)) continue;
                    CellBlockNode cbNew = (CellBlockNode)cb.clone();
                    cbNew.setRefs(null);
                    cbNew.offset(offsetY, offsetX);
                    nodes[i] = cbNew.getSheet().setDependent((ICalculable)refer, cbNew);
                    offseted = true;
                }
            }
        }
        return offseted;
    }

    public void setCurrentGroup() {
        if (this._group != null) {
            this._group.getDataSet().setCurrentGroup(this._group);
        }
        if (this._row != null) {
            this._row.getDataSet().setCurrentRow(this._row);
        }
        ExtDataSet headDataSet = null;
        ExtProps head = this._yHead;
        while (head != null) {
            if (head._group != null && (headDataSet = head._group.getDataSet()).getCurrentGroup() == null) {
                headDataSet.setCurrentGroup(head._group);
            }
            if (head._row != null && (headDataSet = head._row.getDataSet()).getCurrentRow() == null) {
                headDataSet.setCurrentRow(head._row);
            }
            head = head._yHead;
        }
        head = this._xHead;
        while (head != null) {
            if (head._group != null) {
                ExtGroup current = head._group.getDataSet().getCurrentGroup();
                current = current != null ? current.getDataSet().intersect(current, head._group) : head._group;
                current.getDataSet().setCurrentGroup(current);
            }
            if (head._row != null && (headDataSet = head._row.getDataSet()).getCurrentRow() == null) {
                headDataSet.setCurrentRow(head._row);
            }
            head = head._xHead;
        }
    }
}

