/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.expans.model.data;

import com.kingdee.bos.ctrl.common.variant.ExprErr;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.expans.model.ExtProps;
import com.kingdee.bos.ctrl.excel.expans.model.data.ExtColumn;
import com.kingdee.bos.ctrl.excel.expans.model.data.ExtDataSet;
import com.kingdee.bos.ctrl.excel.expans.model.data.ExtGroup;
import com.kingdee.bos.ctrl.excel.expans.model.data.ExtendFuncProvider;
import com.kingdee.bos.ctrl.excel.model.expr.ExcelFuncProvider;
import com.kingdee.bos.ctrl.excel.model.expr.Expr;
import com.kingdee.bos.ctrl.excel.model.expr.ExprContext;
import com.kingdee.bos.ctrl.excel.model.expr.ExprExpressionParam;
import com.kingdee.bos.ctrl.excel.model.expr.ExprMethod;
import com.kingdee.bos.ctrl.excel.model.expr.ExprNeedExpParam;
import com.kingdee.bos.ctrl.excel.model.expr.ExprParamPos;
import com.kingdee.bos.ctrl.excel.model.expr.IExprNode;
import com.kingdee.bos.ctrl.excel.model.expr.IInnerFuncProvider;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Dependents;
import com.kingdee.bos.ctrl.excel.model.struct.ICalculable;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.excel.model.struct.node.CellBlockNode;
import com.kingdee.bos.ctrl.excel.model.util.IntArray;
import com.kingdee.bos.ctrl.excel.model.util.ObjectArray;

public class ExtFuncProvider
implements IInnerFuncProvider {
    public Variant $(Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 1, 1);
        Variant var = (Variant)args[0];
        if (!(var.getValue() instanceof CellBlockNode)) {
            ExprErr.goError((long)16L, (Object)"\u53c2\u6570\u975e\u5355\u5143\u683c");
        }
        return var;
    }

    public Variant CELL(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        Cell srcCell;
        ExcelFuncProvider.validParamCount(args, 0, 3);
        ICalculable owner = ctx.getExprOwner();
        Object varCll = args[0];
        if (varCll == Variant.nullVariant) {
            if (!(owner instanceof Cell)) {
                ExprErr.goError((long)16L, (Object)"\u53c2\u6570\u975e\u5355\u5143\u683c");
            }
            srcCell = (Cell)owner;
        } else {
            srcCell = this.getValidExtProps(ctx, varCll).getCell();
        }
        int rowOffset = 0;
        int colOffset = 0;
        if (args.length > 1) {
            rowOffset = this.getValidCoorOffset(ctx, args[1], true);
            if (args.length > 2) {
                colOffset = this.getValidCoorOffset(ctx, args[2], true);
            }
        }
        Sheet sheet = srcCell.getSheet();
        int row = srcCell.getRow() + rowOffset;
        int col = srcCell.getCol() + colOffset;
        CellBlockNode node = CellBlockNode.getNewBlock(sheet, row, col, row, col, 0);
        sheet.setDependent(owner, node);
        return new Variant((Object)node, 18);
    }

    public Variant EXINDEX(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        boolean isLeft;
        ExcelFuncProvider.validParamCount(args, 0, 1);
        ICalculable owner = ctx.getExprOwner();
        if (!(owner instanceof Cell)) {
            ExprErr.goError((long)2048L, (Object)"\u5355\u5143\u683c\u516c\u5f0f\u624d\u53ef\u5305\u542b\u672c\u51fd\u6570");
        }
        Cell exprOwner = (Cell)owner;
        ExtProps epDst = exprOwner.getExtProps(false);
        ExtProps epDim = args.length == 0 ? epDst : this.getValidExtProps(ctx, args[0]);
        boolean bl = isLeft = epDst.getExtensible(true) == 2;
        if (!epDim.isHeadOf(epDst, isLeft)) {
            ExprErr.goError((long)262144L, (Object)(this.getCellName(epDim) + "\u975e" + this.getCellName(epDst) + "\u7236\u7ef4"));
        }
        return new Variant(epDim.getExtIndex() + 1);
    }

    public Variant EX(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        return this._ex(ctx, args, false);
    }

    public Variant EXS(ExprNeedExpParam ctx, Object[] args) throws SyntaxErrorException {
        return this._ex(ctx, args, true);
    }

    private Variant _ex(ExprContext ctx, Object[] args, boolean returnRange) throws SyntaxErrorException {
        ExtProps epDst;
        ExcelFuncProvider.validParamCount(args, 1, returnRange ? 4 : 3);
        Variant varRet = Variant.nullVariant;
        ObjectArray yDims = null;
        ObjectArray xDims = null;
        ICalculable owner = ctx.getExprOwner();
        if (!(owner instanceof Cell)) {
            ExprErr.goError((long)2048L, (Object)"\u5355\u5143\u683c\u516c\u5f0f\u624d\u53ef\u5305\u542b\u672c\u51fd\u6570");
        }
        Cell exprOwner = (Cell)owner;
        ExtProps epOwner = exprOwner.getExtProps(false);
        Expr filterExpr = null;
        if (ctx.getDeps().isCalcLastMode()) {
            if (!exprOwner.isQueueLast()) {
                exprOwner.setQueueLast(true);
                return Variant.calcLast;
            }
        } else {
            exprOwner.setQueueLast(false);
        }
        if (returnRange && args.length == 4) {
            Object value = args[3];
            if (value instanceof ExprExpressionParam) {
                filterExpr = ((ExprExpressionParam)value).getExpr();
            } else {
                ExprErr.goError((long)16L, (Object)"\u8fc7\u6ee4\u8868\u8fbe\u5f0f");
            }
        }
        Variant varY = Variant.nullVariant;
        Variant varX = Variant.nullVariant;
        boolean all = false;
        Variant varDst = (Variant)args[0];
        boolean referSelf = varDst.isArray();
        int dimIndex = 1;
        if (referSelf || varDst.isNull()) {
            epDst = epOwner;
            if (referSelf) {
                dimIndex = 0;
            }
        } else {
            epDst = this.getValidExtProps(ctx, varDst);
        }
        if (args.length > dimIndex) {
            varY = this.checkDimVar((Variant)args[dimIndex++], ctx, exprOwner);
            if (args.length > dimIndex) {
                varX = this.checkDimVar((Variant)args[dimIndex], ctx, exprOwner);
            }
        }
        if (varY.isNull() && varX.isNull()) {
            if (epDst == epOwner) {
                ExprErr.goError((long)32768L, null);
            } else {
                all = true;
            }
        }
        if (!varX.isNull()) {
            xDims = this.getDimsFromVar(ctx, epDst, varX, false);
        } else if (returnRange) {
            xDims = this.createDefaultDims(ctx, epOwner, epDst, false, all);
        }
        if (!varY.isNull()) {
            yDims = this.getDimsFromVar(ctx, epDst, varY, true);
        } else if (returnRange) {
            yDims = this.createDefaultDims(ctx, epOwner, epDst, true, all);
        }
        Sheet sheet = ctx.getExprOwner().getSheet();
        if (returnRange) {
            Object[][] aaParams = null;
            if (filterExpr != null && filterExpr.hasCellBlock()) {
                aaParams = new Object[3][];
                ObjectArray oriParams = ctx.getObjectArray(0);
                ObjectArray newParams = ctx.getObjectArray(0);
                ObjectArray indexs = ctx.getObjectArray(0);
                filterExpr.getParameters(oriParams, false);
                aaParams[0] = oriParams.toArray();
                filterExpr = (Expr)filterExpr.clone();
                filterExpr.getParameters(newParams, false);
                aaParams[1] = newParams.toArray();
                IntArray aPos = new IntArray();
                int size = oriParams.size();
                for (int i = 0; i < size; ++i) {
                    Expr expr = (Expr)oriParams.get(i);
                    IntArray aAbs = null;
                    if (expr.hasAbsMethod()) {
                        aAbs = this.getAbsParamPos(ctx, expr);
                    }
                    IExprNode[] nodes = expr.getParameters();
                    for (int j = 0; j < nodes.length; ++j) {
                        if (nodes[j].getExprType() != 4 || aAbs != null && aAbs.contains(j)) continue;
                        aPos.add(j);
                    }
                    indexs.append((Object)aPos.toArray());
                    aPos.clear();
                    if (aAbs == null) continue;
                    ctx.recycleArray(aAbs);
                }
                aaParams[2] = indexs.toArray();
                ctx.recycleArray(oriParams);
                ctx.recycleArray(newParams);
                ctx.recycleArray(indexs);
            }
            IntArray xCoors = this.getCoors(ctx, xDims, epDst, false);
            IntArray yCoors = this.getCoors(ctx, yDims, epDst, true);
            IntArray xSpans = this.getCoorSpans(ctx, xCoors);
            IntArray ySpans = this.getCoorSpans(ctx, yCoors);
            ObjectArray blocks = ctx.getObjectArray(xSpans.size() * ySpans.size() / 4);
            int oriRow = epDst.getRow();
            int oriCol = epDst.getCol();
            int ySize = ySpans.size();
            for (int y = 0; y < ySize; y += 2) {
                int row = ySpans.get(y);
                int row2 = ySpans.get(y + 1);
                int xSize = xSpans.size();
                for (int x = 0; x < xSize; x += 2) {
                    CellBlockNode cb = CellBlockNode.getNewBlock(sheet, row, xSpans.get(x), row2, xSpans.get(x + 1), 0);
                    sheet.setDependent((ICalculable)exprOwner, cb);
                    if (filterExpr == null) {
                        blocks.append((Object)new Variant((Object)cb, 18));
                        continue;
                    }
                    if (cb.isSingleCell()) {
                        if (aaParams != null) {
                            this.offsetFilterExpr(aaParams, cb.getRow() - oriRow, cb.getCol() - oriCol);
                        }
                        if (!filterExpr.execute(ctx, exprOwner).booleanValue()) continue;
                        blocks.append((Object)new Variant((Object)cb, 18));
                        continue;
                    }
                    Sheet.ICellsIterator ci = sheet.getCellsIterator(cb, false, false);
                    while (ci.hasNext()) {
                        Cell cll = ci.next();
                        int cllRow = cll.getRow();
                        int cllCol = cll.getCol();
                        if (aaParams != null) {
                            this.offsetFilterExpr(aaParams, cllRow - oriRow, cllCol - oriCol);
                        }
                        if (!filterExpr.execute(ctx, exprOwner).booleanValue()) continue;
                        CellBlockNode singleCB = CellBlockNode.getNewBlock(sheet, cllRow, cllCol, cllRow, cllCol, 0);
                        blocks.append((Object)new Variant((Object)singleCB, 18));
                    }
                }
            }
            Object[] a = new Variant[blocks.size()];
            blocks.toArray(a, 0);
            varRet = new Variant((Object)a, 527);
            ctx.recycleArray(yCoors);
            ctx.recycleArray(xCoors);
            ctx.recycleArray(xSpans);
            ctx.recycleArray(ySpans);
            ctx.recycleArray(blocks);
        } else {
            ExtProps yCoor = epDst;
            ExtProps xCoor = epDst;
            if (!(xDims != null && (xCoor = this.getFirstDim(ctx, xDims, epDst, false)) == null || yDims != null && (yCoor = this.getFirstDim(ctx, yDims, epDst, true)) == null)) {
                int row = yCoor.getRow();
                int col = xCoor.getCol();
                Cell cll = this.setDependent(sheet, ctx.getDeps(), exprOwner, sheet.getRow(row, false), row, col);
                if (cll != null) {
                    varRet = cll.getValue();
                }
            }
        }
        if (yDims != null) {
            ctx.recycleArray(yDims);
        }
        if (xDims != null) {
            ctx.recycleArray(xDims);
        }
        return varRet;
    }

    private IntArray getAbsParamPos(ExprContext ctx, Expr expr) {
        IntArray ai = ctx.getIntArray();
        IExprNode[] nodes = expr.getExprOps().getNodes();
        int matchs = 0;
        for (int i = nodes.length - 1; i >= 0; --i) {
            IExprNode node = nodes[i];
            int type = node.getExprType();
            if (type == 256) {
                if (!((ExprMethod)node).getName().equals("$")) continue;
                ++matchs;
                continue;
            }
            if (type != 131072 || matchs-- <= 0) continue;
            ai.add(((ExprParamPos)node).getPos());
        }
        return ai;
    }

    private void offsetFilterExpr(Object[][] aaParams, int offsetY, int offsetX) {
        Object[] aOriParams = aaParams[0];
        Object[] aNewParams = aaParams[1];
        Object[] aIndex = aaParams[2];
        for (int i = 0; i < aOriParams.length; ++i) {
            IExprNode[] srcNodes = ((Expr)aOriParams[i]).getParameters();
            IExprNode[] dstNodes = ((Expr)aNewParams[i]).getParameters();
            int[] index = (int[])aIndex[i];
            for (int j = 0; j < index.length; ++j) {
                int pos = index[j];
                CellBlockNode cb = (CellBlockNode)((CellBlockNode)srcNodes[pos]).clone();
                cb.offset(offsetY, offsetX);
                dstNodes[pos] = cb;
            }
        }
    }

    private Variant checkDimVar(Variant var, ExprContext ctx, ICalculable exprOwner) throws SyntaxErrorException {
        block4: {
            block5: {
                block6: {
                    if (var.isNull()) break block4;
                    if (var.isArray()) break block5;
                    if (var instanceof ExprExpressionParam) {
                        var = ((ExprExpressionParam)var).getExpr().execute(ctx, exprOwner);
                    }
                    if (!var.isArray()) break block6;
                    this.checkDimVar(var, ctx, exprOwner);
                    break block4;
                }
                if (var.getValue() instanceof Level) break block4;
                ExprErr.goError((long)16L, (Object)"\u7ef4\u5ea6\u53c2\u6570");
                break block4;
            }
            Variant[] levels = (Variant[])var.getValue();
            if (levels.length == 0) {
                var.setVariant(Variant.nullVariant);
            } else {
                for (int i = 0; i < levels.length; ++i) {
                    this.checkDimVar(levels[i], ctx, exprOwner);
                }
            }
        }
        return var;
    }

    private IntArray getCoorSpans(ExprContext ctx, IntArray coors) {
        IntArray spans = ctx.getIntArray();
        int size = coors.size();
        for (int i = 0; i < size; ++i) {
            int col;
            int col2 = col = coors.get(i);
            if (i < size - 1) {
                int c2;
                int c = col;
                if (c + 1 == (c2 = coors.get(++i))) {
                    while (i < size - 1 && c + 1 == c2) {
                        c = c2;
                        c2 = coors.get(++i);
                    }
                    if (i >= size - 1) {
                        col2 = c2;
                    } else {
                        col2 = c;
                        --i;
                    }
                } else {
                    --i;
                }
            }
            spans.add(col);
            spans.add(col2);
        }
        return spans;
    }

    private ObjectArray createDefaultDims(ExprContext ctx, ExtProps epOwner, ExtProps epDst, boolean vDir, boolean all) {
        ObjectArray aDims = ctx.getObjectArray(-1);
        if (all) {
            ExtProps statFrom = epOwner.getHead(vDir, true);
            for (ExtProps dstHead = epDst.getHead(vDir, true); dstHead != statFrom && !dstHead.isCell00(); dstHead = dstHead.getHead(vDir, true)) {
                aDims.insert(0, (Object)new Level(dstHead, Integer.MAX_VALUE, false));
            }
            aDims.append((Object)new Level(epDst, Integer.MAX_VALUE, false));
        } else {
            aDims.append((Object)new Level(epDst, 0, false));
        }
        return aDims;
    }

    private ExtProps getFirstDim(ExprContext ctx, ObjectArray aDims, ExtProps epDst, boolean isLeft) throws SyntaxErrorException {
        Dependents deps = ctx.getDeps();
        ExtProps dim = null;
        int size = aDims.size();
        for (int i = 0; i < size; ++i) {
            Level lvl = (Level)aDims.get(i);
            dim = lvl.dim;
            Cell cll = dim.getCell();
            deps.calcReferTo(cll);
            ExtProps[] exts = dim.getExts();
            while (exts == null && (dim = dim.getHead(isLeft, false)) != null && !dim.isCell00()) {
                exts = dim.getExts();
            }
            if (exts == null) continue;
            int pos = lvl.pos;
            if (pos == Integer.MIN_VALUE) {
                if (!dim.isHeadOf(epDst, isLeft)) {
                    for (int f = 0; f < exts.length; ++f) {
                        ExtProps ep = exts[f];
                        if (!ep.isHeadOf(epDst, isLeft)) continue;
                        dim = ep;
                        break;
                    }
                }
            } else {
                if (pos == Integer.MAX_VALUE) {
                    pos = 0;
                } else if (lvl.relative) {
                    int base = dim.getExtIndex();
                    pos += base;
                }
                if (pos < 0 || pos >= exts.length) {
                    return null;
                }
                dim = exts[pos];
            }
            if (i >= size - 1) continue;
            Level lvlNext = (Level)aDims.get(i + 1);
            ExtProps nextDim = lvlNext.dim;
            if (dim.isHeadOf(nextDim, isLeft)) continue;
            int p = nextDim.getExtIndex();
            dim = dim.getSubBySource(nextDim, isLeft);
            lvlNext.dim = dim = dim.getExts()[p];
        }
        if (dim != null) {
            return dim.getSubBySource(epDst, isLeft);
        }
        return null;
    }

    private IntArray getCoors(ExprContext ctx, ObjectArray aDims, ExtProps epDst, boolean vDir) throws SyntaxErrorException {
        IntArray spans = ctx.getIntArray();
        this.getCoors(ctx, aDims, 0, vDir, spans, epDst);
        return spans;
    }

    private void getCoors(ExprContext ctx, ObjectArray aDims, int start, boolean vDir, IntArray spans, ExtProps epDst) throws SyntaxErrorException {
        boolean endRecursion = start >= aDims.size() - 1;
        Level lvl = (Level)aDims.get(start);
        ExtProps dim = lvl.dim;
        ExtProps[] exts = dim.getExts();
        if (exts != null && lvl.pos != Integer.MIN_VALUE && dim.getExtensible(true) == (vDir ? 2 : 1)) {
            if (lvl.pos == Integer.MAX_VALUE) {
                for (int e = 0; e < exts.length; ++e) {
                    if (endRecursion) {
                        spans.add(exts[e].getRC(vDir));
                        continue;
                    }
                    this.getSubCoors(ctx, aDims, start + 1, vDir, spans, exts[e], epDst);
                }
            } else {
                int pos = lvl.pos;
                if (lvl.relative) {
                    int base = dim.getExtIndex();
                    pos += base;
                }
                if (pos < 0 || pos >= exts.length) {
                    return;
                }
                if (endRecursion) {
                    spans.add(exts[pos].getRC(vDir));
                } else {
                    this.getSubCoors(ctx, aDims, start + 1, vDir, spans, exts[pos], epDst);
                }
            }
        } else if (endRecursion) {
            spans.add(dim.getRC(vDir));
        } else {
            this.getSubCoors(ctx, aDims, start + 1, vDir, spans, dim, epDst);
        }
    }

    private void getSubCoors(ExprContext ctx, ObjectArray aDims, int start, boolean vDir, IntArray spans, ExtProps epHead, ExtProps epDst) throws SyntaxErrorException {
        Level lvl = (Level)aDims.get(start);
        lvl.dim = epHead.getSubBySource(lvl.dim, vDir);
        this.getCoors(ctx, aDims, start, vDir, spans, epDst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectArray getDimsFromVar(ExprContext ctx, ExtProps epDst, Variant varDim, boolean yDir) throws SyntaxErrorException {
        String msg = yDir ? "\u7eb5\u5411\u7236\u7ef4" : "\u6a2a\u5411\u7236\u7ef4";
        boolean isArray = varDim.isArray();
        Variant[] args = isArray ? (Variant[])varDim.getValue() : ctx.getOneVariantArray(varDim);
        ObjectArray aDims = ctx.getObjectArray(args.length);
        try {
            ExtProps prev = null;
            for (int i = 0; i < args.length; ++i) {
                Level lvl = (Level)args[i].getValue();
                ExtProps dim = lvl.dim;
                if (!dim.isHeadOf(epDst, yDir)) {
                    ExprErr.goError((long)262144L, (Object)(this.getCellName(dim) + "\u975e" + this.getCellName(epDst) + msg));
                } else if (prev != null) {
                    ExtProps head;
                    if (!prev.isHeadOf(dim, yDir)) {
                        ExprErr.goError((long)262144L, (Object)(this.getCellName(prev) + "\u975e" + this.getCellName(dim) + msg));
                    }
                    if ((head = dim.getHead(yDir, true)) != prev) {
                        int pos = aDims.size();
                        while (head != prev) {
                            aDims.insert(pos, (Object)new Level(head, Integer.MAX_VALUE, false));
                            head = head.getHead(yDir, true);
                        }
                    }
                }
                aDims.append((Object)lvl);
                prev = dim;
            }
            ExtProps head = epDst.getHead(yDir, true);
            if (head != prev && prev != null && prev.isHeadOf(head, yDir)) {
                int pos = aDims.size();
                while (head != prev) {
                    aDims.insert(pos, (Object)new Level(head, Integer.MAX_VALUE, false));
                    head = head.getHead(yDir, true);
                }
            }
        }
        finally {
            if (!isArray) {
                ctx.recycleArray(args);
            }
        }
        return aDims;
    }

    private ExtProps getValidExtProps(ExprContext ctx, Object obj) throws SyntaxErrorException {
        CellBlockNode cb;
        Object value = ((Variant)obj).getValue();
        if (!(value instanceof CellBlockNode)) {
            ExprErr.goError((long)16L, (Object)"\u53c2\u6570\u975e\u5355\u5143\u683c");
        }
        if (!(cb = (CellBlockNode)value).isSingleCell()) {
            ExprErr.goError((long)16L, (Object)"\u53c2\u6570\u975e\u5355\u4e2a\u5355\u5143\u683c");
        } else if (cb.getSheet() != ctx.getExprOwner().getSheet()) {
            ExprErr.goError((long)16L, (Object)"\u975e\u672c\u8868\u9875\u5355\u5143\u683c");
        }
        ExtProps ep = null;
        Cell cll = cb.getFirstCell(false);
        if (cll != null) {
            ep = cll.getExtProps(false);
        }
        if (ep == null) {
            ExprErr.goError((long)262144L, (Object)cb.toString());
        }
        return ep;
    }

    private int getValidCoorOffset(ExprContext ctx, Object obj, boolean relative) throws SyntaxErrorException {
        Variant vPos = ctx.getVariant();
        if (!((Variant)obj).isNumeric(vPos)) {
            ExprErr.goError((long)16L, (Object)"Offset\u975e\u6570\u503c");
        }
        int pos = vPos.intValue();
        if (!relative && --pos < 0) {
            ExprErr.goError((long)16L, (Object)"\u5750\u6807\u5c0f\u4e8e1");
        }
        ctx.recycleVariant(vPos);
        return pos;
    }

    private Cell setDependent(Sheet sheet, Dependents deps, ICalculable refer, Row rowObj, int row, int col) throws SyntaxErrorException {
        sheet.setDependent(refer, CellBlockNode.getNewBlock(sheet, row, col, row, col, 0));
        Cell referTo = null;
        if (rowObj != null && (referTo = rowObj.getCell(col, false)) != null) {
            deps.calcReferTo(referTo);
        }
        return referTo;
    }

    private String getCellName(ExtProps ep) {
        if (ep.isCell00()) {
            return ep.toString();
        }
        Cell cll = ep.getCell();
        return SheetBaseMath.getBlockName(cll.getRow(), cll.getCol(), true, false, false);
    }

    public Variant A(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        return this._ar(ctx, args, false);
    }

    public Variant R(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        return this._ar(ctx, args, true);
    }

    private Variant _ar(ExprContext ctx, Object[] args, boolean relative) throws SyntaxErrorException {
        ExtProps dim;
        ExcelFuncProvider.validParamCount(args, 1, 2);
        int pos = args.length == 2 ? this.getValidCoorOffset(ctx, args[1], relative) : Integer.MIN_VALUE;
        Object varCll = args[0];
        if (varCll == Variant.nullVariant) {
            Sheet sheet = ctx.getExprOwner().getSheet();
            dim = pos == Integer.MIN_VALUE || pos == 0 ? sheet.LEFT00 : sheet.TOP00;
        } else {
            dim = this.getValidExtProps(ctx, varCll);
        }
        return new Variant((Object)new Level(dim, pos, relative), 17);
    }

    static ExtDataSet getValidDataSet(ExprContext ctx, Variant dataSet) throws SyntaxErrorException {
        Object value = dataSet.getValue();
        if (!(value instanceof ExtDataSet)) {
            ExprErr.goError((long)16L, (Object)"\u975e\u6709\u6548\u6570\u636e\u6e90");
        }
        return (ExtDataSet)value;
    }

    static Variant getValidExp(ExtDataSet ds, Object var, String errMsg) throws SyntaxErrorException {
        Variant field = (Variant)var;
        if (field.isNull() || var instanceof ExprExpressionParam) {
            return field;
        }
        Variant varIndex = Variant.intMinValue;
        if (field.isReferences()) {
            Object value = field.getValue();
            if (value instanceof ExtColumn) {
                varIndex = ((ExtColumn)value).getIndex();
            }
        } else if (field.isString()) {
            varIndex = ds.getColumnIndex((String)field.getValue());
        } else if (field.isNumber()) {
            varIndex = new Variant(field.intValue());
        }
        if (varIndex == Variant.intMinValue) {
            ExprErr.goError((long)16L, (Object)"\u5217\u6807\u7f3a\u5931");
        } else {
            int index;
            int n = index = varIndex.getVt() == 3 ? ((Integer)varIndex.getValue()).intValue() : varIndex.intValue();
            if (index < 0 || index >= ds.getDataColumns()) {
                ExprErr.goError((long)16L, (Object)errMsg);
            }
        }
        return varIndex;
    }

    public Variant FIELD(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 2, 2);
        ExtDataSet ds = ExtFuncProvider.getValidDataSet(ctx, (Variant)args[0]);
        Variant selExp = ExtFuncProvider.getValidExp(ds, args[1], "\u975e\u6709\u6548\u5217\u6807");
        return ds.calc(ctx, selExp);
    }

    public Variant FIELDS(ExprNeedExpParam ctx, Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 2, 3);
        ExtDataSet ds = ExtFuncProvider.getValidDataSet(ctx, (Variant)args[0]);
        Variant selExp = ExtFuncProvider.getValidExp(ds, args[1], "\u975e\u6709\u6548\u5217\u6807");
        ExtGroup group = ds.getCurrentGroup();
        if (args.length > 2) {
            group = (ExtGroup)group.clone();
            Variant filterExp = ExtFuncProvider.getValidExp(ds, args[2], "\u8fc7\u6ee4\u8868\u8fbe\u5f0f");
            group.filter(ctx, filterExp, group);
        }
        group.select(ctx, selExp);
        Variant[] av = group.getValues();
        return new Variant((Object)av, 527);
    }

    public Variant FIRST(ExprNeedExpParam ctx, Object[] args) throws SyntaxErrorException {
        Variant[] aRet = new Variant[1];
        ExtGroup group = ExtendFuncProvider.inst.filter(ctx, args, aRet);
        return group.first(ctx, aRet[0]);
    }

    public Variant LAST(ExprNeedExpParam ctx, Object[] args) throws SyntaxErrorException {
        Variant[] aRet = new Variant[1];
        ExtGroup group = ExtendFuncProvider.inst.filter(ctx, args, aRet);
        return group.last(ctx, aRet[0]);
    }

    private static class Level {
        public ExtProps dim;
        public int pos;
        public boolean relative;

        public Level(ExtProps dim, int pos, boolean relative) {
            this.dim = dim;
            this.pos = pos;
            this.relative = relative;
        }

        public String toString() {
            return this.dim.toString() + ", \u4f4d\u7f6e:" + this.pos + (this.relative ? ", \u76f8\u5bf9" : ", \u7edd\u5bf9");
        }
    }
}

