/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.expans.model.data;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.expans.model.data.ExtDataSet;
import com.kingdee.bos.ctrl.excel.expans.model.data.ExtRow;
import java.util.Arrays;
import java.util.Comparator;

public class ExtIndex
implements Comparator,
Comparable {
    private int[] _indexCols;
    private int _col;
    private int _col2;
    private long _key;
    private ExtRow[] _rows;

    ExtIndex(ExtDataSet ds, int[] indexCols, long key) {
        this.init(ds, indexCols, key);
    }

    void init(ExtDataSet ds, int[] indexCols, long key) {
        this._key = key;
        if (this._rows == null) {
            this._indexCols = indexCols;
            this._col = 0;
            this._col2 = indexCols.length;
            ExtRow[] src = ds.getDefaultGroup().getRows();
            this._rows = new ExtRow[src.length];
            System.arraycopy(src, 0, this._rows, 0, src.length);
            Arrays.sort(this._rows, this);
        } else {
            this._col = this._indexCols.length;
            this._col2 = indexCols.length;
            this._indexCols = indexCols;
            ExtRow[] rows = this._rows;
            int prev = 0;
            for (int i = 1; i < rows.length; ++i) {
                if (this.compareOldIndex(rows[prev].getRowData(), rows[i].getRowData())) continue;
                if (i > prev + 1) {
                    Arrays.sort(rows, prev, i, this);
                }
                prev = i;
            }
            if (prev < rows.length - 1) {
                Arrays.sort(rows, prev, rows.length, this);
            }
        }
    }

    private boolean compareOldIndex(Variant[] a1, Variant[] a2) {
        for (int i = this._col - 1; i >= 0; --i) {
            int field = this._indexCols[i];
            if (a1[field] == a2[field]) continue;
            return false;
        }
        return true;
    }

    public int compare(Object o1, Object o2) {
        int field;
        int cmp = 0;
        Variant[] a1 = ((ExtRow)o1).getRowData();
        Variant[] a2 = ((ExtRow)o2).getRowData();
        for (int i = this._col; i < this._col2 && (cmp = a1[field = this._indexCols[i]].compareTo((Object)a2[field])) == 0; ++i) {
        }
        return cmp;
    }

    public int compareTo(Object o) {
        long cmp = o instanceof ExtIndex ? this._key - ((ExtIndex)o)._key : this._key - (Long)o;
        return cmp > 0L ? 1 : (cmp == 0L ? 0 : -1);
    }

    long getKey() {
        return this._key;
    }

    int[] getIndexCols() {
        return this._indexCols;
    }
}

