/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.expans.model.data;

import com.kingdee.bos.ctrl.common.KDToolkit;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.variant.ExprErr;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.expans.model.data.ExtDataSet;
import com.kingdee.bos.ctrl.excel.expans.model.data.ExtFuncProvider;
import com.kingdee.bos.ctrl.excel.expans.model.data.ExtGroup;
import com.kingdee.bos.ctrl.excel.expans.model.data.ExtRow;
import com.kingdee.bos.ctrl.excel.model.expr.ExcelFuncProvider;
import com.kingdee.bos.ctrl.excel.model.expr.ExprContext;
import com.kingdee.bos.ctrl.excel.model.expr.ExprExpressionParam;
import com.kingdee.bos.ctrl.excel.model.expr.ExprNeedExpParam;
import com.kingdee.bos.ctrl.excel.model.expr.IInnerFuncProvider;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.node.CellBlockNode;
import com.kingdee.bos.ctrl.excel.model.util.ObjectArray;
import java.util.Arrays;

public class ExtendFuncProvider
implements IInnerFuncProvider {
    static final ExtendFuncProvider inst = new ExtendFuncProvider();

    public Variant TO(Object[] args) throws SyntaxErrorException {
        Variant varResult;
        ExcelFuncProvider.validParamCount(args, 2, 3);
        try {
            Variant step;
            Variant begin = new Variant(this.getValue((Variant)args[0]));
            Variant end = new Variant(this.getValue((Variant)args[1]));
            ExcelFuncProvider.validNumericParam("Begin", begin);
            ExcelFuncProvider.validNumericParam("End", end);
            if (args.length == 3) {
                step = new Variant((Variant)args[2]);
                ExcelFuncProvider.validNumericParam("Step", step);
            } else {
                step = new Variant(1L);
            }
            double dfStep = step.toBigDecimal().doubleValue();
            int cmp = begin.compareTo(end);
            if (cmp < 0) {
                if (dfStep <= 0.0) {
                    ExprErr.goError((long)16L, (Object)"Cannot End");
                }
            } else if (cmp > 0 && dfStep >= 0.0) {
                ExprErr.goError((long)16L, (Object)"Cannot End");
            }
            ObjectArray al = new ObjectArray(10);
            while (begin.compareTo(end) <= 0) {
                al.append((Object)new Variant(begin));
                begin.add(step);
            }
            Object[] va = new Variant[al.size()];
            al.toArray(va, 0);
            varResult = new Variant((Object)va, 527);
        }
        catch (SyntaxErrorException e) {
            varResult = new Variant((Object)e, 16);
        }
        return varResult;
    }

    private Variant getValue(Variant var) {
        if (var.isArray()) {
            Variant[] aV = (Variant[])var.getValue();
            var = aV[0];
        }
        return var;
    }

    public Variant LIST(Object[] args) {
        ObjectArray al = new ObjectArray(args.length);
        for (int i = 0; i < args.length; ++i) {
            Variant var = (Variant)args[i];
            Object value = var.getValue();
            int vt = var.getVt();
            if ((vt & 0x200) != 0) {
                Variant[] va = (Variant[])value;
                for (int v = 0; v < va.length; ++v) {
                    al.append((Object)va[v]);
                }
                continue;
            }
            if ((vt & 0x11) != 0 && value instanceof CellBlockNode) {
                CellBlockNode cb = (CellBlockNode)value;
                Sheet.ICellsIterator ci = cb.getSheet().getCellsIterator(cb, false, true);
                while (ci.hasNext()) {
                    al.append((Object)ci.next().getValue());
                }
                continue;
            }
            al.append((Object)var);
        }
        Object[] av = new Variant[al.size()];
        al.toArray(av, 0);
        return new Variant((Object)av, 527);
    }

    ExtGroup filter(ExprContext ctx, Object[] args, Variant[] aRet) throws SyntaxErrorException {
        ExtGroup oriGroup;
        Variant selExp;
        ExcelFuncProvider.validParamCount(args, 2, 5);
        int argCount = args.length;
        ExtDataSet ds = ExtFuncProvider.getValidDataSet(ctx, (Variant)args[0]);
        aRet[0] = selExp = ExtFuncProvider.getValidExp(ds, args[1], "\u975e\u6709\u6548\u5217\u6807");
        ExtGroup group = oriGroup = ds.getCurrentGroup();
        if (argCount > 2) {
            Variant descExp = (Variant)args[2];
            if (!descExp.isNull()) {
                group = (ExtGroup)group.clone();
            }
            Variant sortExp = null;
            if (argCount > 3) {
                Variant filterExp;
                if (group == oriGroup) {
                    group = (ExtGroup)group.clone();
                }
                if (!(filterExp = ExtFuncProvider.getValidExp(ds, args[3], "\u8fc7\u6ee4\u8868\u8fbe\u5f0f")).isNull()) {
                    group.filter(ctx, filterExp, group);
                }
                if (argCount > 4) {
                    sortExp = ExtFuncProvider.getValidExp(ds, args[4], "\u6392\u5e8f\u8868\u8fbe\u5f0f");
                }
            }
            if (sortExp != null || !descExp.isNull()) {
                Variant exp = sortExp == null ? selExp : sortExp;
                boolean desc = descExp instanceof ExprExpressionParam ? ((ExprExpressionParam)descExp).getExpr().execute(ctx, null).booleanValue() : descExp.booleanValue();
                group.sort(ctx, exp, desc);
            }
        }
        return group;
    }

    ExtGroup filterEx(ExprContext ctx, Object[] args, Variant[] aRet) throws SyntaxErrorException {
        ExtGroup oriGroup;
        Variant selExp;
        ExcelFuncProvider.validParamCount(args, 2, 4);
        int argCount = args.length;
        ExtDataSet ds = ExtFuncProvider.getValidDataSet(ctx, (Variant)args[0]);
        aRet[0] = selExp = ExtFuncProvider.getValidExp(ds, args[1], "\u975e\u6709\u6548\u5217\u6807");
        ExtGroup group = oriGroup = ds.getCurrentGroup();
        if (argCount > 2) {
            group = (ExtGroup)group.clone();
            Variant filterExp = ExtFuncProvider.getValidExp(ds, args[2], "\u8fc7\u6ee4\u8868\u8fbe\u5f0f");
            if (!filterExp.isNull()) {
                group.filter(ctx, filterExp, group);
            }
            if (argCount > 3) {
                String[] aStr = args[3].toString().split(";");
                int sorts = aStr.length;
                Variant[] aSort = new Variant[sorts];
                boolean[] aDesc = new boolean[sorts];
                Variant var = Variant.getNewEmptyVariant();
                for (int i = 0; i < sorts; ++i) {
                    String strSort = aStr[i];
                    String strDesc = null;
                    int pos = strSort.indexOf(44);
                    if (pos >= 0) {
                        strDesc = strSort.substring(pos + 1);
                        strSort = strSort.substring(0, pos);
                    }
                    var.setObject((Object)strSort, 11);
                    aSort[i] = ExtFuncProvider.getValidExp(ds, var, "\u6392\u5e8f\u8868\u8fbe\u5f0f");
                    if (StringUtil.isEmptyString((String)strDesc)) continue;
                    aDesc[i] = Boolean.valueOf(strDesc);
                }
                group.sort(ctx, aSort, aDesc);
            }
        }
        return group;
    }

    public Variant SELECT1(ExprNeedExpParam ctx, Object[] args) throws SyntaxErrorException {
        int argCount = args.length;
        if (argCount < 2) {
            ExprErr.goError((long)8L, null);
        }
        ExtDataSet ds = ExtFuncProvider.getValidDataSet(ctx, (Variant)args[0]);
        Variant selExp = ExtFuncProvider.getValidExp(ds, args[1], "\u975e\u6709\u6548\u5217\u6807");
        ExtRow row = ds.getNullRow();
        ExtRow[] rows = ds.getCurrentGroup().getRows();
        if (args.length > 2) {
            Variant filterExp = ExtFuncProvider.getValidExp(ds, args[2], "\u8fc7\u6ee4\u8868\u8fbe\u5f0f");
            for (int i = 0; i < rows.length; ++i) {
                ExtRow r = rows[i];
                ds.setCurrentRow(r);
                Variant var = ds.calc(ctx, filterExp);
                if (!var.booleanValue()) continue;
                row = r;
                Variant value = ds.calc(ctx, selExp);
                row.setValue(value);
                break;
            }
        } else {
            row = rows[0];
            ds.setCurrentRow(row);
            Variant value = ds.calc(ctx, selExp);
            row.setValue(value);
        }
        return new Variant((Object)row, 17);
    }

    public Variant SELECTEX(ExprNeedExpParam ctx, Object[] args) throws SyntaxErrorException {
        Variant[] aRet = ctx.getOneVariantArray(null);
        ExtGroup group = this.filterEx(ctx, args, aRet);
        group.select(ctx, aRet[0]);
        ctx.recycleArray(aRet);
        return group.getVar();
    }

    public Variant SELECT(ExprNeedExpParam ctx, Object[] args) throws SyntaxErrorException {
        Variant[] aRet = ctx.getOneVariantArray(null);
        ExtGroup group = this.filter(ctx, args, aRet);
        group.select(ctx, aRet[0]);
        ctx.recycleArray(aRet);
        return group.getVar();
    }

    public Variant GROUP(ExprNeedExpParam ctx, Object[] args) throws SyntaxErrorException {
        Variant[] aRet = ctx.getOneVariantArray(null);
        ExtGroup group = this.filter(ctx, args, aRet);
        Variant var = group.group(ctx, aRet[0]);
        ctx.recycleArray(aRet);
        return var;
    }

    public Variant ENUMGROUP(ExprNeedExpParam ctx, Object[] args) throws SyntaxErrorException {
        return this.filterGroup(ctx, args, true);
    }

    public Variant OVERLAP(ExprNeedExpParam ctx, Object[] args) throws SyntaxErrorException {
        return this.filterGroup(ctx, args, false);
    }

    private Variant filterGroup(ExprNeedExpParam ctx, Object[] args, boolean isEnum) throws SyntaxErrorException {
        Variant varRet;
        int i;
        ExcelFuncProvider.validParamCount(args, 2, Integer.MAX_VALUE);
        ExtDataSet ds = ExtFuncProvider.getValidDataSet(ctx, (Variant)args[0]);
        boolean keepNullGroup = ((Variant)args[1]).booleanValue();
        ObjectArray groups = ctx.getObjectArray(0);
        ExtGroup group = (ExtGroup)ds.getCurrentGroup().clone();
        int end = args.length - 1;
        for (i = 2; i < end; i += 2) {
            Variant filterExp = ExtFuncProvider.getValidExp(ds, args[i], "\u8fc7\u6ee4\u8868\u8fbe\u5f0f");
            ExtGroup apart = null;
            if (!filterExp.isNull()) {
                apart = isEnum ? group.separate(ctx, filterExp) : group.filter(ctx, filterExp, null);
            }
            if (apart == null && !keepNullGroup) continue;
            if (apart == null) {
                apart = new ExtGroup(ds, new ExtRow[0]);
            }
            apart.setValues(new Variant[]{(Variant)args[i + 1]});
            groups.append((Object)apart);
        }
        if (i < args.length) {
            if (isEnum) {
                if (!group.isNullGroup() || keepNullGroup) {
                    group.setValues(new Variant[]{(Variant)args[args.length - 1]});
                    groups.append((Object)group);
                }
            } else {
                int size = groups.size();
                if (size > 0) {
                    Object[] rows = group.getRows();
                    Object[] newRows = new ExtRow[rows.length];
                    KDToolkit.arraycopy((Object[])rows, (int)0, (Object[])newRows, (int)0, (int)rows.length);
                    for (int j = 0; j < size; ++j) {
                        ExtRow[] aRows = ((ExtGroup)groups.get(j)).getRows();
                        for (int k = 0; k < aRows.length; ++k) {
                            newRows[aRows[k].index()] = null;
                        }
                    }
                    ObjectArray oa = ctx.getObjectArray(0);
                    for (int j = 0; j < newRows.length; ++j) {
                        Object row = newRows[j];
                        if (row == null) continue;
                        oa.append(row);
                    }
                    newRows = new ExtRow[oa.size()];
                    oa.toArray(newRows, 0);
                    group = new ExtGroup(ds, (ExtRow[])newRows);
                    group.setValues(new Variant[]{(Variant)args[args.length - 1]});
                    groups.append((Object)group);
                }
            }
        }
        if (groups.size() == 0) {
            varRet = new Variant((Object)ds.getNullGroup(), 17);
        } else {
            Variant[] aGroups = new Variant[groups.size()];
            for (int j = 0; j < aGroups.length; ++j) {
                aGroups[j] = ((ExtGroup)groups.get(j)).getVar();
            }
            varRet = new Variant((Object)aGroups, 527);
        }
        ctx.recycleArray(groups);
        return varRet;
    }

    public Variant SORT(Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 1, 2);
        Variant var = (Variant)args[0];
        if (!var.isArray()) {
            ExprErr.goError((long)16L, (Object)"Cannot sort");
        }
        Object[] array = (Variant[])var.getValue();
        Arrays.sort(array);
        if (args.length == 2 && !((Variant)args[1]).booleanValue()) {
            int i = 0;
            for (int j = array.length - 1; i < j; ++i, --j) {
                Object tmp = array[i];
                array[i] = array[j];
                array[j] = tmp;
            }
        }
        return var;
    }
}

