/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.impl;

import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.ctrl.common.hyperlink.HyperLinkHandler;
import com.kingdee.bos.ctrl.common.hyperlink.IHyperLinkExec;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.Queue;
import com.kingdee.bos.ctrl.common.util.ZipUtil;
import com.kingdee.bos.ctrl.excel.core.IMouseController;
import com.kingdee.bos.ctrl.excel.core.KDSpread;
import com.kingdee.bos.ctrl.excel.impl.ActionLoader;
import com.kingdee.bos.ctrl.excel.impl.ActionManager;
import com.kingdee.bos.ctrl.excel.impl.CellEditManager;
import com.kingdee.bos.ctrl.excel.impl.FacadeManager;
import com.kingdee.bos.ctrl.excel.impl.FunctionRegister;
import com.kingdee.bos.ctrl.excel.impl.PopMenuManager;
import com.kingdee.bos.ctrl.excel.impl.RangeManager;
import com.kingdee.bos.ctrl.excel.impl.RenderManager;
import com.kingdee.bos.ctrl.excel.impl.SelectionAdapter;
import com.kingdee.bos.ctrl.excel.impl.ThreadManager;
import com.kingdee.bos.ctrl.excel.impl.ToolBarManager;
import com.kingdee.bos.ctrl.excel.impl.UserObjectRegister;
import com.kingdee.bos.ctrl.excel.impl.facade.hyperlink.BookHyperLinkExec;
import com.kingdee.bos.ctrl.excel.impl.state.SpreadStateManager;
import com.kingdee.bos.ctrl.excel.impl.state.mouse.ColMouseController;
import com.kingdee.bos.ctrl.excel.impl.state.mouse.CornerMouseController;
import com.kingdee.bos.ctrl.excel.impl.state.mouse.IMouseStateController;
import com.kingdee.bos.ctrl.excel.impl.state.mouse.OutlineGroupColHeaderMouseController;
import com.kingdee.bos.ctrl.excel.impl.state.mouse.OutlineGroupRowHeaderMouseController;
import com.kingdee.bos.ctrl.excel.impl.state.mouse.RowMouseController;
import com.kingdee.bos.ctrl.excel.impl.state.mouse.TableMouseController;
import com.kingdee.bos.ctrl.excel.io.kds.BookToKds;
import com.kingdee.bos.ctrl.excel.io.kds.KdsToBook;
import com.kingdee.bos.ctrl.excel.io.kml.KmlToBook;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.embed.EmbedObject;
import com.kingdee.bos.ctrl.excel.model.struct.embed.EmbedhLayer;
import com.kingdee.bos.ctrl.excel.model.struct.embed.IEmbedX;
import com.kingdee.bos.ctrl.excel.model.struct.embed.chart.Chart;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeListener;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookPropertyChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookPropertyChangeListener;
import com.kingdee.bos.ctrl.excel.model.struct.event.GraphChangeListener;
import com.kingdee.bos.ctrl.excel.model.struct.event.GraphChangedEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.GraphPropertyChangedEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeListener;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetPropertyChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetPropertyChangeListener;
import com.kingdee.bos.ctrl.excel.model.util.SortedSheetArray;
import com.kingdee.bos.ctrl.excel.print.MultiPrintJobProvider;
import com.kingdee.bos.ctrl.excel.print.PrintBookTrans;
import com.kingdee.bos.ctrl.excel.print.PrintManager;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import com.kingdee.bos.ctrl.print.IConfigChangeListener;
import com.kingdee.bos.ctrl.print.printjob.table.SheetPrintJob;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;

public final class SpreadContext
extends KDPanel {
    private static int base = 0;
    private static final Object ActionM = new Integer(base++);
    private static final Object ActionL = new Integer(base++);
    private static final Object FuncR = new Integer(base++);
    private static final Object UserR = new Integer(base++);
    private static final Object StateM = new Integer(base++);
    private static final Object FacadeM = new Integer(base++);
    private static final Object ToolBarM = new Integer(base++);
    private static final Object PopupM = new Integer(base++);
    private static final Object RenderM = new Integer(base++);
    private static final Object PrintM = new Integer(base++);
    private static final Object PrintJob = new Integer(base++);
    private static final Object RangeM = new Integer(base++);
    private static final Object HyperLinkHander = new Integer(base++);
    private static final Object SelectionM = new Integer(base++);
    private static final Object ThreadM = new Integer(base++);
    private static final Object EditM = new Integer(base++);
    private static final int SheetProChange = 1;
    private static final int SheetChange = 2;
    private static final int BookChange = 3;
    private static final int BookProChange = 4;
    private static final int GraphChange = 5;
    private static final Object SheetProChangeSync = "SheetProChangeSync";
    private static final Object SheetProChangeAsync = "SheetProChangeAsync";
    private static final Object SheetChangeSync = "SheetChangeSync";
    private static final Object SheetChangeAsync = "SheetChangeAsync";
    private static final Object BookProChangeSync = "BookProChangeSync";
    private static final Object BookProChangeAsync = "BookProChangeAsync";
    private static final Object BookChangeSync = "BookChangeSync";
    private static final Object BookChangeAsync = "BookChangeAsync";
    private static final Object GraphChangeSync = "GraphChangeSync";
    private static final Object GraphChangeAsync = "GraphChangeAsync";
    private KDSpread _spread;
    private Queue _syncQueue = new Queue();
    private SyncActionHandler syncHandler;
    private IMouseController _tableMouCtrl;
    private IMouseController _rowMouCtrl;
    private IMouseController _colMouCtrl;
    private IMouseController _cornerMouCtrl;
    private IMouseController _outlineGpRhMouCtrl;
    private IMouseController _outlineGpChMouCtrl;
    private IMouseStateController _userStateCtrl;
    private HashMap _managers;
    private HashMap _listeners;
    private BookListenerDelegate _bookListenerDelegate;
    private PaginationViewChangeListener pvcListeners;
    private EmbedObjectChangeListener eoListeners;
    private static final String HIDDEN_EXPORT_ACTION = "HIDDEN_EXPORT_ACTION";
    private static final String HIDDEN_IMPORT_ACTION = "HIDDEN_IMPORT_ACTION";
    private String userName;

    public SpreadContext() {
        this(Book.Manager.getNewBook(null, 3));
    }

    public SpreadContext(Book book) {
        this.initManagers();
        this.initComps();
        this.initListeners();
        this.setBook(book);
    }

    public void requestFocus() {
        this._spread.requestFocus();
    }

    public void addNotify() {
        EmbedhLayer ems;
        super.addNotify();
        Sheet activeSheet = this.getBook().getActiveSheet();
        if (activeSheet != null && (ems = activeSheet.getEmbedments(false)) != null) {
            EmbedObject[] embeds = new EmbedObject[ems.size()];
            for (int i = ems.size() - 1; i >= 0; --i) {
                embeds[i] = ems.getEmbed(i);
            }
            this.eoListeners.relayoutEmbedXs(embeds, false);
        }
        this.getThreadManager().getTimer(70, this.syncHandler).start();
    }

    public void removeNotify() {
        super.removeNotify();
        this.getThreadManager().dispose();
    }

    public KDSpread getSpread() {
        return this._spread;
    }

    public void setBook(Book book) {
        Book oldBook;
        if (book == null) {
            throw new IllegalArgumentException("Book\u4e0d\u80fd\u4e3aNULL");
        }
        if (this._spread == null) {
            this._spread = new KDSpread();
            this.initSpread();
        } else {
            oldBook = this._spread.getBook();
            this.unRegisterBookListeners(oldBook);
        }
        oldBook = this._spread.getBook();
        if (oldBook != null) {
            this._bookListenerDelegate.changed(new BookChangeEvent(oldBook.getActiveSheet(), "Sheet_Deactive"));
        }
        this._spread.setBook(book);
        this.registerBookListeners(book);
        this._bookListenerDelegate.changed(new BookPropertyChangeEvent(this._spread.getBook(), "", "", "Changed_BookProtection"));
        this._bookListenerDelegate.changed(new BookChangeEvent(this._spread.getBook().getActiveSheet(), "Sheet_Active"));
    }

    public Book getBook() {
        return this._spread.getBook();
    }

    private void initManagers() {
        this.syncHandler = new SyncActionHandler();
        this._tableMouCtrl = new TableMouseController(this);
        this._rowMouCtrl = new RowMouseController(this);
        this._colMouCtrl = new ColMouseController(this);
        this._cornerMouCtrl = new CornerMouseController(this);
        this._outlineGpRhMouCtrl = new OutlineGroupRowHeaderMouseController(this);
        this._outlineGpChMouCtrl = new OutlineGroupColHeaderMouseController(this);
        this._bookListenerDelegate = new BookListenerDelegate();
    }

    private void initComps() {
        this.setLayout(new BorderLayout());
        this.add((Component)((Object)this.getFacadeManager().getPromptPanel()), "North");
        this.setPreferredSize(new Dimension(200, 200));
    }

    private void initListeners() {
        this.pvcListeners = new PaginationViewChangeListener();
        this.addSheetChangeListener(this.pvcListeners);
        this.addBookChangeListener(this.pvcListeners, true);
        this.getPrintManager().addConfigChangeListener(this.pvcListeners);
        this.eoListeners = new EmbedObjectChangeListener();
        this.addSheetChangeListener(this.eoListeners);
        this.addBookChangeListener(this.eoListeners);
        this.addGraphChangeListener(this.eoListeners);
        this.addBookPropertyChangeListener(new BookPropertyChangeListener(){

            @Override
            public void changed(BookPropertyChangeEvent e) {
                if (e.getType() == "Global_Repaint") {
                    SpreadContext.this.repaint();
                }
            }
        }, true);
        this.getInputMap(2).put(KeyStroke.getKeyStroke(69, 576, true), HIDDEN_EXPORT_ACTION);
        this.getActionMap().put(HIDDEN_EXPORT_ACTION, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KDFileChooser fileChooser = new KDFileChooser();
                fileChooser.setFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.isDirectory() || pathname.getName().toLowerCase(Locale.ENGLISH).endsWith(".kds");
                    }

                    @Override
                    public String getDescription() {
                        return "KDS Format";
                    }
                });
                fileChooser.setFileSelectionMode(2);
                if (0 == fileChooser.showOpenDialog((Component)((Object)SpreadContext.this))) {
                    try {
                        BookToKds btk = new BookToKds();
                        btk.export(SpreadContext.this.getBook(), fileChooser.getSelectedFile().getAbsolutePath());
                    }
                    catch (IOException e1) {
                        WindowUtil.msgboxError((Object)e1.getMessage(), (String)"Export ERROR", (Component)((Object)SpreadContext.this));
                    }
                }
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(73, 3), HIDDEN_IMPORT_ACTION);
        this.getActionMap().put(HIDDEN_IMPORT_ACTION, new AbstractAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                block8: {
                    FileInputStream fs;
                    Book book;
                    block7: {
                        KDFileChooser fileChooser = new KDFileChooser();
                        fileChooser.setDialogType(0);
                        fileChooser.setFileSelectionMode(0);
                        fileChooser.setFileFilter(new FileFilter(){

                            @Override
                            public boolean accept(File pathname) {
                                return pathname.isDirectory() || pathname.getName().toLowerCase(Locale.ENGLISH).endsWith(".kdszip");
                            }

                            @Override
                            public String getDescription() {
                                return "KDSZIP Format";
                            }
                        });
                        if (0 != fileChooser.showOpenDialog((Component)((Object)SpreadContext.this))) break block8;
                        book = null;
                        fs = null;
                        try {
                            fs = new FileInputStream(fileChooser.getSelectedFile().getAbsolutePath());
                            byte[] bytes = CtrlUtil.Stream.readInputStream((InputStream)fs);
                            ZipUtil.UnpackResult ur = ZipUtil.unpackWithMagic((byte[])bytes);
                            if ("###KDSpread2.0###".equals(ur.getMagicCode())) {
                                KdsToBook ktb = new KdsToBook();
                                ktb.setBookIOController(null);
                                book = ktb.load(ur.getInputStream());
                                break block7;
                            }
                            if ("###KDSpread1.0###".equals(ur.getMagicCode())) {
                                KmlToBook ktb = new KmlToBook();
                                ktb.setIOController(null);
                                ktb.load(ur.getInputStream(), null);
                                book = ktb.getBook();
                                break block7;
                            }
                            if ("###PACKER4.0.1###".equals(ur.getMagicCode())) break block7;
                            throw new IOException("\u5fc5\u987b\u662fkds\u6216kdf\u6587\u4ef6\u7684\u538b\u7f29\u6d41");
                        }
                        catch (Exception e1) {
                            try {
                                WindowUtil.msgboxError((Object)e1.getMessage(), (String)"Import ERROR", (Component)((Object)SpreadContext.this));
                            }
                            catch (Throwable throwable) {
                                CloseUtil.close((Closeable[])new Closeable[]{fs});
                                throw throwable;
                            }
                            CloseUtil.close((Closeable[])new Closeable[]{fs});
                        }
                    }
                    CloseUtil.close((Closeable[])new Closeable[]{fs});
                    if (book != null) {
                        SpreadContext.this.setBook(book);
                    }
                }
            }
        });
    }

    private void initSpread() {
        this._spread.setExtRender(3, this.getRenderManager().getTableExtRender());
        this._spread.setExtRender(2, this.getRenderManager().getRowExtRender());
        this._spread.setExtRender(1, this.getRenderManager().getColExtRender());
        this._spread.setExtRender(0, this.getRenderManager().getCornerExtRender());
        this._spread.setExtRender(4, this.getRenderManager().getGroupColHeaderExtRender());
        this._spread.setExtRender(5, this.getRenderManager().getGroupRowHeaderExtRender());
        this._spread.setExtRender(6, this.getRenderManager().getGroupColTagBarExtRender());
        this._spread.setExtRender(7, this.getRenderManager().getGroupRowTagBarExtRender());
        this._spread.setExtRender(8, this.getRenderManager().getGroupCornerExtRender());
        this._spread.setCellDisplayProvider(this.getRenderManager().getCellDisplayProvider());
        this._spread.setMouseController(3, this._tableMouCtrl);
        this._spread.setMouseController(2, this._rowMouCtrl);
        this._spread.setMouseController(1, this._colMouCtrl);
        this._spread.setMouseController(0, this._cornerMouCtrl);
        this._spread.setMouseController(5, this._outlineGpRhMouCtrl);
        this._spread.setMouseController(4, this._outlineGpChMouCtrl);
        this._spread.setActionLoader(this.getActionLoader());
        this._spread.getTabbedBar().setPopupMenuProvider(this.getPopMenuManager());
        this._spread.updateUI();
        this.add(this._spread, "Center");
    }

    private void unRegisterBookListeners(Book book) {
        UserObjectRegister ur;
        book.removeSheetChangeListener(this._bookListenerDelegate);
        book.removeBookChangeListener(this._bookListenerDelegate);
        book.removeSheetPropertyChangeListener(this._bookListenerDelegate);
        book.removeBookPropertyChangeListener(this._bookListenerDelegate);
        book.removeGraphChangeListener(this._bookListenerDelegate);
        FunctionRegister fr = this.getFunctionRegister();
        if (fr != null) {
            fr.unRegister();
        }
        if ((ur = this.getUserObjectRegister()) != null) {
            ur.unRegister();
        }
    }

    private void registerBookListeners(Book book) {
        UserObjectRegister ur;
        book.addSheetChangeListener(this._bookListenerDelegate);
        book.addBookChangeListener(this._bookListenerDelegate);
        book.addSheetPropertyChangeListener(this._bookListenerDelegate);
        book.addBookPropertyChangeListener(this._bookListenerDelegate);
        book.addGraphChangeListener(this._bookListenerDelegate);
        FunctionRegister fr = this.getFunctionRegister();
        if (fr != null) {
            fr.register();
        }
        if ((ur = this.getUserObjectRegister()) != null) {
            ur.register();
        }
    }

    private AbstractMap getManagers() {
        if (this._managers == null) {
            this._managers = new HashMap(8);
        }
        return this._managers;
    }

    private AbstractMap getListeners() {
        if (this._listeners == null) {
            this._listeners = new HashMap(8);
        }
        return this._listeners;
    }

    private ArrayList getListener(int type, boolean sync, boolean create) {
        Object key;
        switch (type) {
            case 3: {
                key = sync ? BookChangeSync : BookChangeAsync;
                break;
            }
            case 4: {
                key = sync ? BookProChangeSync : BookProChangeAsync;
                break;
            }
            case 2: {
                key = sync ? SheetChangeSync : SheetChangeAsync;
                break;
            }
            case 5: {
                key = sync ? GraphChangeSync : GraphChangeAsync;
                break;
            }
            default: {
                Object object = key = sync ? SheetProChangeSync : SheetProChangeAsync;
            }
        }
        if (create) {
            AbstractMap map = this.getListeners();
            Object o = map.get(key);
            if (o == null) {
                o = new ArrayList();
                map.put(key, o);
            }
            return (ArrayList)o;
        }
        if (this._listeners == null) {
            return null;
        }
        return (ArrayList)this._listeners.get(key);
    }

    private MultiPrintJobProvider getJobProvider() {
        AbstractMap mg = this.getManagers();
        Object o = mg.get(PrintJob);
        if (o == null) {
            o = new MultiPrintJobProvider(this);
            mg.put(PrintJob, o);
        }
        return (MultiPrintJobProvider)o;
    }

    public void setUserStateController(IMouseStateController mc) {
        this._userStateCtrl = mc;
    }

    public IMouseStateController getUserStateController() {
        return this._userStateCtrl;
    }

    public SelectionAdapter getSelection() {
        AbstractMap mg = this.getManagers();
        Object o = mg.get(SelectionM);
        if (o == null) {
            o = new SelectionAdapter(this);
            mg.put(SelectionM, o);
        }
        return (SelectionAdapter)o;
    }

    public ActionLoader getActionLoader() {
        AbstractMap mg = this.getManagers();
        Object o = mg.get(ActionL);
        if (o == null) {
            o = new ActionLoader(this);
            mg.put(ActionL, o);
        }
        return (ActionLoader)o;
    }

    public FunctionRegister getFunctionRegister() {
        AbstractMap mg = this.getManagers();
        Object o = mg.get(FuncR);
        if (o == null) {
            o = new FunctionRegister(this);
            mg.put(FuncR, o);
        }
        return (FunctionRegister)o;
    }

    public UserObjectRegister getUserObjectRegister() {
        AbstractMap mg = this.getManagers();
        Object o = mg.get(UserR);
        if (o == null) {
            o = new UserObjectRegister(this);
            mg.put(UserR, o);
        }
        return (UserObjectRegister)o;
    }

    public RangeManager getRangeManager() {
        AbstractMap mg = this.getManagers();
        Object o = mg.get(RangeM);
        if (o == null) {
            o = new RangeManager(this);
            mg.put(RangeM, o);
        }
        return (RangeManager)o;
    }

    public RenderManager getRenderManager() {
        AbstractMap mg = this.getManagers();
        Object o = mg.get(RenderM);
        if (o == null) {
            o = new RenderManager(this);
            mg.put(RenderM, o);
        }
        return (RenderManager)o;
    }

    public CellEditManager getEditManager() {
        AbstractMap mg = this.getManagers();
        Object o = mg.get(EditM);
        if (o == null) {
            o = new CellEditManager(this);
            mg.put(EditM, o);
        }
        return (CellEditManager)o;
    }

    public PrintManager getPrintManager() {
        AbstractMap mg = this.getManagers();
        Object o = mg.get(PrintM);
        if (o == null) {
            o = new PrintManager(this.getJobProvider());
            ((PrintManager)o).addConfigChangeListener(new PrintConfigChangeHandler());
            mg.put(PrintM, o);
        }
        return (PrintManager)o;
    }

    public SpreadStateManager getStateManager() {
        AbstractMap mg = this.getManagers();
        Object o = mg.get(StateM);
        if (o == null) {
            SpreadStateManager sm = new SpreadStateManager(this);
            this.addBookChangeListener(sm, false);
            this.addSheetChangeListener(sm, false);
            this.addSheetPropertyChangeListener(sm, false);
            mg.put(StateM, sm);
            o = sm;
        }
        return (SpreadStateManager)o;
    }

    public PopMenuManager getPopMenuManager() {
        AbstractMap mg = this.getManagers();
        Object o = mg.get(PopupM);
        if (o == null) {
            o = new PopMenuManager(this);
            mg.put(PopupM, o);
        }
        return (PopMenuManager)o;
    }

    public FacadeManager getFacadeManager() {
        AbstractMap mg = this.getManagers();
        Object o = mg.get(FacadeM);
        if (o == null) {
            FacadeManager fm = new FacadeManager(this);
            this.addBookChangeListener(fm, true);
            this.addSheetChangeListener(fm, true);
            this.addSheetPropertyChangeListener(fm, true);
            this.addGraphChangeListener(fm, true);
            mg.put(FacadeM, fm);
            o = fm;
        }
        return (FacadeManager)o;
    }

    public ThreadManager getThreadManager() {
        AbstractMap mg = this.getManagers();
        Object o = mg.get(ThreadM);
        if (o == null) {
            ThreadManager fm = new ThreadManager();
            mg.put(ThreadM, fm);
            o = fm;
        }
        return (ThreadManager)o;
    }

    public ActionManager getActionManager() {
        AbstractMap mg = this.getManagers();
        Object o = mg.get(ActionM);
        if (o == null) {
            ActionManager am = new ActionManager(this);
            this.addBookChangeListener(am, true);
            this.addBookPropertyChangeListener(am, true);
            this.addSheetPropertyChangeListener(am, true);
            mg.put(ActionM, am);
            o = am;
        }
        return (ActionManager)o;
    }

    public ToolBarManager getToolBarManager() {
        AbstractMap mg = this.getManagers();
        Object o = mg.get(ToolBarM);
        if (o == null) {
            ToolBarManager tm = new ToolBarManager(this);
            this.addBookChangeListener(tm, true);
            this.addSheetChangeListener(tm, true);
            this.addSheetPropertyChangeListener(tm, true);
            this.addGraphChangeListener(tm, true);
            mg.put(ToolBarM, tm);
            o = tm;
        }
        return (ToolBarManager)o;
    }

    public HyperLinkHandler getHyperLinkHandler() {
        AbstractMap mg = this.getManagers();
        Object o = mg.get(HyperLinkHander);
        if (o == null) {
            o = new HyperLinkHandler();
            ((HyperLinkHandler)o).setExec("#", (IHyperLinkExec)new BookHyperLinkExec(this));
            mg.put(HyperLinkHander, o);
        }
        return (HyperLinkHandler)o;
    }

    public void addSheetChangeListener(SheetChangeListener l) {
        this.addSheetChangeListener(l, false);
    }

    public void removeSheetChangeListener(SheetChangeListener l) {
        this.removeSheetChangeListener(l, false);
    }

    public void addBookChangeListener(BookChangeListener l) {
        this.addBookChangeListener(l, false);
    }

    public void removeBookChangeListener(BookChangeListener l) {
        this.removeBookChangeListener(l, false);
    }

    public void addSheetPropertyChangeListener(SheetPropertyChangeListener l) {
        this.addSheetPropertyChangeListener(l, false);
    }

    public void removeSheetPropertyChangeListener(SheetPropertyChangeListener l) {
        this.removeSheetPropertyChangeListener(l, false);
    }

    public void addBookPropertyChangeListener(BookPropertyChangeListener l) {
        this.addBookPropertyChangeListener(l, false);
    }

    public void removeBookPropertyChangeListener(BookPropertyChangeListener l) {
        this.removeBookPropertyChangeListener(l, false);
    }

    public void addGraphChangeListener(GraphChangeListener l) {
        this.addGraphChangeListener(l, false);
    }

    public void removeGraphChangeListener(GraphChangeListener l) {
        this.removeGraphChangeListener(l, false);
    }

    public void addSheetChangeListener(SheetChangeListener l, boolean sync) {
        ArrayList al = this.getListener(2, sync, true);
        if (!al.contains(l)) {
            al.add(l);
        }
    }

    public void removeSheetChangeListener(SheetChangeListener l, boolean sync) {
        ArrayList al = this.getListener(2, sync, false);
        if (al != null) {
            al.remove(l);
        }
    }

    public void addBookChangeListener(BookChangeListener l, boolean sync) {
        ArrayList al = this.getListener(3, sync, true);
        if (!al.contains(l)) {
            al.add(l);
        }
    }

    public void removeBookChangeListener(BookChangeListener l, boolean sync) {
        ArrayList al = this.getListener(3, sync, false);
        if (al != null) {
            al.remove(l);
        }
    }

    public void addSheetPropertyChangeListener(SheetPropertyChangeListener l, boolean sync) {
        ArrayList al = this.getListener(1, sync, true);
        if (!al.contains(l)) {
            al.add(l);
        }
    }

    public void removeSheetPropertyChangeListener(SheetPropertyChangeListener l, boolean sync) {
        ArrayList al = this.getListener(1, sync, false);
        if (al != null) {
            al.remove(l);
        }
    }

    public void addBookPropertyChangeListener(BookPropertyChangeListener l, boolean sync) {
        ArrayList al = this.getListener(4, sync, true);
        if (!al.contains(l)) {
            al.add(l);
        }
    }

    public void removeBookPropertyChangeListener(BookPropertyChangeListener l, boolean sync) {
        ArrayList al = this.getListener(4, sync, false);
        if (al != null) {
            al.remove(l);
        }
    }

    public void addGraphChangeListener(GraphChangeListener l, boolean sync) {
        ArrayList al = this.getListener(5, sync, true);
        if (!al.contains(l)) {
            al.add(l);
        }
    }

    public void removeGraphChangeListener(GraphChangeListener l, boolean sync) {
        ArrayList al = this.getListener(5, sync, false);
        if (al != null) {
            al.remove(l);
        }
    }

    public void clearQueue() {
        this._syncQueue.clear();
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    private class PaginationViewChangeListener
    implements BookChangeListener,
    IConfigChangeListener,
    SheetChangeListener {
        private PaginationViewChangeListener() {
        }

        @Override
        public void changed(BookChangeEvent e) {
            if (e.isSheetActive()) {
                if (e.getSheet().isPageView()) {
                    SpreadContext.this.getActionManager().getAction("Show_Normal_View").setEnabled(true);
                    SpreadContext.this.getActionManager().getAction("Show_Print_Pagination_View").setEnabled(false);
                } else {
                    SpreadContext.this.getActionManager().getAction("Show_Normal_View").setEnabled(false);
                    SpreadContext.this.getActionManager().getAction("Show_Print_Pagination_View").setEnabled(true);
                }
            }
        }

        public void configChanged() {
            Sheet sheet = SpreadContext.this.getBook().getActiveSheet();
            if (sheet != null && sheet.isPageView()) {
                PrintManager pm = SpreadContext.this.getPrintManager();
                SheetPrintJob job = (SheetPrintJob)pm.getMultiPrintManager().getPrintJob(sheet.getID());
                job.preparePagination();
                if (!job.getTablePrintPagination().isPrinArea()) {
                    sheet.setRowPaginationPointsSnapshot(job.getTablePrintPagination().getRowPaginationPointsSnapshot());
                    sheet.setColPaginationPointsSnapshot(job.getTablePrintPagination().getColPaginationPointsSnapshot());
                }
                SpreadContext.this.repaint();
            }
        }

        public void configOver() {
        }

        public void configWillChange() {
        }

        @Override
        public void changed(SheetChangeEvent e) {
            Sheet sheet = e.getSheet();
            if (sheet == null) {
                return;
            }
            if (e.hasState(SheetChangeEvent.Changed_Delete | SheetChangeEvent.Changed_Insert | SheetChangeEvent.Changed_Resize | SheetChangeEvent.Changed_Sheet_Scale)) {
                if (sheet.isPageView()) {
                    PrintManager pm = SpreadContext.this.getPrintManager();
                    sheet.setPageView(false);
                    pm.reloadPrintJob();
                    sheet.setPageView(true);
                    SheetPrintJob job = (SheetPrintJob)pm.getMultiPrintManager().getPrintJob(sheet.getID());
                    job.preparePagination();
                    if (!job.getTablePrintPagination().isPrinArea()) {
                        sheet.setRowPaginationPointsSnapshot(job.getTablePrintPagination().getRowPaginationPointsSnapshot());
                        sheet.setColPaginationPointsSnapshot(job.getTablePrintPagination().getColPaginationPointsSnapshot());
                    }
                    pm.getMultiPrintManager().clear();
                    SpreadContext.this.repaint();
                }
            } else if (e.hasState(SheetChangeEvent.Changed_Content) && sheet.isPageView()) {
                PrintManager pm = SpreadContext.this.getPrintManager();
                sheet.setPageView(false);
                pm.reloadPrintJob();
                sheet.setPageView(true);
                SheetPrintJob job = (SheetPrintJob)pm.getMultiPrintManager().getPrintJob(sheet.getID());
                job.preparePagination();
                if (!job.getTablePrintPagination().isPrinArea()) {
                    sheet.setRowPaginationPointsSnapshot(job.getTablePrintPagination().getRowPaginationPointsSnapshot());
                    sheet.setColPaginationPointsSnapshot(job.getTablePrintPagination().getColPaginationPointsSnapshot());
                }
                pm.getMultiPrintManager().clear();
                SpreadContext.this.repaint();
            }
        }
    }

    private class EmbedObjectChangeListener
    implements SheetChangeListener,
    BookChangeListener,
    GraphChangeListener {
        static final int DRAG_INSETS_LEFT_OFFSET = 3;
        static final int DRAG_INSETS_RIGHT_OFFSET = 6;

        private EmbedObjectChangeListener() {
        }

        @Override
        public void changed(GraphChangedEvent e) {
            if (!SpreadContext.this.isDisplayable()) {
                return;
            }
            if (e.isGraphRemoved()) {
                this.removeEmbedXs(e.getChangedGraphs(), true);
            } else if (e.isGraphInserted()) {
                this.relayoutEmbedXs(e.getChangedGraphs(), true);
            }
        }

        @Override
        public void propertyChanged(GraphPropertyChangedEvent e) {
            if (!SpreadContext.this.isDisplayable()) {
                return;
            }
            if ("Changed_Bounds".equals(e.getType())) {
                this.relayoutEmbedXs(e.getGraphs(), false);
            }
        }

        @Override
        public void changed(SheetChangeEvent e) {
            Sheet sheet = e.getSheet();
            if (!SpreadContext.this.isDisplayable() || sheet == null) {
                return;
            }
            EmbedhLayer ems = sheet.getEmbedments(false);
            if (ems == null) {
                return;
            }
            if (e.hasState(SheetChangeEvent.Changed_Sheet_Scale | SheetChangeEvent.Changed_Resize | SheetChangeEvent.Changed_Content | SheetChangeEvent.Changed_Delete | SheetChangeEvent.Changed_Insert | SheetChangeEvent.Calculation_Finish)) {
                EmbedObject[] embeds = new EmbedObject[ems.size()];
                for (int i = ems.size() - 1; i >= 0; --i) {
                    EmbedObject eo = ems.getEmbed(i);
                    if (eo instanceof Chart) {
                        Chart chart = (Chart)eo;
                        chart.getModel().getDataNode().setChange(true);
                    }
                    eo.relayout();
                    embeds[i] = eo;
                }
                sheet.getBook().fireGraphPropertyChange(new GraphPropertyChangedEvent(sheet, embeds, "Changed_Bounds", new Rectangle[0], new Rectangle[0]));
            }
        }

        @Override
        public void changed(BookChangeEvent e) {
            Sheet sheet = e.getSheet();
            if (!SpreadContext.this.isDisplayable() || sheet == null) {
                return;
            }
            EmbedhLayer ems = sheet.getEmbedments(false);
            if (ems == null) {
                return;
            }
            if (e.isSheetActive()) {
                EmbedObject[] embeds = new EmbedObject[ems.size()];
                for (int i = ems.size() - 1; i >= 0; --i) {
                    embeds[i] = ems.getEmbed(i);
                }
                this.relayoutEmbedXs(embeds, false);
            } else if (e.isSheetDeactive()) {
                EmbedObject[] embeds = new EmbedObject[ems.size()];
                for (int i = ems.size() - 1; i >= 0; --i) {
                    embeds[i] = ems.getEmbed(i);
                }
                this.removeEmbedXs(embeds, false);
            } else if (e.isSheetRemove()) {
                EmbedObject[] embeds = new EmbedObject[ems.size()];
                for (int i = ems.size() - 1; i >= 0; --i) {
                    embeds[i] = ems.getEmbed(i);
                }
                this.removeEmbedXs(embeds, false);
            }
        }

        private void relayoutEmbedXs(EmbedObject[] eos, boolean careAboutURdo) {
            if (eos.length == 0) {
                return;
            }
            JComponent table = SpreadContext.this.getSpread().getView(2, 2);
            for (int i = 0; i < eos.length; ++i) {
                Component comp;
                EmbedObject eo = eos[i];
                if (!(eo instanceof IEmbedX) || (comp = ((IEmbedX)((Object)eo)).getPhysicalUI()) == null) continue;
                if (comp.getParent() == table && careAboutURdo) {
                    table.remove(comp);
                    continue;
                }
                if (comp.getParent() != table) {
                    table.add(comp);
                }
                comp.setBounds(eo.getX() + 3, eo.getY() + 3, eo.getWidth() - 6, eo.getHeight() - 6);
            }
            table.revalidate();
        }

        private void removeEmbedXs(EmbedObject[] eos, boolean careAboutURdo) {
            if (eos.length == 0) {
                return;
            }
            JComponent table = SpreadContext.this.getSpread().getView(2, 2);
            for (int i = 0; i < eos.length; ++i) {
                Component comp;
                EmbedObject eo = eos[i];
                if (!(eo instanceof IEmbedX) || (comp = ((IEmbedX)((Object)eo)).getPhysicalUI()) == null) continue;
                if (comp.getParent() == table) {
                    table.remove(comp);
                    continue;
                }
                if (!careAboutURdo) continue;
                table.add(comp);
                comp.setBounds(eo.getX() + 3, eo.getY() + 3, eo.getWidth() - 6, eo.getHeight() - 6);
            }
            table.revalidate();
        }
    }

    private class PrintConfigChangeHandler
    implements IConfigChangeListener {
        private PrintConfigChangeHandler() {
        }

        public void configChanged() {
            SpreadContext.this.getBook().setSkipListeners(true);
            SortedSheetArray selectedSheets = SpreadContext.this.getBook().getSelectSheets();
            String[] selecteds = new String[selectedSheets.size()];
            for (int i = 0; i < selectedSheets.size(); ++i) {
                selecteds[i] = selectedSheets.getSheet(i).getID();
            }
            PrintBookTrans.saveToBook(SpreadContext.this.getPrintManager(), SpreadContext.this.getBook(), selecteds);
            SpreadContext.this.getBook().setSkipListeners(false);
        }

        public void configOver() {
        }

        public void configWillChange() {
        }
    }

    private class SyncActionHandler
    implements ActionListener {
        private SyncActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            block8: {
                Object o;
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    if (SpreadContext.this._syncQueue.isEmpty()) break block8;
                                    o = SpreadContext.this._syncQueue.dequeue();
                                    if (!(o instanceof BookChangeEvent)) break block9;
                                    BookChangeEvent event = (BookChangeEvent)o;
                                    ArrayList al = SpreadContext.this.getListener(3, true, false);
                                    if (al == null) break block8;
                                    int size = al.size();
                                    for (int i = 0; i < size; ++i) {
                                        ((BookChangeListener)al.get(i)).changed(event);
                                    }
                                    break block8;
                                }
                                if (!(o instanceof SheetChangeEvent)) break block10;
                                SheetChangeEvent event = (SheetChangeEvent)o;
                                ArrayList al = SpreadContext.this.getListener(2, true, false);
                                if (al == null) break block8;
                                int size = al.size();
                                for (int i = 0; i < size; ++i) {
                                    ((SheetChangeListener)al.get(i)).changed(event);
                                }
                                break block8;
                            }
                            if (!(o instanceof SheetPropertyChangeEvent)) break block11;
                            SheetPropertyChangeEvent event = (SheetPropertyChangeEvent)o;
                            ArrayList al = SpreadContext.this.getListener(1, true, false);
                            if (al == null) break block8;
                            int size = al.size();
                            for (int i = 0; i < size; ++i) {
                                ((SheetPropertyChangeListener)al.get(i)).changed(event);
                            }
                            break block8;
                        }
                        if (!(o instanceof BookPropertyChangeEvent)) break block12;
                        BookPropertyChangeEvent event = (BookPropertyChangeEvent)o;
                        ArrayList al = SpreadContext.this.getListener(4, true, false);
                        if (al == null) break block8;
                        int size = al.size();
                        for (int i = 0; i < size; ++i) {
                            ((BookPropertyChangeListener)al.get(i)).changed(event);
                        }
                        break block8;
                    }
                    if (!(o instanceof GraphChangedEvent)) break block13;
                    GraphChangedEvent event = (GraphChangedEvent)o;
                    ArrayList al = SpreadContext.this.getListener(5, true, false);
                    if (al == null) break block8;
                    int size = al.size();
                    for (int i = 0; i < size; ++i) {
                        ((GraphChangeListener)al.get(i)).changed(event);
                    }
                    break block8;
                }
                if (o instanceof GraphPropertyChangedEvent) {
                    GraphPropertyChangedEvent event = (GraphPropertyChangedEvent)o;
                    ArrayList al = SpreadContext.this.getListener(5, true, false);
                    if (al != null) {
                        int size = al.size();
                        for (int i = 0; i < size; ++i) {
                            ((GraphChangeListener)al.get(i)).propertyChanged(event);
                        }
                    }
                }
            }
        }
    }

    private class BookListenerDelegate
    implements SheetPropertyChangeListener,
    BookChangeListener,
    SheetChangeListener,
    BookPropertyChangeListener,
    GraphChangeListener {
        private BookListenerDelegate() {
        }

        @Override
        public void changed(SheetPropertyChangeEvent event) {
            ArrayList al = SpreadContext.this.getListener(1, false, false);
            if (al != null) {
                int size = al.size();
                for (int i = 0; i < size; ++i) {
                    ((SheetPropertyChangeListener)al.get(i)).changed(event);
                }
            }
            SpreadContext.this._syncQueue.enqueue((Object)event);
        }

        @Override
        public void changed(SheetChangeEvent event) {
            ArrayList al = SpreadContext.this.getListener(2, false, false);
            if (al != null) {
                int size = al.size();
                for (int i = 0; i < size; ++i) {
                    ((SheetChangeListener)al.get(i)).changed(event);
                }
            }
            SpreadContext.this._syncQueue.enqueue((Object)event);
        }

        @Override
        public void changed(BookChangeEvent event) {
            ArrayList al = SpreadContext.this.getListener(3, false, false);
            if (al != null) {
                int size = al.size();
                for (int i = 0; i < size; ++i) {
                    ((BookChangeListener)al.get(i)).changed(event);
                }
            }
            SpreadContext.this._syncQueue.enqueue((Object)event);
        }

        @Override
        public void changed(BookPropertyChangeEvent event) {
            ArrayList al = SpreadContext.this.getListener(4, false, false);
            if (al != null) {
                int size = al.size();
                for (int i = 0; i < size; ++i) {
                    ((BookPropertyChangeListener)al.get(i)).changed(event);
                }
            }
            SpreadContext.this._syncQueue.enqueue((Object)event);
        }

        @Override
        public void changed(GraphChangedEvent e) {
            ArrayList al = SpreadContext.this.getListener(5, false, false);
            if (al != null) {
                int size = al.size();
                for (int i = 0; i < size; ++i) {
                    ((GraphChangeListener)al.get(i)).changed(e);
                }
            }
            SpreadContext.this._syncQueue.enqueue((Object)e);
        }

        @Override
        public void propertyChanged(GraphPropertyChangedEvent e) {
            ArrayList al = SpreadContext.this.getListener(5, false, false);
            if (al != null) {
                int size = al.size();
                for (int i = 0; i < size; ++i) {
                    ((GraphChangeListener)al.get(i)).propertyChanged(e);
                }
            }
            SpreadContext.this._syncQueue.enqueue((Object)e);
        }
    }
}

