/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.impl.facade.wizzard;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.facade.MultiLanguageKeys;
import com.kingdee.bos.ctrl.excel.impl.facade.rangesel.RangeSelector;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.ISpreadWizzard;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.embed.EmbedObject;
import com.kingdee.bos.ctrl.excel.model.struct.embed.EmbedhLayer;
import com.kingdee.bos.ctrl.excel.model.struct.embed.chart.Chart;
import com.kingdee.bos.ctrl.excel.model.struct.embed.chart.ChartDataNode;
import com.kingdee.bos.ctrl.excel.model.struct.embed.chart.ChartModel;
import com.kingdee.bos.ctrl.excel.model.struct.node.CellBlockNode;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.chart.ChartType;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;

public class WizzardChart
extends KDDialog
implements ISpreadWizzard {
    private static final ChartType[] supports = new ChartType[]{ChartType.CT_PIE, ChartType.CT_PIEEXPLODED, ChartType.CT_PIE3D, ChartType.CT_COLUMNCLUSTERED, ChartType.CT_COLUMNSTACKED, ChartType.CT_COLUMNCLUSTERED3D, ChartType.CT_COLUMNSTACKED3D, ChartType.CT_BARCLUSTERED, ChartType.CT_BARSTACKED, ChartType.CT_BARCLUSTERED3D, ChartType.CT_BARSTACKED3D, ChartType.CT_LINE, ChartType.CT_LINESTACKED, ChartType.CT_LINEMARKERS, ChartType.CT_LINEMARKERSSTACKED, ChartType.CT_XYSCATTER, ChartType.CT_XYSCATTERLINES, ChartType.CT_XYSCATTERLINESNOMARKERS, ChartType.CT_AREA, ChartType.CT_AREASTACKED};
    private KDComboBox _cbChartType;
    private KDTextField _tfChartTitle;
    private KDTextField _tfCategoryAxisTitle;
    private KDTextField _tfValAxisTitle;
    private RangeSelector _rsRange;
    private KDTextField _tfGroupKey;
    private KDFormattedTextField _ftfAngle;
    private KDButton _btnOk;
    private KDButton _btnCancel;
    private SpreadContext _context;
    private KDLabel _serialLbl;
    private KDRadioButton _byCol;
    private KDRadioButton _byRow;
    private ButtonGroup _btnGroup;
    private Chart _chart;
    private KDTextField serialValueTextField;
    private KDTextField valueFormatTextField;

    public WizzardChart(Dialog parent, SpreadContext context) {
        super(parent);
        this._context = context;
        this.init();
        this.setLocationRelativeTo(parent);
    }

    public WizzardChart(Frame parent, SpreadContext context) {
        super(parent);
        this._context = context;
        this.init();
    }

    private void init() {
        this.setResizable(false);
        Container cp = this.getContentPane();
        cp.setLayout(null);
        cp.setSize(new Dimension(430, 270));
        this.setSize(440, 270);
        this._cbChartType = new KDComboBox();
        for (int i = 0; i < supports.length; ++i) {
            this._cbChartType.addItem((Object)supports[i]);
        }
        KDLabelContainer lc = new KDLabelContainer(MultiLanguageKeys.getLocalText("Key_EmbededObjectChartType", "\u56fe\u8868\u7c7b\u578b:"), (JComponent)this._cbChartType);
        cp.add((Component)lc);
        lc.setBounds(10, 10, 400, 20);
        this._tfChartTitle = new KDTextField();
        KDLabelContainer lc1 = new KDLabelContainer(MultiLanguageKeys.getLocalText("KEY_ChartTitle") + ":", (JComponent)this._tfChartTitle);
        lc1.setBoundLabelAlignment(8);
        lc1.setPreferredSize(new Dimension(125, 42));
        this._tfCategoryAxisTitle = new KDTextField();
        KDLabelContainer lc2 = new KDLabelContainer(MultiLanguageKeys.getLocalText("KEY_ChartCatAxisTitle") + ":", (JComponent)this._tfCategoryAxisTitle);
        lc2.setBoundLabelAlignment(8);
        lc2.setPreferredSize(new Dimension(125, 42));
        this._tfValAxisTitle = new KDTextField();
        KDLabelContainer lc3 = new KDLabelContainer(MultiLanguageKeys.getLocalText("KEY_ChartValAxisTitle") + ":", (JComponent)this._tfValAxisTitle);
        lc3.setBoundLabelAlignment(8);
        lc3.setPreferredSize(new Dimension(125, 42));
        this._tfGroupKey = new KDTextField();
        KDLabelContainer lc4 = new KDLabelContainer(MultiLanguageKeys.getLocalText("KEY_ChartGroupKeys") + ":", (JComponent)this._tfGroupKey);
        lc4.setBoundLabelAlignment(7);
        lc4.setPreferredSize(new Dimension(325, 21));
        this._ftfAngle = new KDFormattedTextField();
        this._ftfAngle.setColumns(4);
        this._ftfAngle.setDataType(0);
        this._ftfAngle.setSupportedEmpty(false);
        this._ftfAngle.setNumberValue((Number)new Integer(0));
        KDLabelContainer lc5 = new KDLabelContainer(MultiLanguageKeys.getLocalText("Key_EmbededObjectDip", "\u503e\u89d2:"), (JComponent)this._ftfAngle);
        lc5.setBoundLabelAlignment(7);
        lc5.setPreferredSize(new Dimension(60, 21));
        this.serialValueTextField = new KDTextField();
        this.serialValueTextField.setToolTipText(MultiLanguageKeys.getLocalText("KEY_SerialValueTips", "\u4f7f\u7528,\u5206\u9694"));
        KDLabelContainer lc6 = new KDLabelContainer(MultiLanguageKeys.getLocalText("KEY_SerialValue", "\u5e8f\u5217\u540d\u79f0\uff1a"), (JComponent)this.serialValueTextField);
        lc6.setBoundLabelAlignment(8);
        lc6.setPreferredSize(new Dimension(200, 41));
        this.valueFormatTextField = new KDTextField();
        this.valueFormatTextField.setToolTipText(MultiLanguageKeys.getLocalText("KEY_ValueFormatTips", "\u767e\u5206\u6570:0%,\u5343\u5206\u4f4d:#,##0.00"));
        KDLabelContainer numberlc = new KDLabelContainer(MultiLanguageKeys.getLocalText("KEY_ValueFormat", "\u503c\u5750\u6807\u683c\u5f0f\u5316\u4e32\uff1a"), (JComponent)this.valueFormatTextField);
        numberlc.setBoundLabelAlignment(8);
        numberlc.setPreferredSize(new Dimension(150, 41));
        KDPanel p = new KDPanel();
        p.setLayout((LayoutManager)new FlowLayout(0));
        p.add((Component)lc1);
        p.add((Component)lc2);
        p.add((Component)lc3);
        p.add((Component)lc4);
        p.add((Component)lc5);
        p.add((Component)lc6);
        p.add((Component)numberlc);
        cp.add((Component)p);
        p.setBounds(10, 40, 400, 135);
        this._rsRange = this._context.getFacadeManager().createRangeSelector(MultiLanguageKeys.getLocalText("KEY_ChartChooseData"));
        this._rsRange.setWithSheetName(true);
        this._rsRange.setWithOpreatorEqual(true);
        KDLabelContainer rangelc = new KDLabelContainer(MultiLanguageKeys.getLocalText("KEY_ChartChooseData") + ":", (JComponent)this._rsRange);
        rangelc.setBoundLabelAlignment(7);
        rangelc.setPreferredSize(new Dimension(190, 20));
        cp.add((Component)rangelc);
        rangelc.setBounds(10, 175, 220, 20);
        this._serialLbl = new KDLabel();
        this._serialLbl.setText("\u7cfb\u5217\u4ea7\u751f\u5728\uff1a");
        cp.add((Component)this._serialLbl);
        this._serialLbl.setBounds(235, 175, 72, 20);
        this._btnGroup = new ButtonGroup();
        this._byCol = new KDRadioButton();
        this._byRow = new KDRadioButton();
        this._btnGroup.add((AbstractButton)this._byRow);
        this._btnGroup.add((AbstractButton)this._byCol);
        this._byRow.setText("\u884c");
        cp.add((Component)this._byRow);
        this._byRow.setBounds(315, 175, 40, 20);
        this._byCol.setText("\u5217");
        cp.add((Component)this._byCol);
        this._byCol.setBounds(360, 175, 40, 20);
        this._btnOk = new KDButton(MultiLanguageKeys.getLocalText("KEY_OK"));
        this._btnOk.addActionListener((ActionListener)new FinishAction());
        this._btnCancel = new KDButton(MultiLanguageKeys.getLocalText("KEY_CANCEL"));
        this._btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizzardChart.this.closeDialog();
            }
        });
        KDPanel pnlCtrl = new KDPanel();
        pnlCtrl.setLayout((LayoutManager)new FlowLayout());
        pnlCtrl.add((Component)this._btnOk);
        pnlCtrl.add((Component)this._btnCancel);
        cp.add((Component)pnlCtrl);
        pnlCtrl.setBounds(10, 205, 400, 30);
    }

    private void initDatas(Chart chart) {
        if (chart == null) {
            this._cbChartType.setSelectedItem((Object)supports[3]);
            this._tfChartTitle.setText("");
            this._tfCategoryAxisTitle.setText("");
            this._tfValAxisTitle.setText("");
            String srg = '=' + this._context.getBook().getActiveSheet().getSyntaxName() + '!' + Sheet.getBlocksName(this._context.getBook().getActiveSheet().getSheetOption().getSelection().toSortedBlocks(), this._context.getBook().getDeps().isA1Style(), false);
            this._rsRange.setText(srg);
        } else {
            this._cbChartType.setSelectedItem((Object)chart.getChartType());
            this._tfChartTitle.setText(chart.getChartTitle());
            this._tfCategoryAxisTitle.setText(chart.getCategoryAxisTitle());
            this._tfValAxisTitle.setText(chart.getValueAxisTitle());
            this._tfGroupKey.setText(this.buildGroupKeysString(chart.getGroupsKeys()));
            this._ftfAngle.setValue((Object)new Integer(chart.getCategoryLabelPositions()));
            String srg = '=' + this._context.getBook().getActiveSheet().getSyntaxName() + '!' + Sheet.getBlocksName(new ArrayList<CellBlockNode>(Arrays.asList(chart.getChartRange().getRange())), this._context.getBook().getDeps().isA1Style(), false);
            this._rsRange.setText(srg);
            ChartModel model = chart.getModel();
            this.serialValueTextField.setText(this.buildGroupKeysString(model.getSerialKeys()));
            this.valueFormatTextField.setText(model.getValueNumberFormatStr());
            if (model.isSerialByCol()) {
                this._byRow.setSelected(true);
            } else {
                this._byCol.setSelected(true);
            }
            this._byCol.setEnabled(true);
            this._byRow.setEnabled(true);
        }
    }

    private String buildGroupKeysString(List list) {
        if (list == null) {
            return null;
        }
        Iterator it = list.iterator();
        StringBuffer sb = new StringBuffer();
        if (it.hasNext()) {
            sb.append(it.next());
        }
        while (it.hasNext()) {
            sb.append(',');
            sb.append(it.next());
        }
        return sb.toString();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void commit() {
    }

    @Override
    public boolean prepare() {
        Sheet sheet = this._context.getBook().getActiveSheet();
        EmbedhLayer gl = sheet.getEmbedments(false);
        if (gl != null) {
            EmbedObject gr = gl.getActiveSelectedEmbed();
            if (gr instanceof Chart) {
                this._chart = (Chart)gr;
                this.initDatas(this._chart);
                return true;
            }
            return false;
        }
        this._chart = null;
        this.initDatas(this._chart);
        return true;
    }

    private class FinishAction
    extends AbstractAction {
        private FinishAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Book book = WizzardChart.this._context.getBook();
            Sheet sheet = book.getActiveSheet();
            ChartType type = (ChartType)WizzardChart.this._cbChartType.getSelectedItem();
            Range rg = null;
            String refersTo = WizzardChart.this._rsRange.getText();
            if (!StringUtil.isEmptyString((String)refersTo)) {
                rg = WizzardChart.this._context.getRangeManager().findRangeInBook(refersTo, false);
            }
            if (rg == null) {
                WizzardChart.this._context.getFacadeManager().showErrorMessageBox(MultiLanguageKeys.getLocalText("KEY_INVALID_RANGE"), 0);
                WizzardChart.this._rsRange.requestFocus();
                return;
            }
            int allCells = 0;
            for (int i = rg.size() - 1; i >= 0; --i) {
                CellBlock cb = rg.getBlock(i);
                allCells += cb.getWidth() * cb.getHeight();
            }
            if (allCells > 1000) {
                WizzardChart.this._context.getFacadeManager().showErrorMessageBox(MultiLanguageKeys.getLocalText("Key_TooLongRange"), 2);
                return;
            }
            ChartDataNode range = new ChartDataNode(sheet, Sheet.getArrayBlockNodes(sheet, WizzardChart.this._rsRange.getText(), sheet.getDeps().isA1Style()));
            String title = WizzardChart.this._tfChartTitle.getText();
            String categoryTitle = WizzardChart.this._tfCategoryAxisTitle.getText();
            String valueTitle = WizzardChart.this._tfValAxisTitle.getText();
            String[] groupKeys = WizzardChart.this._tfGroupKey.getText().split(",");
            if (groupKeys[0].equals("") && groupKeys.length == 1) {
                groupKeys = null;
            }
            int angle = WizzardChart.this._ftfAngle.getNumberValue().intValue();
            boolean serialByCol = WizzardChart.this._byRow.isSelected();
            String[] serialKeys = WizzardChart.this.serialValueTextField.getText().split(",");
            ArrayList<String> serialKeyList = new ArrayList<String>();
            Collections.addAll(serialKeyList, serialKeys);
            String valueFormat = WizzardChart.this.valueFormatTextField.getText();
            WizzardChart.this._chart.setValueFormat(valueFormat);
            WizzardChart.this._chart.setChartType(type);
            WizzardChart.this._chart.setChartRange(range);
            WizzardChart.this._chart.setChartTitle(title);
            WizzardChart.this._chart.setCategoryAxisTitle(categoryTitle);
            WizzardChart.this._chart.setValueAxisTitle(valueTitle);
            WizzardChart.this._chart.setGroupsKeys(groupKeys);
            WizzardChart.this._chart.setCategoryLabelPositions(angle);
            WizzardChart.this._chart.setSerialByCol(serialByCol);
            WizzardChart.this._chart.setSerialKeys(serialKeyList);
            WizzardChart.this._context.repaint();
            WizzardChart.this.closeDialog();
        }
    }
}

