/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.impl.facade.wizzard.finder;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.finder.ICellUserObjectMatcher;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellFinder;
import com.kingdee.bos.ctrl.excel.model.struct.Comment;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import java.util.HashMap;

public final class CellMatcher
implements CellFinder.ICellMatcher {
    static final Object FIND_VALUE = new Object();
    static final Object FIND_FORMULA = new Object();
    static final Object FIND_COMMENT = new Object();
    private String _value;
    private boolean _matchCase;
    private boolean _matchFull;
    private StyleAttributes _sa;
    private Object _serMode;
    private HashMap _uoMatchers;

    public String getValue() {
        return this._value;
    }

    public boolean isMatchCase() {
        return this._matchCase;
    }

    public boolean isMatchFull() {
        return this._matchFull;
    }

    public StyleAttributes getSA() {
        return this._sa;
    }

    public Object getSerMode() {
        return this._serMode;
    }

    @Override
    public boolean isMatched(Cell cell) {
        Object o;
        String str = null;
        if (FIND_FORMULA == this._serMode) {
            str = cell.getDisplayFormula();
        } else if (FIND_VALUE == this._serMode) {
            Variant variant = cell.getValue();
            str = variant.isNumber() ? variant.toString() : cell.getText();
        } else if (FIND_COMMENT == this._serMode) {
            Comment comment = cell.getComment();
            if (comment != null) {
                str = comment.toString();
            }
        } else if (this._uoMatchers != null && (o = this._uoMatchers.get(this._serMode)) != null) {
            str = ((ICellUserObjectMatcher)o).getMatchString(cell, this._serMode);
        }
        if (str != null) {
            return this.isMatched(cell, str);
        }
        return false;
    }

    void addUserObjectMatcher(Object serMode, ICellUserObjectMatcher matcher) {
        if (this._uoMatchers == null) {
            this._uoMatchers = new HashMap();
        }
        if (matcher == null) {
            this._uoMatchers.remove(serMode);
        } else {
            this._uoMatchers.put(serMode, matcher);
        }
    }

    void setValue(String value) {
        this._value = value;
    }

    void setMatchCase(boolean matchCase) {
        this._matchCase = matchCase;
    }

    void setMatchFull(boolean matchFull) {
        this._matchFull = matchFull;
    }

    void setSA(StyleAttributes sa) {
        this._sa = sa;
    }

    void setSerMode(Object serMode) {
        this._serMode = serMode;
    }

    private boolean isMatched(Cell cell, String cellString) {
        boolean bSameSSA;
        String value = this._value;
        if (!this._matchCase) {
            if (this._value != null) {
                value = this._value.toLowerCase();
            }
            cellString = cellString.toLowerCase();
        }
        if (value == null) {
            value = "";
        }
        boolean bl = this._sa == null ? true : (bSameSSA = this._sa.sameBits((ShareStyleAttributes)cell.getStyle(), 0, ShareStyleAttributes.ATTRS_COUNT) == this._sa.getAttrsBits());
        if (this._matchFull) {
            return bSameSSA && cellString.equalsIgnoreCase(value);
        }
        return bSameSSA && cellString.indexOf(value) != -1;
    }
}

