/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.impl.state.mouse;

import com.kingdee.bos.ctrl.excel.core.SpreadView;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.state.mouse.DefaultMouseController;
import com.kingdee.bos.ctrl.excel.impl.state.mouse.IMouseState;
import com.kingdee.bos.ctrl.excel.impl.state.mouse.OutlineGroupColHeaderMouseHandle;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SortedAttributeSpanArray;
import java.awt.event.MouseEvent;

public class OutlineGroupColHeaderMouseController
extends DefaultMouseController {
    private SpreadContext _context;
    protected IMouseState ch = new OutlineGroupColHeaderMouseHandle();

    public OutlineGroupColHeaderMouseController(SpreadContext context) {
        this._context = context;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public IMouseState prePressing(MouseEvent e) {
        this._context.getSpread().setActiveView((SpreadView)e.getSource());
        return this.ch;
    }

    public static void switchTheHandlerWhenLeft(Sheet sheet, int colId, SortedAttributeSpanArray sasa, int level, boolean isOff) {
        SortedAttributeSpanArray.AttributeSpan as;
        int pos;
        int i = colId + 1;
        while ((pos = sasa.searchSpan(i)) >= 0 && (as = sasa.getAttributeSpan(pos)).getOutlineGroupLevel() > level) {
            if (!isOff) {
                sheet.getColRange(as.getStart(), as.getEnd()).setColumnHidden(!isOff);
            } else {
                int sPos;
                int m = as.getStart() - 1;
                while ((sPos = sasa.searchSpan(m)) >= 0) {
                    SortedAttributeSpanArray.AttributeSpan lookupAs = sasa.getAttributeSpan(sPos);
                    if (as.getOutlineGroupLevel() > lookupAs.getOutlineGroupLevel()) {
                        if (lookupAs.getEnd() == colId) {
                            sheet.getColRange(as.getStart(), as.getEnd()).setColumnHidden(!isOff);
                            break;
                        }
                        if (OutlineGroupColHeaderMouseController.isCollapseWhenHandlerLeft(lookupAs, sasa, colId)) break;
                        sheet.getColRange(as.getStart(), as.getEnd()).setColumnHidden(!isOff);
                        break;
                    }
                    --m;
                }
            }
            i = as.getEnd();
            ++i;
        }
        sheet.getColRange(colId, colId).setColumnOutlineGroupCollapse(!isOff);
    }

    private static boolean isCollapseWhenHandlerLeft(SortedAttributeSpanArray.AttributeSpan as, SortedAttributeSpanArray sasa, int colId) {
        SortedAttributeSpanArray.AttributeSpan lookupAs;
        int sPos;
        if (as.isCollapse()) {
            return true;
        }
        int m = as.getStart() - 1;
        while ((sPos = sasa.searchSpan(m)) >= 0 && (lookupAs = sasa.getAttributeSpan(sPos)).getEnd() > colId) {
            if (as.getOutlineGroupLevel() > lookupAs.getOutlineGroupLevel()) {
                if (lookupAs.isCollapse()) {
                    return true;
                }
                as = lookupAs;
            }
            --m;
        }
        return false;
    }

    public static void switchTheHandlerWhenRight(Sheet sheet, int colId, SortedAttributeSpanArray sasa, int level, boolean isOff) {
        SortedAttributeSpanArray.AttributeSpan as;
        int pos;
        int i = colId - 1;
        while ((pos = sasa.searchSpan(i)) >= 0 && (as = sasa.getAttributeSpan(pos)).getOutlineGroupLevel() > level) {
            if (!isOff) {
                sheet.getColRange(as.getStart(), as.getEnd()).setColumnHidden(!isOff);
            } else {
                int sPos;
                int m = as.getEnd() + 1;
                while ((sPos = sasa.searchSpan(m)) >= 0) {
                    SortedAttributeSpanArray.AttributeSpan lookupAs = sasa.getAttributeSpan(sPos);
                    if (as.getOutlineGroupLevel() > lookupAs.getOutlineGroupLevel()) {
                        if (lookupAs.getStart() == colId) {
                            sheet.getColRange(as.getStart(), as.getEnd()).setColumnHidden(!isOff);
                            break;
                        }
                        if (OutlineGroupColHeaderMouseController.isCollapseWhenHandlerRight(lookupAs, sasa, colId)) break;
                        sheet.getColRange(as.getStart(), as.getEnd()).setColumnHidden(!isOff);
                        break;
                    }
                    ++m;
                }
            }
            i = as.getStart();
            --i;
        }
        sheet.getColRange(colId, colId).setColumnOutlineGroupCollapse(!isOff);
    }

    private static boolean isCollapseWhenHandlerRight(SortedAttributeSpanArray.AttributeSpan as, SortedAttributeSpanArray sasa, int colId) {
        SortedAttributeSpanArray.AttributeSpan lookupAs;
        int sPos;
        if (as.isCollapse()) {
            return true;
        }
        int m = as.getEnd() + 1;
        while ((sPos = sasa.searchSpan(m)) >= 0 && (lookupAs = sasa.getAttributeSpan(sPos)).getStart() < colId) {
            if (as.getOutlineGroupLevel() > lookupAs.getOutlineGroupLevel()) {
                if (lookupAs.isCollapse()) {
                    return true;
                }
                as = lookupAs;
            }
            ++m;
        }
        return false;
    }
}

