/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.io.clipboard;

import com.kingdee.bos.ctrl.common.ClipboardProxy;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.io.BookIOController;
import com.kingdee.bos.ctrl.excel.io.clipboard.KDSTransferable;
import com.kingdee.bos.ctrl.excel.io.clipboard.StringWalker;
import com.kingdee.bos.ctrl.excel.io.kml.BookToKml;
import com.kingdee.bos.ctrl.excel.io.kml.KmlToBook;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.KDClipboard;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.excel.model.util.SortedSheetArray;
import com.kingdee.eas.base.param.util.ParamManager;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.xml.sax.InputSource;
import sun.awt.AppContext;

public class ClipboardTransferHandler
implements Serializable {
    public static final Logger log = LogUtil.getPackageLogger(ClipboardTransferHandler.class);
    private static final long serialVersionUID = -3247920951269236765L;
    static final String XML_SPREADSHEET = "XML Spreadsheet";
    static final String KML = "KML";
    static final String SPREAD_GRAPHS = "Spread_Graphs";
    static final String RANGE_UUID = "KDRANGE UUID";
    private static boolean canAccessSystemClipboard = true;
    private static Object SandboxClipboardKey = new Object();

    private static boolean canAccessSystemClipboard() {
        if (canAccessSystemClipboard) {
            if (GraphicsEnvironment.isHeadless()) {
                canAccessSystemClipboard = false;
                return false;
            }
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                try {
                    sm.checkSystemClipboardAccess();
                    return true;
                }
                catch (SecurityException se) {
                    canAccessSystemClipboard = false;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static boolean exportGraphsToClipboard(byte[] str) {
        boolean bRet = false;
        Clipboard clip = ClipboardTransferHandler.getClipboard();
        if (clip != null) {
            clip.setContents(new StringSelection(null), null);
            ClipboardProxy clipProxy = ClipboardProxy.getInstance();
            if (clipProxy != null) {
                clipProxy.openClipboard(null);
                clipProxy.setClipboardDataByName(SPREAD_GRAPHS, str);
                clipProxy.closeClipboard();
                bRet = true;
            }
        }
        return bRet;
    }

    public static byte[] importGraphsDataFromClipboard() {
        Clipboard clip = ClipboardTransferHandler.getClipboard();
        if (clip == null) {
            return null;
        }
        ClipboardProxy clipProxy = ClipboardProxy.getInstance();
        if (clipProxy == null) {
            return null;
        }
        clipProxy.openClipboard(null);
        try {
            byte[] byArray = clipProxy.getClipboardDataByName(SPREAD_GRAPHS);
            return byArray;
        }
        finally {
            clipProxy.closeClipboard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exportToClipboard(Book srcBook, SortedCellBlockArray blocks, byte[] uuid) {
        Clipboard clip;
        boolean bRet = false;
        ClipboardProxy clipProxy = ClipboardProxy.getInstance();
        if (clipProxy != null) {
            clipProxy.openClipboard(null);
            try {
                clipProxy.emptyClipboard();
            }
            finally {
                clipProxy.closeClipboard();
            }
        }
        if ((clip = ClipboardTransferHandler.getClipboard()) != null) {
            KDSTransferable tf = new KDSTransferable(srcBook.getActiveSheet());
            clip.setContents(tf, null);
            srcBook.setCopyUUID(UUID.randomUUID().toString());
            Book dstBook = ClipboardTransferHandler.getClipDstBook(srcBook.getSelectSheets(), blocks);
            if (dstBook != null) {
                dstBook.setCopyUUID(srcBook.getCopyUUID());
            }
            if (clipProxy != null) {
                clipProxy.openClipboard(null);
                try {
                    clipProxy.setClipboardDataByName(RANGE_UUID, uuid);
                    if (KDClipboard.isEnableSpreadSheet()) {
                        ClipboardTransferHandler.setBookXmlToClipboard(clipProxy, XML_SPREADSHEET, dstBook, srcBook.getUserObjectsProvider());
                        ClipboardTransferHandler.setBookXmlToClipboard(clipProxy, KML, dstBook, srcBook.getUserObjectsProvider());
                    }
                }
                finally {
                    clipProxy.closeClipboard();
                }
            }
            bRet = true;
        }
        return bRet;
    }

    private static Book getClipDstBook(SortedSheetArray srcSheets, SortedCellBlockArray blocks) {
        KDClipboard.clear();
        KDClipboard.setSourceSelection(srcSheets, blocks);
        Sheet desSheet = null;
        int size = srcSheets.size();
        for (int i = 0; i < size; ++i) {
            Sheet srcSheet = srcSheets.getSheet(i);
            desSheet = KDClipboard.getNewSheet(srcSheet.getSheetName());
            srcSheet.copyPartSheetPacked(blocks, desSheet, 0, 0, KDClipboard.isOffset(), true);
        }
        Book dstBook = null;
        if (desSheet != null) {
            dstBook = desSheet.getBook();
            dstBook.setUserObject("CREATE_BORDER", Boolean.TRUE);
            dstBook.calcQueue();
        }
        return dstBook;
    }

    public static Book getClipDstBook(Sheet srcSheet, SortedCellBlockArray blocks) {
        SortedSheetArray srcSheets = new SortedSheetArray();
        srcSheets.insert(srcSheet);
        return ClipboardTransferHandler.getClipDstBook(srcSheets, blocks);
    }

    private static void setBookXmlToClipboard(ClipboardProxy clipProxy, String name, Book dstBook, Book.IUserObjectProvider uoProvider) {
        StringWriter writer = new StringWriter();
        BookToKml btk = new BookToKml();
        BookIOController bc = new BookIOController();
        bc.setKmlUOTrans(uoProvider);
        bc.setToClipboard(true);
        bc.setForExcel(name == XML_SPREADSHEET);
        btk.setBookIOController(bc);
        try {
            btk.export(dstBook, writer);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String str = writer.getBuffer().toString();
        byte[] bts = null;
        try {
            bts = str.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            bts = null;
        }
        clipProxy.setClipboardDataByName(name, bts);
    }

    public static boolean isClipboardDataAvailable() {
        Transferable tf;
        ClipboardProxy clipProxy = ClipboardProxy.getInstance();
        if ((clipProxy == null || KDClipboard.sameUUID(ClipboardTransferHandler.getRangeUUID())) && KDClipboard.canPaste()) {
            return true;
        }
        Clipboard clip = ClipboardTransferHandler.getClipboard();
        if (clip == null) {
            return false;
        }
        if (clipProxy != null) {
            clipProxy.openClipboard(null);
            byte[] bytes = clipProxy.getClipboardDataByName(XML_SPREADSHEET);
            clipProxy.closeClipboard();
            if (bytes != null && bytes.length > 0) {
                return true;
            }
        }
        if ((tf = clip.getContents(null)) == null) {
            return false;
        }
        DataFlavor[] flavors = tf.getTransferDataFlavors();
        DataFlavor flavor = ClipboardTransferHandler.getStringFlavor(flavors);
        if (flavor != null) {
            try {
                Object data = tf.getTransferData(flavor);
                return data != null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static Object importFromClipboard(Book dstBook) {
        return ClipboardTransferHandler.importFromClipboard(dstBook, 0);
    }

    public static boolean isFromSameBook(Book dstBook) {
        String dstCopyUUID;
        String srcCopyUUID;
        Book book;
        if (dstBook == null) {
            return false;
        }
        ClipboardProxy clipProxy = ClipboardProxy.getInstance();
        return (clipProxy == null || KDClipboard.sameUUID(ClipboardTransferHandler.getRangeUUID())) && (book = KDClipboard.getClipboardBook()) != null && (srcCopyUUID = book.getCopyUUID()).equals(dstCopyUUID = dstBook.getCopyUUID());
    }

    public static Object importFromClipboard(Book dstBook, int cf) {
        Book book;
        String dstCopyUUID;
        String dstCopyUUID2;
        String srcCopyUUID;
        Book book2;
        ClipboardProxy clipProxy = ClipboardProxy.getInstance();
        if ((clipProxy == null || KDClipboard.sameUUID(ClipboardTransferHandler.getRangeUUID())) && (book2 = KDClipboard.getClipboardBook()) != null && (srcCopyUUID = book2.getCopyUUID()).equals(dstCopyUUID2 = dstBook.getCopyUUID())) {
            return book2;
        }
        if (KDClipboard.sameUUID(ClipboardTransferHandler.getRangeUUID()) && !(dstCopyUUID = dstBook.getCopyUUID()).equals((book = KDClipboard.getClipboardBook()).getCopyUUID())) {
            return book;
        }
        Clipboard clip = ClipboardTransferHandler.getClipboard();
        if (clip == null) {
            return null;
        }
        Object ret = null;
        if (cf == 0) {
            if (clipProxy != null) {
                clipProxy.openClipboard(null);
                ret = ClipboardTransferHandler.getBookFromClipBoardXml(KML, dstBook, clip, clipProxy);
                if (ret == null) {
                    ret = ClipboardTransferHandler.getBookFromClipBoardXml(XML_SPREADSHEET, dstBook, clip, clipProxy);
                }
                if (ret == null) {
                    clipProxy.closeClipboard();
                    ret = ClipboardTransferHandler.getClipBoardText(clip);
                }
            }
        } else if (cf == 1) {
            ret = ClipboardTransferHandler.getClipBoardText(clip);
        }
        return ret;
    }

    private static Object getClipBoardText(Clipboard clip) {
        DataFlavor[] flavors;
        DataFlavor flavor;
        Object ret = null;
        Transferable tf = clip.getContents(null);
        if (tf != null && (flavor = ClipboardTransferHandler.getStringFlavor(flavors = tf.getTransferDataFlavors())) != null) {
            Object data = null;
            try {
                data = tf.getTransferData(flavor);
            }
            catch (UnsupportedFlavorException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (data instanceof String) {
                ret = data;
            }
        }
        return ret;
    }

    private static Object getBookFromClipBoardXml(String name, Book dstBook, Clipboard clip, ClipboardProxy clipProxy) {
        byte[] bytes = clipProxy.getClipboardDataByName(name);
        if (bytes == null || bytes.length <= 0) {
            return null;
        }
        Book ret = null;
        String str = null;
        try {
            str = new String(bytes, 0, bytes.length, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            str = new String(bytes);
        }
        if (str != null) {
            KmlToBook kml = new KmlToBook();
            kml.setFromExcelClipboard(name == XML_SPREADSHEET);
            BookIOController ctrl = new BookIOController();
            ctrl.setKmlUOTrans(dstBook.getUserObjectsProvider());
            ctrl.setToClipboard(true);
            kml.setIOController(ctrl);
            int len = str.length();
            if (str.charAt(len - 1) != '>') {
                str = str.substring(0, len - 1);
            }
            Book book = Book.Manager.getNewBook("", 0);
            book.getDeps().setFunctionManager(dstBook.getDeps().getFunctionManager());
            try {
                kml.load(new InputSource(new StringReader(str)), book);
            }
            catch (Exception e) {
                str = str.replaceAll("&", "&amp;");
                try {
                    kml.load(new InputSource(new StringReader(str)), book);
                }
                catch (Exception e1) {
                    log.error((Object)"\u7c98\u8d34\u5931\u8d25\uff01", (Throwable)e1);
                    return null;
                }
            }
            ret = kml.getBook();
            clipProxy.closeClipboard();
        }
        if (ret instanceof Book) {
            DataFlavor[] flavors;
            DataFlavor flavor;
            Book book = ret;
            book.setAutoCalculate(false);
            Transferable tf = clip.getContents(null);
            if (tf != null && (flavor = ClipboardTransferHandler.getStringFlavor(flavors = tf.getTransferDataFlavors())) != null) {
                Object data = null;
                try {
                    data = tf.getTransferData(flavor);
                }
                catch (UnsupportedFlavorException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (data instanceof String) {
                    ClipboardTransferHandler.paste(book.getActiveSheet(), CellBlock.getNewCellBlock(0, 0), (String)data);
                }
            }
        }
        return ret;
    }

    public static byte[] getRangeUUID() {
        ClipboardProxy clipProxy = ClipboardProxy.getInstance();
        if (clipProxy != null) {
            clipProxy.openClipboard(null);
            byte[] bytes = clipProxy.getClipboardDataByName(RANGE_UUID);
            clipProxy.closeClipboard();
            return bytes;
        }
        return null;
    }

    static DataFlavor getStringFlavor(DataFlavor[] flavors) {
        int length = flavors.length;
        for (int i = 0; i < length; ++i) {
            if (DataFlavor.stringFlavor != flavors[i]) continue;
            return flavors[i];
        }
        return null;
    }

    static Clipboard getClipboard() {
        if (ClipboardTransferHandler.canAccessSystemClipboard()) {
            return Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        Clipboard clipboard = (Clipboard)AppContext.getAppContext().get(SandboxClipboardKey);
        if (clipboard == null) {
            clipboard = new Clipboard("Sandboxed Component Clipboard");
            AppContext.getAppContext().put(SandboxClipboardKey, clipboard);
        }
        return clipboard;
    }

    private static void paste(Sheet sheet, CellBlock cb, String text) {
        if (StringUtil.isEmptyString((String)text)) {
            return;
        }
        StringWalker.SeperateResult sr = StringWalker.separate2Array(text);
        int row = cb.getRow();
        int rowCount = sr.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            Row rowObj = sheet.getRow(row++, false);
            int col = cb.getCol();
            int colCount = sr.getColCount();
            for (int j = 0; j < colCount; ++j) {
                Cell cell;
                String data = sr.getValueAt(i, j);
                if (rowObj == null || (cell = rowObj.getCell(col++, false)) == null || StringUtil.isEmptyString((String)data)) continue;
                if (!cell.hasFormula()) {
                    if (ClipboardTransferHandler.isFormula(data)) {
                        Variant var = cell.getValue();
                        cell.setFormula(data);
                        cell.setValue(var);
                        continue;
                    }
                    if (cell.getSSA2().getNumberFormat() != null && cell.getSSA2().getNumberFormat().length() > 0 && cell.getValue().getVt() != 10 || StringUtil.isScientificCounting((String)data)) continue;
                    boolean isActualValues = false;
                    try {
                        isActualValues = "true".equals(ParamManager.getParamValue(null, null, (String)"ShowDisplayValue"));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (!isActualValues) continue;
                    data = StringUtil.getNumber((String)data);
                    ClipboardTransferHandler.trasToBigDecimal(cell, data);
                    continue;
                }
                if (ClipboardTransferHandler.isFormula(data)) continue;
                data = StringUtil.getNumber((String)data);
                ClipboardTransferHandler.trasToBigDecimal(cell, data);
            }
        }
    }

    public static void trasToBigDecimal(Cell cell, String data) {
        Variant var = cell.getValue();
        if (var.getVt() == 10) {
            try {
                var.setBigDecimal(new BigDecimal(data));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static boolean isFormula(String formula) {
        return formula != null && formula.length() > 1 && formula.startsWith("=");
    }
}

