/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.io.htm;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import java.io.File;
import org.jdom2.Namespace;

class XslHtmUtil {
    XslHtmUtil() {
    }

    static int toScreenValue(double storeValue) {
        return (int)(storeValue * 4.0 / 3.0);
    }

    static double toStoreValue(double screenValue) {
        return screenValue * 3.0 / 4.0;
    }

    static int toStoreHoriSplit(int split) {
        return 285 + 15 * split;
    }

    static int toScreenHoriSplit(int split) {
        return (split - 285) / 15;
    }

    static int toStoreVertSplit(int split) {
        return 510 + 15 * split;
    }

    static int toScreenVertSplit(int split) {
        return (split - 510) / 15;
    }

    static String getLocalName(String qName) {
        int index = qName.indexOf(":");
        if (index != -1) {
            qName = qName.substring(index + 1);
        }
        return qName;
    }

    static String getNSName(String name, Namespace ns) {
        String pre = ns.getPrefix();
        if (StringUtil.isEmptyString((String)pre)) {
            return name;
        }
        return ns.getPrefix() + ":" + name;
    }

    static String toXmlString(String str) {
        if (str == null) {
            return null;
        }
        String ret = str.replaceAll("&", "&amp;");
        ret = ret.replaceAll("\"", "&quot;");
        ret = ret.replaceAll("<", "&lt;");
        ret = ret.replaceAll(">", "&gt;");
        return ret;
    }

    static String toBookString(String str) {
        if (str == null) {
            return null;
        }
        String ret = str.replaceAll("&quot;", "\"");
        ret = ret.replaceAll("&lt;", "<");
        ret = ret.replaceAll("&gt;", ">");
        ret = ret.replaceAll("&amp;", "&");
        return ret;
    }

    static String intArrayToString(int[] ia) {
        if (ia == null || ia.length == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ia.length; ++i) {
            sb.append(ia[i]);
            if (i == ia.length - 1) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    static int[] stringToIntArray(String str) {
        String[] sa;
        if (!StringUtil.isEmptyString((String)str) && (sa = str.split(",")).length > 0) {
            int[] ia = new int[sa.length];
            for (int i = 0; i < ia.length; ++i) {
                ia[i] = Integer.parseInt(sa[i]);
            }
            return ia;
        }
        return null;
    }

    static String getFileNameWithoutExt(String path) {
        String fNWithoutExt = "";
        String fileName = XslHtmUtil.getFileName(path);
        int endIndex = fileName.lastIndexOf(".htm");
        if (endIndex > 0) {
            fNWithoutExt = fileName.substring(0, endIndex);
        }
        return fNWithoutExt;
    }

    static String getFileName(String path) {
        if (path == null) {
            path = "";
        }
        return new File(path).getName();
    }

    static String parseRangeStr(String range) {
        StringBuffer newStr = new StringBuffer(10);
        int length = range.length();
        if (length == 2) {
            newStr.append("$").append(range.indexOf(0)).append("$").append(range.indexOf(1));
        }
        if (length == 5) {
            newStr.append("$").append(range.indexOf(0)).append("$").append(range.indexOf(1)).append(":").append("$").append(range.indexOf(2)).append("$").append(range.indexOf(3));
        }
        return newStr.toString();
    }
}

