/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.io.kds;

import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.ctrl.excel.io.BookIOController;
import com.kingdee.bos.ctrl.excel.io.kds.KDSBinaryBook;
import com.kingdee.bos.ctrl.excel.io.kds.KDSConstants;
import com.kingdee.bos.ctrl.excel.io.kds.SectionJarInputStream;
import com.kingdee.bos.ctrl.excel.io.kds.archives.kds10.KDSBinaryBook10;
import com.kingdee.bos.ctrl.excel.io.kds.archives.kds540.KDSBinaryBook540;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.IBookProvider;
import com.kingdee.bos.ctrl.excel.util.KDSDataInputStream;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public final class KdsToBook
extends KDSConstants {
    private BookIOController _ctrl;

    public void setBookIOController(BookIOController ctrl) {
        this._ctrl = ctrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Book load(String file) {
        Book book;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            book = this.load(fis);
        }
        catch (FileNotFoundException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{fis});
                throw throwable;
            }
            CloseUtil.close((Closeable[])new Closeable[]{fis});
            return null;
        }
        CloseUtil.close((Closeable[])new Closeable[]{fis});
        return book;
    }

    public Book load(InputStream is) {
        try {
            return this.readBook(new KDSDataInputStream(is));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Book readBook(KDSDataInputStream is) throws IOException {
        byte[] sections = CtrlUtil.Stream.readInputStream((InputStream)is);
        Book book = Book.Manager.getNewBookWithProvider(this.getBookProvider(sections));
        return book;
    }

    private IBookProvider getBookProvider(byte[] sections) throws IOException {
        SectionJarInputStream sis = new SectionJarInputStream(sections);
        int version = sis.getFileVersion();
        if (version >= 20000) {
            return new KDSBinaryBook(sis, this._ctrl);
        }
        if (version < 10000) {
            return new KDSBinaryBook540(sis, this._ctrl);
        }
        return new KDSBinaryBook10(sis, this._ctrl);
    }
}

