/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.io.kml;

import com.kingdee.bos.ctrl.common.hyperlink.HyperLink;
import com.kingdee.bos.ctrl.excel.io.BookIOController;
import com.kingdee.bos.ctrl.excel.io.kml.AbsElement;
import com.kingdee.bos.ctrl.excel.io.kml.BasicElement;
import com.kingdee.bos.ctrl.excel.io.kml.CellDataElement;
import com.kingdee.bos.ctrl.excel.io.kml.CommentElement;
import com.kingdee.bos.ctrl.excel.io.kml.KingdeeDefinedElement;
import com.kingdee.bos.ctrl.excel.io.kml.KmlToBook;
import com.kingdee.bos.ctrl.excel.io.kml.KmlUtil;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.MergeBlocks;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.Span;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class CellElement
extends BasicElement {
    private AbsElement _cde;
    private AbsElement _kde;
    private AbsElement _cme;

    CellElement() {
    }

    @Override
    boolean isCurrentElement(String uri, String localName, String qName) {
        return "Cell".equals(KmlUtil.getLocalName(qName));
    }

    private AbsElement getFitParser(String uri, String localName, String qName) {
        String qqname = KmlUtil.getLocalName(qName);
        if ("Data".equals(qqname)) {
            if (this._cde == null) {
                this._cde = new CellDataElement();
            }
            return this._cde;
        }
        if ("KingdeeDefined".equals(qqname)) {
            if (this._kde == null) {
                this._kde = new KingdeeDefinedElement();
            }
            return this._kde;
        }
        if ("Comment".equals(qqname)) {
            if (this._cme == null) {
                this._cme = new CommentElement();
            }
            return this._cme;
        }
        return null;
    }

    @Override
    void startElement(String uri, String localName, String qName, Attributes attributes, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
        if (this.isCurrentElement(uri, localName, qName)) {
            BookIOController ctrl;
            String formula;
            int cellColIndex;
            Sheet sheet = dataCache.getCurSheet();
            Row row = sheet.getRow(Integer.parseInt(dataCache.getCurRowIndex()), true);
            String strCellColIndex = attributes.getValue(KmlUtil.getNSName("Index", NS_SHEET));
            if (strCellColIndex == null) {
                CellBlock mb;
                cellColIndex = dataCache.getDefaultCellIndex();
                MergeBlocks merge = sheet.getSheetOption().getMerger(false);
                CellBlock cellBlock = mb = merge == null ? null : merge.searchBlock(row.getRow(), cellColIndex);
                if (mb != null && (mb.getCol() != cellColIndex || mb.getRow() != row.getRow())) {
                    cellColIndex = mb.getCol2() + 1;
                }
            } else {
                cellColIndex = Integer.parseInt(strCellColIndex) - 1;
            }
            dataCache.setDefaultCellIndex(cellColIndex + 1);
            Cell cell = row.getCell(cellColIndex, true);
            String slink = attributes.getValue(KmlUtil.getNSName("HRef", NS_SHEET));
            if (slink != null) {
                HyperLink link = new HyperLink();
                link.setLinkTo(KmlUtil.toBookString(slink));
                cell.setHyperLink(link);
            }
            if (ktb.touchModeFlag(FLAG_STYLE)) {
                String styleID = attributes.getValue(KmlUtil.getNSName("StyleID", NS_SHEET));
                ShareStyleAttributes ssa = (ShareStyleAttributes)dataCache.getStyles().get(styleID);
                if (ssa != null) {
                    cell.setSSA(ssa);
                }
            }
            if (ktb.touchModeFlag(FLAG_FORMULA) && (formula = attributes.getValue(KmlUtil.getNSName("Formula", NS_SHEET))) != null) {
                cell.setFormula(formula);
            }
            dataCache.setCurCell(cell);
            dataCache.setCurUOParent(cell);
            int across = 0;
            String mergeAcross = attributes.getValue(KmlUtil.getNSName("MergeAcross", NS_SHEET));
            if (mergeAcross != null) {
                across = Integer.parseInt(mergeAcross);
            }
            if ((ctrl = ktb.getIOController()) != null && ctrl.isToClipboard()) {
                dataCache.setDefaultCellIndex(dataCache.getDefaultCellIndex() + across);
            }
            int down = 0;
            String mergeDown = attributes.getValue(KmlUtil.getNSName("MergeDown", NS_SHEET));
            if (mergeDown != null) {
                down = Integer.parseInt(mergeDown);
            }
            if (across > 0 || down > 0) {
                dataCache.getCurSheet().getSheetOption().getMerger(true).insert(CellBlock.getNewCellBlock(cell.getRow(), cellColIndex, cell.getRow() + down, cellColIndex + across));
                if (ktb.touchModeFlag(FLAG_STYLE)) {
                    String styleID = attributes.getValue(KmlUtil.getNSName("StyleID", NS_SHEET));
                    ShareStyleAttributes ssa = (ShareStyleAttributes)dataCache.getStyles().get(styleID);
                    if (ssa != null) {
                        Span spMaster = new Span(0, 0);
                        Span spMinor = new Span(0, 0);
                        sheet.getBorders().buildCellBorderFromSSA(cell.getRow(), cellColIndex, cell.getRow() + down, cellColIndex + across, spMaster, spMinor, ssa);
                    }
                }
            }
        } else {
            AbsElement parser = this.getFitParser(uri, localName, qName);
            if (parser != null) {
                parserCache.push(parser);
                parser.startElement(uri, localName, qName, attributes, parserCache, dataCache, ktb);
            }
        }
    }
}

