/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.io.kml;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.excel.io.kml.IKmlConstants;
import com.kingdee.bos.ctrl.excel.io.kml.KmlUtil;
import com.kingdee.bos.ctrl.kdf.util.style.LineStyle;
import com.kingdee.bos.ctrl.kdf.util.style.Pattern;
import com.kingdee.bos.ctrl.kdf.util.style.PenStyle;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleParser;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.xml.sax.Attributes;

public final class KmlStyleParser
implements IKmlConstants {
    private static final String[] kmlPatternNames = new String[]{null, "Solid", "Gray75", "Gray50", "Gray25", "Gray125", "Gray0625", "HorzStripe", "VertStripe", "ReverseDiagStripe", "DiagStripe", "DiagCross", "ThickDiagCross", "ThinHorzStripe", "ThinVertStripe", "ThinReverseDiagStripe", "ThinDiagStripe", "ThinHorzCross", "ThinDiagCross"};
    private static final String Continuous = "Continuous";
    private static final String Dot = "Dot";
    private static final String DashDotDot = "DashDotDot";
    private static final String DashDot = "DashDot";
    private static final String SlantDashDot = "SlantDashDot";
    private static final String Double = "Double";
    private static final String Dash = "Dash";
    private static final String Weight0 = "0";
    private static final String Weight1 = "1";
    private static final String Weight2 = "2";
    private static final String Weight3 = "3";
    private static final String DefaultStyleIDString = "Default";
    private static final String DefaultStyleID = "1";
    private static final String StyleIDPrefix = "s";
    private static final String KmlVeriAlignCenterValue = "Center";
    private static final String SaVeriAlignCenterValue = "Middle";
    private static final String KmlUnderlineValue = "Single";
    private static final String KmlUnderlineNoValue = "NoUnderline";

    public static String buildStyleID(ShareStyleAttributes ssa) {
        String styleID = String.valueOf(ssa.getUID());
        styleID = "1".equals(styleID) ? DefaultStyleIDString : StyleIDPrefix + styleID;
        return styleID;
    }

    static StyleAttributes createSA(Attributes attributes) {
        StyleAttributes sa = Styles.getEmptySA();
        String styleID = attributes.getValue(KmlUtil.getNSName("ID", NS_SHEET));
        styleID = DefaultStyleIDString.equals(styleID) ? "1" : styleID.substring(1);
        sa.setUID(Integer.parseInt(styleID));
        return sa;
    }

    static void parseBorder(StyleAttributes sa, Attributes attributes) {
        Styles.Position pos = Styles.Position.parse((String)attributes.getValue(KmlUtil.getNSName("Position", NS_SHEET)));
        String value = attributes.getValue(KmlUtil.getNSName("Color", NS_SHEET));
        if (value != null) {
            sa.setBorderColor(pos, StyleParser.stringToColor((String)value));
        }
        if ((value = attributes.getValue(KmlUtil.getNSName("LineStyle", NS_SHEET))) != null) {
            KmlStyleParser.parseBorderStyle(sa, pos, value, attributes.getValue(KmlUtil.getNSName("Weight", NS_SHEET)));
        }
    }

    static void parseNumberFormat(StyleAttributes sa, Attributes attributes) {
        String value = attributes.getValue(KmlUtil.getNSName("Format", NS_SHEET));
        if (!StringUtil.isEmptyString((String)value)) {
            if ("Short Date".equals(value = KmlUtil.toBookString(value))) {
                sa.setNumberFormat("yyyy.m.d");
            } else if ("Long Date".equals(value)) {
                sa.setNumberFormat("yyyy\"\u5e74\"m\"\u6708\"d\"\u65e5\"");
            } else if ("Long Time".equals(value)) {
                sa.setNumberFormat("h:mm:ss AM/PM");
            } else if ("Short Time".equals(value)) {
                sa.setNumberFormat("h:mm");
            } else if ("Scientific".equals(value)) {
                sa.setNumberFormat("0.00E+00");
            } else if ("Percent".equals(value)) {
                sa.setNumberFormat("0.00%");
            } else if ("Standard".equals(value)) {
                sa.setNumberFormat("#,##0.00");
            } else {
                sa.setNumberFormat(value);
            }
        }
    }

    static void parseAlignment(StyleAttributes sa, Attributes attributes) {
        String value = attributes.getValue(KmlUtil.getNSName("Rotate", NS_SHEET));
        if (value != null) {
            sa.setRotation(Integer.parseInt(value));
        }
        if ((value = attributes.getValue(KmlUtil.getNSName("Horizontal", NS_SHEET))) != null) {
            sa.setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)value));
        }
        if ((value = attributes.getValue(KmlUtil.getNSName("Vertical", NS_SHEET))) != null) {
            if (value.equals(KmlVeriAlignCenterValue)) {
                value = SaVeriAlignCenterValue;
            }
            sa.setVerticalAlign(Styles.VerticalAlignment.getAlignment((String)value));
        }
        if ((value = attributes.getValue(KmlUtil.getNSName("WrapText", NS_SHEET))) != null) {
            sa.setWrapText(KmlStyleParser.getSaBooleanAttribute(value));
        }
        if ((value = attributes.getValue(KmlUtil.getNSName("ShrinkToFit", NS_SHEET))) != null) {
            sa.setShrinkText(KmlStyleParser.getSaBooleanAttribute(value));
        }
    }

    static void parseProtection(StyleAttributes sa, Attributes attributes) {
        String value = attributes.getValue(KmlUtil.getNSName("Protected", NS_SHEET));
        if (value != null) {
            sa.setLocked(KmlStyleParser.getSaBooleanAttribute(value));
        } else {
            sa.setLocked(false);
        }
        value = attributes.getValue(KmlUtil.getNSName("HideFormula", NS_SHEET));
        if (value != null) {
            sa.setHided(KmlStyleParser.getSaBooleanAttribute(value));
        }
    }

    static void parseFont(StyleAttributes sa, Attributes attributes) {
        String value = attributes.getValue(KmlUtil.getNSName("FontName", NS_SHEET));
        if (value != null) {
            sa.setFontName(value);
        }
        if ((value = attributes.getValue(KmlUtil.getNSName("Size", NS_SHEET))) != null) {
            sa.setFontSize((int)Float.parseFloat(value));
        }
        if ((value = attributes.getValue(KmlUtil.getNSName("Color", NS_SHEET))) != null) {
            sa.setFontColor(StyleParser.stringToColor((String)value));
        }
        if ((value = attributes.getValue(KmlUtil.getNSName("Bold", NS_SHEET))) != null) {
            sa.setBold(KmlStyleParser.getSaBooleanAttribute(value));
        }
        if ((value = attributes.getValue(KmlUtil.getNSName("Italic", NS_SHEET))) != null) {
            sa.setItalic(KmlStyleParser.getSaBooleanAttribute(value));
        }
        if ((value = attributes.getValue(KmlUtil.getNSName("StrikeThrough", NS_SHEET))) != null) {
            sa.setStrikeThrough(KmlStyleParser.getSaBooleanAttribute(value));
        }
        if ((value = attributes.getValue(KmlUtil.getNSName("Underline2", NS_SHEET))) != null) {
            if (value.equals(KmlUnderlineValue)) {
                sa.setUnderline(true);
            }
        } else {
            value = attributes.getValue(KmlUtil.getNSName("Underline", NS_SHEET));
            if (value != null && !value.equals(KmlUnderlineNoValue)) {
                sa.setUnderline(true);
            }
        }
    }

    static void parseInterior(StyleAttributes sa, Attributes attributes) {
        String value = attributes.getValue(KmlUtil.getNSName("Color", NS_SHEET));
        if (value != null) {
            sa.setBackground(StyleParser.stringToColor((String)value));
        }
        if ((value = attributes.getValue(KmlUtil.getNSName("Pattern", NS_SHEET))) != null) {
            sa.setPattern(KmlStyleParser.parsePattern(value));
        }
        if ((value = attributes.getValue(KmlUtil.getNSName("PatternColor", NS_SHEET))) != null) {
            sa.setPatternColor(StyleParser.stringToColor((String)value));
        }
    }

    private static Pattern parsePattern(String kmlPatternName) {
        Pattern p = kmlPatternNames[1].equals(kmlPatternName) ? Pattern.getPattern((int)1) : (kmlPatternNames[2].equals(kmlPatternName) ? Pattern.getPattern((int)3) : (kmlPatternNames[3].equals(kmlPatternName) ? Pattern.getPattern((int)19) : (kmlPatternNames[4].equals(kmlPatternName) ? Pattern.getPattern((int)26) : (kmlPatternNames[5].equals(kmlPatternName) ? Pattern.getPattern((int)35) : (kmlPatternNames[6].equals(kmlPatternName) ? Pattern.getPattern((int)43) : (kmlPatternNames[7].equals(kmlPatternName) ? Pattern.getPattern((int)45) : (kmlPatternNames[8].equals(kmlPatternName) ? Pattern.getPattern((int)37) : (kmlPatternNames[9].equals(kmlPatternName) ? Pattern.getPattern((int)20) : (kmlPatternNames[10].equals(kmlPatternName) ? Pattern.getPattern((int)28) : (kmlPatternNames[11].equals(kmlPatternName) ? Pattern.getPattern((int)34) : (kmlPatternNames[12].equals(kmlPatternName) ? Pattern.getPattern((int)40) : (kmlPatternNames[13].equals(kmlPatternName) ? Pattern.getPattern((int)13) : (kmlPatternNames[14].equals(kmlPatternName) ? Pattern.getPattern((int)5) : (kmlPatternNames[15].equals(kmlPatternName) ? Pattern.getPattern((int)4) : (kmlPatternNames[16].equals(kmlPatternName) ? Pattern.getPattern((int)12) : (kmlPatternNames[17].equals(kmlPatternName) ? Pattern.getPattern((int)9) : (kmlPatternNames[18].equals(kmlPatternName) ? Pattern.getPattern((int)41) : Pattern.getPattern((int)0))))))))))))))))));
        return p;
    }

    private static void parseBorderStyle(StyleAttributes sa, Styles.Position pos, String lineStyle, String weight) {
        if (Continuous.equals(lineStyle)) {
            if ("1".equals(weight)) {
                sa.setBorderLineStyle(pos, LineStyle.SINGLE_LINE);
                sa.setBorderPenStyle(pos, PenStyle.PS_SOLID);
            } else if (Weight2.equals(weight)) {
                sa.setBorderLineStyle(pos, LineStyle.DOUBLE_LINE_A);
                sa.setBorderPenStyle(pos, PenStyle.PS_SOLID);
            } else if (Weight3.equals(weight)) {
                sa.setBorderLineStyle(pos, LineStyle.TRIGRAM_SOLID_LINE);
                sa.setBorderPenStyle(pos, PenStyle.PS_SOLID);
            } else {
                sa.setBorderLineStyle(pos, LineStyle.SINGLE_LINE);
                sa.setBorderPenStyle(pos, PenStyle.PS_CONTINUOUS);
            }
        } else if (Dot.equals(lineStyle)) {
            if ("1".equals(weight)) {
                sa.setBorderLineStyle(pos, LineStyle.SINGLE_LINE);
                sa.setBorderPenStyle(pos, PenStyle.PS_DOT);
            }
        } else if (DashDotDot.equals(lineStyle)) {
            if ("1".equals(weight)) {
                sa.setBorderLineStyle(pos, LineStyle.SINGLE_LINE);
                sa.setBorderPenStyle(pos, PenStyle.PS_DASHDOTDOT);
            } else if (Weight2.equals(weight)) {
                sa.setBorderLineStyle(pos, LineStyle.SINGLE_LINE);
                sa.setBorderPenStyle(pos, PenStyle.PS_DASHDOTDOT);
            }
        } else if (DashDot.equals(lineStyle)) {
            if ("1".equals(weight)) {
                sa.setBorderLineStyle(pos, LineStyle.SINGLE_LINE);
                sa.setBorderPenStyle(pos, PenStyle.PS_DASHDOT);
            } else if (Weight2.equals(weight)) {
                sa.setBorderLineStyle(pos, LineStyle.DOUBLE_LINE_A);
                sa.setBorderPenStyle(pos, PenStyle.PS_DASHDOT);
            }
        } else if (SlantDashDot.equals(lineStyle)) {
            if (Weight2.equals(weight)) {
                sa.setBorderLineStyle(pos, LineStyle.DOUBLE_LINE_A);
                sa.setBorderPenStyle(pos, PenStyle.PS_DASHDOT);
            }
        } else if (Dash.equals(lineStyle)) {
            if ("1".equals(weight)) {
                sa.setBorderLineStyle(pos, LineStyle.SINGLE_LINE);
                sa.setBorderPenStyle(pos, PenStyle.PS_DASH);
            } else if (Weight2.equals(weight)) {
                sa.setBorderLineStyle(pos, LineStyle.DOUBLE_LINE_A);
                sa.setBorderPenStyle(pos, PenStyle.PS_DASH);
            }
        } else if (Double.equals(lineStyle) && Weight3.equals(weight)) {
            sa.setBorderLineStyle(pos, LineStyle.TRIGRAM_HOLLOW_LINE);
            sa.setBorderPenStyle(pos, PenStyle.PS_SOLID);
        }
    }

    static void buildStylesElement(Element stylesElement, Iterator iterStyles) {
        HashMap customPenStyles = new HashMap();
        while (iterStyles.hasNext()) {
            Map.Entry e = (Map.Entry)iterStyles.next();
            ShareStyleAttributes ssa = (ShareStyleAttributes)e.getValue();
            Element styleElement = KmlStyleParser.buildStyleElement(ssa);
            stylesElement.addContent((Content)styleElement);
            if (!ssa.hasBordersAttributes()) continue;
            KmlStyleParser.getCustomPenStyle(customPenStyles, ssa, Styles.Position.LEFT);
            KmlStyleParser.getCustomPenStyle(customPenStyles, ssa, Styles.Position.TOP);
            KmlStyleParser.getCustomPenStyle(customPenStyles, ssa, Styles.Position.RIGHT);
            KmlStyleParser.getCustomPenStyle(customPenStyles, ssa, Styles.Position.BOTTOM);
            KmlStyleParser.getCustomPenStyle(customPenStyles, ssa, Styles.Position.DIAGONALLEFT);
            KmlStyleParser.getCustomPenStyle(customPenStyles, ssa, Styles.Position.DIAGONALRIGHT);
        }
        KmlStyleParser.writeCustomPenStyle(stylesElement, customPenStyles, NS_SHEET);
    }

    private static void writeCustomPenStyle(Element eleStyles, HashMap customPenStyles, Namespace ns) {
        Iterator i = customPenStyles.entrySet().iterator();
        if (!i.hasNext()) {
            return;
        }
        Element penStyles = new Element("PenStyles", ns);
        eleStyles.addContent((Content)penStyles);
        while (i.hasNext()) {
            Map.Entry e = i.next();
            PenStyle ps = (PenStyle)e.getValue();
            Element penStyle = new Element("PenStyle", ns);
            penStyle.setAttribute("name", ps.getName());
            penStyle.setAttribute("dash", ps.getDashString());
            penStyles.addContent((Content)penStyle);
        }
    }

    private static void getCustomPenStyle(HashMap customPenStyles, ShareStyleAttributes ssa, Styles.Position pos) {
        PenStyle ps = ssa.getBorderPenStyle(pos);
        if (ps != null && !ps.isSystem()) {
            customPenStyles.put(ps.getName(), ps);
        }
    }

    private static Element buildStyleElement(ShareStyleAttributes ssa) {
        Element styleElement = new Element("Style");
        String styleID = KmlStyleParser.buildStyleID(ssa);
        styleElement.setAttribute("ID", styleID, NS_SHEET);
        KmlStyleParser.buildAlignmentElement(ssa, styleElement);
        KmlStyleParser.buildBordersElement(ssa, styleElement);
        KmlStyleParser.buildFontElement(ssa, styleElement);
        KmlStyleParser.buildInteriorElement(ssa, styleElement);
        KmlStyleParser.buildNumberFormatElement(ssa, styleElement);
        KmlStyleParser.buildProtectionElement(ssa, styleElement);
        return styleElement;
    }

    private static void buildNumberFormatElement(ShareStyleAttributes ssa, Element styleElement) {
        String nf;
        if (ssa.hasAttributes(ShareStyleAttributes.NUMBER_FORMAT) && !StringUtil.isEmptyString((String)(nf = ssa.getNumberFormat()))) {
            nf = nf.replace("!", "\\");
            Element nfElement = new Element("NumberFormat");
            styleElement.addContent((Content)nfElement);
            nfElement.setAttribute("Format", nf, NS_SHEET);
        }
    }

    private static void buildFontElement(ShareStyleAttributes ssa, Element styleElement) {
        if (ssa.hasFontAttributes()) {
            Element fontElement = new Element("Font");
            StyleAttributes attributes = Styles.getSA((ShareStyleAttributes)ssa);
            if (StringUtil.isEmptyString((String)ssa.getFontName())) {
                attributes.setFontName(Styles.getDefaultSSA().getFontName());
            }
            if (ssa.getFontSize() == 0) {
                attributes.setFontSize(12);
            }
            ssa = attributes;
            boolean b = KmlStyleParser.setKmlStyleAttribute(ssa, ShareStyleAttributes.FONT_NAME, "FontName", fontElement, NS_SHEET);
            b |= KmlStyleParser.setKmlStyleAttribute(ssa, ShareStyleAttributes.FONT_SIZE, "Size", fontElement, NS_SHEET);
            fontElement.setAttribute("CharSet", "134", NS_EXCEL);
            KmlStyleParser.setKmlStyleAttribute(ssa, ShareStyleAttributes.FONT_SIZE, "Size", fontElement, NS_SHEET);
            b |= KmlStyleParser.setKmlStyleColorAttribute(ssa, ShareStyleAttributes.FONT_COLOR, "Color", fontElement, NS_SHEET);
            b |= KmlStyleParser.setKmlStyleBooleanAttribute(ssa, ShareStyleAttributes.FONT_BOLD, "Bold", fontElement, NS_SHEET);
            if (ssa.hasAttributes(ShareStyleAttributes.FONT_UNDERLINE)) {
                b = true;
                if (ssa.isUnderline()) {
                    fontElement.setAttribute("Underline", KmlUnderlineValue, NS_SHEET);
                    fontElement.setAttribute("Underline2", KmlUnderlineValue, NS_SHEET);
                } else {
                    fontElement.setAttribute("Underline2", KmlUnderlineNoValue, NS_SHEET);
                }
            }
            b |= KmlStyleParser.setKmlStyleBooleanAttribute(ssa, ShareStyleAttributes.FONT_ITALIC, "Italic", fontElement, NS_SHEET);
            if (b |= KmlStyleParser.setKmlStyleBooleanAttribute(ssa, ShareStyleAttributes.FONT_STRIKETHROUGH, "StrikeThrough", fontElement, NS_SHEET)) {
                styleElement.addContent((Content)fontElement);
            }
        }
    }

    private static void buildBordersElement(ShareStyleAttributes ssa, Element styleElement) {
        if (ssa.hasBordersAttributes()) {
            Element bordersElement = new Element("Borders");
            boolean b = false;
            b = KmlStyleParser.buildBorderElement(ssa, Styles.Position.LEFT, bordersElement);
            b |= KmlStyleParser.buildBorderElement(ssa, Styles.Position.TOP, bordersElement);
            b |= KmlStyleParser.buildBorderElement(ssa, Styles.Position.RIGHT, bordersElement);
            b |= KmlStyleParser.buildBorderElement(ssa, Styles.Position.BOTTOM, bordersElement);
            b |= KmlStyleParser.buildBorderElement(ssa, Styles.Position.DIAGONALLEFT, bordersElement);
            if (b |= KmlStyleParser.buildBorderElement(ssa, Styles.Position.DIAGONALRIGHT, bordersElement)) {
                styleElement.addContent((Content)bordersElement);
            }
        }
    }

    private static boolean buildBorderElement(ShareStyleAttributes ssa, Styles.Position pos, Element bordersElement) {
        LineStyle lineStyle;
        if (ssa.hasBorderAttributes(pos) && (lineStyle = ssa.getBorderLineStyle(pos)) != null && lineStyle != LineStyle.NULL_LINE) {
            Element borderElement = new Element("Border");
            PenStyle penStyle = ssa.getBorderPenStyle(pos);
            if (penStyle == null) {
                penStyle = Styles.getDefaultSSA().getBorderPenStyle(pos);
            }
            KmlBorder kmlBorder = KmlStyleParser.toKmlBorder(lineStyle, penStyle);
            borderElement.setAttribute("Position", KmlStyleParser.firstCharToUpper(pos.getName()), NS_SHEET);
            borderElement.setAttribute("LineStyle", kmlBorder.getLineStyle(), NS_SHEET);
            KmlStyleParser.setKmlStyleColorAttribute(ssa, ShareStyleAttributes.getBorderColorIndex((Styles.Position)pos), "Color", borderElement, NS_SHEET);
            if (!Weight0.equals(kmlBorder.getWeight())) {
                borderElement.setAttribute("Weight", kmlBorder.getWeight(), NS_SHEET);
            }
            bordersElement.addContent((Content)borderElement);
            return true;
        }
        return false;
    }

    private static void buildInteriorElement(ShareStyleAttributes ssa, Element styleElement) {
        if (ssa.hasInteriorAttributes()) {
            Element interiorElement = new Element("Interior");
            Pattern pa = ssa.getPattern();
            if (!Pattern.None.equals(pa)) {
                String pattern;
                if (pa == null) {
                    pa = Pattern.Solid;
                }
                if ((pattern = KmlStyleParser.toKmlPatternName(pa)) != null) {
                    interiorElement.setAttribute("Pattern", pattern, NS_SHEET);
                    KmlStyleParser.setKmlStyleColorAttribute(ssa, ShareStyleAttributes.BACKGROUND_COLOR, "Color", interiorElement, NS_SHEET);
                    KmlStyleParser.setKmlStyleColorAttribute(ssa, ShareStyleAttributes.PATTERN_COLOR, "PatternColor", interiorElement, NS_SHEET);
                    styleElement.addContent((Content)interiorElement);
                }
            }
        }
    }

    private static void buildAlignmentElement(ShareStyleAttributes ssa, Element styleElement) {
        if (ssa.hasAlignmentAttributes()) {
            Element alignElement = new Element("Alignment");
            boolean b = false;
            if (ssa.hasAttributes(ShareStyleAttributes.VERTICAL_ALIGN)) {
                b |= true;
                Styles.VerticalAlignment va = ssa.getVerticalAlign();
                String strVa = KmlVeriAlignCenterValue;
                strVa = Styles.VerticalAlignment.MIDDLE.equals(va) ? KmlVeriAlignCenterValue : KmlStyleParser.firstCharToUpper(va.toString());
                alignElement.setAttribute("Vertical", strVa, NS_SHEET);
            }
            if (ssa.hasAttributes(ShareStyleAttributes.HORIZONTAL_ALIGN)) {
                b |= true;
                if (ssa.getHorizontalAlign().getValue() != 0) {
                    alignElement.setAttribute("Horizontal", KmlStyleParser.firstCharToUpper(ssa.getHorizontalAlign().toString()), NS_SHEET);
                }
            }
            b |= KmlStyleParser.setKmlStyleBooleanAttribute(ssa, ShareStyleAttributes.WRAP_TEXT, "WrapText", alignElement, NS_SHEET);
            if (ssa.hasAttributes(StyleAttributes.ROTATION)) {
                b |= true;
                alignElement.setAttribute("Rotate", ssa.get(ShareStyleAttributes.ROTATION).toString(), NS_SHEET);
            }
            if (b |= KmlStyleParser.setKmlStyleBooleanAttribute(ssa, ShareStyleAttributes.SHRINK_TEXT, "ShrinkToFit", alignElement, NS_SHEET)) {
                styleElement.addContent((Content)alignElement);
            }
        }
    }

    private static void buildProtectionElement(ShareStyleAttributes ssa, Element styleElement) {
        if (ssa.hasProtectionAttributes()) {
            Element e = new Element("Protection");
            boolean b = false;
            b |= KmlStyleParser.setKmlStyleBooleanAttribute(ssa, ShareStyleAttributes.PROTECTION_HIDDED, "HideFormula", e, NS_EXCEL);
            if (b |= KmlStyleParser.setKmlStyleBooleanAttribute(ssa, ShareStyleAttributes.PROTECTION_LOCKED, "Protected", e, NS_SHEET)) {
                styleElement.addContent((Content)e);
            }
        }
    }

    private static String firstCharToUpper(String str) {
        if (str.length() > 1) {
            return (char)(str.charAt(0) - 32) + str.substring(1);
        }
        return str;
    }

    private static boolean getSaBooleanAttribute(String str) {
        return "1".equals(str);
    }

    private static boolean setKmlStyleAttribute(ShareStyleAttributes ssa, int index, String attriName, Element element, Namespace ns) {
        return KmlStyleParser.setKmlStyleAttribute(ssa, index, attriName, null, element, ns);
    }

    private static boolean setKmlStyleAttribute(ShareStyleAttributes ssa, int index, String attriName, Object def, Element element, Namespace ns) {
        boolean b = ssa.hasAttributes(index);
        if (b) {
            Object obj = ssa.get(index);
            element.setAttribute(attriName, obj.toString(), ns);
        } else if (null != def) {
            element.setAttribute(attriName, def.toString(), ns);
        }
        return b;
    }

    private static boolean setKmlStyleBooleanAttribute(ShareStyleAttributes ssa, int index, String attriName, Element element, Namespace ns) {
        if (ssa.hasAttributes(index)) {
            Object obj = ssa.get(index);
            if (Boolean.TRUE.equals(obj)) {
                element.setAttribute(attriName, Boolean.TRUE.equals(obj) ? "1" : Weight0, ns);
            }
            return true;
        }
        return false;
    }

    private static boolean setKmlStyleColorAttribute(ShareStyleAttributes ssa, int index, String attriName, Element element, Namespace ns) {
        boolean b = ssa.hasAttributes(index);
        if (b) {
            Color color = (Color)ssa.get(index);
            if (color.getAlpha() != 255) {
                color = new Color(color.getRed(), color.getGreen(), color.getBlue());
            }
            element.setAttribute(attriName, StyleParser.colorToHex((Color)color), ns);
        }
        return b;
    }

    private static String toKmlPatternName(Pattern p) {
        String n;
        int id = p.getID();
        switch (id) {
            default: {
                n = kmlPatternNames[0];
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 14: 
            case 15: 
            case 22: 
            case 23: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 39: 
            case 42: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                n = kmlPatternNames[1];
                break;
            }
            case 3: {
                n = kmlPatternNames[2];
                break;
            }
            case 19: {
                n = kmlPatternNames[3];
                break;
            }
            case 18: 
            case 26: 
            case 27: {
                n = kmlPatternNames[4];
                break;
            }
            case 24: 
            case 35: 
            case 38: {
                n = kmlPatternNames[5];
                break;
            }
            case 2: 
            case 10: 
            case 43: 
            case 44: {
                n = kmlPatternNames[6];
                break;
            }
            case 45: {
                n = kmlPatternNames[7];
                break;
            }
            case 21: 
            case 37: {
                n = kmlPatternNames[8];
                break;
            }
            case 20: 
            case 36: {
                n = kmlPatternNames[9];
                break;
            }
            case 28: {
                n = kmlPatternNames[10];
                break;
            }
            case 34: {
                n = kmlPatternNames[11];
                break;
            }
            case 11: 
            case 25: 
            case 40: {
                n = kmlPatternNames[12];
                break;
            }
            case 13: 
            case 29: {
                n = kmlPatternNames[13];
                break;
            }
            case 5: {
                n = kmlPatternNames[14];
                break;
            }
            case 4: {
                n = kmlPatternNames[15];
                break;
            }
            case 12: {
                n = kmlPatternNames[16];
                break;
            }
            case 6: 
            case 9: 
            case 16: 
            case 17: {
                n = kmlPatternNames[17];
                break;
            }
            case 41: {
                n = kmlPatternNames[18];
            }
        }
        return n;
    }

    private static KmlBorder toKmlBorder(LineStyle lineStyle, PenStyle penStyle) {
        String weight = "1";
        String strLineStyle = Continuous;
        if (PenStyle.PS_SOLID.equals(penStyle)) {
            int w = lineStyle.getWidth();
            if (w >= 3) {
                weight = Weight3;
                if (!lineStyle.isFillCenterLine()) {
                    strLineStyle = Double;
                }
            } else if (w == 2) {
                weight = Weight2;
            }
        } else if (PenStyle.PS_CONTINUOUS.equals(penStyle)) {
            if (lineStyle.getWidth() == 1) {
                weight = Weight0;
            }
        } else if (PenStyle.PS_DOT.equals(penStyle)) {
            strLineStyle = Dot;
        } else if (PenStyle.PS_DASHDOTDOT.equals(penStyle)) {
            strLineStyle = DashDotDot;
            if (lineStyle.getWidth() >= 2) {
                weight = Weight2;
            }
        } else if (PenStyle.PS_DASHDOT.equals(penStyle)) {
            strLineStyle = DashDot;
            if (lineStyle.getWidth() >= 2) {
                weight = Weight2;
            }
        } else if (PenStyle.PS_DASH.equals(penStyle)) {
            strLineStyle = Dash;
            if (lineStyle.getWidth() >= 2) {
                weight = Weight2;
            }
        }
        KmlBorder kmlBorder = new KmlBorder();
        kmlBorder.setLineStyle(strLineStyle);
        kmlBorder.setWeight(weight);
        return kmlBorder;
    }

    private static class KmlBorder {
        private String _lineStyle;
        private String _weight;

        private KmlBorder() {
        }

        void setLineStyle(String lineStyle) {
            this._lineStyle = lineStyle;
        }

        String getLineStyle() {
            return this._lineStyle;
        }

        void setWeight(String weight) {
            this._weight = weight;
        }

        String getWeight() {
            return this._weight;
        }
    }
}

