/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.model.expr;

import com.kingdee.bos.ctrl.common.digitalstyle.Formats;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.impl.facade.MultiLanguageKeys;
import com.kingdee.bos.ctrl.excel.model.expr.ExprConst;
import com.kingdee.bos.ctrl.excel.model.expr.ExprContext;
import com.kingdee.bos.ctrl.excel.model.expr.ExprExpressionMark;
import com.kingdee.bos.ctrl.excel.model.expr.ExprExpressionParam;
import com.kingdee.bos.ctrl.excel.model.expr.ExprOperator;
import com.kingdee.bos.ctrl.excel.model.expr.ExprOps;
import com.kingdee.bos.ctrl.excel.model.expr.ExprParamPos;
import com.kingdee.bos.ctrl.excel.model.expr.IExprNode;
import com.kingdee.bos.ctrl.excel.model.struct.Dependents;
import com.kingdee.bos.ctrl.excel.model.struct.ICalculable;
import com.kingdee.bos.ctrl.excel.model.struct.node.CellBlockNode;
import com.kingdee.bos.ctrl.excel.model.struct.node.NamedObjectNode;
import com.kingdee.bos.ctrl.excel.model.util.ObjectArray;
import com.kingdee.bos.ctrl.excel.model.util.ObjectStack;
import java.util.Calendar;
import java.util.Date;

public class Expr
implements Cloneable {
    private ExprOps _ops;
    private IExprNode[] _params;
    private int _nodesState;

    public static Expr getExpr(IExprNode[] nodes, int nodesState, int start, int end) {
        boolean hasParam = (nodesState & 0x1000E) != 0;
        ObjectArray aOps = new ObjectArray();
        ObjectArray aParams = hasParam ? new ObjectArray() : null;
        int param = 0;
        block4: for (int i = start; i < end; ++i) {
            IExprNode node = nodes[i];
            switch (node.getExprType()) {
                case 2: 
                case 4: 
                case 8: {
                    if (aParams != null) {
                        aParams.append((Object)node);
                    }
                    aOps.append((Object)ExprParamPos.getExprParamPos(param++));
                    continue block4;
                }
                case 65536: {
                    ExprExpressionMark mark = (ExprExpressionMark)node;
                    int count = mark.getCount();
                    Expr sub = Expr.getExpr(nodes, mark.getNodesState(), i + 1, i + 1 + count);
                    if (aParams != null) {
                        aParams.append((Object)new ExprExpressionParam(sub));
                    }
                    aOps.append((Object)ExprParamPos.getExprParamPos(param++));
                    i += count;
                    continue block4;
                }
                default: {
                    aOps.append((Object)node);
                }
            }
        }
        Object[] ops = new IExprNode[aOps.size()];
        aOps.toArray(ops, 0);
        ExprOps eo = ExprOps.getExprOps((IExprNode[])ops);
        Object[] params = null;
        if (aParams != null) {
            params = new IExprNode[aParams.size()];
            aParams.toArray(params, 0);
        }
        return new Expr(eo, (IExprNode[])params, nodesState);
    }

    private Expr(ExprOps ops, IExprNode[] params, int nodesState) {
        this._ops = ops;
        this._params = params;
        this._nodesState = nodesState;
    }

    public Expr getCopy() {
        return (Expr)this.clone();
    }

    public Object clone() {
        Expr newExpr;
        try {
            newExpr = (Expr)super.clone();
            if (this._params != null) {
                newExpr._params = new IExprNode[this._params.length];
                IExprNode[] nodes = newExpr._params;
                System.arraycopy(this._params, 0, nodes, 0, this._params.length);
                if (this.hasExpParam()) {
                    for (int i = 0; i < nodes.length; ++i) {
                        IExprNode node = nodes[i];
                        if (node.getExprType() != 65536) continue;
                        Expr newSub = (Expr)((ExprExpressionParam)node).getExpr().clone();
                        nodes[i] = new ExprExpressionParam(newSub);
                    }
                }
            }
        }
        catch (CloneNotSupportedException e) {
            newExpr = null;
        }
        return newExpr;
    }

    public String toString() {
        return "Expr " + this._ops.getNodes()[0];
    }

    public int getExprNodeState() {
        return this._nodesState;
    }

    private boolean touchState(int state) {
        return (this._nodesState & state) != 0;
    }

    public boolean isSyntaxError() {
        return this.touchState(1);
    }

    public boolean isNeedContext() {
        return this.touchState(16384);
    }

    public boolean isExtensible() {
        return this.touchState(4096);
    }

    public boolean isNamedObject() {
        return this._ops.getNodes().length == 1 && this._params != null && this._params[0] instanceof NamedObjectNode;
    }

    public boolean isSingleCellBlock() {
        return this._ops.getNodes().length == 1 && this._params != null && this._params[0] instanceof CellBlockNode;
    }

    public boolean isSingleCell() {
        if (this.isSingleCellBlock()) {
            CellBlockNode cb = (CellBlockNode)this._params[0];
            return cb.isSingleCell();
        }
        return false;
    }

    public boolean hasMethod() {
        return this.touchState(1408);
    }

    public boolean hasExternMethod() {
        return this.touchState(1152);
    }

    public boolean hasExcelMethod() {
        return this.touchState(512);
    }

    public boolean hasSubTotalMethod() {
        return this.touchState(2048);
    }

    public boolean hasAbsMethod() {
        return this.touchState(262144);
    }

    public boolean hasUnknownMethod() {
        return this.touchState(1024);
    }

    public boolean hasCellBlock() {
        return this.touchState(4);
    }

    public boolean hasExpParam() {
        return this.touchState(65536);
    }

    public ExprOps getExprOps() {
        return this._ops;
    }

    public IExprNode[] getAllNodesClone() {
        ObjectArray al = new ObjectArray(this._ops.getNodes().length + (this._params == null ? 0 : this._params.length));
        this.addAllNodes(al);
        Object[] nodes = new IExprNode[al.size()];
        al.toArray(nodes, 0);
        return nodes;
    }

    public IExprNode[] getNodes() {
        return this.getAllNodesClone();
    }

    private void addAllNodes(ObjectArray al) {
        IExprNode[] ops = this._ops.getNodes();
        for (int i = 0; i < ops.length; ++i) {
            IExprNode node = ops[i];
            if (node.getExprType() == 131072 && this._params != null) {
                if ((node = this._params[((ExprParamPos)node).getPos()]).getExprType() == 65536) {
                    ((ExprExpressionParam)node).getExpr().addAllNodes(al);
                    continue;
                }
                al.append((Object)node);
                continue;
            }
            al.append((Object)node);
        }
    }

    public int getExprOps(ObjectArray array) {
        int count = 1;
        array.append((Object)this._ops);
        if (this.hasExpParam()) {
            for (int i = 0; i < this._params.length; ++i) {
                IExprNode node = this._params[i];
                if (node.getExprType() != 65536) continue;
                ExprExpressionParam ep = (ExprExpressionParam)node;
                count += ep.getExpr().getExprOps(array);
            }
        }
        return count;
    }

    public IExprNode[] getParameters() {
        return this._params;
    }

    public int getParameters(ObjectArray array, boolean allParam) {
        int count = 0;
        if (this._params != null && (allParam || this.hasCellBlock())) {
            array.append((Object)this);
            ++count;
        }
        if (this.hasExpParam()) {
            IExprNode[] nodes = this._params;
            for (int i = 0; i < nodes.length; ++i) {
                IExprNode node = nodes[i];
                if (node.getExprType() != 65536) continue;
                ExprExpressionParam ep = (ExprExpressionParam)node;
                count += ep.getExpr().getParameters(array, allParam);
            }
        }
        return count;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Expr) {
            Expr cmpExpr = (Expr)obj;
            if (this._ops != cmpExpr._ops) {
                return false;
            }
            if (this._params != null) {
                IExprNode[] a = this._params;
                IExprNode[] a2 = cmpExpr._params;
                for (int i = a.length - 1; i >= 0; --i) {
                    if (a[i].equals(a2[i])) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public Variant execute(ExprContext ctx, ICalculable exprOwner) {
        Variant ret;
        IExprNode[] ops = this._ops.getNodes();
        if (ops == null || ops.length == 0) {
            return Variant.nullVariant;
        }
        if (exprOwner == null) {
            exprOwner = ctx.getExprOwner();
        }
        int ownerStackSize = 0;
        ExprContext sheetCtx = null;
        if (this.isNeedContext()) {
            sheetCtx = exprOwner.getSheet().getExprContextNode();
            ownerStackSize = sheetCtx.getOwnerStackSize();
        }
        ObjectStack stack = ctx.getStack();
        ObjectStack oldStack = ctx.setCurrentExprStack(stack);
        try {
            if (exprOwner == null) {
                exprOwner = ctx.getExprOwner();
            }
            for (int i = 0; i < ops.length; ++i) {
                IExprNode node = ops[i];
                if (node.getExprType() == 131072) {
                    int paramPos = ((ExprParamPos)node).getPos();
                    this._params[paramPos].action(ctx, exprOwner);
                    continue;
                }
                node.action(ctx, exprOwner);
            }
            ret = ((Variant)stack.pop()).getVariant();
        }
        catch (SyntaxErrorException e) {
            if (sheetCtx != null) {
                sheetCtx.popExprOwnerN(sheetCtx.getOwnerStackSize() - ownerStackSize);
            }
            stack.clear();
            if (e.getErrorCode() == 64L) {
                e.setExtData((Object)(MultiLanguageKeys.getLocalText("ValueIncorrect", "\u516c\u5f0f\u4e2d\u6240\u7528\u7684\u67d0\u4e2a\u503c\u662f\u9519\u8bef\u7684\u6570\u636e\u7c7b\u578b\u3002") + "(" + (String)e.getExtData() + ")"));
            }
            ret = new Variant((Object)e, 16);
        }
        catch (Exception e) {
            if (sheetCtx != null) {
                sheetCtx.popExprOwnerN(sheetCtx.getOwnerStackSize() - ownerStackSize);
            }
            stack.clear();
            ret = new Variant((Object)e, 16);
        }
        ctx.setCurrentExprStack(oldStack);
        ctx.recycleStack(stack);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectArray getDecodeList(ExprContext ctx) {
        ObjectArray current;
        ctx.getDeps();
        Dependents.lock.lock();
        try {
            int i;
            ObjectStack stack = ctx.getStack();
            ObjectStack parameters = ctx.getStack();
            IExprNode[] ops = this._ops.getNodes();
            for (i = 0; i < ops.length; ++i) {
                current = null;
                IExprNode node = ops[i];
                if (node.getExprType() == 131072) {
                    node = null == this._params ? ExprConst.DEFAULT_PARAM : this._params[((ExprParamPos)node).getPos()];
                }
                switch (node.getExprType()) {
                    case 2: 
                    case 4: 
                    case 8: 
                    case 65536: 
                    case 524288: 
                    case 0x100000: {
                        current = ctx.getObjectArray(0);
                        current.append((Object)node);
                        break;
                    }
                    case 16: 
                    case 128: 
                    case 256: 
                    case 1024: {
                        current = (ObjectArray)stack.pop();
                        current.insert(0, (Object)node);
                        if (!(node instanceof ExprOperator) || ((ExprOperator)node).parameterCount() != 2) break;
                        current.insertAll(0, (ObjectArray)stack.pop());
                        break;
                    }
                    case 64: {
                        if (node == ExprOperator.LP || node == ExprOperator.LARRAY) {
                            stack.push(node);
                            break;
                        }
                        int params = 0;
                        while (!stack.isEmpty()) {
                            Object obj = stack.pop();
                            if (obj instanceof ObjectArray) {
                                if (params > 0) {
                                    parameters.push(ExprOperator.COMMA);
                                }
                                ObjectArray array = (ObjectArray)obj;
                                for (int j = array.size() - 1; j >= 0; --j) {
                                    parameters.push(array.get(j));
                                }
                            } else {
                                boolean leftBound;
                                boolean bl = leftBound = obj == ExprOperator.LP || obj == ExprOperator.LARRAY;
                                if (params > 0 && !leftBound) {
                                    parameters.push(ExprOperator.COMMA);
                                }
                                parameters.push(obj);
                                if (leftBound) break;
                            }
                            if (obj == ExprOperator.RARRAY) continue;
                            ++params;
                        }
                        current = ctx.getObjectArray(0);
                        while (!parameters.isEmpty()) {
                            current.append(parameters.pop());
                        }
                        current.append((Object)node);
                        break;
                    }
                    case 32: {
                        Object obj = stack.getTop();
                        current = obj instanceof ObjectArray ? (ObjectArray)stack.pop() : ctx.getObjectArray(0);
                        current.append((Object)node);
                        break;
                    }
                }
                if (current == null) continue;
                stack.push(current);
            }
            current = null;
            if (stack.size() > 0) {
                current = ctx.getObjectArray(ops.length);
                int stackSize = stack.size();
                for (i = 0; i < stackSize; ++i) {
                    Object obj = stack.getAt(i);
                    if (obj instanceof IExprNode) {
                        current.append(obj);
                        continue;
                    }
                    ObjectArray array = (ObjectArray)obj;
                    int arraySize = array.size();
                    for (int j = 0; j < arraySize; ++j) {
                        current.append(array.get(j));
                    }
                    ctx.recycleArray(array);
                }
            }
            ctx.recycleStack(stack);
            ctx.recycleStack(parameters);
        }
        finally {
            ctx.getDeps();
            Dependents.lock.unlock();
        }
        return current;
    }

    public String decode(ExprContext ctx, ICalculable owner) {
        return this.decode(this.getDecodeList(ctx), ctx, owner);
    }

    public String decode(ObjectArray array, ExprContext ctx, ICalculable exprOwner) {
        String code = "";
        if (array.size() > 0) {
            StringBuffer sb = new StringBuffer();
            int size = array.size();
            for (int i = 0; i < size; ++i) {
                sb.append(((IExprNode)array.get(i)).decode(ctx, exprOwner));
            }
            code = sb.toString();
        }
        return code;
    }

    public static String getDateString(Variant var) {
        String dateFormula = "";
        if (var.isDate()) {
            Calendar cal = null;
            if (var.getVt() == 13) {
                cal = (Calendar)var.getValue();
            } else {
                cal = Calendar.getInstance();
                cal.setTime((Date)var.getValue());
            }
            dateFormula = cal.get(11) != 0 || cal.get(12) != 0 || cal.get(13) != 0 ? Formats.getFormat((String)"yyyy-m-d h:mm:ss").format(var, false).toString() : Formats.getFormat((String)"yyyy-m-d").format(var, false).toString();
        }
        return dateFormula;
    }
}

