/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.model.expr;

import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.expr.ExprContext;
import com.kingdee.bos.ctrl.excel.model.expr.ExprOperator;
import com.kingdee.bos.ctrl.excel.model.struct.ICalculable;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.node.CellBlockNode;
import com.kingdee.bos.ctrl.excel.model.util.ObjectStack;
import java.util.ArrayList;

class Operator_Multiply
extends ExprOperator {
    Operator_Multiply() {
    }

    @Override
    public void action(ExprContext ctx, ICalculable exprOwner) {
        ObjectStack stack = ctx.getCurrentExprStack();
        Variant op2 = (Variant)stack.pop();
        Variant op1 = (Variant)stack.pop();
        Variant result = Variant.getNewEmptyVariant();
        if (op1.isError() || op2.isError()) {
            result.setObject(op1.isError() ? op1.getValue() : op2.getValue(), 16);
            stack.push(result);
            return;
        }
        int leftFlag = this.getMultilyFlag(op1);
        int rightFlag = this.getMultilyFlag(op2);
        switch (leftFlag) {
            case 1: {
                this.doSingleMultiply(op1, op2, result, rightFlag);
                break;
            }
            case 2: {
                this.doArrayMultiply(op1, op2, result, rightFlag);
                break;
            }
            case 3: {
                this.doCellBlockMultiply(op1, op2, result, rightFlag);
                break;
            }
            default: {
                try {
                    op1.multiply(op2, result);
                    break;
                }
                catch (SyntaxErrorException e) {
                    result.setObject((Object)e, 16);
                }
            }
        }
        stack.push(result);
    }

    private Variant doSingleMultiply(Variant op1, Variant op2, Variant result, int rightFlag) {
        switch (rightFlag) {
            case 1: {
                this.singleMultiplySingle(op1, op2, result);
                break;
            }
            case 2: {
                this.singleMultiplyArray(op1, op2, result);
                break;
            }
            case 3: {
                this.singleMultiplyCellBlock(op1, op2, result);
                break;
            }
            default: {
                result.setObject((Object)"\u4e0d\u652f\u6301\u672a\u77e5\u6570\u636e\u7c7b\u578b\u7684\u8fd0\u7b97", 16);
            }
        }
        return result;
    }

    private Variant doArrayMultiply(Variant op1, Variant op2, Variant result, int rightFlag) {
        switch (rightFlag) {
            case 1: {
                this.singleMultiplyArray(op2, op1, result);
                break;
            }
            case 2: {
                this.arrayMultiplyArray(op1, op2, result);
                break;
            }
            case 3: {
                this.arrayMultiplyCellBlock(op1, op2, result);
                break;
            }
            default: {
                result.setObject((Object)"\u4e0d\u652f\u6301\u7684\u6570\u636e\u7c7b\u578b", 16);
            }
        }
        return result;
    }

    private Variant doCellBlockMultiply(Variant op1, Variant op2, Variant result, int rightFlag) {
        switch (rightFlag) {
            case 1: {
                this.singleMultiplyCellBlock(op2, op1, result);
                break;
            }
            case 2: {
                this.arrayMultiplyCellBlock(op2, op1, result);
                break;
            }
            case 3: {
                this.cellBlockMultiplyCellBlock(op1, op2, result);
                break;
            }
            default: {
                result.setObject((Object)"\u4e0d\u652f\u6301\u7684\u6570\u636e\u7c7b\u578b", 16);
            }
        }
        return result;
    }

    private Variant singleMultiplySingle(Object obj1, Object obj2, Variant result) {
        try {
            if (obj1 instanceof Variant && ((Variant)obj1).getVt() == 8) {
                if (obj2 instanceof Variant && ((Variant)obj2).getVt() == 8) {
                    result.setObject((Object)(((Variant)obj1).booleanValue() && ((Variant)obj2).booleanValue() ? 1 : 0));
                } else {
                    result.setObject(((Variant)obj1).booleanValue() ? obj2 : Integer.valueOf(0));
                }
            } else if (obj2 instanceof Variant && ((Variant)obj2).getVt() == 8) {
                result.setObject(((Variant)obj2).booleanValue() ? obj1 : Integer.valueOf(0));
            } else if (obj1 instanceof Variant && obj2 instanceof Variant) {
                ((Variant)obj1).multiply((Variant)obj2, result);
            } else if (obj1 instanceof Boolean && obj2 instanceof Boolean) {
                result.setObject((Object)((Boolean)obj1 != false && (Boolean)obj2 != false ? 1 : 0));
            } else if (obj1 instanceof Boolean) {
                result.setObject((Boolean)obj1 != false ? obj2 : Integer.valueOf(0));
            } else if (obj2 instanceof Boolean) {
                result.setObject((Boolean)obj2 != false ? obj1 : Integer.valueOf(0));
            } else {
                result.setObject((Object)"\u4e0d\u652f\u6301\u672a\u77e5\u6570\u636e\u7c7b\u578b\u7684\u8fd0\u7b97", 16);
            }
        }
        catch (SyntaxErrorException e) {
            result.setObject((Object)e, 16);
        }
        return result;
    }

    private Variant singleMultiplyArray(Variant op1, Variant op2, Variant result) {
        Object[] values2 = (Object[])op2.getValue();
        ArrayList<Variant> results = new ArrayList<Variant>();
        int len = values2.length;
        for (int i = 0; i < len; ++i) {
            Variant value = (Variant)values2[i];
            Variant newResult = Variant.getNewEmptyVariant();
            this.singleMultiplySingle(op1, value, newResult);
            results.add(newResult);
        }
        result.setObject((Object)results.toArray());
        return result;
    }

    private Variant singleMultiplyCellBlock(Variant op1, Variant op2, Variant result) {
        ArrayList<Variant> results = new ArrayList<Variant>();
        CellBlockNode cbn = (CellBlockNode)op2.getValue();
        Sheet.ICellsIterator cellsIterator = cbn.getCellsIterator(false, true);
        while (cellsIterator.hasNext()) {
            Variant var = cellsIterator.next().getValue();
            Variant newResult = Variant.getNewEmptyVariant();
            this.singleMultiplySingle(op1, var, newResult);
            results.add(newResult);
        }
        result.setObject((Object)results.toArray());
        return result;
    }

    private Variant arrayMultiplyArray(Variant op1, Variant op2, Variant result) {
        Object[] values2;
        Object[] values1 = (Object[])op1.getValue();
        if (values1.length != (values2 = (Object[])op2.getValue()).length) {
            result.setObject((Object)"\u4e0d\u652f\u6301\u672a\u77e5\u6570\u636e\u7c7b\u578b\u7684\u8fd0\u7b97", 16);
            return result;
        }
        ArrayList<Variant> results = new ArrayList<Variant>();
        int len = values1.length;
        for (int i = 0; i < len; ++i) {
            Variant newResult = Variant.getNewEmptyVariant();
            this.singleMultiplySingle(values1[i], values2[i], newResult);
            results.add(newResult);
        }
        result.setObject((Object)results.toArray());
        return result;
    }

    private Variant arrayMultiplyCellBlock(Variant op1, Variant op2, Variant result) {
        CellBlockNode cbn;
        Object[] values = (Object[])op1.getValue();
        if (values.length != ((cbn = (CellBlockNode)op2.getValue()).getRow2() - cbn.getRow() + 1) * (cbn.getCol2() - cbn.getCol() + 1)) {
            result.setObject((Object)"\u4e0d\u652f\u6301\u672a\u77e5\u6570\u636e\u7c7b\u578b\u7684\u8fd0\u7b97", 16);
            return result;
        }
        ArrayList<Variant> results = new ArrayList<Variant>();
        Sheet.ICellsIterator cellsIterator = cbn.getCellsIterator(false, true);
        Object[] arrayOfObject1 = values;
        int j = values.length;
        for (int i = 0; i < j; ++i) {
            Object value = arrayOfObject1[i];
            if (!cellsIterator.hasNext()) break;
            Variant cll = cellsIterator.next().getValue();
            Variant newResult = Variant.getNewEmptyVariant();
            this.singleMultiplySingle(value, cll, newResult);
            results.add(newResult);
        }
        result.setObject((Object)results.toArray());
        return result;
    }

    private Variant cellBlockMultiplyCellBlock(Variant op1, Variant op2, Variant result) {
        CellBlockNode cb1 = (CellBlockNode)op1.getValue();
        CellBlockNode cb2 = (CellBlockNode)op2.getValue();
        if (cb1.getRow2() - cb1.getRow() != cb2.getRow2() - cb2.getRow() || cb1.getCol2() - cb1.getCol() != cb2.getCol2() - cb2.getCol()) {
            result.setObject((Object)"\u4e0d\u652f\u6301\u672a\u77e5\u6570\u636e\u7c7b\u578b\u7684\u8fd0\u7b97", 16);
            return result;
        }
        Sheet.ICellsIterator cellsIterator1 = cb1.getCellsIterator(false, true);
        Sheet.ICellsIterator cellsIterator2 = cb2.getCellsIterator(false, true);
        ArrayList<Variant> results = new ArrayList<Variant>();
        while (cellsIterator1.hasNext()) {
            Variant var1 = cellsIterator1.next().getValue();
            Variant var2 = cellsIterator2.next().getValue();
            Variant newResult = Variant.getNewEmptyVariant();
            this.singleMultiplySingle(var1, var2, newResult);
            results.add(newResult);
        }
        result.setObject((Object)results.toArray());
        return result;
    }

    private int getMultilyFlag(Variant var) {
        int flag = 1;
        Object obj = var.getValue();
        if (obj == null) {
            return flag;
        }
        flag = obj.getClass().isArray() ? 2 : (obj instanceof CellBlockNode && !((CellBlockNode)obj).isSingleCell() ? 3 : 1);
        return flag;
    }

    @Override
    public String decode(ExprContext ctx, ICalculable exprOwner) {
        return Compact ? "*" : " * ";
    }
}

