/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.model.struct;

import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetAction;
import com.kingdee.bos.ctrl.excel.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.excel.model.struct.URState;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeEvent;

public class SheetAction_UpdateAutoFilter
extends SheetAction {
    boolean isClosedAutoFilter = false;

    protected SheetAction_UpdateAutoFilter(Range rg, long changedState) {
        super(rg, changedState);
    }

    @Override
    protected void actionBlock(URState state, Sheet sheet, CellBlock cb) {
        this.checkedAutoFilter(state, sheet, cb);
        this.updateAutoFilter(sheet, state);
    }

    private void checkedAutoFilter(URState state, Sheet sheet, CellBlock block) {
        CellBlock autofilterArea = sheet.getAutoFilterArea();
        if (autofilterArea == null) {
            return;
        }
        if (block.contains(new CellBlock(autofilterArea.getRow(), autofilterArea.getCol(), autofilterArea.getRow(), autofilterArea.getCol2()))) {
            this.isClosedAutoFilter = true;
        }
    }

    private void updateAutoFilter(Sheet sheet, URState state) {
        CellBlock autoFilterArea = sheet.getAutoFilterArea();
        if (autoFilterArea == null) {
            return;
        }
        if (this.isClosedAutoFilter) {
            this.colseAutoFilter(sheet, state, autoFilterArea);
            return;
        }
        CellBlock newArea = CellBlock.getNewCellBlock(autoFilterArea);
        SheetBaseMath.unCancerizeCellBlock(sheet, newArea);
        if (newArea.getCol() == -1 || newArea.getCol2() == -1 || newArea.getRow() == -1 || newArea.getRow2() == -1) {
            this.colseAutoFilter(sheet, state, autoFilterArea);
            return;
        }
        SheetBaseMath.cancerizeCellBlock(sheet, newArea, false, true, false);
        state.setData("AutoFilterArea", sheet.getAutoFilterArea());
        sheet.setAutoFilterArea(newArea);
        sheet.getBook().fireSheetChange(sheet, null, SheetChangeEvent.Changed_AutoFilter);
    }

    @Override
    protected void resumeBlock(URState state, Sheet sheet, CellBlock cb) {
    }
}

