/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.model.struct;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.InsertType;
import com.kingdee.bos.ctrl.excel.model.struct.MergeBlocks;
import com.kingdee.bos.ctrl.excel.model.struct.PrintSetup;
import com.kingdee.bos.ctrl.excel.model.struct.Protection;
import com.kingdee.bos.ctrl.excel.model.struct.Selection;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.ViewSplitInfo;
import java.awt.Color;

public final class SheetOption {
    public static final int CellDisplayMode_Formula = 1;
    public static final int CellDisplayMode_Value = 0;
    private Sheet _sheet;
    private Selection _sel;
    private MergeBlocks _merger;
    private Protection _pro;
    private PrintSetup _printSetup;
    private ViewSplitInfo _vsInfo;
    private int _percentScale;
    private Color _gridColor;
    private boolean _showHoriLines;
    private boolean _showVertLines;
    private Color _tabColor;
    private boolean _selected;
    private boolean _hide;
    private int _sheetType = 0;
    private int _cellDisplayMode;
    private InsertType insertType;
    private boolean leftToOutlineGroup;
    private boolean aboveOfOutlineGroup;

    SheetOption(Sheet sheet) {
        this._sheet = sheet;
        this._percentScale = 100;
        this._gridColor = new Color(192, 192, 192);
        this._showHoriLines = true;
        this._showVertLines = true;
        this.insertType = InsertType.FLLOW_UP_STYLE;
    }

    void copyFrom(SheetOption so) {
        PrintSetup ps;
        MergeBlocks mb;
        this.getSelection().copyFrom(so.getSelection());
        Protection pro = so.getProtection(false);
        if (pro != null) {
            this.getProtection(true).copyFrom(pro);
        }
        if ((mb = so.getMerger(false)) != null) {
            this.getMerger(true).copyFrom(mb);
        }
        if ((ps = so.getPrintSetup(false)) != null) {
            this.getPrintSetup(true).copyFrom(ps);
        }
        this.getViewSplitInfo().copyFrom(so.getViewSplitInfo());
        this._percentScale = so._percentScale;
        this._gridColor = null == so._gridColor ? null : new Color(so._gridColor.getRGB());
        this._showHoriLines = so._showHoriLines;
        this._showVertLines = so._showVertLines;
        this._tabColor = null == so._tabColor ? null : new Color(so._tabColor.getRGB());
        this._selected = so._selected;
        this._hide = so._hide;
        this._cellDisplayMode = so._cellDisplayMode;
        this.insertType = so.insertType;
    }

    public Protection getProtection(boolean bCreate) {
        if (this._pro == null && bCreate) {
            this._pro = new Protection(this._sheet);
        }
        return this._pro;
    }

    public Selection getSelection() {
        if (this._sel == null) {
            this._sel = new Selection(this._sheet);
        }
        return this._sel;
    }

    public MergeBlocks getMerger(boolean bCreate) {
        if (this._merger == null && bCreate) {
            this._merger = new MergeBlocks(this._sheet);
        }
        return this._merger;
    }

    public ViewSplitInfo getViewSplitInfo() {
        if (this._vsInfo == null) {
            this._vsInfo = new ViewSplitInfo();
        }
        return this._vsInfo;
    }

    public PrintSetup getPrintSetup(boolean bcreate) {
        if (bcreate && this._printSetup == null) {
            this._printSetup = new PrintSetup();
        }
        return this._printSetup;
    }

    public void setCellDisplayMode(int mode) {
        this._cellDisplayMode = mode;
    }

    public int getCellDisplayMode() {
        int parentMode = 2;
        Book book = this._sheet.getBook();
        if (book != null) {
            parentMode = book.getCellDisplayMode();
        }
        if (parentMode == 2) {
            return this._cellDisplayMode;
        }
        return parentMode;
    }

    public int setScale(int scale) {
        if (this._percentScale != scale) {
            int old = this._percentScale;
            this._percentScale = scale;
            return old;
        }
        return -1;
    }

    public float getScaleNoPercent() {
        return (float)this._percentScale / 100.0f;
    }

    public int getScale() {
        return this._percentScale;
    }

    public void setGridLineColor(Color color) {
        this._gridColor = color;
    }

    public Color getGridLineColor() {
        return this._gridColor;
    }

    public boolean isShowHoriLines() {
        return this._showHoriLines;
    }

    public void setShowHoriLines(boolean b) {
        this._showHoriLines = b;
    }

    public boolean isShowVertLines() {
        return this._showVertLines;
    }

    public void setShowVertLines(boolean b) {
        this._showVertLines = b;
    }

    public Color getTabColor() {
        return this._tabColor;
    }

    public void setTabColor(Color color) {
        this._tabColor = color;
    }

    public boolean isSelected() {
        return this._selected;
    }

    public void setSelected(boolean b) {
        this._selected = b;
    }

    public boolean isHide() {
        return this._hide;
    }

    public void setHide(boolean b) {
        this._hide = b;
    }

    public InsertType getInsertType() {
        return this.insertType;
    }

    public void setInsertType(InsertType insertType) {
        this.insertType = insertType;
    }

    public boolean isLeftToOulineGroup() {
        return this.leftToOutlineGroup;
    }

    public void setLeftToOutlineGroup(boolean leftToOutlineGroup) {
        this.leftToOutlineGroup = leftToOutlineGroup;
    }

    public boolean isAboveOfOutlineGroup() {
        return this.aboveOfOutlineGroup;
    }

    public void setAboveOfOutlineGroup(boolean aboveOfOutlineGroup) {
        this.aboveOfOutlineGroup = aboveOfOutlineGroup;
    }

    public int getSheetType() {
        return this._sheetType;
    }

    public void setSheetType(int type) {
        this._sheetType = type;
    }
}

