/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.model.struct.undo;

import com.kingdee.bos.ctrl.excel.model.struct.undo.AbstractUndoableEdit;
import com.kingdee.bos.ctrl.excel.model.struct.undo.IStateEditable;
import java.util.ArrayList;
import java.util.HashMap;

public class StateUndoableEdit
extends AbstractUndoableEdit {
    private static final int STATE_INIT_SIZE = 5;
    protected IStateEditable object;
    protected HashMap preState;
    protected HashMap postState;
    protected String undoRedoName;

    public StateUndoableEdit(IStateEditable anObject) {
        this.init(anObject, null);
    }

    public StateUndoableEdit(IStateEditable anObject, String name) {
        this.init(anObject, name);
    }

    protected void init(IStateEditable anObject, String name) {
        this.object = anObject;
        this.preState = new HashMap(5);
        this.object.storeState(this.preState);
        this.postState = null;
        this.undoRedoName = name;
    }

    public void end() {
        this.postState = new HashMap(5);
        this.object.storeState(this.postState);
        this.removeRedundantState();
    }

    @Override
    public void undo() {
        super.undo();
        this.object.restoreState(this.preState);
    }

    @Override
    public void redo() {
        super.redo();
        this.object.restoreState(this.postState);
    }

    @Override
    public String getPresentationName() {
        return this.undoRedoName;
    }

    protected void removeRedundantState() {
        ArrayList uselessKeys = new ArrayList();
        for (Object myKey : this.preState.keySet()) {
            if (!this.postState.containsKey(myKey) || !this.postState.get(myKey).equals(this.preState.get(myKey))) continue;
            uselessKeys.add(myKey);
        }
        for (int i = uselessKeys.size() - 1; i >= 0; --i) {
            Object myKey = uselessKeys.get(i);
            this.preState.remove(myKey);
            this.postState.remove(myKey);
        }
    }
}

