/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.report.forapp.bim;

import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModelException;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModelUtil;
import com.kingdee.bos.ctrl.common.FullPath;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.data.DataDefType;
import com.kingdee.bos.ctrl.data.framework.datasource.VirtualQueryAccess;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaLibrary;
import com.kingdee.bos.ctrl.data.meta.bmd.BmdMetaType;
import com.kingdee.bos.ctrl.data.modal.INameSpace;
import com.kingdee.bos.ctrl.data.modal.StringNameSpace;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.report.forapp.bim.ObjectSto4MDQueryInfo;
import com.kingdee.bos.ctrl.report.forapp.bim.ObjectSto4QueryInfo;
import com.kingdee.bos.ctrl.report.forapp.bim.SimpleExecutor;
import com.kingdee.bos.ctrl.report.forapp.bim.datasource.BmdDataSource;
import com.kingdee.bos.ctrl.report.forapp.bim.reportframework.FileStreamStorage;
import com.kingdee.bos.ctrl.report.forapp.bim.reportframework.IReportEnvVar;
import com.kingdee.bos.ctrl.report.forapp.bim.reportframework.SimpleReportEnv;
import com.kingdee.bos.ctrl.report.forapp.bim.reportframework.invoke.IReportInvoker;
import com.kingdee.bos.ctrl.report.forapp.bim.reportframework.invoke.LocalReportInvoker;
import com.kingdee.bos.ctrl.report.forapp.bim.reportimpl.form.KDFormRptExecutor;
import com.kingdee.bos.ctrl.report.forapp.bim.reportimpl.olap.KDOlapRptEditor;
import com.kingdee.bos.ctrl.report.forapp.bim.reportimpl.table.KDTableRptBrowser;
import com.kingdee.bos.ctrl.report.forapp.bim.reportimpl.table.KDTableRptExecutor;
import com.kingdee.bos.ctrl.report.forapp.kdnote.upgrade.UpgradeEasNote;
import com.kingdee.bos.ctrl.reportone.data.framework.bos.BosExecutor;
import com.kingdee.bos.ctrl.reportone.data.framework.datasource.IDataSource;
import com.kingdee.bos.ctrl.reportone.data.framework.datasource.IDataSourceFactory;
import com.kingdee.bos.ctrl.reportone.data.framework.datasource.SimpleDSFactory;
import com.kingdee.bos.ctrl.reportone.data.invoke.IDataExecutor;
import com.kingdee.bos.ctrl.reportone.data.invoke.SimpleDataExecutor;
import com.kingdee.bos.ctrl.reportone.data.meta.bmd.BmdMetaLibrary;
import com.kingdee.bos.ctrl.reportone.data.meta.io.Bmd2Meta;
import com.kingdee.bos.ctrl.reportone.data.modal.DataDef;
import com.kingdee.bos.ctrl.reportone.data.modal.IDataDef;
import com.kingdee.bos.ctrl.reportone.data.modal.ParamUtil;
import com.kingdee.bos.ctrl.reportone.data.modal.io.DataDef2Meta;
import com.kingdee.bos.ctrl.reportone.kdrs.Path;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.ReportType;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.IStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.ResourceType;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.StorageProxy;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.db.PersistentConnection;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.db2.DBStorage2;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.fs.FSStorage;
import com.kingdee.bos.ctrl.reportone.reportframework.IReportEnv;
import com.kingdee.bos.ctrl.reportone.reportframework.IReportStorage;
import com.kingdee.bos.ctrl.reportone.reportframework.IStreamStorage;
import com.kingdee.bos.ctrl.reportone.reportframework.ReportException;
import com.kingdee.bos.ctrl.reportone.reportframework.ReportFactory;
import com.kingdee.bos.ctrl.reportone.reportframework.ReportUtil;
import com.kingdee.bos.ctrl.reportone.reportframework.browse.AReportBrowser;
import com.kingdee.bos.ctrl.reportone.reportframework.browse.IReportBrowser;
import com.kingdee.bos.ctrl.reportone.reportframework.design.IReportDesignListener;
import com.kingdee.bos.ctrl.reportone.reportframework.design.IReportDesigner;
import com.kingdee.bos.ctrl.reportone.reportframework.execute.AbstractLocalReportExecutor;
import com.kingdee.bos.ctrl.reportone.reportframework.execute.IReportExecutor;
import com.kingdee.bos.ctrl.reportone.reportimpl.cubemodel.CubeModelExecutor;
import com.kingdee.bos.ctrl.reportone.reportimpl.cubemodel.CubeModelRptDesigner;
import com.kingdee.bos.ctrl.reportone.reportimpl.xdata.DataBindUtil;
import com.kingdee.bos.ctrl.reportone.reportimpl.xdata.XDataExecutor;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.mdquery.MDQueryInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class BimReportHelper {
    private static final Logger log = LogUtil.getPackageLogger(BimReportHelper.class);

    public static void designQuery(boolean isNew, QueryInfo qi, Component owner, IReportDesignListener eventListner) throws ReportException {
        if (log.isInfoEnabled()) {
            log.info((Object)("designQuery(" + isNew + ", " + qi + ", " + owner + ", " + eventListner + ")"));
        }
        if (qi != null) {
            String dataDefType = qi.getExtendedProperty("dataDefType");
            String dataDef = qi.getExtendedProperty("dataDef");
            DataDefType category = DataDefType.fromName((String)dataDefType);
            if (category == null) {
                if (dataDef != null) {
                    category = DataDefType.KDRS_GROUPING;
                }
            } else if (dataDef == null) {
                throw new ReportException("DataDef is null, but DataDefType is " + dataDefType);
            }
            MetaClass mc = Bmd2Meta.parseQuery((QueryInfo)qi);
            mc.setNameSpace((INameSpace)new StringNameSpace(FullPath.dots2path((String)qi.getPackage())));
            SimpleReportEnv rptEnv = new SimpleReportEnv();
            ObjectSto4QueryInfo temp = new ObjectSto4QueryInfo(qi, category);
            rptEnv.setReportStorage((IReportStorage)temp);
            IReportDesigner rptDsg = null;
            rptDsg = dataDef == null ? ReportFactory.createDesigner((Object)ReportFactory.KDRS_XDATA, (Component)owner) : ReportFactory.createDesigner((Object)category, (Component)owner);
            rptDsg.setReportEnv((IReportEnv)rptEnv);
            if (eventListner != null) {
                rptDsg.addDesignListener(eventListner);
            }
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put(ReportUtil.ARG_META_CLASS, mc);
            args.put("PROCESSER_WIZARD_FILE", "/com/kingdee/bos/ctrl/report/forapp/bim/Bim_ProcessWizard.xml");
            rptDsg.design(isNew, args);
        }
        log.info((Object)"designQuery return.");
    }

    public static void restoreQuery(QueryInfo qi) {
        if (log.isInfoEnabled()) {
            log.info((Object)("restoreQuery(" + qi + ")"));
        }
        if (qi != null) {
            qi.removeExtendedProperty("dataDef");
            qi.removeExtendedProperty("dataDefType");
        }
        log.info((Object)"restoreQuery return.");
    }

    public static void designMDQuery(boolean isNew, MDQueryInfo mdqi, String metasPath, Component owner, IReportDesignListener eventListner) throws ReportException {
        if (log.isInfoEnabled()) {
            log.info((Object)("designMDQuery(" + isNew + ", " + mdqi + ", " + metasPath + ", " + owner + ", " + eventListner + ")"));
        }
        BmdMetaLibrary ml = Bmd2Meta.lazyLoad((String)metasPath, (BmdMetaType[])new BmdMetaType[]{BmdMetaType.QUERY, BmdMetaType.PACKAGE, BmdMetaType.SOLUTION});
        BmdDataSource ds = new BmdDataSource(null);
        ds.setMetaLibrary((MetaLibrary)ml);
        SimpleDSFactory dsFactory = new SimpleDSFactory();
        dsFactory.setDataSource(null, (IDataSource)ds);
        dsFactory.setDefaultDataSource((IDataSource)ds);
        SimpleReportEnv rptEnv = new SimpleReportEnv();
        rptEnv.setReportStorage((IReportStorage)new ObjectSto4MDQueryInfo(mdqi, metasPath));
        rptEnv.setDSFactory((IDataSourceFactory)dsFactory);
        CubeModelRptDesigner dsg = new CubeModelRptDesigner(owner);
        dsg.setReportEnv((IReportEnv)rptEnv);
        if (eventListner != null) {
            dsg.addDesignListener(eventListner);
        }
        dsg.design(isNew, null);
        log.info((Object)"designMDQuery return.");
    }

    private static void desginReport(ReportType rptType, boolean isNew, QueryInfo qi, IReportStorage rptSto, IReportEnvVar envVar, Component owner, IReportDesignListener eventListner) throws ReportException {
        MetaClass mc = null;
        if (qi != null) {
            String dataDefText;
            Object dataObj;
            mc = Bmd2Meta.parseQuery((QueryInfo)qi);
            DataDefType dataDefType = DataDefType.fromName((String)qi.getExtendedProperty("dataDefType"));
            if (dataDefType != null && (dataObj = ObjectSto4QueryInfo.loadDataDef(dataDefType, dataDefText = qi.getExtendedProperty("dataDef"))) instanceof IDataDef) {
                MetaClass mc2 = DataDef2Meta.parseDataObject((IDataDef)((IDataDef)dataObj));
                mc.setFields(mc2.getFields());
            }
            FullPath fp = new FullPath();
            fp.setDots(qi.getFullName(), DataDefType.BOS_QUERY.getName());
            mc.setExpr(fp.getText());
        }
        SimpleReportEnv rptEnv = new SimpleReportEnv();
        rptEnv.setReportStorage(rptSto);
        rptEnv.setReportEnvVar(envVar);
        IReportDesigner rptDsg = ReportFactory.createDesigner((Object)rptType, (Component)owner);
        rptDsg.setReportEnv((IReportEnv)rptEnv);
        if (eventListner != null) {
            rptDsg.addDesignListener(eventListner);
        }
        HashMap<String, MetaClass> args = new HashMap<String, MetaClass>();
        args.put(ReportUtil.ARG_META_CLASS, mc);
        rptDsg.design(isNew, args);
    }

    public static void desginTableReport(boolean isNew, QueryInfo qi, IReportStorage rptSto, IReportEnvVar envVar, Component owner, IReportDesignListener eventListner) throws ReportException {
        if (log.isInfoEnabled()) {
            log.info((Object)("desginTableReport(" + isNew + ", " + qi + ", " + rptSto + ", " + envVar + ", " + owner + ", " + eventListner + ")"));
        }
        BimReportHelper.desginReport(ReportType.TABLE, isNew, qi, rptSto, envVar, owner, eventListner);
        log.info((Object)"desginTableReport return.");
    }

    public static void desginFormReport(boolean isNew, QueryInfo qi, IStreamStorage rptSto, IReportEnvVar envVar, Component owner, IReportDesignListener eventListner) throws ReportException {
        if (log.isInfoEnabled()) {
            log.info((Object)("desginFormReport(" + isNew + ", " + qi + ", " + rptSto + ", " + envVar + ", " + owner + ", " + eventListner + ")"));
        }
        BimReportHelper.desginReport(ReportType.FORM, isNew, qi, (IReportStorage)rptSto, envVar, owner, eventListner);
        log.info((Object)"desginFormReport return.");
    }

    public static IReportBrowser browseOlapReport(IReportEnv rptEnv, boolean isNew, MDQueryInfo mdqi, HashMap evis) throws ReportException {
        FullPath fp;
        CubeModel cubeModel;
        if (log.isInfoEnabled()) {
            log.info((Object)("browseOlapReport(" + rptEnv + "," + isNew + ", " + mdqi + ", " + evis + ")"));
        }
        try {
            cubeModel = CubeModelUtil.convertFromMDQuery((MDQueryInfo)mdqi);
        }
        catch (CubeModelException ex) {
            throw ReportException.makeException((Throwable)ex);
        }
        HashMap nsArgs = new HashMap();
        if (evis != null) {
            fp = new FullPath();
            for (Map.Entry ent : evis.entrySet()) {
                String pk;
                Object bosObj = ent.getKey();
                if (bosObj instanceof QueryInfo) {
                    pk = ((QueryInfo)bosObj).getFullName();
                    fp.setDots(pk, DataDefType.BOS_QUERY.getName());
                } else if (bosObj instanceof EntityObjectInfo) {
                    pk = ((EntityObjectInfo)bosObj).getFullName();
                    fp.setDots(pk, DataDefType.BOS_ENTITY.getName());
                } else {
                    log.error((Object)("Unknown filter type " + bosObj));
                    continue;
                }
                String key = ParamUtil.makeKey((String)"FILTER", (String)fp.getText());
                nsArgs.put(key, ent.getValue());
            }
        }
        fp = new FullPath();
        fp.setDots(mdqi.getFullName(), DataDefType.BOS_MDQUERY.getName());
        nsArgs.put(KDOlapRptEditor.ARG_FullPath_cubeInfo, fp);
        nsArgs.put(KDOlapRptEditor.ARG_CubeModel, cubeModel);
        nsArgs.put(KDOlapRptEditor.ARG_String_cubeName, null);
        nsArgs.put(KDOlapRptEditor.ARG_Boolean_isShow, Boolean.FALSE);
        nsArgs.put(KDOlapRptEditor.ARG_Boolean_isNew, isNew);
        AbstractLocalReportExecutor rptExec = ReportFactory.createExecutor((Object)"kdrs-olap");
        rptExec.setDataExecutor((IDataExecutor)new SimpleDataExecutor());
        AReportBrowser rptBrw = ReportFactory.createBrowser((Object)ReportFactory.REPORT_OLAP, null);
        rptBrw.setReportExecutor((IReportExecutor)rptExec);
        rptBrw.browse(nsArgs);
        if (log.isInfoEnabled()) {
            log.info((Object)("browseOlapReport return " + rptBrw));
        }
        return rptBrw;
    }

    public static IReportInvoker executeQuery(QueryInfo qi, EntityViewInfo evi, IReportInvoker rptIvk) throws ReportException {
        if (log.isInfoEnabled()) {
            log.info((Object)("executeQuery(" + qi + "," + evi + ", " + rptIvk + ")"));
        }
        String dataDef = qi.getExtendedProperty("dataDef");
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("dataDef", dataDef);
        args.put("FILTER", (String)evi);
        FullPath fp = new FullPath();
        fp.setDots(qi.getFullName(), DataDefType.BOS_QUERY.getName());
        HashMap nsArgs = new HashMap();
        ParamUtil.mergeArgs(nsArgs, (String)fp.getText(), args);
        if (dataDef == null) {
            KDTableRptExecutor tabRptExec = new KDTableRptExecutor();
            tabRptExec.setDataExecutor(new BosQueryDataExecutor());
            rptIvk = new LocalReportInvoker(tabRptExec);
        }
        rptIvk.execute(nsArgs);
        if (log.isInfoEnabled()) {
            log.info((Object)("executeQuery return " + rptIvk));
        }
        return rptIvk;
    }

    public static IRowSet requestKDTableRowSet(RequestRowSetEvent e, IReportInvoker rptIvk) throws ReportException {
        if (log.isInfoEnabled()) {
            log.info((Object)("requestKDTableRowSet(" + e + "," + rptIvk + ")"));
        }
        HashMap args = KDTableRptBrowser.makeExecuteArgs(e);
        IRowSet rs = (IRowSet)rptIvk.invoke("getPage", new Class[]{HashMap.class}, new Object[]{args});
        log.info((Object)("requestKDTableRowSet return " + rs));
        return rs;
    }

    public static void fillKDTableGrouping(KDTable kdt, int startRow, ResultSet rs) throws SQLException {
        if (log.isInfoEnabled()) {
            log.info((Object)("fillKDTableGrouping(" + kdt + "," + startRow + "," + rs + ")"));
        }
        DataBindUtil.fillKDTableGrouping((KDTable)kdt, (int)startRow, (ResultSet)rs);
        log.info((Object)"fillKDTableGrouping return.");
    }

    private static IReportBrowser getFormBrowser(String filePath, BOSQueryDelegate data, Component owner) throws ReportException {
        FileStreamStorage rptSto = new FileStreamStorage(filePath);
        AbstractLocalReportExecutor rptExec = ReportFactory.createExecutor((Object)ReportFactory.REPORT_FORM);
        rptExec.setDataExecutor((IDataExecutor)BosExecutor.getRemoteInstance());
        rptExec.setReportStorage((IReportStorage)rptSto);
        AReportBrowser rptBrw = ReportFactory.createBrowser((Object)ReportFactory.REPORT_FORM, (Component)owner);
        rptBrw.setReportExecutor((IReportExecutor)rptExec);
        HashMap<String, BOSQueryDelegate> ps = new HashMap<String, BOSQueryDelegate>();
        if (data != null) {
            ps.put(KDFormRptExecutor.ARG_BOSQueryDelegate, data);
        }
        rptBrw.browse(ps);
        return rptBrw;
    }

    public static void printForm(String filePath, BOSQueryDelegate data, Component owner) throws ReportException {
        if (log.isInfoEnabled()) {
            log.info((Object)("printForm(" + filePath + "," + data + "," + owner + ")"));
        }
        BimReportHelper.getFormBrowser(filePath, data, owner).print();
        log.info((Object)"printForm return.");
    }

    public static void browseForm(String filePath, BOSQueryDelegate data, Component owner) throws ReportException {
        if (log.isInfoEnabled()) {
            log.info((Object)("browseForm(" + filePath + "," + data + "," + owner + ")"));
        }
        BimReportHelper.getFormBrowser(filePath, data, owner).browse(new HashMap());
        log.info((Object)"browseForm return.");
    }

    public static IReportExecutor executeReport(Object type, IReportStorage rptSto, HashMap args) throws ReportException {
        if (log.isInfoEnabled()) {
            log.info((Object)("executeReport(" + type + "," + rptSto + "," + args + ")"));
        }
        SimpleExecutor dataExec = new SimpleExecutor();
        dataExec.putExecutor(DataDef.class, (IDataExecutor)new XDataExecutor());
        dataExec.putExecutor(CubeModel.class, (IDataExecutor)new CubeModelExecutor());
        BosExecutor bmdExec = BosExecutor.newLocalInstance((Context)ContextUtils.getContextFromSession());
        dataExec.putExecutor(FullPath.class, (IDataExecutor)bmdExec);
        AbstractLocalReportExecutor rptExec = ReportFactory.createExecutor((Object)type);
        rptExec.setReportStorage(rptSto);
        rptExec.setDataExecutor((IDataExecutor)dataExec);
        rptExec.execute(args);
        if (log.isInfoEnabled()) {
            log.info((Object)("executeReport return " + rptExec));
        }
        return rptExec;
    }

    public static void deployNote(String filePath, final Connection dbConn) throws KDRSException {
        if (log.isInfoEnabled()) {
            log.info((Object)("deployNote(" + filePath + "," + dbConn + ")"));
        }
        if (filePath == null || dbConn == null) {
            throw new IllegalArgumentException("File-path or DB-connection not be null!!!");
        }
        FSStorage fsSto = new FSStorage(filePath);
        com.kingdee.bos.ctrl.reportone.kdrs.storage.db.IDataSource ds = new com.kingdee.bos.ctrl.reportone.kdrs.storage.db.IDataSource(){
            PersistentConnection conn;
            {
                this.conn = new PersistentConnection(dbConn);
            }

            public Connection getConnection() {
                return this.conn;
            }
        };
        DBStorage2 dbSto = new DBStorage2(ds);
        Path easOrg = Path.valueOf((String)"/eas");
        if (!dbSto.isExist(easOrg)) {
            dbSto.create(easOrg, ResourceType.FOLDER, null);
        }
        StorageProxy easDbSto = new StorageProxy((IStorage)dbSto, easOrg);
        UpgradeEasNote.upgrade((IStorage)fsSto, (IStorage)easDbSto);
        if (log.isInfoEnabled()) {
            log.info((Object)"deployNote return.");
        }
    }

    public static class BosQueryDataExecutor
    implements IDataExecutor {
        public Object execute(String category, Object object, HashMap impArgs, IDataExecutor env) throws Exception {
            FullPath fp;
            DataDefType ddType;
            if (object instanceof FullPath && DataDefType.BOS_QUERY == (ddType = DataDefType.fromName((String)(fp = (FullPath)object).getCategory()))) {
                EntityViewInfo evi = (EntityViewInfo)impArgs.get("FILTER");
                String dataDef = (String)impArgs.get("dataDef");
                if (dataDef == null) {
                    return VirtualQueryAccess.newInstance((String)fp.getDots(), (EntityViewInfo)evi);
                }
            }
            throw new UnsupportedOperationException("Unsupport " + category);
        }
    }
}

