/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.report.forapp.kdnote.client.actions;

import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.ui.restree.AbstractResActionHandler;
import com.kingdee.bos.ctrl.common.ui.stepwizard.IWizardStep;
import com.kingdee.bos.ctrl.common.ui.stepwizard.WizardDialog;
import com.kingdee.bos.ctrl.common.ui.tree.TreeUINode;
import com.kingdee.bos.ctrl.common.util.PathUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.NoteTreeCtrl;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.actions.ActionExport;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.ui.OverwritePromptDialog;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.NoteDistributionUtil;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.storage.actions.AbstractStorageResActionHandler;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.storage.ui.CommonBizStorageTreeCtrl;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.storage.ui.importexport.ImportFromFileStep;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.storage.ui.importexport.ProgressBar;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.storage.ui.importexport.model.AImportFromFileModel;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.storage.ui.importexport.model.ICopyBetweenStorage;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.storage.ui.importexport.model.ImportExportModel;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.IBizContent;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.BizStorageUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.IBizStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.StorageCategory;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.AlreadyExistsException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.NotFoundException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.UserCancelException;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.filechooser.FileFilter;
import org.jdom2.Attribute;
import org.jdom2.Element;

public class ActionImport
extends AbstractStorageResActionHandler {
    static final String TemplatePostfix = ".kdrs-form";
    static final String MetadataPostfix = ".bos-query";
    static final String R1TemplatePostfix = ".r1-print";
    static final String NoteDynQueryPostfix = ".note-dynquery";
    private boolean _overwriteYesAll = false;

    protected boolean onAction() throws Exception {
        NoteTreeCtrl ntc = (NoteTreeCtrl)this.getTreeController();
        if (ntc.isSupermanMode()) {
            WizardDialog wd = (WizardDialog)WindowUtil.createWindow(WizardDialog.class, (Component)this.getTreeUI());
            wd.setBigSize(true);
            wd.setModal(true);
            wd.setTitle(MultiLanguageUtil.getMLS("actions.ActionImport.importObject"), true);
            ImportExportModel context = new ImportExportModel();
            context.setToStorage(this.getBizStorage());
            context.setToPath(this.getPathText());
            NoteImportStep fromFileStep = new NoteImportStep((ICopyBetweenStorage)context);
            ArrayList<NoteImportStep> list = new ArrayList<NoteImportStep>();
            list.add(fromFileStep);
            wd.setStepsList(list);
            wd.show();
        } else {
            this.import_limitedManage();
        }
        this.getBizStorageTreeCtrl().getTreeUI().refreshSelectionNode();
        return false;
    }

    private void import_limitedManage() {
        KDFileChooser chooser = new KDFileChooser(System.getProperty("User.dir"));
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(true);
        chooser.setFileFilter((FileFilter)new ImportFileFilter());
        int returnVal = chooser.showOpenDialog((Component)this.getTreeUI());
        if (returnVal == 0) {
            File[] selecteds = chooser.getSelectedFiles();
            String fromPath = chooser.getSelectedFile().getParent().toString();
            System.setProperty("User.dir", fromPath);
            NoteImportFromFileModel model = new NoteImportFromFileModel();
            model.createFSStorage(fromPath);
            NoteImportTreeCtrl ctrl = new NoteImportTreeCtrl(model.getFromStorage());
            ctrl.getTreeUI().setCheckboxMode(true);
            ctrl.getTreeUI().expandRoot();
            TreeUINode root = ctrl.getTreeUI().getRootNode();
            for (int i = 0; i < selecteds.length; ++i) {
                TreeUINode node = root.getChildNode(selecteds[i].getName());
                node.setChecked(true);
            }
            this.copyWithUI(model.getFromStorage(), (IBizContent)this.getBizStorage(), ctrl.getTopNode(), this.getPathText());
        }
    }

    void copyWithUI(final IBizStorage fromSto, final IBizContent toCnt, final TreeUINode tnFrom, final String toPath) {
        final ProgressBar bar = (ProgressBar)WindowUtil.createWindow(ProgressBar.class, (Component)this.getTreeUI());
        bar.setTitle(MultiLanguageUtil.getMLS("actions.ActionImport.importObject"));
        new Thread(new Runnable(){

            @Override
            public void run() {
                CopyWithTree cwt = new CopyWithTree(fromSto, (IBizStorage)toCnt, new Creater(bar), bar);
                try {
                    cwt.copy("/", toPath, tnFrom);
                }
                catch (KDRSException ex) {
                    AbstractResActionHandler.log.error((Object)MultiLanguageUtil.getMLS("actions.ActionImport.importFailed"), (Throwable)ex);
                    WindowUtil.showException((String)MultiLanguageUtil.getMLS("actions.ActionImport.importFailed"), (Throwable)ex, (String)MultiLanguageUtil.getMLS("actions.ActionImport.importObject"), (Component)ActionImport.this.getTreeUI());
                }
                catch (UserCancelException userCancelException) {
                    // empty catch block
                }
                bar.finished();
            }
        }).start();
        bar.show();
    }

    private class Creater
    implements BizStorageUtil.IResourceCreator {
        private ProgressBar bar;

        public Creater(ProgressBar bar) {
            this.bar = bar;
        }

        public HashMap create(IBizStorage fromSto, String fromPath, IBizStorage toSto1, String toPath) throws KDRSException {
            IBizContent toCnt = (IBizContent)toSto1;
            NoteTreeCtrl ntc = (NoteTreeCtrl)ActionImport.this.getTreeController();
            if (!ntc.isSupermanMode()) {
                boolean isDistributed = true;
                try {
                    isDistributed = NoteDistributionUtil.isDistributed(toCnt, toPath);
                }
                catch (NotFoundException notFoundException) {
                    // empty catch block
                }
                if (!isDistributed) {
                    if (!"/".equals(fromPath)) {
                        this.bar.addLine(MultiLanguageUtil.getMLS("actions.ActionImport.cantCover"));
                    }
                    return null;
                }
            }
            HashMap attrs = fromSto.getAttributes(fromPath, new String[]{"name", "type"});
            Object type = attrs.get("type");
            String name = (String)attrs.get("name");
            if (StringUtil.equals((String)StorageCategory.FOLDER.getName(), (String)type.toString())) {
                try {
                    attrs = this.getOriAttrs(fromSto, fromPath, ActionImport.this._overwriteYesAll || fromPath == "/" ? 16 : 1);
                    attrs.put("category", "folder");
                    toCnt.create(toPath, attrs);
                }
                catch (AlreadyExistsException ex) {
                    switch (this.isOverwrite(toPath)) {
                        case 2: {
                            ActionImport.this._overwriteYesAll = true;
                        }
                        case 1: {
                            break;
                        }
                        case 3: {
                            return null;
                        }
                        case 0: {
                            throw new UserCancelException();
                        }
                    }
                    this.putAttrPolicy(attrs, 16);
                    toCnt.create(toPath, attrs);
                }
            } else {
                attrs = null;
                if (name.endsWith(ActionImport.TemplatePostfix) || name.endsWith(ActionImport.R1TemplatePostfix)) {
                    HashMap att = this.getOriAttrs(fromSto, fromPath, ActionImport.this._overwriteYesAll ? 16 : 1);
                    if (name.endsWith(ActionImport.TemplatePostfix)) {
                        att.put("category", "kdrs-form");
                    } else {
                        att.put("category", "r1-print");
                    }
                    att.remove("type");
                    try {
                        toCnt.create(toPath, att);
                    }
                    catch (AlreadyExistsException ex) {
                        switch (this.isOverwrite(toPath)) {
                            case 2: {
                                ActionImport.this._overwriteYesAll = true;
                            }
                            case 1: {
                                break;
                            }
                            case 3: {
                                return null;
                            }
                            case 0: {
                                throw new UserCancelException();
                            }
                        }
                        this.putAttrPolicy(att, 16);
                        toCnt.create(toPath, att);
                    }
                    toCnt.writeTemplate(toPath, BizStorageUtil.readFile((IBizStorage)fromSto, (String)fromPath));
                } else if (name.endsWith(ActionImport.MetadataPostfix) || name.endsWith(ActionImport.NoteDynQueryPostfix)) {
                    HashMap att = this.getOriAttrs(fromSto, fromPath, ActionImport.this._overwriteYesAll ? 16 : 1);
                    if (name.endsWith(ActionImport.NoteDynQueryPostfix)) {
                        att.put("category", "note-dynquery");
                    } else {
                        att.put("category", "bos-query");
                    }
                    try {
                        toCnt.create(toPath, att);
                    }
                    catch (AlreadyExistsException ex) {
                        switch (this.isOverwrite(toPath)) {
                            case 2: {
                                ActionImport.this._overwriteYesAll = true;
                            }
                            case 1: {
                                break;
                            }
                            case 3: {
                                return null;
                            }
                            case 0: {
                                throw new UserCancelException();
                            }
                        }
                        this.putAttrPolicy(att, 16);
                        toCnt.create(toPath, att);
                    }
                    toCnt.writeTemplate(toPath, BizStorageUtil.readFile((IBizStorage)fromSto, (String)fromPath));
                }
            }
            if (!ntc.isSupermanMode()) {
                NoteDistributionUtil.setDistributed(ntc, toPath);
            }
            return attrs;
        }

        private HashMap getAttrsWithDotMeta(IBizStorage sto, String pathText) throws KDRSException {
            HashMap atts = sto.getAttributes(pathText, null);
            try {
                byte[] bs = BizStorageUtil.readFile((IBizStorage)sto, (String)PathUtil.makeSiblingPath((String)pathText, (String)".meta"));
                Element dotMetaRoot = XmlUtil.loadXmlBytes((byte[])bs);
                for (Element node : dotMetaRoot.getChild("Nodes").getChildren()) {
                    if (!StringUtil.equals((String)node.getAttributeValue("name"), (String)atts.get("name").toString())) continue;
                    for (Attribute att : node.getAttributes()) {
                        if (!att.getName().startsWith("alias")) continue;
                        atts.put(att.getName(), att.getValue());
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return atts;
        }

        private HashMap getOriAttrs(IBizStorage sto, String pathText, int createPolicy) throws KDRSException {
            HashMap atts = this.getAttrsWithDotMeta(sto, pathText);
            atts.remove("name");
            atts.remove("size");
            atts.remove("time");
            atts.remove("creator");
            atts.remove("last-access");
            atts.remove("last-modified");
            atts.remove("eas-report-id");
            atts.remove("eas-menu-pk");
            this.putAttrPolicy(atts, createPolicy);
            return atts;
        }

        private void putAttrPolicy(HashMap atts, int createPolicy) {
            atts.put("create_policy", new Integer(createPolicy));
        }

        private int isOverwrite(String pathText) {
            return OverwritePromptDialog.show((Component)ActionImport.this.getTreeUI(), pathText + "  " + MultiLanguageUtil.getMLS("actions.ActionImport.overWritePrompt"), MultiLanguageUtil.getMLS("actions.ActionImport.overWriteTitle"));
        }
    }

    private class CopyWithTree {
        private IBizStorage fromStorage;
        private IBizStorage toStorage;
        private BizStorageUtil.IResourceCreator creator;
        private ProgressBar progressBar;

        public CopyWithTree(IBizStorage fromSto, IBizStorage toSto, BizStorageUtil.IResourceCreator creator, ProgressBar bar) {
            this.fromStorage = fromSto;
            this.toStorage = toSto;
            this.creator = creator;
            this.progressBar = bar;
            ActionImport.this._overwriteYesAll = false;
        }

        public void copy(String fromPath, String toPath, TreeUINode tnFrom) throws KDRSException {
            if (this.progressBar != null) {
                this.progressBar.addLine(toPath);
            }
            this.creator.create(this.fromStorage, fromPath, this.toStorage, toPath);
            if (tnFrom.getAllowsChildren() && !tnFrom.isChildrenLoaded()) {
                ActionExport.copyFolder(this.fromStorage, fromPath, this.toStorage, toPath, this.creator, this.progressBar);
            } else if (!tnFrom.isLeaf()) {
                int j = tnFrom.getChildCount();
                for (int i = 0; i < j; ++i) {
                    TreeUINode tnChild = (TreeUINode)tnFrom.getChildAt(i);
                    if (tnChild.getCheckedValue() == 16) continue;
                    String childName = tnChild.getName();
                    String fromChild = PathUtil.makeChildPath((String)fromPath, (String)childName);
                    String toChild = PathUtil.makeChildPath((String)toPath, (String)childName);
                    this.copy(fromChild, toChild, tnChild);
                }
            }
        }
    }

    private static class NoteImportTreeCtrl
    extends CommonBizStorageTreeCtrl {
        public NoteImportTreeCtrl(IBizStorage bizSto) {
            super(bizSto);
        }

        protected void initFolderNode(String pathText, TreeUINode node) throws KDRSException {
            HashMap rv = this.getBizStorage().list(pathText, LIST_ATTRS);
            String[] names = (String[])rv.get("name");
            String[] alias = (String[])rv.get("alias");
            String[] types = (String[])rv.get("type");
            for (int i = 0; i < names.length; ++i) {
                StorageCategory category;
                StorageCategory storageCategory = category = "Folder".equals(types[i]) ? StorageCategory.FOLDER : StorageCategory.FILE;
                if (category == StorageCategory.FILE && !names[i].endsWith(ActionImport.TemplatePostfix) && !names[i].endsWith(ActionImport.R1TemplatePostfix) && !names[i].endsWith(ActionImport.MetadataPostfix) && !names[i].endsWith(ActionImport.NoteDynQueryPostfix)) continue;
                TreeUINode tcnSub = NoteImportTreeCtrl.newTreeNode((Object)category, (String)names[i], (String)alias[i]);
                this.getTreeUI().addChildNode(tcnSub, node);
            }
        }
    }

    private static class NoteImportFromFileModel
    extends AImportFromFileModel {
        private NoteImportFromFileModel() {
        }

        protected boolean isPersistentAttrs() {
            return false;
        }
    }

    class NoteImportStep
    extends ImportFromFileStep {
        public NoteImportStep(ICopyBetweenStorage context) {
            this.pane = new NoteImportFromFilePane(context);
        }

        public void intoThisStep(IWizardStep prevStep, boolean isOppose) {
            this.manager.setFinishEnabled(true);
            this.manager.setNextStepEnabled(false);
        }

        public IWizardStep outThisStep(boolean isOppose) {
            TreeUINode tnFrom = this.getFromTreeNode();
            if (!tnFrom.isChecked()) {
                WindowUtil.msgboxWarning((Object)MultiLanguageUtil.getMLS("actions.ActionImport.selectSource"), (String)MultiLanguageUtil.getMLS("actions.ActionImport.importObject"), (Component)ActionImport.this.getTreeUI());
                return this;
            }
            ActionImport.this.copyWithUI(this.getPaneModel().getFromStorage(), (IBizContent)ActionImport.this.getBizStorage(), tnFrom, ActionImport.this.getBizStorageTreeCtrl().makePathText(ActionImport.this.getTreeUI().getSelectionPath()));
            return null;
        }

        class NoteImportFromFilePane
        extends ImportFromFileStep.ImportFromFilePane {
            public NoteImportFromFilePane(ICopyBetweenStorage context) {
                super(context);
            }

            protected ICopyBetweenStorage getModel() {
                if (this.model == null) {
                    this.model = new NoteImportFromFileModel();
                }
                return this.model;
            }

            protected CommonBizStorageTreeCtrl createBizStorageTreeCtrl(ICopyBetweenStorage model) {
                NoteImportTreeCtrl ctrl = new NoteImportTreeCtrl(this.getModel().getFromStorage());
                ctrl.getTreeUI().setCheckboxMode(true);
                ctrl.getTreeUI().getRootNode().setAlias(this.getModel().getFromPath());
                ctrl.getTreeUI().expandRoot();
                return ctrl;
            }
        }
    }

    private static class ImportFileFilter
    extends FileFilter {
        private ImportFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            return f.getName().endsWith(ActionImport.R1TemplatePostfix) || f.getName().endsWith(ActionImport.TemplatePostfix);
        }

        @Override
        public String getDescription() {
            return "All template(*.r1-print; *.kdrs-form)";
        }
    }
}

