/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.report.forapp.kdnote.client.util;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.PathUtil;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.data.meta.MetaLibrary;
import com.kingdee.bos.ctrl.data.modal.io.Meta2CommonQuery;
import com.kingdee.bos.ctrl.kdf.fd2.data.DefaultDataManager;
import com.kingdee.bos.ctrl.kdf.fd2.data.IDataManager;
import com.kingdee.bos.ctrl.kdf.fd2.data.IMetaManager;
import com.kingdee.bos.ctrl.kdf.fd2.gui.FormDesigner;
import com.kingdee.bos.ctrl.kdf.fd2.gui.KDFFrame;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.report.impl.r1note.dynquery.exception.NoteDynQuery_LoadException;
import com.kingdee.bos.ctrl.report.impl.r1note.dynquery.exception.NoteDynQuery_MainQueryParseException;
import com.kingdee.bos.ctrl.report.impl.r1note.dynquery.exec.NoteDynQuery2Bos;
import com.kingdee.bos.ctrl.report.impl.r1note.dynquery.model.NoteDynQueryModel;
import com.kingdee.bos.ctrl.report.impl.r1note.specialdata.INoteSpecialData;
import com.kingdee.bos.ctrl.report.impl.r1note.specialdata.NoteSpecialDatas;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.IBizContent;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.DataExtend;
import com.kingdee.bos.ctrl.reportone.r1.print.data.SystemR1PrintDataSource;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.model.R1PrintModelHelper;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.RuntimeModel;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.exception.R1PrintRuntimeException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.jdom2.Element;

public class NoteDataUtil {
    public static final String MetaInfoPrefix_BOSQuery = "::";
    public static final String MetaInfoPrefix_DynQuery = "dynquery://";
    public static final String MetaInfoPrefix_Special = "special://";

    public static void autoCreateQuery(FormDesigner designer) {
        IDataManager idm;
        KDFFrame frame = designer.getKDFFrame();
        if (frame != null && (idm = frame.getReport().getDataManager()) instanceof DefaultDataManager) {
            DefaultDataManager dm = (DefaultDataManager)idm;
            IMetaManager mm = designer.getMetaManager();
            if (mm != null && mm.getMetaData() != null) {
                dm.setData(Meta2CommonQuery.metaLib2CommonQueries((MetaLibrary)mm.getMetaData()));
                designer.updataQueryTree(frame);
            }
        }
    }

    public static String checkMetaCategoryFromInfo(String info) {
        if (info.startsWith(MetaInfoPrefix_BOSQuery)) {
            return MetaInfoPrefix_BOSQuery;
        }
        if (info.startsWith(MetaInfoPrefix_DynQuery)) {
            return MetaInfoPrefix_DynQuery;
        }
        if (info.startsWith(MetaInfoPrefix_Special)) {
            return MetaInfoPrefix_Special;
        }
        return null;
    }

    public static String cutMetaInfoPrefix(String info) {
        if (info.startsWith(MetaInfoPrefix_BOSQuery)) {
            return info.substring(MetaInfoPrefix_BOSQuery.length());
        }
        if (info.startsWith(MetaInfoPrefix_DynQuery)) {
            return info.substring(MetaInfoPrefix_DynQuery.length());
        }
        if (info.startsWith(MetaInfoPrefix_Special)) {
            return info.substring(MetaInfoPrefix_Special.length());
        }
        return info;
    }

    public static String getMetaCategoryPrompt(String info) {
        if (info.startsWith(MetaInfoPrefix_BOSQuery)) {
            return MultiLanguageUtil.getMLS("util.NoteDataUtil.BOSQuery");
        }
        if (info.startsWith(MetaInfoPrefix_DynQuery)) {
            return MultiLanguageUtil.getMLS("util.NoteDataUtil.dynQuery");
        }
        if (info.startsWith(MetaInfoPrefix_Special)) {
            return MultiLanguageUtil.getMLS("util.NoteDataUtil.special");
        }
        return MultiLanguageUtil.getMLS("util.NoteDataUtil.normal");
    }

    public static String getMetaPrompt(String info) {
        String pureInfo;
        StringBuffer sb = new StringBuffer();
        sb.append(NoteDataUtil.getMetaCategoryPrompt(info));
        String category = NoteDataUtil.checkMetaCategoryFromInfo(info);
        if (category == MetaInfoPrefix_Special) {
            pureInfo = NoteDataUtil.cutMetaInfoPrefix(info);
            INoteSpecialData nsd = NoteSpecialDatas.getSpecialData(pureInfo);
            if (nsd != null) {
                pureInfo = nsd.getAlias();
            }
        } else {
            pureInfo = category == MetaInfoPrefix_BOSQuery ? NoteDataUtil.decodeDirectReferenceInfo(info) : NoteDataUtil.cutMetaInfoPrefix(info);
        }
        sb.append("--");
        sb.append(pureInfo);
        return sb.toString();
    }

    public static String decodeDirectReferenceInfo(String info) {
        if ((info = info.substring(3)).endsWith(".bos-query")) {
            int endIdx = info.length() - 10;
            info = info.substring(0, endIdx);
        }
        info = info.replace('/', '.');
        return info;
    }

    public static String encodeDirectReferenceInfo(String info) {
        info = info.replaceAll("\\.", "/");
        info = new StringBuffer("::/" + info + ".bos-query").toString();
        return info;
    }

    public static class R1RuntimeDsInfoCreator
    implements RuntimeModel.IRtDsInfoCreator {
        private static final Logger log = LogUtil.getPackageLogger(R1RuntimeDsInfoCreator.class);
        private IReferenceResourceLoader resourceLoader;
        private String templatePath;

        public R1RuntimeDsInfoCreator(IReferenceResourceLoader resourceLoader, String templatePath) {
            this.resourceLoader = resourceLoader;
            this.templatePath = templatePath;
        }

        public SystemR1PrintDataSource createDsInfo(DataExtend dataExt) {
            SystemR1PrintDataSource dsInfo = new SystemR1PrintDataSource();
            dsInfo.setId(dataExt.getName());
            String pathInfo = dataExt.getInfo();
            if (pathInfo != null) {
                if (pathInfo.startsWith(NoteDataUtil.MetaInfoPrefix_DynQuery)) {
                    this.initDynQueryDsInfo(dsInfo, pathInfo);
                } else if (pathInfo.startsWith(NoteDataUtil.MetaInfoPrefix_BOSQuery)) {
                    dsInfo.setReference(NoteDataUtil.decodeDirectReferenceInfo(pathInfo));
                } else if (pathInfo.startsWith(NoteDataUtil.MetaInfoPrefix_Special)) {
                    String name = NoteDataUtil.cutMetaInfoPrefix(pathInfo);
                    INoteSpecialData specialData = NoteSpecialDatas.getSpecialData(name);
                    if (specialData == null) {
                        throw new R1PrintRuntimeException("Invalid special data: " + name);
                    }
                    specialData.initRuntimeInfo(dsInfo);
                }
            }
            dsInfo.setSortFields(R1PrintModelHelper.getDataSorts((DataExtend)dataExt));
            Object dpcn = dataExt.getProperty("processClassName");
            if (dpcn != null) {
                dsInfo.setProcessClassName(dpcn.toString());
            }
            return dsInfo;
        }

        private void initDynQueryDsInfo(SystemR1PrintDataSource dsInfo, String pathInfo) {
            InputStream inputStream;
            String fileName = pathInfo.substring(NoteDataUtil.MetaInfoPrefix_DynQuery.length());
            try {
                inputStream = this.resourceLoader.load(this.templatePath, fileName);
            }
            catch (Exception e) {
                throw new R1PrintRuntimeException(MultiLanguageUtil.getMLS("util.NoteDataUtil.exception1"), (Throwable)e);
            }
            Element xml = null;
            try {
                xml = XmlUtil.loadXmlStream((InputStream)inputStream);
            }
            catch (Exception e) {
                throw new R1PrintRuntimeException(MultiLanguageUtil.getMLS("util.NoteDataUtil.exception2"), (Throwable)e);
            }
            finally {
                this.closeInputStream(inputStream);
            }
            NoteDynQueryModel model = null;
            try {
                model = NoteDynQueryModel.fromXml(xml);
            }
            catch (NoteDynQuery_MainQueryParseException e) {
                throw new R1PrintRuntimeException(MultiLanguageUtil.getMLS("util.NoteDataUtil.exception3"), (Throwable)e);
            }
            catch (NoteDynQuery_LoadException e) {
                log.error((Object)"\u89e3\u6790\u6a21\u677f\u5f15\u7528\u7684\u52a8\u6001\u67e5\u8be2\u6587\u4ef6\u5931\u8d25", (Throwable)e);
                model = e.getInvalidModel();
            }
            if (model != null) {
                NoteDynQuery2Bos model2Bos = new NoteDynQuery2Bos(model);
                EntityViewInfo bosEntityView = model2Bos.toEntityViewInfo();
                dsInfo.setReference(model.getMainQueryPath());
                dsInfo.setDynamicQueryInfo(bosEntityView);
            }
        }

        private void closeInputStream(InputStream inputStream) {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                log.error((Object)"Can not close input stream.", (Throwable)e);
            }
        }
    }

    public static class OfflineReferenceResourceLoader
    implements IReferenceResourceLoader {
        @Override
        public InputStream load(String templatePath, String refName) throws Exception {
            File templateFile = new File(templatePath);
            File refFile = new File(templateFile.getParent() + "/" + refName);
            FileInputStream inputStream = new FileInputStream(refFile);
            return inputStream;
        }
    }

    public static class DefaultReferenceResourceLoader
    implements IReferenceResourceLoader {
        private IBizContent bizContent;

        public DefaultReferenceResourceLoader(IBizContent bizContent) {
            this.bizContent = bizContent;
        }

        @Override
        public InputStream load(String templatePath, String refName) throws Exception {
            String refPath = PathUtil.makeSiblingPath((String)templatePath, (String)refName);
            String absRefPath = PathUtil.makeChildPath((String)"/EAS_Note.kdrs", (String)refPath);
            byte[] bytes = this.bizContent.readTemplate(absRefPath);
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            return bais;
        }
    }

    public static interface IReferenceResourceLoader {
        public InputStream load(String var1, String var2) throws Exception;
    }
}

