/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.headfootdesigner;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleParser;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import java.io.Serializable;
import org.jdom2.Content;
import org.jdom2.Element;

public class HeadFootRow
implements Serializable {
    private static final long serialVersionUID = 1255340217252535483L;
    private String text;
    private String originText;
    private StyleAttributes sa;

    public HeadFootRow() {
        this("");
    }

    public HeadFootRow(String text) {
        this(text, Styles.getDefaultSA());
    }

    public HeadFootRow(String text, StyleAttributes sa) {
        this.setText(text);
        this.setSA(sa);
    }

    public StyleAttributes getSA() {
        return this.sa;
    }

    public String getText() {
        return this.text;
    }

    public void setSA(StyleAttributes sa) {
        this.sa = sa;
    }

    public void setText(String string) {
        this.text = string;
        this.originText = null;
    }

    public String toString() {
        return this.getOriginText();
    }

    public int hashCode() {
        return this.text.hashCode() ^ this.sa.hashCode();
    }

    public boolean equals(Object o) {
        HeadFootRow r;
        return o instanceof HeadFootRow && (r = (HeadFootRow)o).getText().equals(this.getText()) && r.getSA().equals((Object)this.getSA());
    }

    public Object clone() {
        HeadFootRow newRow = new HeadFootRow();
        newRow.setText(this.getText());
        newRow.setOriginText(this.originText);
        newRow.setSA(Styles.getSA((ShareStyleAttributes)(this.getSA() == null ? Styles.getDefaultSSA() : this.getSA())));
        return newRow;
    }

    public Element writeToXmlNode(String rowName) {
        Element eleRow = new Element("HeadFootRow");
        eleRow.setAttribute("id", rowName);
        Element eleStyle = StyleParser.getStyleElement((ShareStyleAttributes)this.getSA(), (String)(rowName + "_Style"), null);
        Element eleText = new Element("Text");
        eleText.setAttribute("id", rowName + "_Text");
        eleText.addContent(this.getOriginText());
        eleRow.addContent((Content)eleText);
        eleRow.addContent((Content)eleStyle);
        return eleRow;
    }

    public boolean readFromXmlNode(Element eleRow) {
        if (eleRow.getName().equals("HeadFootRow")) {
            String text2 = eleRow.getChildText("Text");
            StyleAttributes sa2 = StyleParser.parseDefSA((Element)eleRow.getChild("Style"));
            this.setText(text2);
            this.setOriginText(text2);
            this.setSA(sa2);
            return true;
        }
        return false;
    }

    public void setOriginText(String originText) {
        this.originText = originText;
    }

    public String getOriginText() {
        if (StringUtil.isEmptyString((String)this.originText)) {
            return this.getText();
        }
        return this.originText;
    }
}

