/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.config;

import com.kingdee.bos.ctrl.print.config.AbstractXmlTranslate;
import com.kingdee.bos.ctrl.print.config.IConfigModel;
import com.kingdee.bos.ctrl.print.config.IXmlTranslate;
import com.kingdee.bos.ctrl.print.config.PrintJobConfig;
import java.util.Map;
import org.jdom2.Content;
import org.jdom2.Element;

public class PrintJobConfigXml
extends AbstractXmlTranslate {
    public static String NAME = "printjob";
    public static String CHILD_DynamicPaper = "dynamicpaper";

    public PrintJobConfigXml(IConfigModel model) {
        super(model);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Element toXmlElement() {
        this.createRoot(this.model);
        int pageCount = ((PrintJobConfig)this.model).printJob.getPageCount();
        PrintJobConfigXml.setAttribute(this.rootElement, "pageCount", pageCount);
        this.toChildModelXmlElement();
        this.toDynamicPaper(((PrintJobConfig)this.model).isDynamicPaper());
        return this.rootElement;
    }

    private void toChildModelXmlElement() {
        PrintJobConfig printModel = (PrintJobConfig)this.model;
        Map configPanes = printModel.getConfigPanes();
        for (Object key : configPanes.keySet()) {
            IXmlTranslate xmlranslate;
            PrintJobConfig.OneConfigPage page = (PrintJobConfig.OneConfigPage)configPanes.get(key);
            IConfigModel model = page.getConfigModel();
            if (model == null || !page.isVisible() || (xmlranslate = model.createXmlTrans()) == null) continue;
            Element childElement = xmlranslate.toXmlElement();
            this.rootElement.addContent((Content)childElement);
        }
    }

    private void toDynamicPaper(boolean isFrugal) {
        Element e = PrintJobConfigXml.createElement(CHILD_DynamicPaper);
        e.setText(String.valueOf(isFrugal));
        this.rootElement.addContent((Content)e);
    }

    @Override
    public Object fromXmlElement(Element element) {
        if (element == null) {
            return null;
        }
        if (!element.getName().equals(NAME)) {
            element = element.getChild(NAME);
        }
        if (!element.getName().equals(NAME)) {
            element = element.getChild(NAME);
            return null;
        }
        PrintJobConfig printModel = (PrintJobConfig)this.model;
        this.fromDynamicPaper(PrintJobConfigXml.getChild(element, CHILD_DynamicPaper));
        Map configPanes = printModel.getConfigPanes();
        for (Object key : configPanes.keySet()) {
            Element child;
            IXmlTranslate xmlranslate;
            PrintJobConfig.OneConfigPage page = (PrintJobConfig.OneConfigPage)configPanes.get(key);
            IConfigModel model = page.getConfigModel();
            if (model == null) {
                page.createModel();
            }
            if ((model = page.getConfigModel()) == null || !page.isVisible() || (xmlranslate = model.createXmlTrans()) == null || (child = PrintJobConfigXml.getChild(element, xmlranslate.getName())) == null) continue;
            xmlranslate.fromXmlElement(child);
        }
        return this;
    }

    private void fromDynamicPaper(Element child) {
        PrintJobConfig configModel = (PrintJobConfig)this.model;
        if (child == null) {
            configModel.setDynamicPaper(false);
        } else {
            String text = child.getText();
            if (text != null) {
                configModel.setDynamicPaper(text.equals("true"));
            }
        }
    }
}

