/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.config.extendui;

import com.kingdee.bos.ctrl.print.config.IConfigModel;
import com.kingdee.bos.ctrl.print.config.PrintJobConfig;
import com.kingdee.bos.ctrl.print.config.extendui.ITextUI;
import com.kingdee.bos.ctrl.print.config.extendui.TablePageSetupModel;
import com.kingdee.bos.ctrl.print.config.ui.AbstractConfigUI;
import com.kingdee.bos.ctrl.print.config.ui.SunPrintConfigDialog;
import com.kingdee.bos.ctrl.print.resource.Resources2;
import com.kingdee.bos.ctrl.print.resource.TableResources;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDOptionPane;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TablePageSetupUI
extends AbstractConfigUI {
    private static final long serialVersionUID = 4456203782951999448L;
    private static final int PAGE_W = 410;
    private static final int GAP = 5;
    private ITextUI printAreas;
    private ITextUI topTitleRows;
    private ITextUI leftTitleColumns;
    private KDCheckBox isGrid;
    private KDCheckBox isSingleColor;
    private KDCheckBox isRowIndex;
    private KDCheckBox isColumnIndex;
    private KDRadioButton order_column;
    private KDRadioButton order_row;
    private KDCheckBox chkVerEconomizePaper;
    private KDCheckBox chkHorEconomizePaper;
    private KDSpinner spnVerPageSpace;
    private KDSpinner spnHorPageSpace;
    public static int SELECT_ALL = 0;
    public static int SELECT_ROW = 1;
    public static int SELECT_COLUMN = 2;

    @Override
    public void init(PrintJobConfig manager, String uniqueName) {
        super.init(manager, uniqueName);
        PrintAreaPanel pnlArea = new PrintAreaPanel();
        PrintTitle pnlTitle = new PrintTitle();
        PrintOptionPanel pnlOption = new PrintOptionPanel();
        OrderPanel pnlOrder = new OrderPanel();
        EconomizePanel pnlEco = new EconomizePanel();
        this.setLayout(null);
        this.add((Component)((Object)pnlArea));
        this.add((Component)((Object)pnlTitle));
        this.add((Component)((Object)pnlOption));
        this.add((Component)((Object)pnlOrder));
        this.add((Component)((Object)pnlEco));
        int x = 5;
        int y = 5;
        int h = pnlArea.getPreferredSize().height;
        int w = 400;
        pnlArea.setBounds(x, y, w, h);
        y = y + h + 5;
        h = pnlTitle.getPreferredSize().height;
        pnlTitle.setBounds(x, y, w, h);
        y = y + h + 5;
        h = pnlOption.getPreferredSize().height;
        pnlOption.setBounds(x, y, w, h);
        y = y + h + 5;
        pnlOrder.setBounds(x, y, w - 270, pnlOrder.getPreferredSize().height);
        x = x + pnlOrder.getWidth() + 5;
        pnlEco.setBounds(x, y, w - x + 5, pnlEco.getPreferredSize().height);
        this.setPreferredSize(new Dimension(425, 350));
    }

    @Override
    public IConfigModel createConfigModel() {
        return new TablePageSetupModel();
    }

    @Override
    public void updateConfigToUI() {
        TablePageSetupModel model = (TablePageSetupModel)this.config;
        this.printAreas.setText(model.getPrintAreas());
        this.topTitleRows.setText(model.getTopTitleRows());
        this.leftTitleColumns.setText(model.getLeftTitleColumns());
        this.isGrid.setSelected(model.isGrid());
        this.isSingleColor.setSelected(model.isSingleColor());
        this.isRowIndex.setSelected(model.isRowIndex());
        this.isColumnIndex.setSelected(model.isColumnIndex());
        this.order_column.setSelected(model.getOrder());
        this.order_row.setSelected(!model.getOrder());
        this.chkVerEconomizePaper.setSelected(model.isVerEconomizePaper());
        this.chkHorEconomizePaper.setSelected(model.isHorEconomizePaper());
        this.spnVerPageSpace.setValue((Object)new Integer(model.getVerSpace()));
        this.spnHorPageSpace.setValue((Object)new Integer(model.getHorSpace()));
    }

    @Override
    public void approve() {
        TablePageSetupModel model = (TablePageSetupModel)this.config;
        model.resetChange();
        model.setPrintAreas(this.printAreas.getText());
        model.setTopTitleRows(this.topTitleRows.getText());
        model.setLeftTitleColumns(this.leftTitleColumns.getText());
        model.setGrid(this.isGrid.isSelected());
        model.setSingleColor(this.isSingleColor.isSelected());
        model.setRowIndex(this.isRowIndex.isSelected());
        model.setColumnIndex(this.isColumnIndex.isSelected());
        model.setOrder(this.order_column.isSelected());
        model.setVerEconomizePaper(this.chkVerEconomizePaper.isSelected());
        model.setHorEconomizePaper(this.chkHorEconomizePaper.isSelected());
        model.setVerSpace(this.spnVerPageSpace.getIntegerVlaue());
        model.setHorSpace(this.spnHorPageSpace.getIntegerVlaue());
        this.manager.setChange(model.isChange());
    }

    private void checkRowColSelectString(Object source, int type) {
        final KDTextField textfield = (KDTextField)source;
        String text = textfield.getText();
        if (text != null && !text.equals("")) {
            boolean isValid = TablePageSetupModel.isValidColRowSelectString(text = text.toUpperCase(), type);
            if (!isValid) {
                String str = type == 0 ? TablePageSetupUI.getMsg2("prompt.tablearea_error0") : (type == 1 ? TablePageSetupUI.getMsg2("prompt.tablearea_error1") : TablePageSetupUI.getMsg2("prompt.tablearea_error2"));
                KDOptionPane.showMessageDialog((Component)((Object)this), (Object)str);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        textfield.grabFocus();
                        textfield.selectAll();
                    }
                });
            } else {
                textfield.setText(text);
            }
        }
    }

    private static String getMsg(String key) {
        return TableResources.getMsg(key);
    }

    private static String getMsg2(String key) {
        return Resources2.getMsg(key);
    }

    public ITextUI createTextUI(int length, int type) {
        return new MyKDTextField(length);
    }

    class MyKDTextField
    extends KDTextField
    implements ITextUI {
        public MyKDTextField(int i) {
            super(i);
        }
    }

    private class EconomizePanel
    extends KDPanel {
        private static final long serialVersionUID = 7079672959041898265L;
        private final String strTitle = TablePageSetupUI.access$000("border.economizeTitle");

        public EconomizePanel() {
            this.setOpaque(false);
            this.setLayout(null);
            this.setBorder(BorderFactory.createTitledBorder(this.strTitle));
            int chkWidth = 100;
            int spnWidth = 130;
            TablePageSetupUI.this.chkHorEconomizePaper = new KDCheckBox(TablePageSetupUI.getMsg("checkbox.horEconomizePaper"));
            TablePageSetupUI.this.chkHorEconomizePaper.setBounds(10, 20, chkWidth, ((TablePageSetupUI)TablePageSetupUI.this).chkHorEconomizePaper.getPreferredSize().height);
            TablePageSetupUI.this.chkHorEconomizePaper.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    TablePageSetupUI.this.spnHorPageSpace.setEnabled(((KDCheckBox)e.getSource()).isSelected());
                    TablePageSetupUI.this.chkVerEconomizePaper.setSelected(false);
                }
            });
            TablePageSetupUI.this.spnHorPageSpace = new KDSpinner((SpinnerModel)new SpinnerNumberModel(0, -100, 10000, 1));
            TablePageSetupUI.this.spnHorPageSpace.setEnabled(TablePageSetupUI.this.chkHorEconomizePaper.isSelected());
            KDLabelContainer lbcHorPageSpace = CtrlSwingUtilities.createLabelContainer((JComponent)TablePageSetupUI.this.spnHorPageSpace, (String)TablePageSetupUI.getMsg("label.horPageSpace"), (int)50);
            lbcHorPageSpace.setBounds(20 + chkWidth, 20, spnWidth, lbcHorPageSpace.getPreferredSize().height);
            TablePageSetupUI.this.chkVerEconomizePaper = new KDCheckBox(TablePageSetupUI.getMsg("checkbox.verEconomizePaper"));
            TablePageSetupUI.this.chkVerEconomizePaper.setBounds(10, 20 + TablePageSetupUI.this.chkHorEconomizePaper.getHeight(), chkWidth, ((TablePageSetupUI)TablePageSetupUI.this).chkVerEconomizePaper.getPreferredSize().height);
            TablePageSetupUI.this.chkVerEconomizePaper.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    TablePageSetupUI.this.spnVerPageSpace.setEnabled(((KDCheckBox)e.getSource()).isSelected());
                    TablePageSetupUI.this.chkHorEconomizePaper.setSelected(false);
                }
            });
            TablePageSetupUI.this.spnVerPageSpace = new KDSpinner((SpinnerModel)new SpinnerNumberModel(0, -100, 10000, 1));
            TablePageSetupUI.this.spnVerPageSpace.setEnabled(TablePageSetupUI.this.chkVerEconomizePaper.isSelected());
            KDLabelContainer lbcVerPageSpace = CtrlSwingUtilities.createLabelContainer((JComponent)TablePageSetupUI.this.spnVerPageSpace, (String)TablePageSetupUI.getMsg("label.verPageSpace"), (int)50);
            lbcVerPageSpace.setBounds(20 + chkWidth, 28 + lbcHorPageSpace.getPreferredSize().height, spnWidth, lbcVerPageSpace.getPreferredSize().height);
            this.add((Component)TablePageSetupUI.this.chkHorEconomizePaper);
            this.add((Component)lbcHorPageSpace);
            this.add((Component)TablePageSetupUI.this.chkVerEconomizePaper);
            this.add((Component)lbcVerPageSpace);
            this.setPreferredSize(new Dimension(410, 80));
        }
    }

    private class OrderPanel
    extends KDPanel {
        private static final long serialVersionUID = 439649824833822650L;
        private final String strTitle = TablePageSetupUI.access$000("border.printorder");

        public OrderPanel() {
            this.setOpaque(false);
            this.setLayout(null);
            this.setBorder(BorderFactory.createTitledBorder(this.strTitle));
            ButtonGroup bg = new ButtonGroup();
            TablePageSetupUI.this.order_column = new KDRadioButton(TablePageSetupUI.getMsg("radiobutton.printordercol"));
            TablePageSetupUI.this.order_row = new KDRadioButton(TablePageSetupUI.getMsg("radiobutton.printorderrow"));
            bg.add((AbstractButton)TablePageSetupUI.this.order_column);
            bg.add((AbstractButton)TablePageSetupUI.this.order_row);
            this.add((Component)TablePageSetupUI.this.order_column);
            this.add((Component)TablePageSetupUI.this.order_row);
            int width = 100;
            TablePageSetupUI.this.order_column.setBounds(10, 25, width, ((TablePageSetupUI)TablePageSetupUI.this).order_column.getPreferredSize().height);
            TablePageSetupUI.this.order_row.setBounds(10, 30 + ((TablePageSetupUI)TablePageSetupUI.this).order_column.getPreferredSize().height, width, ((TablePageSetupUI)TablePageSetupUI.this).order_column.getPreferredSize().height);
            this.setPreferredSize(new Dimension(410, 80));
        }
    }

    private class PrintOptionPanel
    extends KDPanel {
        private static final long serialVersionUID = -2858909273912647306L;
        private final String strTitle = TablePageSetupUI.access$000("border.print");

        public PrintOptionPanel() {
            this.setOpaque(false);
            this.setLayout(null);
            this.setBorder(BorderFactory.createTitledBorder(this.strTitle));
            int x = 5;
            int y = 20;
            int lingGap = 3;
            int width = 200;
            TablePageSetupUI.this.isGrid = new KDCheckBox(TablePageSetupUI.getMsg("checkbox.gridline"));
            this.add((Component)TablePageSetupUI.this.isGrid);
            int heigh = ((TablePageSetupUI)TablePageSetupUI.this).isGrid.getPreferredSize().height;
            TablePageSetupUI.this.isGrid.setBounds(x, y, width, heigh);
            TablePageSetupUI.this.isSingleColor = new KDCheckBox(TablePageSetupUI.getMsg("checkbox.singleColor"));
            this.add((Component)TablePageSetupUI.this.isSingleColor);
            TablePageSetupUI.this.isSingleColor.setBounds(x, y += 20, width, heigh);
            TablePageSetupUI.this.isRowIndex = new KDCheckBox(TablePageSetupUI.getMsg("checkbox.rowindex"));
            this.add((Component)TablePageSetupUI.this.isRowIndex);
            x = width;
            y = 20;
            TablePageSetupUI.this.isRowIndex.setBounds(x, y, width, ((TablePageSetupUI)TablePageSetupUI.this).isRowIndex.getPreferredSize().height);
            TablePageSetupUI.this.isColumnIndex = new KDCheckBox(TablePageSetupUI.getMsg("checkbox.colindex"));
            this.add((Component)TablePageSetupUI.this.isColumnIndex);
            TablePageSetupUI.this.isColumnIndex.setBounds(x, y += 20, width, heigh);
            y = y + heigh + lingGap;
            this.setPreferredSize(new Dimension(410, y + 2));
        }
    }

    private class PrintTitle
    extends KDPanel {
        private static final long serialVersionUID = 246016759149903470L;
        private final String strTitle = TablePageSetupUI.access$000("border.printtitle");

        public PrintTitle() {
            this.setOpaque(false);
            this.setLayout(SunPrintConfigDialog.LineLayout.LIGHTWEIGHT);
            this.setBorder(BorderFactory.createTitledBorder(this.strTitle));
            TablePageSetupUI.this.topTitleRows = TablePageSetupUI.this.createTextUI(15, SELECT_ROW);
            TablePageSetupUI.this.topTitleRows.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                }

                @Override
                public void focusLost(FocusEvent e) {
                    TablePageSetupUI.this.checkRowColSelectString(e.getSource(), 1);
                }
            });
            String str = TablePageSetupUI.getMsg2("label.topTitleRows");
            this.add((Component)((Object)SunPrintConfigDialog.L(str, (JComponent)((Object)TablePageSetupUI.this.topTitleRows))));
            TablePageSetupUI.this.leftTitleColumns = TablePageSetupUI.this.createTextUI(15, SELECT_COLUMN);
            TablePageSetupUI.this.leftTitleColumns.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                }

                @Override
                public void focusLost(FocusEvent e) {
                    TablePageSetupUI.this.checkRowColSelectString(e.getSource(), 2);
                }
            });
            str = TablePageSetupUI.getMsg2("label.leftTitleColumns");
            this.add((Component)((Object)SunPrintConfigDialog.L(str, (JComponent)((Object)TablePageSetupUI.this.leftTitleColumns))));
            this.setPreferredSize(new Dimension(410, 85));
        }
    }

    private class PrintAreaPanel
    extends KDPanel
    implements FocusListener {
        private static final long serialVersionUID = 6019076137722167319L;
        private final String strTitle = TablePageSetupUI.access$000("border.printarea");
        private final String strLabel = TablePageSetupUI.access$100("label.printarea");

        public PrintAreaPanel() {
            this.setOpaque(false);
            this.setLayout(SunPrintConfigDialog.LineLayout.LIGHTWEIGHT);
            this.setBorder(BorderFactory.createTitledBorder(this.strTitle));
            TablePageSetupUI.this.printAreas = TablePageSetupUI.this.createTextUI(15, SELECT_ALL);
            TablePageSetupUI.this.printAreas.addFocusListener(this);
            this.add((Component)((Object)SunPrintConfigDialog.L(this.strLabel + ":", (JComponent)((Object)TablePageSetupUI.this.printAreas))));
            this.setPreferredSize(new Dimension(410, 55));
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            TablePageSetupUI.this.checkRowColSelectString(e.getSource(), 0);
        }
    }
}

