/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.io;

import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootRow;
import com.kingdee.bos.ctrl.print.KDPrinter;
import com.kingdee.bos.ctrl.print.control.ControlPrint;
import com.kingdee.bos.ctrl.print.printjob.BufferPrintJob;
import com.kingdee.bos.ctrl.print.printjob.IPrintJob;
import com.kingdee.bos.ctrl.print.printjob.MultiBufferPrintJobs;
import com.kingdee.bos.ctrl.print.ui.component.HeaderFooter;
import com.kingdee.bos.ctrl.print.ui.component.Paper;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractExport {
    private List<String[]> headerRow;
    private List<String[]> footerRow;

    public void begin(String fileNamePre, KDPrinter printer) {
    }

    public void export(String fileNamePre, KDPrinter printer) {
        Paper paper;
        this.begin(fileNamePre, printer);
        ControlPrint cPrint = printer.getControlPrint();
        int index = 0;
        while ((paper = cPrint.getPaper(index)) != null) {
            this.addHeaderFooter(paper);
            this.exportPaper(paper, fileNamePre, index);
            ++index;
        }
        this.deleteTemplateFile(printer);
        this.end();
    }

    private void addHeaderFooter(Paper paper) {
        HeaderFooter footer;
        HeaderFooter header;
        if (paper.getHeader() instanceof HeaderFooter && (header = (HeaderFooter)paper.getHeader()) != null) {
            HeadFootModel headerModel = new HeadFootModel();
            List<HeadFootRow> headerList = null;
            headerList = null != this.headerRow ? this.wrapperHeaderFooter(this.headerRow) : header.getModel().getRowList();
            headerModel.setRowList(headerList);
            header.setModel(headerModel);
        }
        if (paper.getFooter() instanceof HeaderFooter && null != (footer = (HeaderFooter)paper.getFooter())) {
            HeadFootModel footerModel = new HeadFootModel();
            List<HeadFootRow> footerList = null;
            footerList = null != this.footerRow ? this.wrapperHeaderFooter(this.footerRow) : footer.getModel().getRowList();
            footerModel.setRowList(footerList);
            footer.setModel(footerModel);
        }
    }

    private List<HeadFootRow> wrapperHeaderFooter(List<String[]> list) {
        ArrayList<HeadFootRow> lst = new ArrayList<HeadFootRow>();
        HeadFootRow row = new HeadFootRow();
        String headerSB = this.headerFooter2Text(list);
        row.setText(headerSB);
        lst.add(row);
        return lst;
    }

    private String headerFooter2Text(List<String[]> list) {
        if (null == list) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            String[] str = list.get(i);
            if (str.length <= 0) continue;
            sb.append(str[0]);
            if (i >= list.size() - 1) continue;
            sb.append("&|");
        }
        return sb.toString();
    }

    public void setPrintSetup(List<String[]> headerRow, List<String[]> footerRow) {
        this.headerRow = headerRow;
        this.footerRow = footerRow;
    }

    private void deleteTemplateFile(KDPrinter printer) {
        MultiBufferPrintJobs jobs = (MultiBufferPrintJobs)printer.getPrintJob();
        int taskCount = jobs.getTaskCount();
        for (int i = 0; i < taskCount; ++i) {
            BufferPrintJob bjob;
            IPrintJob iprintJob = jobs.getPrintJobByPaperIndex(i);
            if (!(iprintJob instanceof BufferPrintJob) || (bjob = (BufferPrintJob)iprintJob).getPrintFileBuffer() == null) continue;
            bjob.getPrintFileBuffer().destroy();
        }
    }

    public void end() {
    }

    protected abstract void exportPaper(Paper var1, String var2, int var3);
}

