/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.io;

import com.kingdee.bos.ctrl.common.KDToolkit;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleUtil;
import com.kingdee.bos.ctrl.print.KDPrinter;
import com.kingdee.bos.ctrl.print.control.ControlPrint;
import com.kingdee.bos.ctrl.print.io.AbstractExportOS;
import com.kingdee.bos.ctrl.print.ui.component.Paper;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Graphics2D;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public class PdfExportOS
extends AbstractExportOS {
    OutputStream os;
    Document document;
    PdfContentByte pdfContentByte;
    ArrayList<OutputStream> list;

    public PdfExportOS() {
    }

    public PdfExportOS(ArrayList<OutputStream> list) {
        this.list = list;
    }

    @Override
    public void begin(String fileNamePre, KDPrinter printer) {
        try {
            ControlPrint cPrint = printer.getControlPrint();
            Paper paper = cPrint.getPaper(0);
            float width = paper.getWidth();
            float height = paper.getHeight();
            Rectangle rc = new Rectangle((float)StyleUtil.pixelToPt((long)((long)width)), (float)StyleUtil.pixelToPt((long)((long)height)));
            float topM = paper.getPainterInfo().getAttributeManager().getBodyTopMargin(1000);
            float bottomM = paper.getPainterInfo().getAttributeManager().getBodyBottomMargin(1000);
            float leftM = paper.getPainterInfo().getAttributeManager().getLeftMargin(1000);
            float rightM = paper.getPainterInfo().getAttributeManager().getRightMargin(1000);
            float topPt = (float)StyleUtil.lomToPt((double)(topM * 10.0f));
            float bottomPt = (float)StyleUtil.lomToPt((double)(bottomM * 10.0f));
            float leftPt = (float)StyleUtil.lomToPt((double)(leftM * 10.0f));
            float rightPt = (float)StyleUtil.lomToPt((double)(rightM * 10.0f));
            this.document = new Document(rc, leftPt, rightPt, topPt, bottomPt);
            this.os = new ByteArrayOutputStream();
            PdfWriter pdfWriter = PdfWriter.getInstance((Document)this.document, (OutputStream)this.os);
            this.document.open();
            this.pdfContentByte = pdfWriter.getDirectContent();
        }
        catch (DocumentException e) {
            throw new RuntimeException("PDF Document error:" + e.getMessage(), e);
        }
    }

    @Override
    protected void exportPaper(Paper paper, String fileNamePre, int index) {
        long width = (long)paper.getWidth();
        long height = (long)paper.getHeight();
        PdfTemplate pdftemplate = this.pdfContentByte.createTemplate((float)StyleUtil.pixelToPt((long)width), (float)StyleUtil.pixelToPt((long)height));
        Graphics2D graphics2d = pdftemplate.createGraphics((float)StyleUtil.pixelToPt((long)width), (float)StyleUtil.pixelToPt((long)height), (FontMapper)Style.DEFAULT_FONTMAPPERPLUS);
        graphics2d.scale(72.0 / (double)KDToolkit.getCurrentDpi(), 72.0 / (double)KDToolkit.getCurrentDpi());
        paper.painting(graphics2d, paper.getPainterInfo());
        graphics2d.dispose();
        pdftemplate.setWidth((float)StyleUtil.pixelToPt((long)width));
        pdftemplate.setHeight((float)StyleUtil.pixelToPt((long)height));
        this.pdfContentByte.addTemplate(pdftemplate, 0.0f, 0.0f);
        this.document.newPage();
    }

    @Override
    public void end() {
        try {
            this.document.close();
            this.os.flush();
            this.os.close();
            this.list.add(this.os);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public ArrayList<OutputStream> export(String fileNamePre, KDPrinter printer) {
        printer.getPrintJob().getPageCount();
        return super.export(fileNamePre, printer);
    }

    @Override
    public ArrayList<OutputStream> result() {
        return this.list;
    }
}

