/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.preview;

import com.kingdee.bos.ctrl.print.KDPreview;
import com.kingdee.bos.ctrl.print.KDPrinter;
import com.kingdee.bos.ctrl.print.preview.ButtonItem;
import com.kingdee.bos.ctrl.print.preview.CenterViewLayout;
import com.kingdee.bos.ctrl.print.preview.EditToolBar;
import com.kingdee.bos.ctrl.print.preview.KDPEditManager;
import com.kingdee.bos.ctrl.print.preview.MultiViewLayout;
import com.kingdee.bos.ctrl.print.preview.OnePaperUI;
import com.kingdee.bos.ctrl.print.preview.PrintTestDialog;
import com.kingdee.bos.ctrl.print.preview.SelectMultiPageDialog;
import com.kingdee.bos.ctrl.print.printjob.IPrintJob;
import com.kingdee.bos.ctrl.print.resource.Resources;
import com.kingdee.bos.ctrl.print.resource.Resources2;
import com.kingdee.bos.ctrl.print.ui.component.Page;
import com.kingdee.bos.ctrl.print.ui.component.Paper;
import com.kingdee.bos.ctrl.print.util.KDPrintUtil;
import com.kingdee.bos.ctrl.print.util.KDPrinterUtils;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.MatteBorder;

public class PreviewBody
extends JScrollPane {
    private static final long serialVersionUID = 4557374259659277118L;
    protected KDPreview preview;
    private JPanel contentPanel;
    private KDPrinter printer;
    private int paperIndex = 0;
    private boolean isPageModified = false;
    private int totalPageCount = -1;
    protected int[] multiViewRowCol = new int[]{1, 1};
    private int status = 0;
    private OnePaperUI activeUI = null;
    public static final int STATUS_ZOOM = 0;
    public static final int STATUS_EDIT = 1;
    public static final int STATUS_MARGIN = 2;
    private boolean zoomStatus = false;
    public static final boolean ZOOM_OUT = true;
    public static final boolean ZOOM_IN = false;
    private MultiViewLayout multiViewLayout = new MultiViewLayout(this);
    private CenterViewLayout centerViewLayout = new CenterViewLayout(this);
    protected ArrayList pagerUIList = new ArrayList();
    KDPEditManager editManager;
    String previewTitle = "  " + Resources.getMsg("dialog.printpreview") + " ";
    String di = " " + Resources.getMsg("label.strdi") + " ";
    String strpage = " " + Resources.getMsg("label.strpage") + " ";
    String strtotal = "  " + Resources.getMsg("label.strtotal") + " ";
    private boolean isZoomFirstShow = true;

    public PreviewBody(KDPreview preview) {
        this.preview = preview;
        this.printer = preview.getPrinter();
        this.init();
    }

    public KDPEditManager getEditManager() {
        if (this.editManager == null) {
            this.editManager = new KDPEditManager();
        }
        this.editManager.setOnePaneUI(this.activeUI);
        return this.editManager;
    }

    private void init() {
        this.getVerticalScrollBar().setUnitIncrement(15);
        this.getHorizontalScrollBar().setUnitIncrement(15);
        this.contentPanel = new KDPanel();
        this.getViewport().setView(this.contentPanel);
        this.getViewport().setScrollMode(2);
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        this.contentPanel.setBackground(Color.GRAY);
        this.getActionMap().put("export", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreviewBody.this.exportKDP();
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke(69, 128), "export");
        this.getActionMap().put("import", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreviewBody.this.importKDP();
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke(73, 128), "import");
    }

    public void setToolbarConfigXmlUrl(String url) {
    }

    public void setPageCount(int pageCount) {
        this.totalPageCount = pageCount;
        if (this.activeUI != null) {
            this.refresh();
        }
    }

    public void setPageModified(boolean isModify) {
        this.isPageModified = isModify;
    }

    public void firstShow() {
        this.status = 0;
        if (this.activeUI != null) {
            this.contentPanel.remove((Component)((Object)this.activeUI));
        }
        this.activeUI = new OnePaperUI(this.printer, this);
        this.paperIndex = 0;
        this.updatePaper();
        this.contentPanel.add((Component)((Object)this.activeUI));
        this.activeUI.validate();
        this.updateNumberOfPages();
        if (this.isZoomFirstShow) {
            this.zoomOut();
        }
    }

    public void updateNumberOfPages() {
        Thread thread = new Thread(){

            @Override
            public void run() {
                int pageCount = PreviewBody.this.printer.getPrintJob().getPageCount();
                PreviewBody.this.setPageCount(pageCount);
                if (pageCount > 0 && PreviewBody.this.activeUI != null) {
                    PreviewBody.this.activeUI.repaint();
                }
            }
        };
        thread.start();
    }

    public KDPrinter getPrinter() {
        return this.printer;
    }

    public int getStatus() {
        return this.status;
    }

    public void setViewStatus(int s) {
        this.status = s;
    }

    public void setActiveUI(OnePaperUI ui) {
        this.activeUI = ui;
        MatteBorder border1 = BorderFactory.createMatteBorder(1, 1, 2, 2, Color.DARK_GRAY);
        int size = this.pagerUIList.size();
        for (int i = 0; i < size; ++i) {
            OnePaperUI oui = (OnePaperUI)((Object)this.pagerUIList.get(i));
            oui.setBorder(border1);
        }
        MatteBorder border2 = BorderFactory.createMatteBorder(1, 1, 1, 1, Color.YELLOW);
        this.activeUI.setBorder(BorderFactory.createCompoundBorder(border2, border1));
        this.paperIndex = this.activeUI.getPaper().getIndex();
        this.reflushStatusBar();
    }

    public OnePaperUI getActiveUI() {
        return this.activeUI;
    }

    public boolean getZoomStatus() {
        return this.zoomStatus;
    }

    public void zoomUI(Point mouseP) {
        if (this.zoomStatus) {
            this.zoomIn(mouseP);
        } else {
            this.zoomOut();
        }
        this.validate();
    }

    private void zoomOut() {
        this.zoomStatus = true;
        if (this.pagerUIList.size() == 0) {
            this.pagerUIList.add(this.activeUI);
        }
        this.contentPanel.setPreferredSize(null);
        this.contentPanel.setLayout(this.multiViewLayout);
    }

    private void zoomIn(Point mouseP) {
        this.zoomStatus = false;
        Point pLocation = this.getActiveUI().getLocation();
        double scale = this.getActiveUI().getScale();
        int lastClicX = pLocation.x + mouseP.x;
        int lastClickY = pLocation.y + mouseP.y;
        this.getActiveUI().setScale(1.0);
        Dimension pSize = this.getActiveUI().getPreferredSize();
        int pWidth = pSize.width * 2;
        int pHeight = pSize.height * 2;
        this.contentPanel.setPreferredSize(new Dimension(pWidth, pHeight));
        this.contentPanel.setSize(pWidth, pHeight);
        int size = this.pagerUIList.size();
        for (int i = 0; i < size; ++i) {
            OnePaperUI ui = (OnePaperUI)((Object)this.pagerUIList.get(i));
            ui.setVisible(false);
        }
        this.getActiveUI().setVisible(true);
        this.contentPanel.setLayout(this.centerViewLayout);
        Point newPoint = this.countCenter(this.contentPanel, this.getActiveUI());
        int scollX = newPoint.x + (int)((double)(mouseP.x * 1) / scale);
        int scollY = newPoint.y + (int)((double)(mouseP.y * 1) / scale);
        int vX = scollX - lastClicX;
        int vY = scollY - lastClickY;
        this.getViewport().setViewPosition(new Point(vX, vY));
        this.preview.getPreviewBar().scaleTextField.setText("100%");
    }

    protected void zoomView(ButtonItem buttonItem, Object value) {
        int[] temp = new int[]{1, 1};
        this.multiViewRowCol = temp;
        int size = this.pagerUIList.size();
        for (int i = 0; i < size; ++i) {
            OnePaperUI ui = (OnePaperUI)((Object)this.pagerUIList.get(i));
            this.contentPanel.remove((Component)((Object)ui));
        }
        this.pagerUIList.clear();
        if (this.activeUI != null) {
            this.activeUI.setScale((Double)value);
            this.contentPanel.add((Component)((Object)this.activeUI));
        }
        this.preview.getPreviewBar().scaleTextField.setEditable(true);
        this.contentPanel.setLayout(new FlowLayout());
        this.validate();
        this.contentPanel.repaint();
    }

    protected void importKDP() {
        try {
            KDPrinter newPrinter = new KDPrinter();
            newPrinter.getIOManager().importFromKDP();
            newPrinter.preParePrint();
            newPrinter.setParentWindow(this);
            newPrinter.printPreview();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void exportKDP() {
        try {
            this.saveCurrentPage();
            this.printer.getIOManager().exportToKDP(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void exportPDF() {
        try {
            KDFileChooser chooser = new KDFileChooser();
            int result = chooser.showOpenDialog(this.printer.getParentWindow());
            if (result == 0) {
                String filename = chooser.getSelectedFile().getAbsolutePath();
                if (!filename.toLowerCase().endsWith(".pdf")) {
                    filename = filename + ".pdf";
                }
                this.printer.getIOManager().exportToPdf(filename);
                this.open(filename);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    protected void open(String filename) throws IOException {
        if (PreviewBody.isWindowsPlatform()) {
            String cmd = "cmd /c start " + filename.replace(" ", "\" \"");
            Runtime.getRuntime().exec(cmd);
        } else if (PreviewBody.isMacOSPlatform()) {
            String[] cmdArray = new String[]{"open", filename};
            Runtime.getRuntime().exec(cmdArray);
        } else {
            String[] cmdArray = new String[]{"xdg-open", filename};
            Runtime.getRuntime().exec(cmdArray);
        }
    }

    public static boolean isMacOSPlatform() {
        String osname = System.getProperty("os.name");
        return osname != null && !osname.trim().isEmpty() && osname.startsWith("Mac OS");
    }

    public static boolean isWindowsPlatform() {
        String osname = System.getProperty("os.name");
        return osname != null && !osname.trim().isEmpty() && osname.toLowerCase().indexOf("windows") > -1;
    }

    protected void showSelectMultiPageDialog(ButtonItem buttonItem) {
        if (buttonItem.getOtherComponent() instanceof AbstractButton) {
            Window frame = KDPrinterUtils.getWindowForComponent(this);
            SelectMultiPageDialog smp = null;
            if (frame instanceof Frame) {
                smp = new SelectMultiPageDialog((Frame)frame, 3, 3, 9);
            } else if (frame instanceof Dialog) {
                smp = new SelectMultiPageDialog((Dialog)frame, 3, 3, 9);
            }
            smp.setUndecorated(true);
            smp.pack();
            AbstractButton button = (AbstractButton)buttonItem.getOtherComponent();
            int x = button.getLocation().x;
            int y = button.getLocation().y + (int)button.getSize().getHeight();
            for (Container cont = button.getParent(); cont != null && cont != frame; cont = cont.getParent()) {
                x += cont.getLocation().x;
                y += cont.getLocation().y;
            }
            smp.setLocation(x += frame.getLocation().x, y += frame.getLocation().y);
            smp.setVisible(true);
            this.setViewStatus(0);
            int[] rowCol = smp.getResult();
            if (rowCol != null) {
                this.multiViewRowCol = rowCol;
                this.gainMultiPage(this.paperIndex);
                this.reflushStatusBar();
                this.preview.getPreviewBar().scaleTextField.setEditable(false);
                this.zoomOut();
                this.contentPanel.setLayout(this.multiViewLayout);
                this.contentPanel.validate();
                this.contentPanel.repaint();
                this.validate();
            }
        }
    }

    void checkZoom() {
        if (this.getViewCount() > 1 && !this.zoomStatus) {
            this.zoomOut();
            this.validate();
        }
    }

    private int getViewCount() {
        if (this.multiViewRowCol == null) {
            return 1;
        }
        return this.multiViewRowCol[0] * this.multiViewRowCol[1];
    }

    private int getFirstPageIndex(int pageIndex, int viewCount) {
        return pageIndex / viewCount * viewCount;
    }

    private int getPrevPageIndex(int pageIndex, int viewCount) {
        int first = this.getFirstPageIndex(pageIndex, viewCount);
        return first - viewCount;
    }

    private int getNextPageIndex(int pageIndex, int viewCount) {
        int first = this.getFirstPageIndex(pageIndex, viewCount);
        return first + viewCount;
    }

    private boolean gainMultiPage(int pageIndex) {
        int count = this.getViewCount();
        int firstPage = this.getFirstPageIndex(pageIndex, count);
        this.contentPanel.removeAll();
        this.pagerUIList.clear();
        boolean pageNull = false;
        for (int i = 0; i < count; ++i) {
            if (firstPage + i == pageIndex) {
                if (this.activeUI == null) {
                    this.activeUI = this.createPaperUI(firstPage + i, false);
                }
                Paper onePaper = this.printer.getControlPrint().getPaper(this.paperIndex);
                if (i == 0 && onePaper == null) {
                    pageNull = true;
                }
                this.activeUI.setPaper(onePaper);
                this.pagerUIList.add(this.activeUI);
                this.contentPanel.add((Component)((Object)this.activeUI));
                continue;
            }
            OnePaperUI ui = this.createPaperUI(firstPage + i, i != 0);
            if (ui == null) continue;
            if (i == 0 && ui.getPaper() == null) {
                pageNull = true;
            }
            this.pagerUIList.add(ui);
            this.contentPanel.add((Component)((Object)ui));
        }
        return pageNull;
    }

    protected void print(ButtonItem buttonItem, Object value) {
        int pageCount = this.printer.getPrintJob().getPageCount2();
        if (pageCount <= 0) {
            this.printer.prompt(Resources2.getMsg("prompt.countunknown"));
            return;
        }
        boolean printDirect = this.printer.getPrintPreview().isPrintDirect();
        if (this.printer.getPrintPreview().isCloseWhenPrint()) {
            this.printer.closePreview();
        }
        if (printDirect) {
            this.printer.getPrintPreview().setPrintDirect(false);
            if (this.printer.getPrintConfig().getModel().getPrintDirect()) {
                KDPrintUtil.getInstance();
                KDPrintUtil.addConfigToXml(this.printer.getPrintConfig().getPrintJobName(), this.printer.getPrintConfig().getPrintService().getName());
            }
            this.printer.printDirectNoPagination();
            return;
        }
        int result_status = this.printer.printDialog(this);
        if (result_status == 1) {
            if (this.printer.getPrintConfig().getModel().getPrintDirect()) {
                KDPrintUtil.getInstance();
                KDPrintUtil.addConfigToXml(this.printer.getPrintConfig().getPrintJobName(), this.printer.getPrintConfig().getPrintService().getName());
            }
            this.printer.printDirectNoPagination();
        } else if (result_status == 3) {
            this.printer.printPreview(true);
        } else if (this.preview.isPreviewing()) {
            this.updatePaper();
            this.updateNumberOfPages();
        }
    }

    protected void pageDialog(ButtonItem buttonItem, Object value) {
        if (this.printer.pageDialog(this, this.paperIndex, true) == 1) {
            this.paperIndex = 0;
        }
        this.updatePaper();
        this.updateNumberOfPages();
    }

    public boolean updatePaper() {
        if (this.activeUI != null) {
            this.saveCurrentPage();
            this.activeUI.setSelectRect(null);
        }
        if (this.paperIndex < 0) {
            this.paperIndex = 0;
        } else if (this.totalPageCount != -1 && this.totalPageCount > 0 && this.paperIndex >= this.totalPageCount) {
            this.paperIndex = this.totalPageCount - 1;
        }
        boolean pageNull = this.gainMultiPage(this.paperIndex);
        this.activeUI.grabFocus();
        this.contentPanel.validate();
        this.contentPanel.repaint();
        this.reflushStatusBar();
        return !pageNull;
    }

    private void saveCurrentPage() {
        Paper paper = this.activeUI.getPaper();
        if (paper != null && this.isPageModified) {
            IPrintJob job = paper.getPrintJob();
            Page bodyPage = paper.getBody();
            job.addModifiedPage(bodyPage);
            this.isPageModified = false;
        }
    }

    public void refresh() {
        this.reflushStatusBar();
    }

    private OnePaperUI createPaperUI(int index, boolean canBeNull) {
        Paper onePaper = this.printer.getControlPrint().getPaper(index);
        OnePaperUI ui = null;
        if (onePaper == null && canBeNull) {
            return null;
        }
        ui = new OnePaperUI(this.printer, this);
        if (onePaper != null) {
            ui.setPaper(onePaper);
        }
        return ui;
    }

    protected void first(ButtonItem buttonItem, Object value) {
        this.paperIndex = 0;
        this.updatePaper();
        this.checkZoom();
    }

    protected void last(ButtonItem buttonItem, Object value) {
        int count = this.printer.getPrintJob().getPageCount();
        if (count > 0) {
            int lastIndex = this.paperIndex;
            this.paperIndex = count - 1;
            boolean isHasNextPage = this.updatePaper();
            if (!isHasNextPage) {
                this.paperIndex = lastIndex;
                this.updatePaper();
                this.preview.getPreviewBar().getButtonItem(8).setEnabled(false);
                this.preview.getPreviewBar().getButtonItem(9).setEnabled(false);
            }
        }
        this.checkZoom();
    }

    protected void previous(ButtonItem buttonItem, Object value) {
        int viewCount = this.getViewCount();
        int first = this.getFirstPageIndex(this.paperIndex, viewCount);
        if (first <= 0) {
            return;
        }
        this.paperIndex = this.getPrevPageIndex(this.paperIndex, viewCount);
        this.updatePaper();
        this.checkZoom();
    }

    protected void next(ButtonItem buttonItem, Object value) {
        this.paperIndex = this.getNextPageIndex(this.paperIndex, this.getViewCount());
        boolean isHasNextPage = this.updatePaper();
        if (!isHasNextPage) {
            --this.paperIndex;
            this.updatePaper();
            this.preview.getPreviewBar().getButtonItem(8).setEnabled(false);
            this.preview.getPreviewBar().getButtonItem(9).setEnabled(false);
        }
        this.checkZoom();
    }

    public void setPageInterval(boolean isInterval) {
        if (isInterval) {
            this.activeUI.setInterval(OnePaperUI.IntervalSetting);
        } else {
            this.activeUI.setInterval(0);
        }
    }

    public void changePageInterval() {
        if (this.editManager != null) {
            this.editManager.stopEditing();
        }
        this.setColumnHeaderView(null);
        this.activeUI.changeInterval();
    }

    protected void changeEditStatus() {
        if (this.status != 1) {
            this.setViewStatus(1);
            this.zoomOut();
            this.zoomView(null, new Double(1.0));
            this.preview.getPreviewBar().scaleTextField.setText("100%");
            this.setColumnHeaderView((Component)((Object)new EditToolBar(this)));
        } else {
            if (this.editManager != null) {
                this.editManager.stopEditing();
            }
            this.setViewStatus(0);
            this.setColumnHeaderView(null);
        }
    }

    protected void closeWindow() {
        this.printer.closePreview();
    }

    public int getPaperIndex() {
        return this.paperIndex;
    }

    protected void reflushStatusBar() {
        String info = this.previewTitle;
        info = info + ":" + this.di + (this.paperIndex + 1) + this.strpage;
        int totalPages = this.totalPageCount;
        String totalStr = totalPages <= 0 ? "?" : "" + totalPages;
        info = info + this.strtotal + totalStr + this.strpage;
        if (this.activeUI.getPaper() == null) {
            this.setStatus(this.previewTitle + ": " + Resources.getMsg("prompt.nocontent"));
        } else {
            this.setStatus(info);
        }
        this.updatePageNavigatorButtomStatus(this.paperIndex, totalPages);
    }

    protected void setStatus(String str) {
        this.preview.setStatus(str);
    }

    protected void printTestPage() {
        Window window = KDPrinterUtils.getWindowForComponent(this);
        PrintTestDialog testDialog = null;
        testDialog = window instanceof Dialog ? new PrintTestDialog(this.getPrinter(), (Dialog)window) : new PrintTestDialog(this.getPrinter(), (Frame)window);
        testDialog.setVisible(true);
    }

    protected void updatePageNavigatorButtomStatus(int currentIndex, int numberOfPages) {
        if (numberOfPages == -1) {
            this.setButtonItemEnable(0, true);
            this.setButtonItemEnable(1, true);
            this.setButtonItemEnable(10, true);
            if (currentIndex == 0) {
                this.setButtonItemEnable(6, false);
                this.setButtonItemEnable(7, false);
                this.setButtonItemEnable(8, true);
                this.setButtonItemEnable(9, false);
            } else {
                this.setButtonItemEnable(6, true);
                this.setButtonItemEnable(7, true);
                this.setButtonItemEnable(8, true);
                this.setButtonItemEnable(9, false);
            }
        } else if (numberOfPages <= 1) {
            this.setButtonItemEnable(0, true);
            this.setButtonItemEnable(1, true);
            this.setButtonItemEnable(6, false);
            this.setButtonItemEnable(7, false);
            this.setButtonItemEnable(8, false);
            this.setButtonItemEnable(9, false);
            this.setButtonItemEnable(10, true);
            if (numberOfPages == 0) {
                this.setButtonItemEnable(0, false);
                this.setButtonItemEnable(10, false);
                this.setButtonItemEnable(4, false);
                this.setButtonItemEnable(5, false);
            }
        } else {
            int viewCount = this.getViewCount();
            int firstPage = this.getFirstPageIndex(this.paperIndex, viewCount);
            int lastPage = firstPage + viewCount - 1;
            this.setButtonItemEnable(0, true);
            this.setButtonItemEnable(1, true);
            this.setButtonItemEnable(10, true);
            this.setButtonItemEnable(4, true);
            this.setButtonItemEnable(5, true);
            if (firstPage <= 0) {
                this.setButtonItemEnable(6, false);
                this.setButtonItemEnable(7, false);
            } else {
                this.setButtonItemEnable(6, true);
                this.setButtonItemEnable(7, true);
            }
            if (lastPage >= numberOfPages - 1) {
                this.setButtonItemEnable(8, false);
                this.setButtonItemEnable(9, false);
            } else {
                this.setButtonItemEnable(8, true);
                this.setButtonItemEnable(9, true);
            }
        }
    }

    private void setButtonItemEnable(int category, boolean enable) {
        ButtonItem item = this.preview.getPreviewBar().getButtonItem(category);
        if (item != null) {
            item.setEnabled(enable);
        }
    }

    public Point countCenter(Container con, OnePaperUI ui) {
        Insets insets = con.getInsets();
        Dimension pDim = con.getSize();
        int w = pDim.width - insets.left - insets.right;
        Dimension pSize = ui.getPreferredSize();
        return new Point((w - pSize.width) / 2, 400);
    }

    public void clear() {
        this.contentPanel.removeAll();
        this.activeUI = null;
        if (this.pagerUIList != null) {
            this.pagerUIList.clear();
        }
        this.editManager = null;
    }

    public void setZoomFirstShow(boolean isZoom) {
        this.isZoomFirstShow = isZoom;
    }
}

