/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.printjob.table;

import com.kingdee.bos.ctrl.print.config.attribute.ZoomScaleInfo;
import com.kingdee.bos.ctrl.print.config.extendui.TablePageSetupModel;
import com.kingdee.bos.ctrl.print.config.ui.PageSetupModel;
import com.kingdee.bos.ctrl.print.config.ui.PrintConfigModel;
import com.kingdee.bos.ctrl.print.control.PaperInfo;
import com.kingdee.bos.ctrl.print.printjob.BufferPrintJob;
import com.kingdee.bos.ctrl.print.printjob.IEconomizePrint;
import com.kingdee.bos.ctrl.print.printjob.IPageProvider;
import com.kingdee.bos.ctrl.print.printjob.table.ITableForPrint;
import com.kingdee.bos.ctrl.print.printjob.table.TablePrintPagination;
import com.kingdee.bos.ctrl.print.resource.TableResources;
import com.kingdee.bos.ctrl.print.ui.component.DimensionFloat;
import com.kingdee.bos.ctrl.print.ui.component.Page;
import com.kingdee.bos.ctrl.print.util.KDPrinterUtils;
import java.awt.Rectangle;
import javax.print.attribute.PrintRequestAttributeSet;

public class SheetPrintJob
extends BufferPrintJob
implements IPageProvider,
IEconomizePrint {
    protected String configName;
    protected TablePageSetupModel configmodel;
    protected TablePrintPagination tp;
    protected ITableForPrint sheet;
    protected int pageIndex = 0;

    public SheetPrintJob() {
    }

    public SheetPrintJob(String id) {
        super(id);
    }

    public SheetPrintJob(ITableForPrint sheet, PrintConfigModel printmodel, String configName) {
        super(sheet.getName());
        this.sheet = sheet;
        this.tp = new TablePrintPagination(sheet, printmodel, null);
        this.configName = configName;
        this.setPageProvider(this);
    }

    public void initConfigModel2() {
        if (this.configmodel == null) {
            this.configmodel = (TablePageSetupModel)this.getConfig().getConfig(this.configName);
            this.tp.setTablePageSetupModel(this.configmodel);
        }
    }

    private void initCofigModel() {
        PageSetupModel psModel;
        if (this.configmodel == null) {
            this.configmodel = (TablePageSetupModel)this.getConfig().getConfig(this.configName);
            this.tp.setTablePageSetupModel(this.configmodel);
        }
        if ((psModel = (PageSetupModel)this.getConfig().getConfig(TableResources.getMsg("tree.page"))) != null) {
            this.tp.setBackGroundColor(psModel.getBackGroundColor());
        }
        this.tp.setPageIndex(this.pageIndex);
        this.tp.initCofigModel();
        if (this.pageIndex == 0) {
            this.fireBeginGetPage();
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.tp.clear();
    }

    @Override
    public void preparePagination() {
        super.preparePagination();
        this.calculatePageCount(this.getPaperInfo());
    }

    public TablePrintPagination getTablePrintPagination() {
        return this.tp;
    }

    private void calculatePageCount(PaperInfo info) {
        if (!info.isUseFrugalPaintable() && this.getPageCount() == -1) {
            this.initCofigModel();
            this.setPageCount(this.tp.pageCount(info));
        }
    }

    @Override
    public Page get(int index, PaperInfo info) {
        DimensionFloat rect = info.getPaintableSize();
        Page page = this.createPage(index, rect);
        if (this.isEconomizePaper() && !info.isUseFrugalPaintable() && page != null && rect != null) {
            page.setPainterBounds(0.0f, 0.0f, rect.width, rect.height);
        }
        return page;
    }

    public Page createPage(int index, DimensionFloat rect) {
        this.pageIndex = index;
        this.initCofigModel();
        return this.tp.getPage(index, rect);
    }

    public int getPageCount(PaperInfo info) {
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return this.sheet.isEmpty();
    }

    @Override
    protected double getScale(PrintRequestAttributeSet printRequestSet) {
        Class<ZoomScaleInfo> c = ZoomScaleInfo.class;
        ZoomScaleInfo factor = (ZoomScaleInfo)printRequestSet.get(c);
        if (factor == null) {
            return 1.0;
        }
        double scale = 1.0;
        if (!factor.isAutoFit()) {
            scale = factor.getScale();
            if (scale <= 0.0) {
                scale = 1.0;
            }
        } else {
            int w = factor.getAutoFitWidth();
            int h = factor.getAutoFitHeight();
            Rectangle pageRect = KDPrinterUtils.getPageBounds(printRequestSet, KDPrinterUtils.SCREEN_RESOLUTION);
            double scaleW = 1.0;
            double scaleH = 1.0;
            if (w > 0) {
                int width = this.sheet.getAllColWidth();
                if (width != 0) {
                    scaleW = (double)(pageRect.width * w) / (double)width;
                }
                if (scaleW > 1.0) {
                    scaleW = 1.0;
                }
            }
            if (h > 0) {
                int height = this.sheet.getAllRowHeight();
                if (height != 0) {
                    scaleH = (double)(pageRect.height * h) / (double)height;
                }
                if (scaleH > 1.0) {
                    scaleH = 1.0;
                }
            }
            scale = scaleH > scaleW ? scaleW : scaleH;
            printRequestSet.add(new ZoomScaleInfo(w, h, scale));
        }
        return scale;
    }

    @Override
    public int getHorSpace() {
        return this.configmodel.getHorSpace();
    }

    @Override
    public int getVerSpace() {
        return this.configmodel.getVerSpace();
    }

    @Override
    public boolean isEconomizePaper() {
        return this.isHorEconomizePaper() || this.isVerEconomizePaper();
    }

    @Override
    public boolean isHorEconomizePaper() {
        return this.configmodel.isHorEconomizePaper();
    }

    @Override
    public boolean isVerEconomizePaper() {
        return this.configmodel.isVerEconomizePaper();
    }
}

