/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.ui.io;

import com.kingdee.bos.ctrl.common.util.ObjectUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.util.render.splitrectangle.AbstractTableSplitRectInfo;
import com.kingdee.bos.ctrl.kdf.util.render.splitrectangle.TableSplitRectInfoXml;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.print.KDPrinter;
import com.kingdee.bos.ctrl.print.config.IXmlTranslate;
import com.kingdee.bos.ctrl.print.config.IXmlTranslate2;
import com.kingdee.bos.ctrl.print.ui.component.BasicPainter;
import com.kingdee.bos.ctrl.print.ui.component.Canvas;
import com.kingdee.bos.ctrl.print.ui.component.IDecorate;
import com.kingdee.bos.ctrl.print.ui.component.IPainter;
import com.kingdee.bos.ctrl.print.ui.component.ImageCell;
import com.kingdee.bos.ctrl.print.ui.component.LabelCell;
import com.kingdee.bos.ctrl.print.ui.component.LineBorder;
import com.kingdee.bos.ctrl.print.ui.component.LineCell;
import com.kingdee.bos.ctrl.print.ui.component.Page;
import com.kingdee.bos.ctrl.print.ui.component.Paper;
import com.kingdee.bos.ctrl.print.ui.component.StyleCell;
import com.kingdee.bos.ctrl.print.ui.component.TableCell;
import com.kingdee.bos.ctrl.print.ui.component.VariantLabelCell;
import com.kingdee.bos.ctrl.print.util.KDPrinterUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import org.jdom2.Element;

public class Xml2Painter {
    private Map styles;

    public Xml2Painter(Map styles) {
        this.styles = styles;
    }

    public IPainter parsePainter(Element xml) {
        String tag = xml.getName();
        if ("Label".equals(tag)) {
            return this.parseLabel(xml);
        }
        if ("StyleCell".equals(tag)) {
            return this.parseStyleCell(xml);
        }
        if ("ImageCell".equals(tag)) {
            return this.parseImage(xml);
        }
        if ("Line".equals(tag)) {
            return this.parseLine(xml);
        }
        if ("Page".equals(tag)) {
            return this.parsePage(xml);
        }
        if ("Canvas".equals(tag)) {
            return this.parseCanvas(xml);
        }
        if ("Paper".equals(tag)) {
            return this.parsePaper(xml);
        }
        if ("VariantLabel".equals(tag)) {
            return this.parseVariantLabel(xml);
        }
        if ("Table".equals(tag)) {
            return this.parseTable(xml);
        }
        IPainter painter = null;
        IXmlTranslate xmlTrans = KDPrinter.getPainterXmlTranslate(xml.getName());
        if (xmlTrans instanceof IXmlTranslate2) {
            ((IXmlTranslate2)xmlTrans).setXml2Painter(this);
            painter = (IPainter)xmlTrans.fromXmlElement(xml);
        } else if (xmlTrans instanceof IXmlTranslate2) {
            painter = (IPainter)xmlTrans.fromXmlElement(xml);
        } else {
            throw new UnsupportedOperationException("xml:[" + xml.getName() + "]:can't load.");
        }
        return painter;
    }

    private void parseChildren(Canvas cv, Element xml) {
        Iterator itr = xml.getChildren().iterator();
        while (itr.hasNext()) {
            IPainter pnt = this.parsePainter((Element)itr.next());
            if (pnt == null) continue;
            cv.addPainter(pnt);
        }
    }

    public void parseCommon(IPainter pnt, Element xml) {
        String layer;
        String extend;
        String decorate;
        if (xml.getAttributeValue("x") != null) {
            float x = Float.parseFloat(xml.getAttributeValue("x"));
            float y = Float.parseFloat(xml.getAttributeValue("y"));
            float width = Float.parseFloat(xml.getAttributeValue("width"));
            float height = Float.parseFloat(xml.getAttributeValue("height"));
            pnt.setPainterBounds(x, y, width, height);
            if (pnt instanceof BasicPainter) {
                String rotateAttrValue;
                BasicPainter bpnt = (BasicPainter)pnt;
                String zIndexAttrValue = xml.getAttributeValue("z-index");
                if (zIndexAttrValue != null && !zIndexAttrValue.isEmpty()) {
                    int zIndex = Integer.parseInt(zIndexAttrValue);
                    bpnt.setZIndex(zIndex);
                }
                if ((rotateAttrValue = xml.getAttributeValue("rotate")) != null && !rotateAttrValue.isEmpty()) {
                    int rotate = Integer.parseInt(rotateAttrValue);
                    bpnt.setRotate(rotate);
                }
            }
        }
        if (xml.getAttributeValue("background") != null) {
            String rgb = xml.getAttributeValue("background");
            pnt.setBackGround(KDPrinterUtils.hexToColor(rgb));
        }
        if (xml.getAttributeValue("style") != null) {
            String styleID = xml.getAttributeValue("style");
            Style style = this.getStyle(styleID);
            pnt.setStyle(style);
        }
        if ((decorate = xml.getAttributeValue("decorate")) != null) {
            IDecorate lineDecorate = this.parseLineDecorate(decorate);
            pnt.setDecorate(lineDecorate);
        }
        if ((extend = xml.getAttributeValue("extend")) != null) {
            pnt.setPainterExtend(Float.parseFloat(extend));
        }
        if ((layer = xml.getAttributeValue("layer")) != null) {
            pnt.setLayer(Integer.parseInt(layer));
        }
    }

    private IDecorate parseLineDecorate(String decorate) {
        LineBorder de = null;
        int index = decorate.indexOf(":");
        String name = null;
        String type = null;
        if (index >= 0) {
            name = decorate.substring(0, index);
            type = decorate.substring(index + 1);
        }
        if (LineBorder.getName().equals(name)) {
            de = new LineBorder();
            de.setType(Integer.parseInt(type));
        }
        return de;
    }

    public Object getObject(String Id) {
        return this.styles != null ? this.styles.get(Id) : null;
    }

    private Style getStyle(String styleID) {
        return this.styles != null ? (Style)this.styles.get(styleID) : null;
    }

    public StyleCell parseStyleCell(Element xml) {
        StyleCell lbl = new StyleCell();
        this.parseCommon(lbl, xml);
        lbl.setText(xml.getText());
        for (int i = 0; i < StyleCell.StylesDir.length; ++i) {
            String id = xml.getAttributeValue("aroundstyle" + i);
            if (id == null) continue;
            Style style = this.getStyle(id);
            lbl.setAroundStyles(StyleCell.StylesDir[i], style);
        }
        String isBlackWhite = xml.getAttributeValue("isBlackWhite");
        lbl.setBlackWhite(Boolean.valueOf(isBlackWhite));
        int borderSpace = StyleCell.BORDER_SPACE_DEFUALT;
        if (xml.getAttributeValue("borderspace") != null) {
            borderSpace = Integer.parseInt(xml.getAttributeValue("borderspace"));
            lbl.setBorderSpace(borderSpace);
        }
        int borderMode = Integer.parseInt(xml.getAttributeValue("bordermode"));
        lbl.setBorderMode(borderMode);
        Element diagonal = xml.getChild("DiagonalHeader");
        if (diagonal != null) {
            AbstractTableSplitRectInfo info = TableSplitRectInfoXml.fromXml((Element)diagonal, (Map)this.styles);
            lbl.setDiagonalInfo(info);
        }
        return lbl;
    }

    public LabelCell parseLabel(Element xml) {
        LabelCell lbl = new LabelCell();
        this.parseCommon(lbl, xml);
        String isBlackWhite = xml.getAttributeValue("isBlackWhite");
        if (isBlackWhite != null) {
            lbl.setBlackWhite(Boolean.valueOf(isBlackWhite));
        }
        lbl.setText(xml.getText());
        return lbl;
    }

    public LabelCell parseVariantLabel(Element xml) {
        VariantLabelCell lbl = new VariantLabelCell();
        this.parseCommon(lbl, xml);
        lbl.setText(xml.getText());
        return lbl;
    }

    public LineCell parseLine(Element xml) {
        LineCell ln = new LineCell();
        this.parseCommon(ln, xml);
        if (xml.getAttributeValue("color") != null) {
            String rgb = xml.getAttributeValue("color");
            ln.setColor(KDPrinterUtils.hexToColor(rgb));
        }
        if (xml.getAttributeValue("x1") != null) {
            String x1 = xml.getAttributeValue("x1");
            String y1 = xml.getAttributeValue("y1");
            String x2 = xml.getAttributeValue("x2");
            String y2 = xml.getAttributeValue("y2");
            ln.setLine(Float.parseFloat(x1), Float.parseFloat(y1), Float.parseFloat(x2), Float.parseFloat(y2));
        }
        return ln;
    }

    public ImageCell parseImage(Element xml) {
        ImageCell img = new ImageCell();
        this.parseCommon(img, xml);
        String text = xml.getText();
        if (!StringUtil.isEmptyString((String)text) && text.startsWith("OTHER|")) {
            String fileType = text.substring(6, text.indexOf("|", 6));
            byte[] content = (byte[])ObjectUtil.stringToObject((String)text.substring(6 + fileType.length() + 1));
            if (content != null) {
                img.setContent(content);
            }
            img.setFileType(fileType);
        } else {
            ImageIcon image = (ImageIcon)ObjectUtil.stringToObject((String)text);
            if (image != null) {
                img.setImage(image.getImage());
            }
            img.setFileType("IMAGE");
        }
        String scale = xml.getAttributeValue("scale");
        if (scale != null && !"".equals(scale)) {
            img.setScale(Integer.parseInt(scale));
        }
        return img;
    }

    public Canvas parseCanvas(Element xml) {
        Canvas pg = new Canvas();
        this.parseCommon(pg, xml);
        this.parseChildren(pg, xml);
        return pg;
    }

    public Page parsePage(Element xml) {
        Page pg = new Page();
        this.parseCommon(pg, xml);
        this.parseChildren(pg, xml);
        return pg;
    }

    private IPainter parseTable(Element xml) {
        String rows = xml.getAttributeValue("rows");
        String columns = xml.getAttributeValue("columns");
        float[] rowsHeight = StringUtil.str2FloatArray((String)rows, (String)",");
        float[] columnsHeight = StringUtil.str2FloatArray((String)columns, (String)",");
        TableCell table = new TableCell(rowsHeight.length, columnsHeight.length);
        this.parseCommon(table, xml);
        table.setRows(rowsHeight);
        table.setColumns(columnsHeight);
        String grid = xml.getAttributeValue("grid");
        table.setGrid("true".equals(grid));
        List cellChildren = xml.getChildren("cell");
        int size = cellChildren.size();
        block0: for (int i = 0; i < size; ++i) {
            Element cell = (Element)cellChildren.get(i);
            int rowIndex = Integer.parseInt(cell.getAttributeValue("row"));
            int colIndex = Integer.parseInt(cell.getAttributeValue("column"));
            List content = cell.getContent();
            int length = content.size();
            for (int j = 0; j < length; ++j) {
                Object pXml = content.get(j);
                if (!(pXml instanceof Element)) continue;
                IPainter painter = this.parsePainter((Element)pXml);
                table.setValue(rowIndex, colIndex, (StyleCell)painter);
                continue block0;
            }
        }
        List mergChildren = xml.getChildren("mergeblock");
        int size2 = mergChildren.size();
        for (int i = 0; i < size2; ++i) {
            Element block = (Element)mergChildren.get(i);
            int row = Integer.parseInt(block.getAttributeValue("row"));
            int col = Integer.parseInt(block.getAttributeValue("col"));
            int row2 = Integer.parseInt(block.getAttributeValue("row2"));
            int col2 = Integer.parseInt(block.getAttributeValue("col2"));
            table.addMerge(row, col, row2, col2);
        }
        return table;
    }

    public Paper parsePaper(Element xml) {
        Paper pp = new Paper();
        this.parseCommon(pp, xml);
        this.parseChildren(pp, xml);
        return pp;
    }
}

