/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.webframework.dynamic.CtrlConfigInfo;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class DynamicWebUtils {
    private static Logger logger = Logger.getLogger(DynamicWebUtils.class);

    public static String getWatermarkContent(Context ctx) {
        try {
            String str;
            StringBuffer sql = new StringBuffer("SELECT FOptionData FROM t_dyn_ctrlConfig WHERE fCtrlType = 'configPage'");
            ISQLExecutor iSQL = SQLExecutorFactory.getRemoteInstance((String)sql.toString());
            IRowSet rows = iSQL.executeSQL();
            if (rows.first() && (str = rows.getString("FOptionData")) != null) {
                JSONObject jsonWaterMark = JSON.parseObject((String)str);
                String watermarkJsonStr = jsonWaterMark.getJSONObject("watermark").getString("ctrlOptVal");
                return DynamicWebUtils.getRealText(JSON.parseObject((String)watermarkJsonStr), ctx);
            }
        }
        catch (BOSException e) {
            logger.error((Object)("getWatermarkContent failed:" + (Object)((Object)e)));
            e.printStackTrace();
        }
        catch (SQLException e) {
            logger.error((Object)("getWatermarkContent failed:" + e));
            e.printStackTrace();
        }
        return "";
    }

    public static void processSpecialConfig(CtrlConfigInfo ctrlConfigInfo, Context ctx) {
        if ("configPage".equals(ctrlConfigInfo.getCtrlType())) {
            String optionData = ctrlConfigInfo.getOptionData();
            JSONObject optionDataJson = JSON.parseObject((String)optionData);
            JSONObject watermark = optionDataJson.getJSONObject("watermark");
            if (optionDataJson != null) {
                String ctrlOptVal = watermark.getString("ctrlOptVal");
                String newCtrlOptVal = DynamicWebUtils.generateWatermarkRealText(ctrlOptVal, ctx);
                watermark.put("ctrlOptVal", (Object)newCtrlOptVal);
                optionDataJson.put("watermark", (Object)watermark);
                ctrlConfigInfo.setOptionData(JSON.toJSONString((Object)optionDataJson));
            }
        }
    }

    public static String generateWatermarkRealText(String watermarkJsonStr, Context ctx) {
        if (StringUtil.isEmptyString((String)watermarkJsonStr)) {
            return "";
        }
        JSONObject watermarkJson = JSON.parseObject((String)watermarkJsonStr);
        watermarkJson.put("realText", (Object)DynamicWebUtils.getRealText(watermarkJson, ctx));
        return JSON.toJSONString((Object)watermarkJson);
    }

    private static String getRealText(JSONObject watermarkJson, Context ctx) {
        String realText = "";
        realText = watermarkJson.getString("text");
        String content = watermarkJson.getString("content");
        if (!"custom".equals(content)) {
            String callId = ctx.getCaller() == null ? "" : ctx.getCaller().toString();
            String cellTailNumber = "";
            String fullName = "";
            try {
                UserInfo userInfo = UserFactory.getRemoteInstance().getUserInfo((IObjectPK)new ObjectUuidPK(callId));
                fullName = userInfo.getName(ctx.getLocale());
                String cell = userInfo.getCell();
                cellTailNumber = StringUtils.isEmpty((String)cell) ? "" : (cell.length() < 4 ? cell : cell.substring(cell.length() - 4));
            }
            catch (Exception e) {
                logger.error((Object)"\u83b7\u53d6\u7528\u6237\u521d\u59cb\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            }
            if ("name".equals(content)) {
                realText = fullName;
            }
            if ("nameAndTel".equals(content)) {
                realText = fullName + cellTailNumber;
            }
        }
        try {
            boolean isShow = false;
            isShow = !ConfigMDUtil.isClient() ? LicenseSrvAgentFactory.getLocalInstance((Context)ctx).isShowWaterMark() : LicenseSrvAgentFactory.getRemoteInstance().isShowWaterMark();
            if (isShow) {
                String language = ctx.getLocale().getLanguage();
                String temporaryLicense = "\u3010\u4e34\u65f6\u8bb8\u53ef\u3011";
                if ("l1".equals(language)) {
                    temporaryLicense = "[Temporary License]";
                } else if ("l3".equals(language)) {
                    temporaryLicense = "\u3010\u81e8\u6642\u8a31\u53ef\u3011";
                }
                if ("no".equals(watermarkJson.getString("display"))) {
                    String temporaryLicenseClosedWaterMark = "\u4e34\u65f6\u8bb8\u53ef";
                    if ("l1".equals(language)) {
                        temporaryLicenseClosedWaterMark = "Temporary License";
                    } else if ("l3".equals(language)) {
                        temporaryLicenseClosedWaterMark = "\u81e8\u6642\u8a31\u53ef";
                    }
                    realText = temporaryLicenseClosedWaterMark;
                } else {
                    realText = temporaryLicense + realText;
                }
            } else if ("no".equals(watermarkJson.getString("display"))) {
                return "";
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u83b7\u53d6License\u7248\u672c\u5931\u8d25", (Throwable)e);
        }
        return realText;
    }
}

