/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.io.kds;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.util.UnitConverter;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.MergeBlocks;
import com.kingdee.bos.ctrl.excel.model.struct.PrintSetup;
import com.kingdee.bos.ctrl.excel.model.struct.Protection;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.excel.model.struct.SortedAttributeSpanArray;
import com.kingdee.bos.ctrl.excel.model.struct.embed.EmbedObject;
import com.kingdee.bos.ctrl.excel.model.struct.embed.EmbedhLayer;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootRow;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSProtection;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheetPrintSetup;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import javax.imageio.ImageIO;

public class BookToKDSBook {
    public static KDSBook traslate(Book book) {
        return BookToKDSBook.traslate(book, null);
    }

    public static KDSBook traslate(Book book, String[] sheetNames) {
        KDSBook kdsbook = new KDSBook(book.getName());
        BookToKDSBook.traslate(book, kdsbook, sheetNames);
        return kdsbook;
    }

    public static void traslate(Book book, KDSBook kdsbook, String[] sheetNames) {
        if (sheetNames == null || sheetNames.length == 0) {
            int count = book.getSheetCount();
            for (int i = 0; i < count; ++i) {
                Sheet sheet = book.getSheet(i);
                if (sheet == null) continue;
                KDSSheet kdssheet = new KDSSheet(kdsbook, sheet.getSheetName(), (ShareStyleAttributes)sheet.getStyle());
                BookToKDSBook.traslateSheet(sheet, kdssheet, kdsbook);
                try {
                    kdsbook.addSheet(null, kdssheet);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        } else {
            int count = sheetNames.length;
            for (int i = 0; i < count; ++i) {
                Sheet sheet = book.getSheet(sheetNames[i]);
                if (sheet == null) continue;
                KDSSheet kdssheet = new KDSSheet(kdsbook, sheet.getSheetName(), (ShareStyleAttributes)sheet.getStyle());
                BookToKDSBook.traslateSheet(sheet, kdssheet, kdsbook);
                try {
                    kdsbook.addSheet(null, kdssheet);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private static void traslateSheet(Sheet sheet, KDSSheet kdssheet, KDSBook kdsbook) {
        BookToKDSBook.translateColumns(sheet, kdssheet);
        BookToKDSBook.translateRows(sheet, kdssheet);
        BookToKDSBook.translateCells(sheet, kdssheet);
        BookToKDSBook.translateMerger(sheet, kdssheet);
        BookToKDSBook.translatePlainEmbedObjects(sheet, kdsbook);
        BookToKDSBook.translatePrintSetup(sheet, kdssheet);
        BookToKDSBook.translateProtection(sheet, kdssheet);
        kdssheet.setValidationList(sheet.getValidations());
    }

    private static void translatePrintSetup(Sheet sheet, KDSSheet kdssheet) {
        PrintSetup printSetup = sheet.getSheetOption().getPrintSetup(true);
        KDSSheetPrintSetup kdsPrintSetup = kdssheet.getPrintSetup();
        if (kdsPrintSetup == null) {
            kdsPrintSetup = new KDSSheetPrintSetup();
        }
        kdsPrintSetup.setPageSize((short)printSetup.getPagesizeIndex());
        boolean autoFit = printSetup.isAutoFit();
        if (autoFit) {
            kdsPrintSetup.setAutoFit(true);
            kdsPrintSetup.setWidthFit((short)printSetup.getAutoFitWidth());
            kdsPrintSetup.setHeightFit((short)printSetup.getAutoFitHeight());
            kdsPrintSetup.setScale((short)100);
        } else {
            printSetup.setAutoFit(false);
            kdsPrintSetup.setScale((short)printSetup.getScale());
            kdsPrintSetup.setHeightFit((short)1);
            kdsPrintSetup.setWidthFit((short)1);
        }
        kdsPrintSetup.setBottom(printSetup.getBottomMargin());
        kdsPrintSetup.setTop(printSetup.getTopMargin());
        kdsPrintSetup.setRight(printSetup.getRightMargin());
        kdsPrintSetup.setLeft(printSetup.getLeftMargin());
        kdsPrintSetup.setLandScape(printSetup.isLandScape());
        StringBuffer leftBufferHeader = new StringBuffer("");
        StringBuffer centerBufferHeader = new StringBuffer("");
        StringBuffer rightBufferHeader = new StringBuffer("");
        List headData = printSetup.getHeadData();
        if (headData != null && headData.size() > 0) {
            BookToKDSBook.configHeaderOrFooter(headData, leftBufferHeader, centerBufferHeader, rightBufferHeader);
        }
        kdsPrintSetup.setHeaderLeft(leftBufferHeader.toString());
        kdsPrintSetup.setHeaderCenter(centerBufferHeader.toString());
        kdsPrintSetup.setHeaderRight(rightBufferHeader.toString());
        StringBuffer leftBufferFooter = new StringBuffer("");
        StringBuffer centerBufferFooter = new StringBuffer("");
        StringBuffer rightBufferFooter = new StringBuffer("");
        List footData = printSetup.getFootData();
        if (footData != null && footData.size() > 0) {
            BookToKDSBook.configHeaderOrFooter(footData, leftBufferFooter, centerBufferFooter, rightBufferFooter);
        }
        kdsPrintSetup.setFooterLeft(leftBufferFooter.toString());
        kdsPrintSetup.setFooterCenter(centerBufferFooter.toString());
        kdsPrintSetup.setFooterRight(rightBufferFooter.toString());
        kdssheet.setPrintSetup(kdsPrintSetup);
    }

    private static String translateSpecailChar(String strIn) {
        strIn = strIn.replace("&[Page]", "&P");
        strIn = strIn.replace("&[PageCount]", "&N");
        strIn = strIn.replace("&[Date]", "&D");
        strIn = strIn.replace("&[Time]", "&T");
        strIn = strIn.replace("&L", "&L");
        strIn = strIn.replace("&C", "&C");
        strIn = strIn.replace("&R", "&R");
        strIn = strIn.replace("&", "&amp;");
        return strIn;
    }

    private static void configHeaderOrFooter(List data, StringBuffer leftBuffer, StringBuffer centerBuffer, StringBuffer rightBuffer) {
        ListIterator iterator = data.listIterator();
        while (iterator.hasNext()) {
            String originRowText = ((HeadFootRow)iterator.next()).toString();
            String[] Text = StringUtil.splitString((String)originRowText, (String)"&|");
            String[] Result = BookToKDSBook.spliceHeaderOrFooter(Text, iterator.previousIndex());
            leftBuffer.append(Result[0]);
            centerBuffer.append(Result[1]);
            rightBuffer.append(Result[2]);
        }
    }

    private static String[] spliceHeaderOrFooter(String[] rowText, int rowIndex) {
        String newLine = rowIndex > 0 ? "\n" : "";
        StringBuffer left = new StringBuffer(newLine + "");
        StringBuffer center = new StringBuffer(newLine + "");
        StringBuffer right = new StringBuffer(newLine + "");
        int col = rowText.length;
        if (col != 0) {
            if (col == 1) {
                center.append(rowText[0]);
            } else if (col == 2) {
                left.append(rowText[0]);
                right.append(rowText[1]);
            } else if (col == 3) {
                left.append(rowText[0]);
                center.append(rowText[1]);
                right.append(rowText[2]);
            } else {
                left.append(rowText[0]);
                right.append(rowText[col - 1]);
                for (int i = 1; i <= col - 2; ++i) {
                    center.append(rowText[i]);
                }
            }
        }
        return new String[]{left.toString(), center.toString(), right.toString()};
    }

    private static void translatePlainEmbedObjects(Sheet sheet, KDSBook kdsbook) {
        EmbedhLayer el = sheet.getEmbedments(false);
        try {
            if (el != null) {
                for (int i = 0; i < el.size(); ++i) {
                    EmbedObject eo = el.getEmbed(i);
                    int width = eo.getWidth();
                    int height = eo.getHeight();
                    BufferedImage buffer = new BufferedImage(width, height, 2);
                    Graphics2D g = buffer.createGraphics();
                    ((Graphics)g).translate(-eo.getX(), -eo.getY());
                    eo.paintData((Graphics)g);
                    ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)buffer, "png", bytes);
                    KDSBook.KDSImage image = new KDSBook.KDSImage(bytes.toByteArray(), 6);
                    Point p = eo.getBounds().getLocation();
                    Point p2 = new Point(p.x + eo.getWidth(), p.y + eo.getHeight());
                    int left = SheetBaseMath.colAtPoint((Sheet)sheet, (Point2D)p);
                    image.setLeft(left);
                    int right = SheetBaseMath.colAtPoint((Sheet)sheet, (Point2D)p2);
                    image.setRight(right);
                    int top = SheetBaseMath.rowAtPoint((Sheet)sheet, (Point2D)p);
                    image.setTop(top);
                    int bottom = SheetBaseMath.rowAtPoint((Sheet)sheet, (Point2D)p2);
                    image.setBottom(bottom);
                    image.setWidth(width);
                    image.setHeight(height);
                    image.setSheetName(sheet.getSheetName());
                    kdsbook.addImage(image);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void translateColumns(Sheet sheet, KDSSheet kdssheet) {
        SortedAttributeSpanArray colSpans = sheet.getColSpans();
        int maxColIndex = sheet.getMaxColIndex();
        for (int i = 0; i <= maxColIndex; ++i) {
            int index = colSpans.searchSpan(i);
            if (index < 0) {
                kdssheet.setColumnWidth(i, (float)UnitConverter.px2mm((int)sheet.getOriginalDefColWidth()));
                continue;
            }
            SortedAttributeSpanArray.AttributeSpan span = colSpans.getAttributeSpan(index);
            if (span.isVisible()) {
                kdssheet.setColumnWidth(i, (float)UnitConverter.px2mm((int)span.getOriginalLength()));
                continue;
            }
            kdssheet.setColumnWidth(i, 0.0f);
        }
    }

    private static void translateRows(Sheet sheet, KDSSheet kdssheet) {
        SortedAttributeSpanArray rowSpans = sheet.getRowSpans();
        int maxRowIndex = sheet.getMaxRowIndex();
        for (int i = 0; i <= maxRowIndex; ++i) {
            int index = rowSpans.searchSpan(i);
            if (index < 0) {
                kdssheet.setRowHeight(i, (float)UnitConverter.px2mm((int)sheet.getOriginalDefRowHeight()));
                continue;
            }
            SortedAttributeSpanArray.AttributeSpan span = rowSpans.getAttributeSpan(index);
            if (span.isVisible()) {
                kdssheet.setRowHeight(i, (float)UnitConverter.px2mm((int)span.getOriginalLength()));
                continue;
            }
            kdssheet.setRowHeight(i, 0.0f);
        }
    }

    private static void translateCells(Sheet sheet, KDSSheet kdssheet) {
        Sheet.ICellsIterator iter = sheet.getCellsIterator(0, 0, sheet.getMaxRowIndex(), sheet.getMaxColIndex(), false, false, false);
        while (iter.hasNext()) {
            Cell cell = iter.next();
            Style ssa = sheet.getCellDisplayStyle(cell.getRow(), cell.getCol());
            if (null == ssa) {
                ssa = Styles.getEmptySSA();
            }
            BookToKDSBook.translateOneCell(cell, kdssheet, (ShareStyleAttributes)ssa);
        }
    }

    private static void translateOneCell(Cell cell, KDSSheet kdssheet, ShareStyleAttributes ssa) {
        CellBlock merge;
        boolean b;
        int rowIndex = cell.getRow();
        int colIndex = cell.getCol();
        Variant var = cell.getValue();
        Object value = var.getValue();
        String formula = cell.getFormula();
        String text = cell.getText();
        boolean bl = b = formula != null && formula.length() > 0 && formula.charAt(0) == '=';
        if (b) {
            formula = formula.substring(1);
        }
        if (var.isNumber() && !var.isNull() && value instanceof String) {
            try {
                value = var.toBigDecimal();
            }
            catch (SyntaxErrorException e) {
                e.printStackTrace();
            }
        }
        if (value instanceof Date || value instanceof Calendar) {
            value = cell.getText();
        } else if (value instanceof String && StringUtil.isEmptyString((String)((String)value))) {
            value = null;
        }
        kdssheet.setCell(rowIndex, colIndex, value, b ? formula : null, ssa, text);
        if (cell.getHyperLink() != null && !StringUtil.isEmptyString((String)cell.getHyperLink().getLinkTo())) {
            kdssheet.getCell(rowIndex, colIndex, false).setHyperLink(cell.getHyperLink());
        }
        if ((merge = cell.getMerge(false)) != null) {
            int r2 = merge.getRow2();
            for (int r1 = merge.getRow(); r1 <= r2; ++r1) {
                int c2 = merge.getCol2();
                for (int c1 = merge.getCol(); c1 <= c2; ++c1) {
                    if (r1 == rowIndex && c1 == colIndex) continue;
                    kdssheet.setCell(r1, c1, (Object)"", null, ssa, text);
                }
            }
        }
    }

    private static void translateMerger(Sheet sheet, KDSSheet kdssheet) {
        MergeBlocks mergeBlocks = sheet.getSheetOption().getMerger(false);
        if (mergeBlocks == null) {
            return;
        }
        for (int i = mergeBlocks.size() - 1; i >= 0; --i) {
            CellBlock merge = mergeBlocks.getBlock(i);
            kdssheet.getMerges().addMerge(merge.getRow(), merge.getCol(), merge.getRow2(), merge.getCol2());
        }
    }

    private static void translateProtection(Sheet sheet, KDSSheet kdsSheet) {
        Protection protection = sheet.getSheetOption().getProtection(false);
        if (null != protection) {
            KDSProtection p = new KDSProtection(protection.getOperations(), protection.getEncryptedPassword());
            kdsSheet.setProtection(p);
        }
    }
}

