/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing;

import com.kingdee.bos.ctrl.swing.AutoSearchPopup;
import com.kingdee.bos.ctrl.swing.IKDComponent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.text.JTextComponent;

public class KDAutoSearch
extends JComponent
implements IKDComponent {
    private static final long serialVersionUID = -4492561082251383145L;
    protected Object userObject = null;
    JTextComponent parent = null;
    private Vector indexValues = new Vector();
    private boolean isCanDoValueChange = true;
    private String fileName = "";
    private ComboPopup popup = null;
    private ValueChangeListener valueChangeListener = null;
    private AutoSearchFocusListener autoSearchFocusListener = null;
    private AutoSearchKeyListener autoSearchKeyListener = null;

    public KDAutoSearch(JTextComponent parent, String fileName) {
        this.parent = parent;
        this.fileName = fileName;
        try {
            this.indexValues = this.readData(fileName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.popup = new AutoSearchPopup(this);
        this.doEvent();
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public void doEvent() {
        ValueChangeListener valueChangeListener = new ValueChangeListener();
        this.parent.getDocument().addDocumentListener(valueChangeListener);
        AutoSearchFocusListener autoSearchFocusListener = new AutoSearchFocusListener();
        this.parent.addFocusListener(autoSearchFocusListener);
        AutoSearchKeyListener autoSearchKeyListener = new AutoSearchKeyListener();
        this.parent.addKeyListener(autoSearchKeyListener);
    }

    private void addData(Vector listData, String indexValue) {
        boolean haveAdd = false;
        for (int i = 0; i < listData.size(); ++i) {
            if (indexValue.compareToIgnoreCase(listData.get(i).toString()) >= 0) continue;
            haveAdd = true;
            listData.insertElementAt(indexValue, i);
            break;
        }
        if (!haveAdd) {
            listData.add(indexValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector readData(String fileName) {
        Vector<String> alData = new Vector<String>();
        File file = new File(fileName);
        FileInputStream fis = null;
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            fis = new FileInputStream(file);
            int dataLen = fis.available();
            byte[] data = new byte[dataLen];
            fis.read(data);
            String content = new String(data, "UTF-8");
            String[] contentArray = content.split("\n");
            for (int i = 0; i < contentArray.length; ++i) {
                if (contentArray[i] == null || contentArray[i].trim().equals("")) continue;
                alData.add(contentArray[i].replaceAll("\r", ""));
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception exception) {}
            }
        }
        return alData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeData(String fileName, Vector data) throws IOException {
        String content = "";
        for (int i = 0; i < data.size(); ++i) {
            content = i == data.size() - 1 ? content + (String)data.get(i) : content + (String)data.get(i) + "\n";
        }
        if (content != null && !content.equals("")) {
            try (FileOutputStream fos = null;){
                File file = new File(fileName);
                if (!file.exists()) {
                    file.createNewFile();
                }
                fos = new FileOutputStream(file);
                fos.write(content.getBytes());
            }
        }
    }

    public Vector getIndexValus() {
        return this.indexValues;
    }

    public JTextComponent getTextComponent() {
        return this.parent;
    }

    public void setCanDoValueChange(boolean isCanDoValueChange) {
        this.isCanDoValueChange = isCanDoValueChange;
    }

    public boolean isCanDoValueChange() {
        return this.isCanDoValueChange;
    }

    public void removeListener() {
        if (this.popup != null) {
            ((AutoSearchPopup)this.popup).uninstallListListeners();
        }
        if (this.valueChangeListener != null) {
            this.parent.getDocument().removeDocumentListener(this.valueChangeListener);
        }
        if (this.autoSearchFocusListener != null) {
            this.parent.removeFocusListener(this.autoSearchFocusListener);
        }
        if (this.autoSearchKeyListener != null) {
            this.parent.removeKeyListener(this.autoSearchKeyListener);
        }
        this.popup = null;
    }

    class AutoSearchKeyListener
    implements KeyListener {
        AutoSearchKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (!KDAutoSearch.this.popup.isVisible()) {
                return;
            }
            JList<Object> list = KDAutoSearch.this.popup.getList();
            int selectedIndex = list.getSelectedIndex();
            int itemCount = list.getModel().getSize();
            if (itemCount == 0) {
                KDAutoSearch.this.popup.hide();
                return;
            }
            switch (e.getKeyCode()) {
                case 40: {
                    if (++selectedIndex > itemCount - 1) {
                        selectedIndex = itemCount - 1;
                    }
                    list.setSelectedIndex(selectedIndex);
                    list.ensureIndexIsVisible(selectedIndex);
                    break;
                }
                case 38: {
                    if (--selectedIndex < 0) {
                        selectedIndex = 0;
                    }
                    list.setSelectedIndex(selectedIndex);
                    list.ensureIndexIsVisible(selectedIndex);
                    break;
                }
                case 33: {
                    if ((selectedIndex -= 5) < 0) {
                        selectedIndex = 0;
                    }
                    list.setSelectedIndex(selectedIndex);
                    list.ensureIndexIsVisible(selectedIndex);
                    break;
                }
                case 34: {
                    if ((selectedIndex += 5) > itemCount - 1) {
                        selectedIndex = itemCount - 1;
                    }
                    list.setSelectedIndex(selectedIndex);
                    list.ensureIndexIsVisible(selectedIndex);
                    break;
                }
                case 10: {
                    KDAutoSearch.this.setCanDoValueChange(false);
                    KDAutoSearch.this.parent.setText(list.getSelectedValue().toString());
                    if (KDAutoSearch.this.parent.getText() != null) {
                        KDAutoSearch.this.parent.setCaretPosition(KDAutoSearch.this.parent.getText().length());
                    }
                    KDAutoSearch.this.popup.hide();
                    break;
                }
            }
        }
    }

    class AutoSearchFocusListener
    implements FocusListener {
        AutoSearchFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            String text = KDAutoSearch.this.parent.getText();
            if (text == null || text.equals("")) {
                return;
            }
            String indexValue = "";
            boolean existValue = false;
            for (int i = 0; i < KDAutoSearch.this.indexValues.size(); ++i) {
                indexValue = (String)KDAutoSearch.this.indexValues.get(i);
                if (!text.equals(indexValue)) continue;
                existValue = true;
                break;
            }
            if (!existValue) {
                KDAutoSearch.this.indexValues.add(text);
            }
            try {
                KDAutoSearch.this.writeData(KDAutoSearch.this.fileName, KDAutoSearch.this.indexValues);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    class ValueChangeListener
    implements DocumentListener {
        ValueChangeListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.valueChange(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.valueChange(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.valueChange(e);
        }

        private void valueChange(DocumentEvent e) {
            if (!KDAutoSearch.this.isCanDoValueChange) {
                KDAutoSearch.this.isCanDoValueChange = true;
                return;
            }
            String text = KDAutoSearch.this.parent.getText();
            String indexValue = "";
            KDAutoSearch.this.popup.getList().removeAll();
            if (KDAutoSearch.this.popup.isVisible()) {
                KDAutoSearch.this.popup.hide();
            }
            int popupItemCount = 0;
            Vector vListData = new Vector();
            if (text == null || text.equals("")) {
                for (int i = 0; i < KDAutoSearch.this.indexValues.size(); ++i) {
                    indexValue = (String)KDAutoSearch.this.indexValues.get(i);
                    KDAutoSearch.this.addData(vListData, indexValue);
                    ++popupItemCount;
                }
            } else {
                for (int i = 0; i < KDAutoSearch.this.indexValues.size(); ++i) {
                    indexValue = (String)KDAutoSearch.this.indexValues.get(i);
                    if (!indexValue.startsWith(text)) continue;
                    KDAutoSearch.this.addData(vListData, indexValue);
                    ++popupItemCount;
                }
            }
            if (vListData.size() != 0) {
                KDAutoSearch.this.popup.getList().setListData(vListData);
            }
            if (popupItemCount != 0) {
                KDAutoSearch.this.popup.show();
            }
        }
    }
}

