/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing;

import com.kingdee.bos.ctrl.swing.DefaultKingdeeListCellRenderer;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.StringUtils;
import java.awt.AWTEvent;
import java.awt.event.KeyEvent;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.TreeSet;
import javax.swing.AbstractListModel;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class KDFilteredList<E>
extends JList<E> {
    private static final long serialVersionUID = 7449243164207689297L;
    private FilterField filterField;
    private Comparator<? super E> cp;
    private boolean sort;

    public KDFilteredList() {
        this(0, null);
    }

    public KDFilteredList(int searchTextWidth, Comparator<? super E> p) {
        this.cp = p;
        this.setModel((ListModel)new FilterModel());
        this.filterField = new FilterField(searchTextWidth);
        this.setCellRenderer(new DefaultKingdeeListCellRenderer());
    }

    public boolean isSort() {
        return this.sort;
    }

    public void setSort(boolean sort) {
        this.sort = sort;
    }

    @Override
    public void setModel(ListModel m) {
        if (!(m instanceof FilterModel)) {
            throw new IllegalArgumentException();
        }
        super.setModel(m);
    }

    @Override
    public void setListData(E[] listData) {
        this.getFModel().clear();
        for (E e : listData) {
            this.getFModel().addElement(e);
        }
    }

    private FilterModel<E> getFModel() {
        return (FilterModel)this.getModel();
    }

    public void addItem(E o) {
        this.getFModel().addElement(o);
    }

    public KDTextField getFilterField() {
        return this.filterField;
    }

    @Override
    protected void processEvent(AWTEvent e) {
        super.processEvent(e);
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        return super.processKeyBinding(ks, e, condition, pressed);
    }

    public int getElementCount() {
        return this.getModel().getSize();
    }

    public int getRealSize() {
        return ((FilterModel)this.getModel()).getRealSize();
    }

    class FilterField
    extends KDTextField
    implements DocumentListener {
        private static final long serialVersionUID = 1L;

        public FilterField(int width) {
            super(width);
            this.getDocument().addDocumentListener(this);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            ((FilterModel)KDFilteredList.this.getFModel()).refilter();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            ((FilterModel)KDFilteredList.this.getFModel()).refilter();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            ((FilterModel)KDFilteredList.this.getFModel()).refilter();
        }
    }

    class FilterModel<E>
    extends AbstractListModel<E> {
        private static final long serialVersionUID = -3194000804882859082L;
        List<E> items = new ArrayList();
        List<E> filterItems = new ArrayList();

        @Override
        public E getElementAt(int index) {
            if (index < this.filterItems.size()) {
                return this.filterItems.get(index);
            }
            return null;
        }

        @Override
        public int getSize() {
            return this.filterItems.size();
        }

        public int getRealSize() {
            return this.items.size();
        }

        public void addElement(E o) {
            this.items.add(o);
            this.refilter();
        }

        public void clear() {
            this.items.clear();
        }

        private void refilter() {
            this.filterItems.clear();
            AbstractSet set = new LinkedHashSet();
            String term = KDFilteredList.this.getFilterField().getText();
            if ((null != KDFilteredList.this.cp || KDFilteredList.this.sort) && !StringUtils.isEmpty(term)) {
                set = new TreeSet(KDFilteredList.this.cp);
            }
            for (int i = 0; i < this.items.size(); ++i) {
                if (this.items.get(i).toString().indexOf(term, 0) == -1) continue;
                set.add(this.items.get(i));
            }
            this.filterItems.addAll(set);
            this.fireContentsChanged(this, 0, this.getSize());
        }
    }
}

