/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.dial;

import com.kingdee.bos.ctrl.swing.dial.DialElement;
import com.kingdee.bos.ctrl.swing.dial.DialScale;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class DialNeedle
implements DialElement {
    private static AffineTransform transform = new AffineTransform();
    protected static final double BADANGLE = 0.0;
    protected Object value;
    protected EventListenerList listenerList = new EventListenerList();
    protected transient ChangeEvent changeEvent = null;
    protected Point axle;
    protected int radius;
    protected DialScale scale;

    public DialNeedle() {
    }

    public DialNeedle(Point o, int r) {
        this.setAxle(o);
        this.setRadius(r);
    }

    public void setValue(Object v) {
        this.value = v;
        this.fireStateChanged();
    }

    public Object getValue() {
        return this.value;
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
        }
    }

    public Point getAxle() {
        return this.axle;
    }

    public void setAxle(Point p) {
        this.axle = p;
    }

    public DialScale getScale() {
        return this.scale;
    }

    public void setScale(DialScale scl) {
        DialScale old = this.scale;
        if (old != null) {
            old.dismiss();
        }
        this.scale = scl;
        if (this.scale != null) {
            this.scale.install(this);
        }
    }

    @Override
    public void draw(Graphics g, Rectangle area, JComponent c) {
        g.setColor(Color.BLUE);
        double angle = this.getAngle();
        Point pt = this.getAxle();
        int r = this.getRadius();
        this.drawNeedle(g, area, pt, r, angle, c);
    }

    protected void drawNeedle(Graphics g, Rectangle area, Point pt, int r, double angle, JComponent c) {
        Graphics2D g2 = (Graphics2D)g;
        Line2D.Float shape = new Line2D.Float();
        Shape d = null;
        ((Line2D)shape).setLine(pt.x, pt.y, pt.x - r, pt.y);
        if (angle != 0.0) {
            this.getTransform().setToRotation(StrictMath.toRadians(angle), pt.x, pt.y);
            d = this.getTransform().createTransformedShape(shape);
        } else {
            d = shape;
        }
        g2.draw(d);
        g2.fillArc(pt.x - 5, pt.y - 5, 10, 10, 0, 360);
    }

    private AffineTransform getTransform() {
        return transform;
    }

    protected double getAngle() {
        DialScale scl = this.getScale();
        if (scl == null) {
            return 0.0;
        }
        return scl.getAngle(this.getValue());
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int r) {
        this.radius = r;
    }

    public String getCaption() {
        if (this.scale != null) {
            return this.scale.getCaption();
        }
        return "";
    }
}

