/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.dial;

import com.kingdee.bos.ctrl.swing.dial.DialScale;
import com.kingdee.bos.ctrl.swing.dial.DialTickValueGenerator;
import com.kingdee.bos.ctrl.swing.dial.KpiRange;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.text.Format;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.JComponent;

public class ImageScale
extends DialScale {
    protected KpiRange normalRange;
    protected KpiRange warningRange;
    protected KpiRange criticalRange;
    protected Paint defaultPaint = new Color(0x414142);
    protected Paint normalPaint = Color.GREEN;
    protected Paint warningPaint = Color.YELLOW;
    protected Paint criticalPaint = Color.RED;
    protected Paint labelShadowColor = this.defaultPaint;
    protected boolean drawLabel = true;

    public ImageScale() {
    }

    public ImageScale(Point pt, int r) {
        super(pt, r);
    }

    public ImageScale(Point pt, int r, int minAngle, int arcAngle) {
        super(pt, r, minAngle, arcAngle);
    }

    public ImageScale(Point pt, int r, int minAngle, int arcAngle, boolean cw) {
        super(pt, r, minAngle, arcAngle, cw);
    }

    @Override
    public void setMaximumValue(Object maxValue) {
        if (maxValue instanceof Number) {
            this.maximumValue = new Double(((Number)maxValue).doubleValue());
            this.setDirty(true);
        }
    }

    @Override
    public void setMinimumValue(Object minValue) {
        if (minValue instanceof Number) {
            this.minimumValue = new Double(((Number)minValue).doubleValue());
            this.setDirty(true);
        }
    }

    public void setNormalRange(KpiRange range) {
        this.normalRange = range;
    }

    public void setWarningRange(KpiRange range) {
        this.warningRange = range;
    }

    public void setCriticalRange(KpiRange range) {
        this.criticalRange = range;
    }

    public KpiRange getNormalRange() {
        return this.normalRange;
    }

    public KpiRange getWarningRange() {
        return this.warningRange;
    }

    public KpiRange getCriticalRange() {
        return this.criticalRange;
    }

    public Paint getDefaultPaint() {
        return this.defaultPaint;
    }

    public void setDefaultPaint(Paint paint) {
        this.defaultPaint = paint;
    }

    public void setNormalPaint(Paint p) {
        this.normalPaint = p;
    }

    public void setWarningPaint(Paint p) {
        this.warningPaint = p;
    }

    public void setCriticalPaint(Paint p) {
        this.criticalPaint = p;
    }

    public Paint getNormalPaint() {
        return this.normalPaint;
    }

    public Paint getWarningPaint() {
        return this.warningPaint;
    }

    public Paint getCriticalPaint() {
        return this.criticalPaint;
    }

    public Paint getLabelShadowColor() {
        return this.labelShadowColor;
    }

    public void setLabelShadowColor(Color color) {
        this.labelShadowColor = color;
    }

    @Override
    protected DialTickValueGenerator createGenerator() {
        return new KpiTicker();
    }

    @Override
    protected void drawTicks(Graphics2D g2, double amin, double as, JComponent c) {
        Paint oldPaint = g2.getPaint();
        Font oldFont = g2.getFont();
        Font newFont = oldFont.deriveFont(1);
        g2.setFont(newFont);
        int LOWANGLE = 20;
        int UPANGLE = 160;
        int GAP = 2;
        int tickLen = this.getTickLength();
        Format ft = this.getTickLabelFormat();
        String label = "";
        FontMetrics fm = g2.getFontMetrics();
        int w = 0;
        int h = fm.getAscent() - fm.getLeading();
        double x1 = 0.0;
        double y1 = 0.0;
        double x2 = 0.0;
        double y2 = 0.0;
        double x3 = 0.0;
        double y3 = 0.0;
        double rcos = 0.0;
        double rsin = 0.0;
        int r = this.getRadius();
        double angle = 0.0;
        double temp = 0.0;
        Object val = null;
        while (this.generator.hasNext()) {
            val = this.generator.next();
            angle = this.getAngle(val);
            rcos = Math.cos(Math.toRadians(angle));
            rsin = Math.sin(Math.toRadians(angle));
            x1 = (double)this.getAxle().x - rcos * (double)r;
            y1 = (double)this.getAxle().y - rsin * (double)r;
            x2 = (double)this.getAxle().x - rcos * (double)(r - tickLen);
            y2 = (double)this.getAxle().y - rsin * (double)(r - tickLen);
            g2.setPaint(this.getTicksPaint());
            g2.drawLine((int)x1, (int)y1, (int)x2, (int)y2);
            if (!this.isDrawLabel()) continue;
            label = ft != null ? ft.format(val) : val.toString();
            w = fm.stringWidth(label);
            temp = angle > 20.0 && angle < 160.0 ? (double)h / (2.0 * rsin) : (double)w / (2.0 * rcos);
            temp = Math.abs(temp) + 2.0;
            x3 = x2 + temp * rcos;
            y3 = y2 + temp * rsin;
            x3 -= (double)(w / 2);
            if ((y3 += (double)(h / 2)) > (double)this.getAxle().y) {
                y3 = this.getAxle().y;
            }
            g2.setPaint(this.getLabelShadowColor());
            g2.drawString(label, (float)x3, (float)y3);
            g2.setPaint(this.getTickLabelPaint());
            g2.drawString(label, (float)x3 - 1.0f, (float)y3 - 1.0f);
        }
        g2.setPaint(oldPaint);
        g2.setFont(oldFont);
    }

    @Override
    protected void drawArcs(Graphics2D g2, double start, double arc, JComponent c) {
        int r = this.getRadius();
        int x = this.getAxle().x;
        int y = this.getAxle().y;
        int w = this.getTickLength();
        r -= w / 2;
        Stroke old = g2.getStroke();
        BasicStroke stk = new BasicStroke(w, 0, 2);
        g2.setStroke(stk);
        KpiRange range = null;
        Paint paint = null;
        range = new KpiRange((Double)this.getMinimumValue(), (Double)this.getMaximumValue());
        paint = this.getDefaultPaint();
        start = this.graduator.getAngle(new Double(range.getLowerBound()));
        arc = this.graduator.getAngle(new Double(range.getUpperBound())) - start;
        this.drawArc(g2, x, y, r, (int)start, (int)arc, paint);
        stk = new BasicStroke(--w, 0, 2);
        g2.setStroke(stk);
        range = this.getNormalRange();
        if (range != null) {
            paint = this.getNormalPaint();
            start = this.graduator.getAngle(new Double(range.getLowerBound()));
            arc = this.graduator.getAngle(new Double(range.getUpperBound())) - start;
            this.drawArc(g2, x, y, r, (int)start, (int)arc, paint);
        }
        if ((range = this.getWarningRange()) != null) {
            paint = this.getWarningPaint();
            start = this.graduator.getAngle(new Double(range.getLowerBound()));
            arc = this.graduator.getAngle(new Double(range.getUpperBound())) - start;
            this.drawArc(g2, x, y, r, (int)start, (int)arc, paint);
        }
        if ((range = this.getCriticalRange()) != null) {
            paint = this.getCriticalPaint();
            start = this.graduator.getAngle(new Double(range.getLowerBound()));
            arc = this.graduator.getAngle(new Double(range.getUpperBound())) - start;
            this.drawArc(g2, x, y, r, (int)start, (int)arc, paint);
        }
        g2.setStroke(old);
    }

    private void drawArc(Graphics2D g2, int x, int y, int r, double start, double arc, Paint paint) {
        g2.setPaint(paint);
        Arc2D.Double arcShape = null;
        arcShape = this.isClockWise() ? new Arc2D.Double(x - r, y - r, 2 * r, 2 * r, DialScale.DialUtils.cwToGeom(start, arc), arc, 0) : new Arc2D.Double(x - r, y - r, 2 * r, 2 * r, start, arc, 0);
        g2.draw(arcShape);
    }

    public boolean isDrawLabel() {
        return this.drawLabel;
    }

    public void setDrawLabel(boolean b) {
        this.drawLabel = b;
    }

    public class KpiTicker
    implements DialTickValueGenerator {
        private int index = 0;
        private List values = new ArrayList();
        private static final int STEP = 20;

        @Override
        public boolean hasNext() {
            if (this.index > 0) {
                return true;
            }
            this.reverse();
            return false;
        }

        @Override
        public Object next() {
            --this.index;
            if (this.index < 0) {
                throw new NoSuchElementException();
            }
            return this.values.get(this.index);
        }

        @Override
        public void setParameters(Object min, Object max) {
            this.addValue(ImageScale.this.getNormalRange());
            this.addValue(ImageScale.this.getWarningRange());
            this.addValue(ImageScale.this.getCriticalRange());
            if (this.values.isEmpty()) {
                int mini = ((Number)min).intValue();
                int maxi = ((Number)max).intValue();
                int temp = mini - mini % 20;
                if (temp <= mini) {
                    temp += 20;
                }
                this.values.add(new Double(mini));
                while (temp < maxi) {
                    this.values.add(new Double(temp));
                    temp += 20;
                }
                this.values.add(new Double(maxi));
            }
            this.addValue(new KpiRange((Double)ImageScale.this.getMinimumValue(), (Double)ImageScale.this.getMaximumValue()));
            this.reverse();
        }

        private void addValue(KpiRange range) {
            Double val = null;
            if (range != null) {
                val = new Double(range.getLowerBound());
                if (this.values.indexOf(val) == -1) {
                    this.values.add(val);
                }
                if (this.values.indexOf(val = new Double(range.getUpperBound())) == -1) {
                    this.values.add(val);
                }
            }
        }

        private void reverse() {
            this.index = this.values.size();
        }
    }
}

