/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.dial;

import com.kingdee.bos.ctrl.swing.dial.DialNeedle;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import javax.swing.JComponent;

public class KpiNeedle
extends DialNeedle {
    protected static final double NEEDLE_RADIUS = 0.6705882352941176;
    protected static final double NEEDLE_RADIUS_L = 0.611764705882353;
    protected static final double NEEDLE_TOP_W = 0.04615384615384615;
    protected static final double NEEDLE_BOTTOM_W = 0.08235294117647059;
    protected static final double BORDER_OF_NEEDLE = 0.14285714285714285;
    protected static final Color NEEDLE_BACK = Color.GRAY;
    protected static final Color NEEDLE_FORE = new Color(16755265);
    protected static final double PANHEIGHT = 0.023529411764705882;
    protected static final double TICKWIDTH = 0.12941176470588237;
    private Paint borderPaint = NEEDLE_BACK;
    private Paint fillPaint = NEEDLE_FORE;

    public KpiNeedle() {
    }

    public KpiNeedle(Point o, int r) {
        super(o, r);
    }

    @Override
    public void draw(Graphics g, Rectangle area, JComponent c) {
        int height = area.height;
        int width = area.width;
        Rectangle backupClip = g.getClipBounds();
        int r = (int)(0.6705882352941176 * (double)height);
        if (r < 3) {
            r = 3;
        }
        int botw = (int)(0.08235294117647059 * (double)height);
        int borderOfNeedle = (int)(0.14285714285714285 * (double)botw);
        double BOTW_MIN = 3.0;
        int tickWidth = (int)(0.12941176470588237 * (double)height);
        if (tickWidth > 20) {
            tickWidth = 20;
            r = (int)(0.611764705882353 * (double)height + (double)(tickWidth / 3));
        }
        int x = area.x + width / 2;
        int y = area.y + height - (int)(0.023529411764705882 * (double)height);
        double angle = this.getAngle();
        Rectangle newClip = new Rectangle(area.x, area.y, width, height - (int)((double)height * 0.023529411764705882));
        newClip = newClip.intersection(backupClip);
        g.setClip(newClip);
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform old = null;
        old = g2.getTransform();
        g2.rotate(StrictMath.toRadians(angle), x, y);
        g2.setPaint(NEEDLE_FORE);
        if ((double)botw < 3.0) {
            g2.fillRect(x - r, (int)((double)y - 0.5), r, 1);
        } else {
            int bottomBotw = botw / 2;
            int topBotw = botw / 6;
            int topCircleRadius = topBotw * 2 - 1;
            int[] xs = new int[]{x, x, x - r, x - r};
            int[] ys = new int[]{y + bottomBotw, y - bottomBotw, y - topBotw, y + topBotw};
            g2.fillPolygon(xs, ys, 4);
            g2.fillArc(xs[2] - topBotw + 1, ys[2], topCircleRadius, topCircleRadius, 90, 180);
            xs = null;
            ys = null;
            xs = new int[]{x, x, x - r};
            ys = new int[]{y + bottomBotw, y + bottomBotw - borderOfNeedle, y + topBotw};
            g2.setPaint(new Color(16049041));
            g2.fillPolygon(xs, ys, 3);
            xs = null;
            ys = null;
            xs = new int[]{x, x, x - r};
            ys = new int[]{y - bottomBotw, y - bottomBotw + borderOfNeedle, y - topBotw};
            g2.setPaint(new Color(0x534435));
            g2.fillPolygon(xs, ys, 3);
        }
        if (old != null) {
            g2.setTransform(old);
        }
        int tempRadius = 0;
        tempRadius = (int)((double)height * 0.12352941176470589);
        g2.setPaint(new Color(0x9A9A9A));
        g2.fillArc(x - tempRadius, y - tempRadius, 2 * tempRadius, 2 * tempRadius, 0, 180);
        tempRadius = (int)((double)height * 0.11176470588235295);
        GradientPaint p = new GradientPaint(x + tempRadius, y - tempRadius, new Color(0x9E9E9E), x, y, new Color(0xEEEEEE));
        GradientPaint p2 = new GradientPaint(x - tempRadius, y - tempRadius, new Color(0x9E9E9E), x, y, new Color(0xEEEEEE));
        g2.setPaint(p);
        g2.fillArc(x - tempRadius, y - tempRadius, 2 * tempRadius, 2 * tempRadius, 0, 90);
        g2.setPaint(p2);
        g2.fillArc(x - tempRadius, y - tempRadius, 2 * tempRadius, 2 * tempRadius, 90, 90);
        g.setClip(backupClip);
    }

    public Paint getBorderPaint() {
        return this.borderPaint;
    }

    public Paint getFillPaint() {
        return this.fillPaint;
    }

    public void setBorderPaint(Paint paint) {
        this.borderPaint = paint;
    }

    public void setFillPaint(Paint paint) {
        this.fillPaint = paint;
    }
}

