/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.plaf;

import com.kingdee.bos.ctrl.swing.ComboFunctionChooserDownList;
import com.kingdee.bos.ctrl.swing.plaf.KingdeeComboFunctionChooserUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Area;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class ComboFunctionChooserDownListUI
extends ComponentUI {
    private static int NO_SHADOW_EFFECT = -1;
    private static int SHADOW_EFFECT_ON_MORE_CELL = -2;
    private ComboFunctionChooserDownList c;
    private int shadowEffectIndex = NO_SHADOW_EFFECT;
    private boolean mousePressed;
    private ShadowEffectMouseListener shadowEffectMouseListener = new ShadowEffectMouseListener();
    private MouseActionListener mouseActionListener = new MouseActionListener();

    @Override
    public void paint(Graphics g, JComponent c) {
        Color oldcolor;
        Area cover;
        Point p;
        super.paint(g, c);
        Color oldColor = g.getColor();
        Color shadowColor = UIManager.getColor("ComboFunctionChooser.look.shadowColor");
        Shape oldClip = g.getClip();
        Area target = new Area(oldClip);
        if (this.c.getOwner().getDownListLocation() == KingdeeComboFunctionChooserUI.DOWN_THE_OWNER) {
            p = this.c.getOwner().getLocationOnScreen();
            p = new Point(p.x + 1, p.y + this.c.getOwner().getHeight());
            SwingUtilities.convertPointFromScreen(p, c);
            cover = new Area(new Rectangle(p.x, p.y - 1, this.c.getOwner().getWidth() - 2, 1));
            target.subtract(cover);
        } else {
            p = this.c.getOwner().getLocationOnScreen();
            p = new Point(p.x + 1, p.y);
            SwingUtilities.convertPointFromScreen(p, c);
            cover = new Area(new Rectangle(p.x, p.y - 1, this.c.getOwner().getWidth() - 2, 1));
            target.subtract(cover);
        }
        g.setColor(shadowColor);
        g.setClip(target);
        g.drawRect(0, 0, this.getPreferredSize((JComponent)c).width - 1, this.getPreferredSize((JComponent)c).height - 1);
        g.setClip(oldClip);
        g.setColor(oldColor);
        for (int i = 0; i < this.c.getModel().getActionIcons().length; ++i) {
            Rectangle actionCellRectangle = this.c.getModel().getActionCellRectangleWithoutBorder(i);
            this.c.getModel().getActionIcons()[i].paintIcon(c, g, actionCellRectangle.x, actionCellRectangle.y);
        }
        if (this.c.getModel().isMoreCellEnabled()) {
            Rectangle moreRect = this.c.getModel().getMoreCellRectangle();
            this.c.getModel().getMoreCellActionIcon().paintIcon(c, g, moreRect.x + 2, moreRect.y + 2);
            if (this.mousePressed && this.shadowEffectIndex == SHADOW_EFFECT_ON_MORE_CELL) {
                g.setColor(UIManager.getColor("ComboFunctionChooser.look.pressedFontColor"));
                g.drawString(this.c.getOwner().getMoreString(), moreRect.x + 2 + this.c.getModel().getMoreCellActionIcon().getIconWidth(), moreRect.y + g.getFontMetrics().getAscent() + 2);
                g.setColor(oldColor);
            } else {
                g.setColor(Color.BLACK);
                g.drawString(this.c.getOwner().getMoreString(), moreRect.x + 2 + this.c.getModel().getMoreCellActionIcon().getIconWidth(), moreRect.y + g.getFontMetrics().getAscent() + 2);
                g.setColor(oldColor);
            }
        }
        if (this.shadowEffectIndex > NO_SHADOW_EFFECT) {
            Rectangle rectD = this.c.getModel().getActionCellRectangleWithBorder(this.shadowEffectIndex);
            oldcolor = g.getColor();
            g.setColor(shadowColor);
            g.drawRect(rectD.x, rectD.y, rectD.width - 1, rectD.height - 1);
            if (this.mousePressed) {
                g.setColor(new Color(shadowColor.getRed(), shadowColor.getGreen(), shadowColor.getBlue(), 160));
            } else {
                g.setColor(new Color(shadowColor.getRed(), shadowColor.getGreen(), shadowColor.getBlue(), 80));
            }
            g.fillRect(rectD.x, rectD.y, rectD.width, rectD.height);
            g.setColor(oldcolor);
        } else if (this.shadowEffectIndex == SHADOW_EFFECT_ON_MORE_CELL) {
            Rectangle moreRect = this.c.getModel().getMoreCellRectangle();
            oldcolor = g.getColor();
            g.setColor(shadowColor);
            g.drawRect(moreRect.x, moreRect.y, moreRect.width - 1, moreRect.height - 1);
            if (this.mousePressed) {
                g.setColor(new Color(shadowColor.getRed(), shadowColor.getGreen(), shadowColor.getBlue(), 160));
            } else {
                g.setColor(new Color(shadowColor.getRed(), shadowColor.getGreen(), shadowColor.getBlue(), 80));
            }
            g.fillRect(moreRect.x, moreRect.y, moreRect.width, moreRect.height);
            g.setColor(oldcolor);
        }
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.c = (ComboFunctionChooserDownList)c;
        this.installListeners();
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallListeners();
        super.uninstallUI(c);
    }

    private void installListeners() {
        this.c.addMouseMotionListener(this.shadowEffectMouseListener);
        this.c.addMouseListener(this.mouseActionListener);
    }

    private void uninstallListeners() {
        this.c.removeMouseListener(this.mouseActionListener);
        this.c.removeMouseMotionListener(this.shadowEffectMouseListener);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension actionCellPanelDimension = this.c.getModel().getActionCellPanelDimension();
        if (this.c.getModel().isMoreCellEnabled()) {
            Dimension moreCellPanelDimension = this.c.getModel().getMoreCellPanelDimension();
            return new Dimension(actionCellPanelDimension.width, moreCellPanelDimension.height + actionCellPanelDimension.height);
        }
        return actionCellPanelDimension;
    }

    private void setShadowEffectOwnerIndex(Point p) {
        int x = p.x - this.c.getModel().getActionCellPanelInsets();
        int y = p.y - this.c.getModel().getActionCellPanelInsets();
        int columnCount = this.c.getModel().getActionCellColumnCount();
        int actionCount = this.c.getModel().getActionIcons().length;
        Rectangle moreRect = this.c.getModel().getMoreCellRectangle();
        int column = x / this.c.getModel().getActionCellDimension().width;
        int row = y / this.c.getModel().getActionCellDimension().height;
        this.shadowEffectIndex = column >= columnCount || row * columnCount + column >= actionCount ? NO_SHADOW_EFFECT : row * columnCount + column;
        if (this.c.getModel().isMoreCellEnabled() && p.x > moreRect.x && p.x < moreRect.x + moreRect.width && p.y > moreRect.y && p.y < moreRect.y + moreRect.height) {
            this.shadowEffectIndex = SHADOW_EFFECT_ON_MORE_CELL;
        }
    }

    public int getShadowEffectIndex() {
        return this.shadowEffectIndex;
    }

    private class MouseActionListener
    implements MouseListener {
        private MouseActionListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (ComboFunctionChooserDownListUI.this.shadowEffectIndex == NO_SHADOW_EFFECT) {
                return;
            }
            if (ComboFunctionChooserDownListUI.this.shadowEffectIndex == SHADOW_EFFECT_ON_MORE_CELL) {
                ComboFunctionChooserDownListUI.this.c.getOwner().actionPerformed(-2);
                ComboFunctionChooserDownListUI.this.c.getOwner().getUI().setPopupVisible(false);
            } else {
                ComboFunctionChooserDownListUI.this.c.getOwner().actionPerformed(ComboFunctionChooserDownListUI.this.shadowEffectIndex);
                ComboFunctionChooserDownListUI.this.c.getModel().setDefaultActionIcon(ComboFunctionChooserDownListUI.this.c.getModel().getActionIcons()[ComboFunctionChooserDownListUI.this.shadowEffectIndex]);
                ComboFunctionChooserDownListUI.this.c.getOwner().getUI().setPopupVisible(false);
            }
            ComboFunctionChooserDownListUI.this.mousePressed = false;
            ComboFunctionChooserDownListUI.this.c.repaint();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            ComboFunctionChooserDownListUI.this.mousePressed = true;
            ComboFunctionChooserDownListUI.this.c.repaint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            ComboFunctionChooserDownListUI.this.mousePressed = false;
            ComboFunctionChooserDownListUI.this.c.repaint();
        }
    }

    private class ShadowEffectMouseListener
    implements MouseMotionListener {
        private ShadowEffectMouseListener() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            ComboFunctionChooserDownListUI.this.setShadowEffectOwnerIndex(e.getPoint());
            ComboFunctionChooserDownListUI.this.c.repaint();
        }
    }
}

