/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.plaf;

import com.kingdee.bos.ctrl.common.variant.Util;
import com.kingdee.bos.ctrl.swing.KDCurrencyEditor;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.GeneralPath;
import java.math.BigDecimal;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class KingdeeCurrencyEditorUI
extends ComponentUI {
    private KDCurrencyEditor ce;
    private int leftPerGrid;
    private int rightPerGrid;
    private int brokenGridCount;
    private Rectangle[] cloudyRects;
    private Rectangle[] clearRects;
    private int brokenPosition = -1;
    private int leftWidth;
    private int rightWidth;
    private static int CLOUDY_BROKEN_GRID = 0;
    private static int CLEAR_BROKEN_GRID = 1;
    private int trianglePosition = -1;
    private KeyListener keyboardLogicListener = new KeyboardLogicListener();
    private MouseListener mouseLogicListener = new MouseLogicListener();
    private FocusListener focusLogicListener = new FocusLogicListener();
    private DataChangeListener dataChangeListener = new ModelDataChangeListener();

    @Override
    public void installUI(JComponent c) {
        this.ce = (KDCurrencyEditor)c;
        super.installUI(c);
        this.installListeners(c);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.uninstallListeners(c);
    }

    protected void installListeners(JComponent c) {
        this.ce.addKeyListener(this.keyboardLogicListener);
        this.ce.addMouseListener(this.mouseLogicListener);
        this.ce.addFocusListener(this.focusLogicListener);
        this.ce.getModel().addModelChangeListener(this.dataChangeListener);
    }

    protected void uninstallListeners(JComponent c) {
        this.ce.removeFocusListener(this.focusLogicListener);
        this.ce.removeMouseListener(this.mouseLogicListener);
        this.ce.removeKeyListener(this.keyboardLogicListener);
        this.ce.getModel().removeModelChangeListener(this.dataChangeListener);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Color oldColor = g.getColor();
        g.setColor(Color.black);
        this.paintCloudAndLines(g);
        if (this.ce.getValue() != null) {
            this.paintNumbers(g);
        }
        this.paintTriangle(g);
        g.setColor(oldColor);
    }

    /*
     * Unable to fully structure code
     */
    protected void paintCloudAndLines(Graphics g) {
        this.calculateAndInit();
        oldColor = g.getColor();
        temp = UIManager.getColor("CurrencyEditor.lightGrayCloudColor");
        cloudColor = new Color(temp.getRed(), temp.getGreen(), temp.getBlue(), 200);
        chiliarchBorderColor = UIManager.getColor("CurrencyEditor.chiliarchBorderColor");
        normalSeparatorColor = UIManager.getColor("CurrencyEditor.normalSeparatorColor");
        horizontalBorderColor = UIManager.getColor("CurrencyEditor.horizontalBorderColor");
        g.setColor(horizontalBorderColor);
        g.drawLine(0, 0, this.ce.getWidth(), 0);
        g.drawLine(0, this.ce.getHeight() - 1, this.ce.getWidth(), this.ce.getHeight() - 1);
        g.setColor(chiliarchBorderColor);
        g.drawLine(0, 0, 0, this.ce.getHeight());
        g.drawLine(this.ce.getWidth() - 1, 0, this.ce.getWidth() - 1, this.ce.getHeight());
        block8: for (i = this.cloudyRects.length - 1; i >= 0; --i) {
            rect = this.cloudyRects[i];
            g.setColor(cloudColor);
            g.fillRect(rect.x, rect.y, rect.width, rect.height);
            g.setColor(chiliarchBorderColor);
            g.drawLine(rect.x, rect.y - 1, rect.x, rect.y + rect.height);
            if (i == 0) {
                radixSeparatorColor = UIManager.getColor("CurrencyEditor.radixSeparatorColor");
                g.setColor(radixSeparatorColor);
            }
            g.drawLine(rect.x + rect.width, rect.y - 1, rect.x + rect.width, rect.y + rect.height);
            g.setColor(normalSeparatorColor);
            if (i != this.cloudyRects.length - 1 || this.brokenGridCount == 0 || this.brokenPosition != KingdeeCurrencyEditorUI.CLOUDY_BROKEN_GRID) ** GOTO lbl-1000
            switch (this.brokenGridCount) {
                case 1: {
                    continue block8;
                }
                case 2: {
                    g.drawLine(rect.x + this.leftPerGrid, rect.y - 1, rect.x + this.leftPerGrid, rect.y + rect.height);
                    continue block8;
                }
                default: lbl-1000:
                // 2 sources

                {
                    g.drawLine(rect.x + this.leftPerGrid, rect.y - 1, rect.x + this.leftPerGrid, rect.y + rect.height);
                    g.drawLine(rect.x + this.leftPerGrid * 2, rect.y - 1, rect.x + this.leftPerGrid * 2, rect.y + rect.height);
                }
            }
        }
        block9: for (i = this.clearRects.length - 1; i >= 0; --i) {
            rect = this.clearRects[i];
            g.setColor(normalSeparatorColor);
            if (i != this.clearRects.length - 1 || this.brokenGridCount == 0 || this.brokenPosition != KingdeeCurrencyEditorUI.CLEAR_BROKEN_GRID) ** GOTO lbl-1000
            switch (this.brokenGridCount) {
                case 1: {
                    continue block9;
                }
                case 2: {
                    g.drawLine(rect.x + this.leftPerGrid, rect.y - 1, rect.x + this.leftPerGrid, rect.y + rect.height);
                    continue block9;
                }
                default: lbl-1000:
                // 2 sources

                {
                    g.drawLine(rect.x + this.leftPerGrid, rect.y - 1, rect.x + this.leftPerGrid, rect.y + rect.height);
                    g.drawLine(rect.x + this.leftPerGrid * 2, rect.y - 1, rect.x + this.leftPerGrid * 2, rect.y + rect.height);
                }
            }
        }
        for (i = 1; i < this.ce.getDecimalDigitCount(); ++i) {
            g.drawLine(this.leftWidth - 1 + this.rightPerGrid * i, 0, this.leftWidth - 1 + this.rightPerGrid * i, this.ce.getHeight());
        }
        g.setColor(oldColor);
    }

    protected void paintNumbers(Graphics g) {
        int i;
        Shape oldClip = g.getClip();
        Color oldColor = g.getColor();
        int sign = ((BigDecimal)this.ce.getValue()).signum();
        if (this.ce.isNegative()) {
            g.setColor(UIManager.getColor("CurrencyEditor.negativeColor"));
        }
        String temp = Util.bigDecimalToPlainString((BigDecimal)((BigDecimal)this.ce.getValue()));
        String[] temps = temp.split("\\.");
        String integerDigits = temps[0];
        String decimalDigits = temps.length == 2 ? temps[1] : "";
        Font oldFont = g.getFont();
        g.setFont(new Font("DIALOG", 1, 14));
        for (i = integerDigits.length(); i > 0; --i) {
            int position;
            if (i == 1 && sign < 0 || (position = this.ce.getIntegerDigitCount() - integerDigits.length() + i - 1) < 0) continue;
            String charValue = new String(new char[]{integerDigits.charAt(i - 1)});
            int baseX = this.leftPerGrid * position;
            int baseY = 0;
            int baseWidth = this.leftPerGrid;
            int baseHeight = this.ce.getHeight();
            g.setClip(baseX, baseY, baseWidth, baseHeight);
            g.drawString(charValue, baseX + baseWidth / 3, baseY + baseHeight / 2 + g.getFontMetrics().getLeading() + g.getFontMetrics().getDescent());
        }
        for (i = 0; i < this.ce.getDecimalDigitCount(); ++i) {
            String charValue = i < decimalDigits.length() ? new String(new char[]{decimalDigits.charAt(i)}) : "0";
            int baseX = this.leftPerGrid * this.ce.getIntegerDigitCount() + this.rightPerGrid * i;
            int baseY = 0;
            int baseWidth = this.rightPerGrid;
            int baseHeight = this.ce.getHeight();
            g.setClip(baseX, baseY, baseWidth, baseHeight);
            g.drawString(charValue, baseX + baseWidth / 4, baseY + baseHeight / 2 + g.getFontMetrics().getLeading() + g.getFontMetrics().getDescent());
        }
        g.setFont(oldFont);
        g.setColor(oldColor);
        g.setClip(oldClip);
    }

    protected void paintTriangle(Graphics g) {
        int baseWidth;
        int baseX;
        if (this.trianglePosition == -1) {
            return;
        }
        if (this.trianglePosition > this.ce.getIntegerDigitCount() - 1) {
            baseX = this.leftPerGrid * this.ce.getIntegerDigitCount() + this.rightPerGrid * (this.trianglePosition - this.ce.getIntegerDigitCount());
            baseWidth = this.rightPerGrid;
        } else {
            baseX = this.leftPerGrid * this.trianglePosition;
            baseWidth = this.leftPerGrid;
        }
        int baseY = 0;
        int baseHeight = this.ce.getHeight();
        g.translate(baseX + baseWidth / 3 * 2, baseY + baseHeight / 4 * 3);
        GeneralPath path = new GeneralPath();
        path.moveTo(0.0f, 0.0f);
        path.lineTo(-5.0f, 5.0f);
        path.lineTo(5.0f, 5.0f);
        path.closePath();
        ((Graphics2D)g).fill(path);
    }

    public void resetTrianglePosition() {
        this.trianglePosition = this.ce.getIntegerDigitCount() - 1;
    }

    private void calculateAndInit() {
        int i;
        int integerDigit = this.ce.getIntegerDigitCount();
        int decimalDigit = this.ce.getDecimalDigitCount();
        int width = this.ce.getWidth();
        int height = this.ce.getHeight();
        this.leftPerGrid = Math.round((float)width * 1.0f / (float)(integerDigit + decimalDigit));
        this.leftWidth = this.leftPerGrid * integerDigit;
        this.rightWidth = width - this.leftWidth;
        this.rightPerGrid = Math.round((float)this.rightWidth * 1.0f / (float)decimalDigit);
        int footPrint = this.leftPerGrid * 3;
        this.brokenGridCount = integerDigit % 3;
        int iterativeCount = this.brokenGridCount == 0 ? integerDigit / 3 : integerDigit / 3 + 1;
        ArrayList<Rectangle> cloudyCollector = new ArrayList<Rectangle>();
        ArrayList<Rectangle> clearCollector = new ArrayList<Rectangle>();
        boolean mark = true;
        for (i = iterativeCount; i > 0; --i) {
            Rectangle rect;
            if (mark) {
                if (i == 1 && this.brokenGridCount != 0) {
                    rect = new Rectangle(0, 1, this.brokenGridCount * this.leftPerGrid, height - 2);
                    this.brokenPosition = CLOUDY_BROKEN_GRID;
                } else {
                    rect = new Rectangle(this.leftWidth - footPrint * (iterativeCount - i + 1), 1, footPrint, height - 2);
                }
                cloudyCollector.add(rect);
                mark = false;
                continue;
            }
            if (i == 1 && this.brokenGridCount != 0) {
                rect = new Rectangle(0, 1, this.brokenGridCount * this.leftPerGrid, height - 2);
                this.brokenPosition = CLEAR_BROKEN_GRID;
            } else {
                rect = new Rectangle(this.leftWidth - footPrint * (iterativeCount - i + 1), 1, footPrint, height - 2);
            }
            clearCollector.add(rect);
            mark = true;
        }
        this.cloudyRects = new Rectangle[cloudyCollector.size()];
        for (i = 0; i < cloudyCollector.size(); ++i) {
            this.cloudyRects[i] = (Rectangle)cloudyCollector.get(i);
        }
        this.clearRects = new Rectangle[clearCollector.size()];
        for (i = 0; i < clearCollector.size(); ++i) {
            this.clearRects[i] = (Rectangle)clearCollector.get(i);
        }
    }

    private class ModelDataChangeListener
    implements DataChangeListener {
        private ModelDataChangeListener() {
        }

        @Override
        public void dataChanged(DataChangeEvent eventObj) {
            KingdeeCurrencyEditorUI.this.ce.revalidate();
            KingdeeCurrencyEditorUI.this.ce.repaint();
        }
    }

    private class FocusLogicListener
    implements FocusListener {
        private FocusLogicListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            KingdeeCurrencyEditorUI.this.trianglePosition = KingdeeCurrencyEditorUI.this.ce.getIntegerDigitCount() - 1;
            KingdeeCurrencyEditorUI.this.ce.revalidate();
            KingdeeCurrencyEditorUI.this.ce.repaint();
        }

        @Override
        public void focusLost(FocusEvent e) {
            KingdeeCurrencyEditorUI.this.trianglePosition = -1;
            KingdeeCurrencyEditorUI.this.ce.revalidate();
            KingdeeCurrencyEditorUI.this.ce.repaint();
        }
    }

    private class MouseLogicListener
    extends MouseAdapter {
        private MouseLogicListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            KingdeeCurrencyEditorUI.this.ce.requestFocusInWindow();
            if (e.getX() < KingdeeCurrencyEditorUI.this.ce.getIntegerDigitCount() * KingdeeCurrencyEditorUI.this.leftPerGrid) {
                KingdeeCurrencyEditorUI.this.trianglePosition = e.getX() / KingdeeCurrencyEditorUI.this.leftPerGrid;
            }
            if (e.getX() > KingdeeCurrencyEditorUI.this.ce.getIntegerDigitCount() * KingdeeCurrencyEditorUI.this.leftPerGrid) {
                KingdeeCurrencyEditorUI.this.trianglePosition = (e.getX() - KingdeeCurrencyEditorUI.this.leftWidth) / KingdeeCurrencyEditorUI.this.rightPerGrid + KingdeeCurrencyEditorUI.this.ce.getIntegerDigitCount();
            }
            KingdeeCurrencyEditorUI.this.ce.revalidate();
            KingdeeCurrencyEditorUI.this.ce.repaint();
        }
    }

    private class KeyboardLogicListener
    implements KeyListener {
        private KeyboardLogicListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 37) {
                if (KingdeeCurrencyEditorUI.this.trianglePosition == 0) {
                    return;
                }
                KingdeeCurrencyEditorUI.this.trianglePosition--;
            } else if (e.getKeyCode() == 39) {
                if (KingdeeCurrencyEditorUI.this.trianglePosition == KingdeeCurrencyEditorUI.this.ce.getIntegerDigitCount() + KingdeeCurrencyEditorUI.this.ce.getDecimalDigitCount() - 1) {
                    return;
                }
                KingdeeCurrencyEditorUI.this.trianglePosition++;
            } else if (e.isControlDown() && e.getKeyCode() == 127) {
                KingdeeCurrencyEditorUI.this.ce.setValue("0");
                KingdeeCurrencyEditorUI.this.trianglePosition = KingdeeCurrencyEditorUI.this.ce.getIntegerDigitCount() - 1;
            } else if (e.getKeyCode() == 8 || e.getKeyCode() == 127) {
                if (KingdeeCurrencyEditorUI.this.ce.getValue() == null) {
                    return;
                }
                BigDecimal oldValue = (BigDecimal)KingdeeCurrencyEditorUI.this.ce.getValue();
                String plainString = Util.bigDecimalToPlainString((BigDecimal)oldValue);
                String[] splittedStrings = plainString.split("\\.");
                String integerDigitsWithSymbol = splittedStrings[0];
                int sign = oldValue.signum();
                int integerDigitCount = sign < 0 ? integerDigitsWithSymbol.length() - 1 : integerDigitsWithSymbol.length();
                int theCentralizedDeletingDigit = KingdeeCurrencyEditorUI.this.trianglePosition - KingdeeCurrencyEditorUI.this.ce.getIntegerDigitCount();
                if (theCentralizedDeletingDigit < 0) {
                    int position = Math.abs(theCentralizedDeletingDigit);
                    if (sign >= 0 && position > integerDigitsWithSymbol.length() || sign <= 0 && position > integerDigitsWithSymbol.length() - 1) {
                        return;
                    }
                    if (position == 1 && (sign < 0 && integerDigitsWithSymbol.length() == 2 || sign >= 0 && integerDigitsWithSymbol.length() == 1)) {
                        if (sign >= 0) {
                            StringBuffer sb = new StringBuffer();
                            sb.append("0");
                            sb.append(plainString.substring(integerDigitCount + theCentralizedDeletingDigit + 1));
                            KingdeeCurrencyEditorUI.this.ce.setValue(sb.toString());
                        } else {
                            StringBuffer sb = new StringBuffer();
                            sb.append("-0");
                            sb.append(plainString.substring(integerDigitCount + theCentralizedDeletingDigit + 2));
                            KingdeeCurrencyEditorUI.this.ce.setValue(sb.toString());
                        }
                    } else if (sign >= 0) {
                        StringBuffer sb = new StringBuffer();
                        sb.append(plainString.substring(0, integerDigitCount + theCentralizedDeletingDigit));
                        sb.append(plainString.substring(integerDigitCount + theCentralizedDeletingDigit + 1));
                        KingdeeCurrencyEditorUI.this.ce.setValue(sb.toString());
                        if (position == integerDigitCount) {
                            KingdeeCurrencyEditorUI.this.trianglePosition = KingdeeCurrencyEditorUI.this.ce.getIntegerDigitCount() - Util.bigDecimalToPlainString((BigDecimal)((BigDecimal)KingdeeCurrencyEditorUI.this.ce.getValue())).split("\\.")[0].length();
                        }
                    } else {
                        StringBuffer sb = new StringBuffer();
                        sb.append(plainString.substring(0, integerDigitCount + theCentralizedDeletingDigit + 1));
                        sb.append(plainString.substring(integerDigitCount + theCentralizedDeletingDigit + 2));
                        KingdeeCurrencyEditorUI.this.ce.setValue(sb.toString());
                        if (position == integerDigitCount) {
                            KingdeeCurrencyEditorUI.this.trianglePosition = KingdeeCurrencyEditorUI.this.ce.getIntegerDigitCount() - Util.bigDecimalToPlainString((BigDecimal)((BigDecimal)KingdeeCurrencyEditorUI.this.ce.getValue())).split("\\.")[0].length() + 1;
                        }
                    }
                } else {
                    if (splittedStrings.length == 1) {
                        return;
                    }
                    String decimals = splittedStrings[1];
                    if (theCentralizedDeletingDigit > decimals.length() - 1) {
                        KingdeeCurrencyEditorUI.this.trianglePosition--;
                        return;
                    }
                    if (theCentralizedDeletingDigit == 0 && decimals.length() == 1) {
                        KingdeeCurrencyEditorUI.this.ce.setValue(integerDigitsWithSymbol);
                    } else {
                        StringBuffer sb;
                        if (sign >= 0) {
                            sb = new StringBuffer();
                            sb.append(plainString.substring(0, integerDigitCount + theCentralizedDeletingDigit + 1));
                            sb.append(plainString.substring(integerDigitCount + theCentralizedDeletingDigit + 2));
                            KingdeeCurrencyEditorUI.this.ce.setValue(sb.toString());
                        } else {
                            sb = new StringBuffer();
                            sb.append(plainString.substring(0, integerDigitCount + theCentralizedDeletingDigit + 2));
                            sb.append(plainString.substring(integerDigitCount + theCentralizedDeletingDigit + 3));
                            KingdeeCurrencyEditorUI.this.ce.setValue(sb.toString());
                        }
                        int newDecimalDigitCount = Util.bigDecimalToPlainString((BigDecimal)((BigDecimal)KingdeeCurrencyEditorUI.this.ce.getValue())).split("\\.")[1].length();
                        int nowDecimalCursorPosition = KingdeeCurrencyEditorUI.this.trianglePosition - KingdeeCurrencyEditorUI.this.ce.getIntegerDigitCount() + 1;
                        if (newDecimalDigitCount < nowDecimalCursorPosition) {
                            KingdeeCurrencyEditorUI.this.trianglePosition--;
                        }
                    }
                }
            }
            KingdeeCurrencyEditorUI.this.ce.revalidate();
            KingdeeCurrencyEditorUI.this.ce.repaint();
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (e.getKeyChar() == '-') {
                if (!KingdeeCurrencyEditorUI.this.ce.isAllowMinus()) {
                    return;
                }
                KingdeeCurrencyEditorUI.this.ce.setNegative(!KingdeeCurrencyEditorUI.this.ce.isNegative());
            } else if (e.getKeyChar() == '.') {
                KingdeeCurrencyEditorUI.this.trianglePosition = KingdeeCurrencyEditorUI.this.ce.getIntegerDigitCount();
            } else if (e.getKeyChar() >= '0' && e.getKeyChar() <= '9') {
                BigDecimal oldValue;
                String plainString;
                String[] splittedStrings;
                String integerDigits;
                if (KingdeeCurrencyEditorUI.this.ce.getValue() == null) {
                    KingdeeCurrencyEditorUI.this.ce.setValue("0");
                }
                if ((integerDigits = (splittedStrings = (plainString = Util.bigDecimalToPlainString((BigDecimal)(oldValue = (BigDecimal)KingdeeCurrencyEditorUI.this.ce.getValue()))).split("\\."))[0]).charAt(0) == '-') {
                    integerDigits = integerDigits.substring(1);
                }
                String plainStringWithoutSign = plainString;
                if (plainString.charAt(0) == '-') {
                    plainStringWithoutSign = plainString.substring(1);
                }
                int sign = oldValue.signum();
                if (KingdeeCurrencyEditorUI.this.trianglePosition == KingdeeCurrencyEditorUI.this.ce.getIntegerDigitCount() - 1) {
                    if (sign > 0) {
                        StringBuffer result = new StringBuffer();
                        result.append(plainString.substring(0, integerDigits.length()));
                        result.append(e.getKeyChar());
                        result.append(plainString.substring(integerDigits.length()));
                        KingdeeCurrencyEditorUI.this.ce.setValue(result.toString());
                    } else if (sign == 0) {
                        KingdeeCurrencyEditorUI.this.ce.setValue("" + e.getKeyChar());
                    } else {
                        StringBuffer result = new StringBuffer();
                        result.append(plainString.substring(0, integerDigits.length() + 1));
                        result.append(e.getKeyChar());
                        result.append(plainString.substring(integerDigits.length() + 1));
                        KingdeeCurrencyEditorUI.this.ce.setValue(result.toString());
                    }
                } else if (KingdeeCurrencyEditorUI.this.trianglePosition == KingdeeCurrencyEditorUI.this.ce.getIntegerDigitCount()) {
                    if (sign > 0) {
                        StringBuffer result = new StringBuffer();
                        if (plainString.length() == integerDigits.length()) {
                            result.append(plainString);
                            result.append("." + e.getKeyChar());
                        } else {
                            result.append(plainString.substring(0, integerDigits.length() + 1));
                            result.append(e.getKeyChar());
                            if (splittedStrings[1].length() != 1) {
                                result.append(plainString.substring(integerDigits.length() + 2));
                            }
                        }
                        KingdeeCurrencyEditorUI.this.ce.setValue(result.toString());
                        KingdeeCurrencyEditorUI.this.trianglePosition++;
                    } else if (sign == 0) {
                        KingdeeCurrencyEditorUI.this.ce.setValue("0." + e.getKeyChar());
                        KingdeeCurrencyEditorUI.this.trianglePosition++;
                    } else {
                        StringBuffer result = new StringBuffer();
                        if (plainString.length() == integerDigits.length() + 1) {
                            result.append(plainString);
                            result.append("." + e.getKeyChar());
                        } else {
                            result.append(plainString.substring(0, integerDigits.length() + 2));
                            result.append(e.getKeyChar());
                            if (splittedStrings[1].length() != 1) {
                                result.append(plainString.substring(integerDigits.length() + 3));
                            }
                        }
                        KingdeeCurrencyEditorUI.this.ce.setValue(result.toString());
                        KingdeeCurrencyEditorUI.this.trianglePosition++;
                    }
                } else {
                    int theCentralizedDeletingDigit = KingdeeCurrencyEditorUI.this.trianglePosition - KingdeeCurrencyEditorUI.this.ce.getIntegerDigitCount();
                    int position = Math.abs(theCentralizedDeletingDigit);
                    if (position > integerDigits.length() && theCentralizedDeletingDigit < 0) {
                        if (e.getKeyChar() == '0') {
                            return;
                        }
                        int zeroCount = position - integerDigits.length() - 1;
                        StringBuffer result = new StringBuffer();
                        if (sign < 0) {
                            result.append("-");
                        }
                        result.append(e.getKeyChar());
                        for (int i = 0; i < zeroCount; ++i) {
                            result.append('0');
                        }
                        result.append(plainStringWithoutSign);
                        KingdeeCurrencyEditorUI.this.ce.setValue(result.toString());
                        KingdeeCurrencyEditorUI.this.trianglePosition++;
                    } else {
                        if (theCentralizedDeletingDigit < 0) {
                            int order = integerDigits.length() - position;
                            StringBuffer result = new StringBuffer();
                            if (sign > 0) {
                                result.append(plainString.substring(0, order));
                                result.append(e.getKeyChar());
                                result.append(plainString.substring(order + 1));
                                KingdeeCurrencyEditorUI.this.ce.setValue(result.toString());
                            } else {
                                result.append(plainString.substring(0, order + 1));
                                result.append(e.getKeyChar());
                                result.append(plainString.substring(order + 2));
                                KingdeeCurrencyEditorUI.this.ce.setValue(result.toString());
                            }
                        } else {
                            int order = integerDigits.length() + position;
                            int difference = order - plainStringWithoutSign.length() + 1;
                            StringBuffer result = new StringBuffer();
                            if (difference >= 0) {
                                result.append(plainString);
                                if (splittedStrings.length == 1) {
                                    result.append(".");
                                    --difference;
                                }
                                for (int i = 0; i < difference; ++i) {
                                    result.append('0');
                                }
                                result.append(e.getKeyChar());
                                KingdeeCurrencyEditorUI.this.ce.setValue(result.toString());
                            } else if (sign >= 0) {
                                result.append(plainString.substring(0, order + 1));
                                result.append(e.getKeyChar());
                                if (difference != -1) {
                                    result.append(plainString.substring(order + 2));
                                }
                                KingdeeCurrencyEditorUI.this.ce.setValue(result.toString());
                            } else {
                                result.append(plainString.substring(0, order + 2));
                                result.append(e.getKeyChar());
                                if (difference != -1) {
                                    result.append(plainString.substring(order + 3));
                                }
                                KingdeeCurrencyEditorUI.this.ce.setValue(result.toString());
                            }
                        }
                        if (KingdeeCurrencyEditorUI.this.trianglePosition != KingdeeCurrencyEditorUI.this.ce.getIntegerDigitCount() + KingdeeCurrencyEditorUI.this.ce.getDecimalDigitCount() - 1) {
                            KingdeeCurrencyEditorUI.this.trianglePosition++;
                        }
                    }
                }
            }
            KingdeeCurrencyEditorUI.this.ce.revalidate();
            KingdeeCurrencyEditorUI.this.ce.repaint();
        }
    }
}

