/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.plaf;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.plaf.KingdeeBorders;
import com.kingdee.bos.ctrl.swing.plaf.KingdeeToolBarUI;
import com.kingdee.bos.ctrl.swing.plaf.PaintUtil;
import com.kingdee.bos.ctrl.swing.util.CtrlImageUtilities;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicToggleButtonUI;

public class KingdeeToggleButtonUI
extends BasicToggleButtonUI {
    private AbstractButton selfAbstractButton = null;
    private int faceType = 1;
    private PropertyHandler propertyHandler = null;
    private Color rollverCol = null;
    private Color pressCol = null;
    private Color arrowCol = null;
    private Color selectForegrond = Color.BLACK;
    private Color disableForeground = Color.GRAY;
    private Color toolBarForeground = null;
    private Color toolBarDisableForeground = null;
    private Color grayInitC0 = null;
    private Color grayInitC1 = null;
    private Color grayRolC0 = null;
    private Color grayRolC1 = null;
    private Color grayPresC0 = null;
    private Color grayPresC1 = null;
    private Color grayDeActiveC0 = null;
    private Color grayDeActiveC1 = null;

    public static ComponentUI createUI(JComponent c) {
        return new KingdeeToggleButtonUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.selfAbstractButton = (AbstractButton)c;
        super.installUI(c);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        switch (this.faceType) {
            case 0: {
                this.paintBlueBackGround(g, c);
                break;
            }
            case 1: {
                this.paintGrayBackground(g, c);
            }
        }
        super.paint(g, c);
    }

    protected void paintBlueBackGround(Graphics g, JComponent c) {
        ButtonModel m = ((AbstractButton)c).getModel();
        boolean isArmed = m.isArmed();
        boolean isRollver = m.isRollover();
        boolean isPress = m.isPressed();
        boolean isSelected = m.isSelected();
        Color oldColor = g.getColor();
        boolean b = false;
        if (isSelected) {
            b = true;
            g.setColor(this.pressCol);
        }
        if (isRollver && !isArmed && !isPress) {
            b = true;
            g.setColor(this.rollverCol);
        } else if (isPress) {
            b = true;
            g.setColor(this.pressCol);
        }
        int w = c.getWidth();
        int h = c.getHeight();
        if (b) {
            g.fillRect(1, 1, w - 2, h - 2);
        }
        g.setColor(oldColor);
    }

    @Override
    protected void paintIcon(Graphics g, AbstractButton b, Rectangle iconRect) {
        ButtonModel model = b.getModel();
        Icon icon = null;
        if (!model.isEnabled()) {
            icon = model.isSelected() ? b.getDisabledSelectedIcon() : CtrlImageUtilities.createDisableIcon(b.getIcon());
        } else if (model.isPressed() && model.isArmed()) {
            icon = b.getPressedIcon();
            if (icon == null) {
                icon = b.getSelectedIcon();
            }
        } else if (model.isSelected()) {
            if (b.isRolloverEnabled() && model.isRollover()) {
                icon = b.getRolloverSelectedIcon();
                if (icon == null) {
                    icon = b.getSelectedIcon();
                }
            } else {
                icon = b.getSelectedIcon();
            }
        } else if (b.isRolloverEnabled() && model.isRollover()) {
            icon = b.getRolloverIcon();
        }
        if (icon == null) {
            icon = b.getIcon();
        }
        icon.paintIcon(b, g, iconRect.x, iconRect.y);
    }

    protected void paintGrayBackground(Graphics g, JComponent c) {
        ButtonModel m = ((AbstractButton)c).getModel();
        boolean isArmed = m.isArmed();
        boolean isRollver = m.isRollover();
        boolean isPress = m.isPressed();
        if (c.isEnabled()) {
            if (isRollver && !isArmed && !isPress) {
                PaintUtil.drawHoriShadow(g, c, 5.0f, 1.0f, this.grayRolC0, 5.0f, c.getHeight() - 2, this.grayRolC1);
            } else if (isArmed || isPress) {
                PaintUtil.drawHoriShadow(g, c, 5.0f, 1.0f, this.grayPresC0, 5.0f, c.getHeight() - 2, this.grayPresC1);
            } else if (c.isFocusOwner()) {
                PaintUtil.drawHoriShadow(g, c, 5.0f, 1.0f, this.grayPresC0, 5.0f, c.getHeight() - 2, this.grayPresC1);
            } else if (c.isOpaque()) {
                PaintUtil.drawHoriShadow(g, c, 5.0f, 1.0f, this.grayInitC0, 5.0f, c.getHeight() - 2, this.grayInitC1);
            }
        } else {
            PaintUtil.drawHoriShadow(g, c, 5.0f, 1.0f, this.grayDeActiveC0, 5.0f, c.getHeight() - 2, this.grayDeActiveC1);
        }
    }

    @Override
    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        FontMetrics fm = g.getFontMetrics();
        int mnemonicIndex = b.getDisplayedMnemonicIndex();
        if (model.isEnabled()) {
            if (c.getParent() instanceof KDToolBar) {
                g.setColor(this.toolBarForeground);
            } else if (model.isRollover() || model.isArmed()) {
                g.setColor(this.selectForegrond);
            } else {
                g.setColor(b.getForeground());
            }
            BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemonicIndex, textRect.x + this.getTextShiftOffset(), textRect.y + fm.getAscent() + this.getTextShiftOffset());
        } else {
            if (c.getParent() instanceof KDToolBar) {
                g.setColor(this.toolBarDisableForeground);
            } else {
                g.setColor(this.disableForeground);
            }
            BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemonicIndex, textRect.x, textRect.y + fm.getAscent());
        }
    }

    @Override
    protected void installListeners(AbstractButton b) {
        super.installListeners(b);
        if (this.propertyHandler == null) {
            this.propertyHandler = new PropertyHandler();
            b.addPropertyChangeListener(this.propertyHandler);
        }
    }

    @Override
    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        b.setRolloverEnabled(true);
        b.setBorderPainted(true);
        this.faceType = 1;
        this.setFactType(new Integer(this.faceType));
        if (b.getMargin() == null || b.getMargin() instanceof UIResource) {
            b.setMargin(UIManager.getInsets("WrokButton.margin"));
        }
        this.selectForegrond = UIManager.getColor("ToggleButton.selectionFG");
        this.disableForeground = UIManager.getColor("WorkButton.disableForeground");
        this.toolBarForeground = UIManager.getColor("ToolBar.foreground");
        this.toolBarDisableForeground = UIManager.getColor("ToolBar.disableForeground");
    }

    @Override
    protected void paintButtonPressed(Graphics g, AbstractButton b) {
    }

    protected void setBlueFaceBorder() {
        this.selfAbstractButton.setBorder(KingdeeBorders.getToolbarToggleButtonBorder());
    }

    protected void setGrayFaceBorder() {
        this.selfAbstractButton.setBorder(KingdeeBorders.getContentToggleButtonBorder());
    }

    protected KDPopupMenu createPopupMenu() {
        KDPopupMenu menu = new KDPopupMenu();
        KDMenuItem textItem = new KDMenuItem(this.getLocaleLanguage("onlyText", "\u53ea\u663e\u793a\u6587\u672c"));
        textItem.putClientProperty("itemType", "text");
        textItem.addActionListener(new ActionHandler());
        KDMenuItem iconItem = new KDMenuItem(this.getLocaleLanguage("onlyIcon", "\u53ea\u663e\u793a\u56fe\u6807"));
        iconItem.putClientProperty("itemType", "icon");
        iconItem.addActionListener(new ActionHandler());
        KDMenuItem textIconItem = new KDMenuItem(this.getLocaleLanguage("partText", "\u663e\u793a\u6587\u672c\u548c\u56fe\u6807"));
        textIconItem.putClientProperty("itemType", "textIcon");
        textIconItem.addActionListener(new ActionHandler());
        menu.add(textItem);
        menu.add(iconItem);
        menu.add(textIconItem);
        return menu;
    }

    private String getLocaleLanguage(String key, String defaultValue) {
        return LanguageManager.getLangMessage((String)key, KingdeeToolBarUI.class, (String)defaultValue);
    }

    private void setFactType(Integer newValue) {
        if (newValue == null) {
            return;
        }
        switch (newValue) {
            case 0: {
                this.faceType = 0;
                this.setBlueFaceBorder();
                break;
            }
            default: {
                this.faceType = 1;
                this.setGrayFaceBorder();
            }
        }
        this.initColor();
    }

    private void initColor() {
        if (this.faceType == 1) {
            if (this.grayInitC0 == null) {
                this.grayInitC0 = UIManager.getColor("WorkButton.grayInitCol0");
                Color color = this.grayInitC0 = this.grayInitC0 != null ? this.grayInitC0 : Color.decode("#F7FBF3");
            }
            if (this.grayInitC1 == null) {
                this.grayInitC1 = UIManager.getColor("WorkButton.grayInitCol1");
                Color color = this.grayInitC1 = this.grayInitC1 != null ? this.grayInitC1 : Color.decode("#D5D5D0");
            }
            if (this.grayRolC0 == null) {
                this.grayRolC0 = UIManager.getColor("WorkButton.grayRolCol0");
                Color color = this.grayRolC0 = this.grayRolC0 != null ? this.grayRolC0 : Color.decode("#D5D6D0");
            }
            if (this.grayRolC1 == null) {
                this.grayRolC1 = UIManager.getColor("WorkButton.grayRolCol1");
                Color color = this.grayRolC1 = this.grayRolC1 != null ? this.grayRolC1 : Color.decode("#F7FBF3");
            }
            if (this.grayPresC0 == null) {
                this.grayPresC0 = UIManager.getColor("WorkButton.grayPresCol0");
                Color color = this.grayPresC0 = this.grayPresC0 != null ? this.grayPresC0 : Color.decode("#D5D6D0");
            }
            if (this.grayPresC1 == null) {
                this.grayPresC1 = UIManager.getColor("WorkButton.grayPresCol1");
                Color color = this.grayPresC1 = this.grayPresC1 != null ? this.grayPresC1 : Color.decode("#F7FBF3");
            }
            if (this.grayDeActiveC0 == null) {
                this.grayDeActiveC0 = UIManager.getColor("WorkButton.grayDeActCol0");
                Color color = this.grayDeActiveC0 = this.grayDeActiveC0 != null ? this.grayDeActiveC0 : Color.decode("#D3D3D3");
            }
            if (this.grayDeActiveC1 == null) {
                this.grayDeActiveC1 = UIManager.getColor("WorkButton.grayDeActCol1");
                this.grayDeActiveC1 = this.grayDeActiveC1 != null ? this.grayDeActiveC1 : Color.decode("#F7F7F7");
            }
            this.rollverCol = null;
            this.pressCol = null;
            this.arrowCol = null;
        } else {
            if (this.arrowCol == null) {
                this.arrowCol = UIManager.getColor("WorkButton.arrowColor");
                Color color = this.arrowCol = this.arrowCol != null ? this.arrowCol : Color.decode("#10497B");
            }
            if (this.rollverCol == null) {
                this.rollverCol = UIManager.getColor("ToggleButton.rolloverBackground");
                Color color = this.rollverCol = this.rollverCol != null ? this.rollverCol : Color.decode("#9BC4E0");
            }
            if (this.pressCol == null) {
                this.pressCol = UIManager.getColor("ToggleButton.pressBackground");
                this.pressCol = this.pressCol != null ? this.pressCol : Color.decode("#6D9DBD");
            }
            this.grayInitC0 = null;
            this.grayInitC1 = null;
            this.grayRolC0 = null;
            this.grayRolC1 = null;
            this.grayPresC0 = null;
            this.grayPresC1 = null;
            this.grayDeActiveC0 = null;
            this.grayDeActiveC1 = null;
        }
    }

    private class PropertyHandler
    implements PropertyChangeListener {
        private PropertyHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            String pName = pce.getPropertyName();
            if ("selfFaceType".equals(pName)) {
                Integer facetype = (Integer)pce.getNewValue();
                KingdeeToggleButtonUI.this.setFactType(facetype);
            }
        }
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (((KDMenuItem)e.getSource()).getClientProperty("itemType").equals("text")) {
                ((KDToolBar)KingdeeToggleButtonUI.this.selfAbstractButton.getParent()).setIsControlByParent(false);
                ((KDToolBar)KingdeeToggleButtonUI.this.selfAbstractButton.getParent()).setTextIconDisStyle((short)1);
            }
            if (((KDMenuItem)e.getSource()).getClientProperty("itemType").equals("icon")) {
                ((KDToolBar)KingdeeToggleButtonUI.this.selfAbstractButton.getParent()).setIsControlByParent(false);
                ((KDToolBar)KingdeeToggleButtonUI.this.selfAbstractButton.getParent()).setTextIconDisStyle((short)2);
            }
            if (((KDMenuItem)e.getSource()).getClientProperty("itemType").equals("textIcon")) {
                ((KDToolBar)KingdeeToggleButtonUI.this.selfAbstractButton.getParent()).setIsControlByParent(false);
                ((KDToolBar)KingdeeToggleButtonUI.this.selfAbstractButton.getParent()).setTextIconDisStyle((short)3);
            }
            KingdeeToggleButtonUI.this.selfAbstractButton.getParent().doLayout();
            KingdeeToggleButtonUI.this.selfAbstractButton.getParent().repaint();
        }
    }
}

