/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.applet;

import com.kingdee.bos.autoupdate.config.ConfigException;
import com.kingdee.bos.autoupdate.config.ConfigInfo;
import com.kingdee.bos.autoupdate.config.ConfigManager;
import com.kingdee.bos.autoupdate.dl.AbstractRSDownloader;
import com.kingdee.bos.autoupdate.util.BASE64Encoder;
import com.kingdee.eas.applet.IEasClientDownloader;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Properties;

public class RSDownloaderHttpImpl
extends AbstractRSDownloader
implements IEasClientDownloader {
    private static RSDownloaderHttpImpl downloader;
    private static int urlConnCount;
    static final /* synthetic */ boolean $assertionsDisabled;

    private RSDownloaderHttpImpl() {
    }

    public static RSDownloaderHttpImpl getInstance() {
        if (downloader == null) {
            downloader = new RSDownloaderHttpImpl();
        }
        return downloader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getContent(URL url) throws IOException {
        if (!($assertionsDisabled || url != null && "http".equalsIgnoreCase(url.getProtocol()))) {
            throw new AssertionError();
        }
        URLConnection cn = null;
        cn = this.getConnection(url);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new HttpInputStream(cn.getInputStream(), (HttpURLConnection)cn));
        return bufferedInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getContent(URLConnection cn) throws IOException {
        if (!$assertionsDisabled && cn == null) {
            throw new AssertionError();
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new HttpInputStream(cn.getInputStream(), (HttpURLConnection)cn));
        return bufferedInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getContentLength(URL url) throws IOException {
        if (!($assertionsDisabled || url != null && "http".equalsIgnoreCase(url.getProtocol()))) {
            throw new AssertionError();
        }
        URLConnection cn = null;
        try {
            cn = this.getConnection(url);
            long l = cn.getContentLength();
            return l;
        }
        finally {
            if (cn instanceof HttpURLConnection) {
                try {
                    ((HttpURLConnection)cn).disconnect();
                }
                catch (Throwable ignore) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getContentLength(URLConnection cn) throws IOException {
        if (!$assertionsDisabled && cn == null) {
            throw new AssertionError();
        }
        try {
            long l = cn.getContentLength();
            return l;
        }
        finally {
            if (cn instanceof HttpURLConnection) {
                // empty if block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long lastModified(URL url) throws IOException {
        if (!($assertionsDisabled || url != null && "http".equalsIgnoreCase(url.getProtocol()))) {
            throw new AssertionError();
        }
        URLConnection cn = null;
        try {
            cn = this.getConnection(url);
            long l = cn.getLastModified();
            return l;
        }
        finally {
            if (cn instanceof HttpURLConnection) {
                try {
                    ((HttpURLConnection)cn).disconnect();
                }
                catch (Throwable ignore) {}
            }
        }
    }

    private File getLocalFile(URL codebase, URL resource, File localFile) {
        if (!$assertionsDisabled && codebase == null) {
            throw new AssertionError();
        }
        String relativePath = this.getRelativePath(codebase, resource);
        return new File(localFile, relativePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public HashMap downloadFiles(URL codebase, URL[] serverURLs, File rootPath) {
        if (codebase == null || serverURLs == null || rootPath == null) {
            throw new NullPointerException("the parameter cannot be null!");
        }
        URL resource = null;
        File localFile = null;
        HashMap<URL, Exception> hashMap = new HashMap<URL, Exception>();
        BufferedOutputStream output = null;
        InputStream input = null;
        int len = serverURLs.length;
        for (int i = 0; i < len; ++i) {
            resource = serverURLs[i];
            localFile = this.getLocalFile(codebase, resource, rootPath);
            File tmp = localFile.getParentFile();
            if (tmp != null) {
                tmp.mkdirs();
            }
            output = new BufferedOutputStream(new FileOutputStream(localFile));
            URLConnection cn = this.getConnection(resource);
            input = this.getContent(cn);
            this.download(resource, this.getContentLength(cn), input, output);
            output.flush();
            Object var14_14 = null;
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (Exception ignore) {
                // empty catch block
            }
            try {
                if (input == null) continue;
                input.close();
            }
            catch (Exception ignore) {}
            continue;
            {
                catch (Exception fnfe) {
                    if (localFile != null) {
                        localFile.delete();
                    }
                    fnfe.printStackTrace();
                    hashMap.put(resource, fnfe);
                    var14_14 = null;
                    try {
                        if (output != null) {
                            output.close();
                        }
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    try {
                        if (input == null) continue;
                        input.close();
                    }
                    catch (Exception ignore) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                var14_14 = null;
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return hashMap;
    }

    private URLConnection getConnection(URL url) throws IOException {
        try {
            URLConnection uc = url.openConnection();
            ++urlConnCount;
            this.addToRequestProperty(uc, "pragma", "no-cache");
            ConfigInfo configInfo = ConfigManager.load();
            if (configInfo.isNeedProxy()) {
                if (!$assertionsDisabled && configInfo.getProxyPort() <= 0) {
                    throw new AssertionError();
                }
                Properties properties = System.getProperties();
                properties.put("http.proxyHost", configInfo.getProxyServerUrl());
                properties.put("http.proxyPort", new Integer(configInfo.getProxyPort()).toString());
                uc.setRequestProperty("Proxy-Authorization", this.encodeUserNameAndPassword(configInfo.getProxyUserName(), configInfo.getProxyPassword()));
            }
            if (configInfo.isNeedBaseAuth()) {
                uc.setRequestProperty("Authorization", this.encodeUserNameAndPassword(configInfo.getBaseAuthUserName(), configInfo.getBaseAuthPassword()));
            }
            return uc;
        }
        catch (ConfigException ce) {
            ce.printStackTrace();
            throw new IOException("Invalidate Config! " + ce.getMessage());
        }
    }

    private String encodeUserNameAndPassword(String userName, String password) {
        return "Basic " + BASE64Encoder.base64Encode((String)(userName + ":" + password));
    }

    private void addToRequestProperty(URLConnection conn, String key, String value) {
        String curvalue = conn.getRequestProperty(key);
        curvalue = curvalue == null || curvalue.trim().length() == 0 ? value : curvalue + "," + value;
        conn.setRequestProperty(key, curvalue);
    }

    public int getUrlConnCount() {
        return urlConnCount;
    }

    static {
        $assertionsDisabled = !RSDownloaderHttpImpl.class.desiredAssertionStatus();
        downloader = null;
        urlConnCount = 0;
    }

    private static class HttpInputStream
    extends InputStream {
        private final InputStream is;
        private final HttpURLConnection httpCn;

        public HttpInputStream(InputStream is, HttpURLConnection httpCn) {
            this.is = is;
            this.httpCn = httpCn;
        }

        public int available() throws IOException {
            return this.is.available();
        }

        public void close() throws IOException {
            this.is.close();
            try {
                this.httpCn.disconnect();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public boolean equals(Object arg0) {
            return this.is.equals(arg0);
        }

        public int hashCode() {
            return this.is.hashCode();
        }

        public void mark(int arg0) {
            this.is.mark(arg0);
        }

        public boolean markSupported() {
            return this.is.markSupported();
        }

        public int read() throws IOException {
            return this.is.read();
        }

        public int read(byte[] arg0) throws IOException {
            return this.is.read(arg0);
        }

        public int read(byte[] arg0, int arg1, int arg2) throws IOException {
            return this.is.read(arg0, arg1, arg2);
        }

        public void reset() throws IOException {
            this.is.reset();
        }

        public long skip(long arg0) throws IOException {
            return this.is.skip(arg0);
        }

        public String toString() {
            return this.is.toString();
        }
    }
}

