/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.applet.autoupdate;

import com.kingdee.bos.autoupdate.cache.CacheException;
import com.kingdee.bos.autoupdate.jnl.JNLParser;
import com.kingdee.bos.autoupdate.jnl.LaunchInfo;
import com.kingdee.bos.autoupdate.jnl.ParseException;
import com.kingdee.eas.applet.EASCacheEntryInfo;
import com.kingdee.eas.applet.EASJNLPCacheEntryInfo;
import com.kingdee.eas.applet.EASJnlpCacheEntryManager;
import com.kingdee.eas.applet.autoupdate.ResourceVerInfo;
import com.kingdee.eas.applet.autoupdate.ResourceVerUtil;
import com.kingdee.eas.webutil.ConsoleLogger;
import com.kingdee.eas.webutil.CreateJNLPResource;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class OnDemandUpdateStateUtil {
    public static void scanAndUpdateLastestUpdateState(File baseDir, String jnlpFileName, File cacheStateBaseDir) {
        long start = System.currentTimeMillis();
        List resCacheList = OnDemandUpdateStateUtil.scanLatestUpdateState(cacheStateBaseDir);
        OnDemandUpdateStateUtil.updateLatestUpdateState(baseDir, resCacheList, jnlpFileName);
        ResourceVerUtil.deleteAllCacheFile(cacheStateBaseDir);
        ConsoleLogger.info("---update local resource.lst spend: " + (System.currentTimeMillis() - start) + ".ms");
    }

    private static List scanLatestUpdateState(File cacheStateBaseDir) {
        List resCacheList = ResourceVerUtil.readAll(cacheStateBaseDir);
        return resCacheList;
    }

    public static void storeResLst(File baseDir, String jnlpFileName, List resDelete) {
        try {
            File jnlpFile = new File(jnlpFileName);
            ConsoleLogger.info("jnlpFilename : " + jnlpFileName);
            LaunchInfo lauchInfo = null;
            if (jnlpFile.exists()) {
                lauchInfo = JNLParser.parse((File)jnlpFile);
                EASJNLPCacheEntryInfo entryInfo = EASJnlpCacheEntryManager.load(baseDir, jnlpFile.getName());
                OnDemandUpdateStateUtil.updateReslst(entryInfo, resDelete);
                CreateJNLPResource.storeLst(baseDir, lauchInfo, entryInfo);
            }
        }
        catch (CacheException e) {
            System.err.println("Load entryInfo from " + jnlpFileName + "]  error[" + e.getMessage() + "]!");
            e.printStackTrace();
        }
        catch (ParseException e) {
            System.err.println("parse jnlpfile " + jnlpFileName + "]  error[" + e.getMessage() + "]!");
            e.printStackTrace();
        }
    }

    private static void updateLatestUpdateState(File baseDir, Collection resCacheList, String jnlpFilename) {
        try {
            File jnlpFile = new File(jnlpFilename);
            LaunchInfo lauchInfo = null;
            ConsoleLogger.info("baseDir : " + baseDir);
            ConsoleLogger.info("jnlpFilename : " + jnlpFilename);
            ConsoleLogger.info("jnlpFile exist: " + jnlpFile.exists());
            if (jnlpFile.exists()) {
                lauchInfo = JNLParser.parse((File)jnlpFile);
                EASJNLPCacheEntryInfo entryInfo = EASJnlpCacheEntryManager.load(baseDir, jnlpFile.getName());
                OnDemandUpdateStateUtil.updateCacheState(entryInfo, resCacheList);
                CreateJNLPResource.storeLst(baseDir, lauchInfo, entryInfo);
            }
        }
        catch (CacheException e) {
            System.err.println("Load entryInfo from " + jnlpFilename + "]  error[" + e.getMessage() + "]!");
            e.printStackTrace();
        }
        catch (ParseException e) {
            System.err.println("parse jnlpfile " + jnlpFilename + "]  error[" + e.getMessage() + "]!");
            e.printStackTrace();
        }
    }

    private static void updateReslst(EASJNLPCacheEntryInfo entryInfo, Collection resDelete) {
        if (resDelete != null) {
            Iterator it = resDelete.iterator();
            while (it.hasNext()) {
                String resVerInfo = (String)it.next();
                OnDemandUpdateStateUtil.updateResLstInfo(entryInfo, resVerInfo);
            }
        }
    }

    private static void updateResLstInfo(EASJNLPCacheEntryInfo info, String resVerInfo) {
        if (info.getCacheEntries() != null) {
            Iterator it = info.getCacheEntries().iterator();
            while (it.hasNext()) {
                EASCacheEntryInfo entryInfo = (EASCacheEntryInfo)((Object)it.next());
                if (entryInfo.getHref() == null || entryInfo.getHref().toString().indexOf(resVerInfo) < 0) continue;
                info.removeCacheEntry(entryInfo);
                break;
            }
        }
    }

    private static void updateCacheState(EASJNLPCacheEntryInfo entryInfo, Collection resCacheList) {
        if (resCacheList != null) {
            Iterator it = resCacheList.iterator();
            while (it.hasNext()) {
                ResourceVerInfo resVerInfo = (ResourceVerInfo)it.next();
                OnDemandUpdateStateUtil.updateEntryInfo(entryInfo, resVerInfo);
            }
        }
    }

    private static void updateEntryInfo(EASJNLPCacheEntryInfo info, ResourceVerInfo resVerInfo) {
        if (info.getCacheEntries() != null) {
            Iterator it = info.getCacheEntries().iterator();
            boolean flag = false;
            while (it.hasNext()) {
                EASCacheEntryInfo entryInfo = (EASCacheEntryInfo)((Object)it.next());
                if (entryInfo.getHref() == null || !entryInfo.getHref().toString().equals(resVerInfo.getHerf())) continue;
                flag = true;
                if (entryInfo.getMd5Version().equals(resVerInfo.getMd5())) break;
                info.removeCacheEntry(entryInfo);
                info.addCacheEntry(OnDemandUpdateStateUtil.createEntryInfo(resVerInfo));
                break;
            }
            if (!flag) {
                EASCacheEntryInfo entryInfoTemp = OnDemandUpdateStateUtil.createEntryInfo(resVerInfo);
                info.addCacheEntry(entryInfoTemp);
            }
        } else {
            EASCacheEntryInfo entryInfoTemp = OnDemandUpdateStateUtil.createEntryInfo(resVerInfo);
            info.addCacheEntry(entryInfoTemp);
        }
    }

    private static EASCacheEntryInfo createEntryInfo(ResourceVerInfo resVerInfo) {
        URL href = null;
        long lastModified = 0L;
        try {
            href = new URL(resVerInfo.getHerf());
            lastModified = Long.parseLong(resVerInfo.getLastModified());
        }
        catch (MalformedURLException e) {
            System.err.println("parse herf [" + resVerInfo.getHerf() + "]  error[" + e.getMessage() + "]!");
            e.printStackTrace();
        }
        EASCacheEntryInfo entryInfo = new EASCacheEntryInfo(href, lastModified, resVerInfo.getMd5());
        return entryInfo;
    }
}

