/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.applet.resource;

import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ResourceHelper {
    private static String MISSING_STRING = "miss string";
    private static String resClassName = "com.kingdee.eas.applet.resource.AppletResource";
    public static Locale defaultLoc = new Locale("l2");
    private static final String PARAM_SEPERATOR = ",";

    public static void setDefaultLocale(Locale locale) {
        defaultLoc = locale;
    }

    public static String getString(String res) {
        return ResourceHelper.getString(res, defaultLoc);
    }

    public static String getString(String res, Locale locale) {
        try {
            return ResourceBundle.getBundle(resClassName, locale).getString(res);
        }
        catch (MissingResourceException e) {
            return MISSING_STRING;
        }
    }

    public static HashMap decodeOldJSParameter(String keysStr, String valuesStr) {
        String[] keys = keysStr.split(PARAM_SEPERATOR);
        String[] values = valuesStr.split(PARAM_SEPERATOR);
        if (keys.length < 1) {
            System.err.println("please set biz parameters(key & value pairs).");
            return null;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        String val = "";
        for (int i = 0; i < keys.length; ++i) {
            val = i > values.length - 1 ? "" : values[i];
            params.put(keys[i], val);
        }
        return params;
    }

    public static String getExcLinkStackTrace(Throwable exc) {
        StringBuffer result = new StringBuffer();
        for (Throwable cause = exc; cause != null; cause = cause.getCause()) {
            result.append(cause.getClass().getName());
            result.append(": ");
            result.append(cause.getMessage());
            result.append(System.getProperty("line.separator"));
            StackTraceElement[] stackTraces = cause.getStackTrace();
            for (int i = 0; i < stackTraces.length; ++i) {
                result.append("        at: ");
                result.append(stackTraces[i].toString());
                result.append(System.getProperty("line.separator"));
            }
            result.append(System.getProperty("line.separator"));
        }
        return result.toString();
    }
}

