/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.da.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.bireport.bimanager.da.FactDataModelFactory;
import com.kingdee.eas.framework.bireport.bimanager.da.FactDataModelInfo;
import com.kingdee.eas.framework.bireport.bimanager.da.FactDataModelTreeInfo;
import com.kingdee.eas.framework.bireport.bimanager.da.client.AbstractFactDataModelEditUI;
import com.kingdee.eas.framework.bireport.bimanager.mdm.MasterDataInfo;
import com.kingdee.eas.framework.bireport.bimanager.mdm.client.MasterDataListUI;
import com.kingdee.eas.framework.bireport.bimanager.util.BiManagerUtil;
import com.kingdee.eas.framework.bireport.bimanager.util.Constant;
import com.kingdee.eas.framework.bireport.bimanager.util.UIHelper;
import com.kingdee.eas.framework.bireport.bimanager.util.client.BIClientVerifyHelper;
import com.kingdee.eas.framework.bireport.bimanager.util.client.F7ListUISelector;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class FactDataModelEditUI
extends AbstractFactDataModelEditUI {
    private static final Logger logger = CoreUIObject.getLogger(FactDataModelEditUI.class);
    private ActionListener[] masterDataActions;
    private ActionListener[] factDataActions;

    public FactDataModelEditUI() throws Exception {
        this.setPreferredSize(new Dimension(620, 500));
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return FactDataModelFactory.getRemoteInstance();
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
        if ("ADDNEW".equals(this.getOprtState())) {
            this.editData.put("treeid", (FactDataModelTreeInfo)this.getUIContext().get("ParentNode"));
        }
    }

    @Override
    protected IObjectValue createNewData() {
        FactDataModelInfo objectValue = new FactDataModelInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        return objectValue;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        int i;
        super.verifyInput(e);
        BIClientVerifyHelper.verifyRequire((CoreUIObject)this);
        if (this.kdtEntryFactData.getRowCount() <= 0) {
            MsgBox.showInfo((String)(Constant.AttribuEntry + Constant.EntryNotBeNull));
            SysUtil.abort();
        }
        UIHelper.verifyTableRequire((CoreUIObject)this, this.kdtEntryFactData, Constant.AttribuEntry + Constant.Entry);
        UIHelper.verifyTableRequire((CoreUIObject)this, this.kdtEntryMasterData, Constant.MasterDataEntry + Constant.Entry);
        HashMap<String, String> map = new HashMap<String, String>();
        int rows = this.kdtEntryFactData.getRowCount();
        for (i = 0; i < rows; ++i) {
            String value = (String)this.kdtEntryFactData.getCell(i, "number").getValue();
            int entryNumberMaxLength = 12;
            if (value.length() > entryNumberMaxLength) {
                MsgBox.showWarning((String)(Constant.AttribuEntry + Constant.Entry + Constant.Attribute + value + Constant.LengthExceed + entryNumberMaxLength));
                SysUtil.abort();
            }
            if (!value.matches("[a-zA-Z]\\w*")) {
                MsgBox.showWarning((String)(Constant.AttribuEntry + Constant.Entry + Constant.Attribute + value + Constant.NumberFormatError));
                SysUtil.abort();
            }
            if ("id".equals(value)) {
                MsgBox.showWarning((String)(Constant.AttribuEntry + Constant.Entry + Constant.Attribute + value + Constant.IsDefault));
                SysUtil.abort();
            }
            if (map.containsKey(value.toUpperCase())) {
                MsgBox.showWarning((String)(Constant.AttribuEntry + Constant.Entry + Constant.Di + (i + 1) + Constant.RowNumberDoubleName));
                SysUtil.abort();
            }
            map.put(value.toUpperCase(), "");
        }
        rows = this.kdtEntryMasterData.getRowCount();
        for (i = 0; i < rows; ++i) {
            MasterDataInfo info = (MasterDataInfo)this.kdtEntryMasterData.getCell(i, "MasterData").getValue();
            String value = info.getNumber();
            if (map.containsKey(value.toUpperCase())) {
                MsgBox.showWarning((Component)((Object)this), (String)(Constant.AttribuEntry + Constant.Entry + Constant.NumberChineseName + value + Constant.MasterDataNumberExists));
                SysUtil.abort();
            }
            map.put(value.toUpperCase(), "");
        }
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.initUI();
    }

    private void initUI() throws Exception {
        super.lockAction();
        ItemAction[] itemActions = new ItemAction[]{this.actionAddNew, this.actionEdit, this.actionRemove, this.actionSubmit};
        BiManagerUtil.setActionsEnabledStatus(itemActions, true);
        BiManagerUtil.setVisibleToolBarStatus(this.toolBar);
        BiManagerUtil.setVisibleMenuBarStatus(this.menuBar);
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.btnSubmit.setEnabled(false);
        } else if (this.getOprtState().equals(OprtState.EDIT)) {
            this.btnEdit.setEnabled(false);
        } else if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.btnEdit.setEnabled(false);
            this.btnRemove.setEnabled(false);
        }
        UIHelper.setTableTitle(this.kdtEntryMasterData_detailPanel, Constant.MasterDataEntry, 110);
        UIHelper.setTableTitle(this.kdtEntryFactData_detailPanel, Constant.AttribuEntry, 110);
        KDBizPromptBox masterDataF7 = new KDBizPromptBox();
        masterDataF7.setQueryInfo("com.kingdee.eas.framework.bireport.bimanager.mdm.app.MasterDataQuery");
        masterDataF7.setVisible(true);
        masterDataF7.setEditable(false);
        masterDataF7.setDisplayFormat("$number$");
        masterDataF7.setEditFormat("$number$");
        masterDataF7.setCommitFormat("$number$");
        F7ListUISelector.setListToPrmtF7(masterDataF7, (ListUI)new MasterDataListUI());
        this.kdtEntryMasterData.getColumn("MasterData").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)masterDataF7));
        KDWorkButton factRemoveButton = this.kdtEntryFactData_detailPanel.getRemoveLinesButton();
        this.masterDataActions = factRemoveButton.getActionListeners();
        int size = this.masterDataActions.length;
        for (int i = 0; i < size; ++i) {
            factRemoveButton.removeActionListener(this.masterDataActions[i]);
        }
        factRemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    boolean isRemove = MsgBox.isYes((int)MsgBox.showConfirm2((String)Constant.DeleteDataConfirm));
                    if (!isRemove) {
                        return;
                    }
                    int size = FactDataModelEditUI.this.masterDataActions.length;
                    for (int i = 0; i < size; ++i) {
                        FactDataModelEditUI.this.masterDataActions[i].actionPerformed(e);
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        KDWorkButton masterRemoveButton = this.kdtEntryMasterData_detailPanel.getRemoveLinesButton();
        this.factDataActions = masterRemoveButton.getActionListeners();
        int size2 = this.factDataActions.length;
        for (int i = 0; i < size2; ++i) {
            masterRemoveButton.removeActionListener(this.factDataActions[i]);
        }
        masterRemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    boolean isRemove = MsgBox.isYes((int)MsgBox.showConfirm2((String)Constant.DeleteDataConfirm));
                    if (!isRemove) {
                        return;
                    }
                    int size = FactDataModelEditUI.this.factDataActions.length;
                    for (int i = 0; i < size; ++i) {
                        FactDataModelEditUI.this.factDataActions[i].actionPerformed(e);
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("*"));
        return sic;
    }
}

