/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.da.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.bireport.bimanager.da.FactDataModelFactory;
import com.kingdee.eas.framework.bireport.bimanager.da.FactDataModelInfo;
import com.kingdee.eas.framework.bireport.bimanager.da.FactDataModelTreeFactory;
import com.kingdee.eas.framework.bireport.bimanager.da.client.AbstractFactDataModelListUI;
import com.kingdee.eas.framework.bireport.bimanager.da.client.FactDataModelTreeEditUI;
import com.kingdee.eas.framework.bireport.bimanager.util.BiManagerUtil;
import com.kingdee.eas.framework.bireport.bimanager.util.Constant;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class FactDataModelListUI
extends AbstractFactDataModelListUI {
    private static final Logger logger = CoreUIObject.getLogger(FactDataModelListUI.class);

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return FactDataModelFactory.getRemoteInstance();
    }

    @Override
    protected ITreeBase getTreeInterface() throws Exception {
        return FactDataModelTreeFactory.getRemoteInstance();
    }

    @Override
    protected String getGroupEditUIName() {
        return FactDataModelTreeEditUI.class.getName();
    }

    @Override
    protected String getQueryFieldName() {
        return "treeid.id";
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected String getRootName() {
        return Constant.FactDataModelCategory;
    }

    @Override
    protected IObjectValue createNewData() {
        FactDataModelInfo objectValue = new FactDataModelInfo();
        return objectValue;
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.initUI();
    }

    private void initUI() {
        super.lockAction();
        ItemAction[] itemActions = new ItemAction[]{this.actionImportData, this.actionExportData};
        BiManagerUtil.setActionsEnabledStatus(itemActions, false);
        itemActions = new ItemAction[]{this.actionAddNew, this.actionView, this.actionEdit, this.actionRemove, this.actionRefresh, this.actionQuery, this.actionLocate, this.actionCancel, this.actionCancelCancel};
        BiManagerUtil.setActionsEnabledStatus(itemActions, true);
        BiManagerUtil.setVisibleToolBarStatus(this.toolBar);
        BiManagerUtil.setVisibleMenuBarStatus(this.menuBar);
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        if (row != null) {
            Boolean isUsed = (Boolean)row.getCell("isUsed").getValue();
            if (isUsed != null && isUsed.booleanValue()) {
                this.btnCancelCancel.setEnabled(false);
                this.btnCancel.setEnabled(true);
            } else {
                this.btnCancelCancel.setEnabled(true);
                this.btnCancel.setEnabled(false);
            }
        }
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        Boolean isUsed;
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        if (row == null) {
            MsgBox.showInfo((String)Constant.ChooseRow);
            SysUtil.abort();
        }
        if ((isUsed = (Boolean)row.getCell("isUsed").getValue()) != null && isUsed.booleanValue()) {
            MsgBox.showInfo((String)Constant.isUsedCanNotModify);
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        boolean isRemove;
        Boolean isUsed;
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        if (row == null) {
            MsgBox.showInfo((String)Constant.ChooseRow);
            SysUtil.abort();
        }
        if ((isUsed = (Boolean)row.getCell("isUsed").getValue()) != null && isUsed.booleanValue()) {
            MsgBox.showInfo((String)Constant.isUsedCanNotRemove);
            SysUtil.abort();
        }
        if (!(isRemove = MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)Constant.DeleteDataConfirm)))) {
            return;
        }
        this.Remove();
        this.refresh(e);
    }

    @Override
    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        String cancelMsg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_CancelCancel");
        if (this.confirmDialog(cancelMsg)) {
            String id;
            this.checkSelected();
            IRow row = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
            if (row == null) {
                MsgBox.showInfo((String)Constant.ChooseRow);
                SysUtil.abort();
            }
            if ((id = (String)row.getCell("id").getValue()) == null) {
                MsgBox.showInfo((String)Constant.IdIsNoll);
                SysUtil.abort();
            }
            FactDataModelFactory.getRemoteInstance().cancelCancel((IObjectPK)new ObjectUuidPK(id), null);
        }
        this.refresh(e);
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        String cancelMsg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Cancel");
        if (this.confirmDialog(cancelMsg)) {
            String id;
            this.checkSelected();
            IRow row = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
            if (row == null) {
                MsgBox.showInfo((String)Constant.ChooseRow);
                SysUtil.abort();
            }
            if ((id = (String)row.getCell("id").getValue()) == null) {
                MsgBox.showInfo((String)Constant.IdIsNoll);
                SysUtil.abort();
            }
            FactDataModelFactory.getRemoteInstance().cancel((IObjectPK)new ObjectUuidPK(id), null);
        }
        this.refresh(e);
    }
}

