/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.dbpool;

import com.kingdee.bos.ctrl.analysis.common.dbcenter.center.DBCenterModel;
import com.kingdee.eas.framework.bireport.bimanager.dbpool.IDBConnectionPool;
import com.kingdee.eas.framework.bireport.bimanager.dbpool.pool.DBConnectionPoolFactory;
import java.sql.Connection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class DBConnectionPoolManager {
    private static final Map poolsRegister = new Hashtable();

    public static synchronized Connection getConnection(DBCenterModel model) {
        IDBConnectionPool pool = DBConnectionPoolManager.getPool(model);
        return pool.getConnection();
    }

    public static synchronized Connection getConnection(String dbCenterId) {
        IDBConnectionPool pool = DBConnectionPoolManager.getPool(dbCenterId);
        if (pool == null) {
            throw new RuntimeException("id\u4e3a" + dbCenterId + "\u7684\u6570\u636e\u4e2d\u5fc3\u8fd8\u6ca1\u6709\u6ce8\u518c\uff0c\u8bf7\u7528\u5176\u4ed6getConnection()\u65b9\u6cd5\u83b7\u53d6\u8fde\u63a5\uff01");
        }
        pool.printPoolStatus();
        return pool.getConnection();
    }

    public static synchronized void updatePool(String dbCenterId) {
        if (poolsRegister.get(dbCenterId) == null) {
            return;
        }
        IDBConnectionPool pool = (IDBConnectionPool)poolsRegister.get(dbCenterId);
        pool.updatePool(dbCenterId, new DBCenterModel());
    }

    public static synchronized void shutdownPool(String dbCenterId) {
        if (poolsRegister.get(dbCenterId) == null) {
            return;
        }
        IDBConnectionPool pool = (IDBConnectionPool)poolsRegister.get(dbCenterId);
        pool.shutdownPool();
        poolsRegister.remove(dbCenterId);
    }

    public static synchronized void shutdownPool() {
        Iterator iterator = poolsRegister.keySet().iterator();
        System.out.println("\u5173\u95ed\u8fde\u63a5\u6c60!");
        while (iterator.hasNext()) {
            Object next = iterator.next();
            System.out.println("\u5173\u95ed\u8fde\u63a5\u6c60  dataCenterID=" + next);
            IDBConnectionPool pool = (IDBConnectionPool)poolsRegister.get(next);
            pool.shutdownPool();
            iterator.remove();
        }
    }

    public static synchronized void printPoolsStates() {
        for (Map.Entry entry : poolsRegister.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            ((IDBConnectionPool)value).printPoolStatus();
        }
    }

    private static synchronized IDBConnectionPool getPool(DBCenterModel model) {
        String dbCenterId = model.getDbCenterId();
        if (poolsRegister.get(dbCenterId) == null) {
            IDBConnectionPool pool = DBConnectionPoolFactory.createPoolInstance(model);
            poolsRegister.put(dbCenterId, pool);
        }
        ((IDBConnectionPool)poolsRegister.get(dbCenterId)).printPoolStatus();
        return (IDBConnectionPool)poolsRegister.get(dbCenterId);
    }

    private static synchronized IDBConnectionPool getPool(String dbCenterId) {
        return (IDBConnectionPool)poolsRegister.get(dbCenterId);
    }
}

